/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NetworkGenPropsPanel
extends AbstractPropsPanel {
    private NetworkData originalNetworkObj;
    private JTextField networkName;
    private JLabel networkNameLabel;
    private JTextField ipAddress;
    private JLabel ipAddressLabel;
    private JTextField netmask;
    private JLabel netmaskLabel;

    public NetworkGenPropsPanel(GenInfoPanel genInfoPanel, NetworkData networkData) {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "NetGenPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "NetGenPropsNetworkName");
        this.networkNameLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.networkNameLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 10, 5, 10, 5);
        this.networkNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.networkNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.networkNameLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.networkName = new JTextField(networkData.getNetworkName(), 16);
        Constraints.constrain(this, this.networkName, 1, -1, 1, 1, 0, 17, 0.0, 0.0, 10, 0, 10, 5);
        this.networkName.setMinimumSize(this.networkName.getPreferredSize());
        this.networkName.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.networkNameLabel.setLabelFor(this.networkName);
        actionString = new ActionString(resourceBundle, "NetGenPropsNetAddr");
        this.ipAddressLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.ipAddressLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.ipAddressLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.ipAddressLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.ipAddressLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.ipAddress = new JTextField(networkData.getNetworkAddress(), 16);
        Constraints.constrain(this, this.ipAddress, 1, -1, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.ipAddress.setMinimumSize(this.ipAddress.getPreferredSize());
        this.ipAddress.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.ipAddressLabel.setLabelFor(this.ipAddress);
        actionString = new ActionString(resourceBundle, "NetGenPropsNetmask");
        this.netmaskLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.netmaskLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.netmaskLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.netmaskLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.netmaskLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.netmask = new JTextField(networkData.getNetmask(), 16);
        Constraints.constrain(this, this.netmask, 1, -1, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.netmask.setMinimumSize(this.netmask.getPreferredSize());
        this.netmask.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.netmaskLabel.setLabelFor(this.netmask);
        if (networkData.getNetworkAddress().length() != 0) {
            this.networkName.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_netprop_name"));
            this.ipAddress.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_netprop_address"));
            this.netmask.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_netprop_netmask"));
        } else {
            this.networkName.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newnet_name"));
            this.ipAddress.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newnet_address"));
            this.netmask.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newnet_netmask"));
        }
        this.networkName.requestFocus();
        this.originalNetworkObj = networkData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        NetworkData networkData = (NetworkData)object;
        if (this.networkName.getText().length() > 0) {
            try {
                NetworkData.validateNetworkName(this.networkName.getText());
                networkData.setNetworkName(this.networkName.getText());
            }
            catch (HostException hostException) {
                this.networkName.requestFocus();
                throw hostException;
            }
        }
        if (this.ipAddress.getText().length() == 0) {
            this.ipAddress.requestFocus();
            throw new HostException("EXM_HST_GUI_MISSING_PROPS_VALUE", this.ipAddressLabel.getText().substring(0, this.ipAddressLabel.getText().length() - 1));
        }
        try {
            NetworkData.validateIPAddress(this.ipAddress.getText());
            networkData.setNetworkAddress(this.ipAddress.getText());
        }
        catch (HostException hostException) {
            this.ipAddress.requestFocus();
            throw hostException;
        }
        if (this.netmask.getText().length() > 0) {
            try {
                NetworkData.validateNetmask(this.netmask.getText());
                networkData.setNetmask(this.netmask.getText());
            }
            catch (HostException hostException) {
                this.netmask.requestFocus();
                throw hostException;
            }
        }
        if (this.networkName.getText().length() == 0 && this.netmask.getText().length() == 0) {
            this.ipAddress.requestFocus();
            throw new HostException("EXM_HST_GUI_ILL_DEFINED_NETWORK", this.ipAddressLabel.getText().substring(0, this.ipAddressLabel.getText().length() - 1), this.networkNameLabel.getText().substring(0, this.networkNameLabel.getText().length() - 1), this.netmaskLabel.getText().substring(0, this.netmaskLabel.getText().length() - 1));
        }
        if (!networkData.isNetwork() && networkData.getNetmask().length() != 0) {
            this.netmask.requestFocus();
            throw new HostException("EXM_HST_GUI_SUBNETWORK_NO_REQUIRES_NETMASK", this.ipAddressLabel.getText().substring(0, this.ipAddressLabel.getText().length() - 1), this.netmaskLabel.getText().substring(0, this.netmaskLabel.getText().length() - 1));
        }
    }

    public void dialogDataInitialize(Object object) {
        NetworkData networkData = (NetworkData)object;
        this.networkName.setText(networkData.getNetworkName());
        this.ipAddress.setText(networkData.getNetworkAddress());
        this.netmask.setText(networkData.getNetmask());
        this.originalNetworkObj = networkData;
    }
}

