/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.AbstractIconModel;
import com.sun.admin.hostmgr.client.AbstractIconView;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.NetworkData;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public class NetworkIconView
extends AbstractIconView {
    private ImageIcon staticNetworkIcon;
    private ImageIcon staticSubnetIcon;
    private ImageIcon dynamicNetworkIcon;
    private ImageIcon dynamicSubnetIcon;
    private ImageIcon allHostsIcon;
    private IconModel iconModel = new IconModel();

    public NetworkIconView() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.staticNetworkIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargeStaticNetworkGif"), "");
        this.staticSubnetIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargeStaticSubnetworkGif"), "");
        this.dynamicNetworkIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargeDynamicNetworkGif"), "");
        this.dynamicSubnetIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargeDynamicSubnetworkGif"), "");
        this.allHostsIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargeAllHostsGif"), "");
    }

    protected AbstractIconModel getIconModel() {
        return this.iconModel;
    }

    protected void onDoubleClick() {
        this.fireItemPressed(2);
    }

    public void openSelected() {
        this.onDoubleClick();
    }

    public String getSortAttribute() {
        return "networkListIPAddress";
    }

    public Vector getAvailableSortAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("networkListIPAddress");
        return vector;
    }

    class IconModel
    extends AbstractIconModel {
        private int preferredWidth;

        public String getIconLabel(Object object) {
            if (((NetworkData)object).getNetworkAddress().length() > 0) {
                return ((NetworkData)object).getNetworkAddress();
            }
            return ((NetworkData)object).getNetworkName();
        }

        public ImageIcon getIcon(Object object) {
            NetworkData networkData = (NetworkData)object;
            if (networkData.getNetworkAddress().length() > 0) {
                if (networkData.isNetwork()) {
                    if (networkData.isStaticNetwork()) {
                        return NetworkIconView.this.staticNetworkIcon;
                    }
                    return NetworkIconView.this.dynamicNetworkIcon;
                }
                if (networkData.isStaticNetwork()) {
                    return NetworkIconView.this.staticSubnetIcon;
                }
                return NetworkIconView.this.dynamicSubnetIcon;
            }
            return NetworkIconView.this.allHostsIcon;
        }

        public String getHelpName(Object object) {
            return "main_netlist";
        }

        public int getButtonWidth() {
            if (this.preferredWidth > 0) {
                return this.preferredWidth;
            }
            try {
                ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
                this.preferredWidth = Integer.parseInt(ResourceStrings.getString(resourceBundle, "NetworkIconButtonWidth"));
            }
            catch (NumberFormatException numberFormatException) {
                this.preferredWidth = 112;
            }
            return this.preferredWidth;
        }

        public int compare(Object object, Object object2) {
            long l;
            NetworkData networkData = (NetworkData)object;
            NetworkData networkData2 = (NetworkData)object2;
            if (networkData.getNetworkAddress().length() <= 0 && networkData2.getNetworkAddress().length() <= 0) {
                return 0;
            }
            if (networkData.getNetworkAddress().length() <= 0) {
                if (NetworkIconView.this.getSortOrder() == 3) {
                    return -1;
                }
                return 1;
            }
            if (networkData2.getNetworkAddress().length() <= 0) {
                if (NetworkIconView.this.getSortOrder() == 3) {
                    return 1;
                }
                return -1;
            }
            long l2 = networkData.getNetworkAddressLong();
            if (l2 < (l = networkData2.getNetworkAddressLong())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }

        IconModel() {
            NetworkIconView.this = NetworkIconView.this;
        }
    }
}

