/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.AdminClientInfo;
import com.sun.admin.cis.client.AdminContext;
import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.AdminSplash;
import com.sun.admin.cis.client.AppSplitPane;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.client.LogOnDialog;
import com.sun.admin.cis.client.MainHelpPanel;
import com.sun.admin.cis.client.MainMenuBar;
import com.sun.admin.cis.client.MainStatusPanel;
import com.sun.admin.cis.client.MainToolBar;
import com.sun.admin.cis.client.SBConstants;
import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.SplitterPane;
import com.sun.admin.cis.common.UmbrellaConnection;
import com.sun.admin.cis.common.UnsupportedScopeTypeException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class AdminFrame
extends JFrame
implements IClientComm {
    private static final String CLIENT_TRACE_FILE = "admapp";
    private static final String HELP_HELP_PATH = "help";
    private static final String HELP_HELP_FILE = "help.html";
    private static final String HELP_CIS_PATH = "cis";
    private static final String HELP_DFLT_PATH = "default";
    private static final String HELP_FILE_SUFFIX = ".html";
    private static final String HELP_NO_HELP = "no_help.html";
    private static final String HELP_S8U3_AUTH_NAME = "auths";
    private static final String HELP_S8U3_AUTH_PATH = "/usr/lib/help/auths/locale";
    private static final String HELP_S8U3_AUTH_DFLT = "C";
    private static final String BIN_PATH = "bin";
    private static final String LIB_PATH = "lib";
    private static final Dimension MIN_DIM = new Dimension(10, 10);
    private Component glassPane;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private Hashtable helpCache;
    private int busyCount;
    private AdminContext adminContext;
    AdminClientInfo adminClientInfo;
    private String basePath;
    private String pkgPath;
    private Component prevSelComponent;
    protected SplitterPane mainSplitPane;
    public AppSplitPane appSplitPane;
    public MainHelpPanel mainHelpPanel;
    public MainMenuBar mainMenuBar;
    public AdminSplash adminSplash;
    public MainToolBar mainToolBar;
    public MainStatusPanel mainStatusPanel;
    UmbrellaConnection umbrellaConnection;
    private static AdminFrame adminFrame;

    public static AdminFrame instance() {
        if (adminFrame == null) {
            adminFrame = new AdminFrame();
        }
        return adminFrame;
    }

    public void addToTreePanel(Component component) {
        this.appSplitPane.addToTreePanel(component);
    }

    public void addToMainView(JComponent jComponent) {
        this.appSplitPane.addToMainView(jComponent);
    }

    public void addToHelpPanel(URL uRL) {
        this.mainHelpPanel.addToHelpPanel(uRL);
    }

    public void addToStatusPanel(String string, int n) {
        this.mainStatusPanel.addToStatusPanel(string, n);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getPackagePath() {
        return this.pkgPath;
    }

    public String getImagePath() {
        return String.valueOf(this.basePath) + this.pkgPath;
    }

    public JFrame getFrame() {
        return this;
    }

    public String getUserName() {
        return this.adminContext.getUserName();
    }

    public String getUserPassword() {
        return this.adminContext.getUserPwd();
    }

    public String getScopeName() {
        return this.adminContext.getScopeName();
    }

    public String getSolServerName() {
        return this.adminContext.getSolServerName();
    }

    public String getServerType() {
        return this.adminContext.getServerType();
    }

    public AdminSession getAdminSession() {
        return this.adminContext.getAdminSession();
    }

    public AdminClientInfo getAdminClientInfo() {
        return this.adminContext.getAdminClientInfo();
    }

    public String getBinPath(String string) {
        String string2 = File.separator;
        String string3 = String.valueOf(this.basePath) + string2 + BIN_PATH + string2 + string;
        return string3;
    }

    public String getLibPath(String string) {
        String string2 = File.separator;
        String string3 = String.valueOf(this.basePath) + string2 + LIB_PATH + string2 + string;
        return string3;
    }

    public String getHelpUrl(String string, String string2) {
        String string3;
        String string4 = File.separator;
        if (string == null || string2 == null) {
            String string5 = String.valueOf(this.basePath) + string4 + HELP_HELP_PATH + string4 + HELP_DFLT_PATH + string4 + HELP_CIS_PATH + string4 + HELP_NO_HELP;
            String string6 = string5.startsWith(string4) ? new String("file:" + string5) : new String("file:" + string4 + string5);
            return string6;
        }
        String string7 = string2;
        if (!string7.endsWith(HELP_FILE_SUFFIX)) {
            string7 = string7.concat(HELP_FILE_SUFFIX);
        }
        if ((string3 = (String)this.helpCache.get(string)) == null) {
            String string8;
            String string9;
            boolean bl = false;
            boolean bl2 = true;
            if (string.equals(HELP_S8U3_AUTH_NAME) && (string9 = this.getHelpLocaleDirectory(string8 = HELP_S8U3_AUTH_PATH, null, HELP_S8U3_AUTH_DFLT, string7, string4)) != null) {
                bl = true;
                string3 = HELP_S8U3_AUTH_PATH + string4 + string9;
            }
            if (!bl) {
                string8 = String.valueOf(this.basePath) + string4 + HELP_HELP_PATH;
                string9 = this.getHelpLocaleDirectory(string8, string, HELP_DFLT_PATH, string7, string4);
                if (string9 == null) {
                    bl2 = false;
                    string9 = HELP_DFLT_PATH;
                    string = HELP_CIS_PATH;
                    string7 = HELP_NO_HELP;
                }
                string3 = String.valueOf(string8) + string4 + string9 + string4 + string;
            }
            if (bl2) {
                this.helpCache.put(string, string3);
            }
        }
        String string10 = (string3 = String.valueOf(string3) + string4 + string7).startsWith(string4) ? new String("file:" + string3) : new String("file:" + string4 + string3);
        return string10;
    }

    public void setAppFocus(Component component) {
        AdminCommonTools.CMN_HandleOutput("Selected comp = " + component);
        if (component != this.prevSelComponent) {
            AdminCommonTools.CMN_HandleOutput("Prev Selected comp = " + this.prevSelComponent);
            if (this.prevSelComponent != null) {
                if (this.prevSelComponent instanceof AdminClientComponent) {
                    ((AdminClientComponent)((Object)this.prevSelComponent)).appLosingMainFocus();
                } else if (this.prevSelComponent instanceof JButton) {
                    ((JButton)this.prevSelComponent).setBackground(SBConstants.getBackGroundColor());
                    ((JButton)this.prevSelComponent).setBorderPainted(false);
                }
            }
            if (component instanceof AdminClientComponent) {
                ((AdminClientComponent)((Object)component)).appReceivingMainFocus();
            }
            this.prevSelComponent = component;
        }
    }

    public void waitOn() {
        this.setBusy(true);
    }

    public void waitOff() {
        this.setBusy(false);
    }

    public boolean isWaitOn() {
        return this.busyCount > 0;
    }

    public ImageIcon createImageIcon(String string, String string2) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(String.valueOf(this.getImagePath()) + "/cis/client/images/" + string, string2);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Can't create toolbar image");
            exception.printStackTrace();
        }
        return imageIcon;
    }

    public void updateTitle() {
        this.setTitle(String.valueOf(Constants.getAppName()) + " - " + this.adminContext.getAdminMgmtScope().toString());
    }

    public void closeHelpPanel() {
        this.mainSplitPane.setSplitterAtExtremeBottom();
    }

    public void showHelpPanel() {
        this.mainSplitPane.setDividerPercent(this.mainSplitPane.getNonSnappedDividerPercent());
    }

    public AdminClientComponent createAdminClientComponent(String string) throws AdminException {
        AdminClientComponent adminClientComponent = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("AdminClient: cannot find class file for: " + string);
            throw new AdminClientException("EXM_CFC", string);
        }
        try {
            Class[] classArray = new Class[]{Class.forName("com.sun.admin.cis.client.IClientComm")};
            Object[] objectArray = new Object[]{this};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            adminClientComponent = (AdminClientComponent)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!(throwable instanceof UnsupportedScopeTypeException)) {
                AdminCommonTools.CMN_HandleOutput("AdminClient: exception thrown by client constructor");
                throw new AdminClientException("EXM_CCC", string);
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("AdminClient: cannot create application client: " + exception.getMessage());
            throw new AdminClientException("EXM_CCC", string);
        }
        return adminClientComponent;
    }

    private String getBaseDirectory() {
        String string = null;
        try {
            string = new String(this.adminContext.getAdminClientInfo().getClientProperty("admin.base.dir"));
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Can't get help base directory");
            string = "";
        }
        return string;
    }

    private String setUpPackagePath() {
        String string = null;
        try {
            string = new String(this.adminContext.getAdminClientInfo().getClientProperty("admin.images.basedir"));
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Can't get help base directory");
            string = null;
        }
        if (string == null || string.equals("")) {
            string = ".";
        }
        return string;
    }

    private void initializeGUIComponents() {
        try {
            this.mainHelpPanel = MainHelpPanel.instance();
            this.appSplitPane = AppSplitPane.instance();
            this.mainSplitPane = new SplitterPane(0, this.appSplitPane, this.mainHelpPanel);
            this.mainMenuBar = new MainMenuBar();
            this.mainToolBar = new MainToolBar();
            this.mainStatusPanel = MainStatusPanel.instance();
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Unexpected error");
            exception.printStackTrace();
            return;
        }
    }

    private void layoutGUIComponents() {
        Constraints.constrain(this.getContentPane(), this.mainMenuBar, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.getContentPane(), this.mainToolBar, 0, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.mainSplitPane.setPreferredSize(new Dimension((int)(0.67 * (double)this.screenSize.width), (int)(0.67 * (double)this.screenSize.height)));
        this.mainSplitPane.setOneTouchExpandable(true);
        Constraints.constrain(this.getContentPane(), this.mainSplitPane, 0, 2, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        Constraints.constrain(this.getContentPane(), this.mainStatusPanel, 0, 3, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Dimension dimension = new Dimension((int)(0.75 * (double)this.screenSize.width), (int)(0.75 * (double)this.screenSize.height));
        ((Component)this).setSize(dimension);
        this.pack();
        this.appSplitPane.setMinimumSize(MIN_DIM);
        this.mainHelpPanel.setMinimumSize(MIN_DIM);
        this.mainSplitPane.setDividerPercent(0.75);
        ((Component)this).setLocation(this.screenSize.width / 2 - this.getSize().width / 2, this.screenSize.height / 2 - this.getSize().height / 2);
    }

    void loadClientApps() {
        Object object;
        Vector vector = new Vector();
        try {
            vector = this.adminContext.getAdminClientInfo().getClientPropertyList("admin.app");
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Can't getClientPropertyList");
            adminException.printStackTrace();
        }
        int n = 0;
        while (n < vector.size()) {
            object = new String((String)vector.elementAt(n));
            AdminCommonTools.CMN_HandleOutput("App names =" + (String)object);
            ++n;
        }
        object = new Vector(vector.size());
        try {
            int n2 = 0;
            while (n2 < vector.size()) {
                AdminClientComponent adminClientComponent = this.createAdminClientComponent((String)vector.elementAt(n2));
                if (adminClientComponent != null) {
                    ((Vector)object).addElement(adminClientComponent);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Can't getClientPropertyList");
            exception.printStackTrace();
        }
        this.adminContext.setAdminClientComponents((Vector)object);
        this.invalidate();
        this.validate();
        this.repaint();
        this.mainSplitPane.requestDefaultFocus();
    }

    private String getHelpLocaleDirectory(String string, String string2, String string3, String string4, String string5) {
        String string6;
        block10: {
            if (string5 == null) {
                string5 = File.separator;
            }
            String string7 = string2 == null ? "" : String.valueOf(string2) + string5;
            Locale locale = Locale.getDefault();
            String string8 = "";
            string6 = "";
            File file = null;
            if (locale != null) {
                string6 = locale.toString();
                boolean bl = true;
                while (bl) {
                    string8 = String.valueOf(string) + string5 + string6 + string5 + string7 + string4;
                    try {
                        file = new File(string8);
                        if (file.exists()) {
                            break;
                        }
                    }
                    catch (Exception exception) {}
                    file = null;
                    int n = string6.lastIndexOf(95);
                    if (n > 0) {
                        string6 = string6.substring(0, n);
                        continue;
                    }
                    bl = false;
                }
            }
            if (file != null) break block10;
            string6 = string3;
            string8 = String.valueOf(string) + string5 + string6 + string5 + string7 + string4;
            file = null;
            try {
                file = new File(string8);
                if (!file.exists()) {
                    string6 = null;
                }
            }
            catch (Exception exception) {
                string6 = null;
            }
        }
        return string6;
    }

    private AdminFrame() {
        try {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            return;
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private synchronized void setBusy(boolean bl) {
        if (this.glassPane == null) {
            return;
        }
        if (bl) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.glassPane.setVisible(true);
                return;
            }
        } else {
            --this.busyCount;
            this.busyCount = Math.max(0, this.busyCount);
            if (this.busyCount == 0) {
                this.glassPane.setVisible(false);
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void startUmbrella() {
        this.adminContext = AdminContext.instance();
        try {
            this.adminClientInfo = new AdminClientInfo(null);
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Can't create AdminClientInfo");
            new ErrorDialog(this, adminException.getLocalizedMessage());
            this.dispose();
        }
        this.adminContext.setAdminClientInfo(this.adminClientInfo);
        this.adminClientInfo.initTrace(CLIENT_TRACE_FILE, "Management client application");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.basePath = this.getBaseDirectory();
        this.pkgPath = this.setUpPackagePath();
        this.helpCache = new Hashtable();
        this.umbrellaConnection = new UmbrellaConnection(this);
        this.adminSplash = new AdminSplash(this);
        ((Component)this.adminSplash).setVisible(true);
        this.adminSplash.setCursor(Cursor.getPredefinedCursor(3));
        LogOnDialog logOnDialog = new LogOnDialog(this, true);
        ((Component)logOnDialog).setVisible(true);
        this.addWindowListener(new JFWindowListener());
        this.initializeGUIComponents();
        this.layoutGUIComponents();
        try {
            ImageIcon imageIcon = new ImageIcon(String.valueOf(this.getImagePath()) + "/cis/client/images/" + "app_icon.gif");
            Image image = imageIcon.getImage();
            ((Frame)this).setIconImage(image);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Can't set Umbrella image");
        }
        this.updateTitle();
        this.loadClientApps();
        this.show();
        this.adminSplash.setCursor(Cursor.getPredefinedCursor(0));
        this.adminSplash.dispose();
        this.glassPane = this.getGlassPane();
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        this.glassPane.addMouseListener(new 1());
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
        }

        /* synthetic */ 1() {
        }
    }

    class JFWindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (AdminContext.instance().getAdminSession() != null) {
                try {
                    AdminCommonTools.CMN_HandleOutput("Closing session");
                    AdminContext.instance().getAdminSession().close();
                }
                catch (AdminException adminException) {
                    AdminCommonTools.CMN_HandleOutput("Unable close Session");
                }
            }
            System.exit(0);
        }

        JFWindowListener() {
            AdminFrame.this = AdminFrame.this;
        }
    }
}

