/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;

public class DnsTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 1;
    static int TABLE_NAME;
    static int MAPPED_TABLE_NAME;
    static int COLUMN_SEPARATORS;
    static int COMMENT_SEPARATORS;
    static int USERID;
    static int GROUPID;
    static int ACCESS;
    static int TABLE_ATTRIBUTES;
    static int NUMBER_OF_COLUMNS;
    static int USER_DEFINED;
    static String[][] definitions;
    int tableIndex = USER_DEFINED;
    String tableName = "";
    String tableType = "";
    String mappedTableName = "";
    String columnSeparators = " \t";
    String commentSeparators = "#";
    int numberOfColumns;
    int tableAttributes = 0;
    int[] columnAttributes = null;
    String[] columnNames = null;
    String[] mappedColumnNames = null;
    int userId = 0;
    int groupId = 3;
    int access = 273;

    public void loadTableDefinitions(String string) throws DirectoryTableInvalidParameterException {
        this.tableName = string;
        int n = 0;
        while (n < NUMBER_OF_TABLES) {
            if (string.equalsIgnoreCase(definitions[n][TABLE_NAME])) {
                this.tableIndex = n;
                this.tableName = definitions[n][TABLE_NAME];
                this.tableType = String.valueOf(this.tableName) + "_tbl";
                this.mappedTableName = definitions[n][MAPPED_TABLE_NAME];
                this.columnSeparators = definitions[n][COLUMN_SEPARATORS];
                this.commentSeparators = definitions[n][COMMENT_SEPARATORS];
                this.userId = Integer.valueOf(definitions[n][USERID]);
                this.groupId = Integer.valueOf(definitions[n][GROUPID]);
                this.access = Integer.valueOf(definitions[n][ACCESS]);
                this.tableAttributes = Integer.valueOf(definitions[n][TABLE_ATTRIBUTES]);
                this.numberOfColumns = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS]);
                this.columnNames = new String[this.numberOfColumns];
                this.mappedColumnNames = new String[this.numberOfColumns];
                this.columnAttributes = new int[this.numberOfColumns];
                int n2 = 0;
                while (n2 < this.numberOfColumns) {
                    this.columnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.mappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 1];
                    this.columnAttributes[n2] = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS + n2 * 2 + 2]);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (n == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[n - 1];
    }

    public String getMappedColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[n - 1];
    }

    public int getColumnNumber(String string) throws DirectoryTableInvalidParameterException {
        int n = 0;
        while (n < this.numberOfColumns) {
            if (this.columnNames[n].equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int n) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            return this.columnAttributes[n - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.mappedTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = n;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            this.columnNames[n - 1] = string;
            return;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public void setMappedColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            this.mappedColumnNames[n - 1] = string;
            return;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public void setColumnAttributes(int n, int n2) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            this.columnAttributes[n - 1] = n2;
            return;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public void setTableAttributes(int n) {
        this.tableAttributes = n;
    }

    public void setMappedTableName(String string) {
        this.mappedTableName = string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableType(String string) {
        this.tableType = string;
    }

    public void setCommentSeparators(String string) {
        this.commentSeparators = string;
    }

    public void setColumnSeparators(String string) {
        this.columnSeparators = string;
    }

    public void setUser(int n) {
        this.userId = n;
    }

    public void setGroup(int n) {
        this.groupId = n;
    }

    public void setAccess(int n) {
        this.access = n;
    }

    static {
        MAPPED_TABLE_NAME = 1;
        COLUMN_SEPARATORS = 2;
        COMMENT_SEPARATORS = 3;
        USERID = 4;
        GROUPID = 5;
        ACCESS = 6;
        TABLE_ATTRIBUTES = 7;
        NUMBER_OF_COLUMNS = 8;
        USER_DEFINED = 99;
        definitions = new String[][]{{"hosts", "/etc/inet/hosts", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(5), "7", "cname", Integer.toString(9), "ttl", Integer.toString(9), "class", Integer.toString(9), "type", Integer.toString(9), "addr", Integer.toString(3), "aliases", Integer.toString(9), "comment", Integer.toString(8)}};
    }
}

