/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.logging;

import com.sun.admin.cis.service.logging.AdminLogException;
import com.sun.admin.cis.service.logging.CorruptDataException;
import com.sun.admin.cis.service.logging.DataRecord;
import com.sun.admin.cis.service.logging.InvalidRecordException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DataStore
implements Cloneable {
    private static String VERSION_STR = "logsvc.seabreeze.version.1";
    String logFileName;
    RandomAccessFile fileDescriptor;
    long totalNumRecords;
    long currentEndOffset;
    long lastRecordOffset;
    long startDate;
    long firstOffset;
    int marker;
    String file_version = VERSION_STR;

    public DataStore(String string) throws IOException, EOFException {
        this.logFileName = string;
        this.fileDescriptor = new RandomAccessFile(string, "rw");
        if (this.fileDescriptor.length() > 0L) {
            this.fileDescriptor.seek(0L);
            this.currentEndOffset = this.fileDescriptor.readLong();
            this.lastRecordOffset = this.fileDescriptor.readLong();
            this.totalNumRecords = this.fileDescriptor.readLong();
            this.marker = this.fileDescriptor.readInt();
            this.startDate = this.fileDescriptor.readLong();
            this.file_version = this.fileDescriptor.readUTF();
            this.firstOffset = this.fileDescriptor.getFilePointer();
            return;
        }
        this.marker = this.hashCode();
        this.startDate = System.currentTimeMillis();
        this.fileDescriptor.seek(0L);
        this.fileDescriptor.writeLong(this.currentEndOffset);
        this.fileDescriptor.writeLong(this.lastRecordOffset);
        this.fileDescriptor.writeLong(this.totalNumRecords);
        this.fileDescriptor.writeInt(this.marker);
        this.fileDescriptor.writeLong(this.startDate);
        this.fileDescriptor.writeUTF(VERSION_STR);
        this.firstOffset = this.currentEndOffset = this.fileDescriptor.getFilePointer();
        this.fileDescriptor.seek(0L);
        this.fileDescriptor.writeLong(this.currentEndOffset);
        this.lastRecordOffset = this.currentEndOffset;
        this.fileDescriptor.writeLong(this.lastRecordOffset);
    }

    protected void finalize() throws IOException {
        this.fileDescriptor.close();
    }

    private long checkOffset(long l) {
        if (l < 0L || l >= this.currentEndOffset) {
            return -1L;
        }
        if (l == 0L) {
            l = this.firstOffset;
        }
        return l;
    }

    private void checkMark() throws IOException, EOFException, CorruptDataException {
        int n = this.fileDescriptor.readInt();
        if (n != this.marker) {
            throw new CorruptDataException("EXLOG_MRK");
        }
    }

    private Object convertToObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray.length <= 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    protected synchronized long writeRecord(String string, long l) throws IOException, InvalidRecordException {
        int n = 0;
        long l2 = this.lastRecordOffset;
        if (string == null) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        this.fileDescriptor.seek(this.currentEndOffset);
        n = string.length();
        if (n <= 0) {
            throw new InvalidRecordException("EXLOG_NUL");
        }
        long l3 = this.fileDescriptor.length();
        if ((l3 += (long)(12 + n + 8)) > l) {
            return -1L;
        }
        byte[] byArray = new byte[n];
        byArray = string.getBytes();
        this.lastRecordOffset = this.currentEndOffset;
        this.fileDescriptor.writeInt(this.marker);
        this.fileDescriptor.writeInt(string.hashCode());
        this.fileDescriptor.writeInt(n);
        this.fileDescriptor.write(byArray);
        this.fileDescriptor.writeLong(l2);
        this.currentEndOffset = this.fileDescriptor.getFilePointer();
        ++this.totalNumRecords;
        this.fileDescriptor.seek(0L);
        this.fileDescriptor.writeLong(this.currentEndOffset);
        this.fileDescriptor.writeLong(this.lastRecordOffset);
        this.fileDescriptor.writeLong(this.totalNumRecords);
        return this.fileDescriptor.length();
    }

    protected synchronized Vector readNumRecordsAsStr(long l, int n, int n2) throws IOException, EOFException, InvalidRecordException, CorruptDataException {
        Vector<DataRecord> vector = new Vector<DataRecord>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l2 = 0L;
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if (n2 == 0) {
            if (l == 0L) {
                l = this.lastRecordOffset;
            } else {
                if (l == this.firstOffset) {
                    return null;
                }
                long l3 = l;
                this.fileDescriptor.seek(l += 8L);
                n4 = this.fileDescriptor.readInt();
                this.fileDescriptor.seek(l + (long)n4 + 4L);
                l = this.fileDescriptor.readLong();
                if (l3 == l) {
                    return null;
                }
            }
        } else if (n2 == 1 && l != 0L) {
            if (l == this.lastRecordOffset) {
                return null;
            }
            l = this.checkOffset(l);
            this.fileDescriptor.seek(l += 8L);
            n4 = this.fileDescriptor.readInt();
            l += (long)(n4 + 4 + 8);
        }
        l = this.checkOffset(l);
        if (l < 0L) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(l);
        while (n5 < n) {
            try {
                this.checkMark();
                n3 = this.fileDescriptor.readInt();
                n4 = this.fileDescriptor.readInt();
                if (n4 < 0) {
                    throw new CorruptDataException("EXLOG_LEN");
                }
                byte[] byArray = new byte[n4];
                this.fileDescriptor.readFully(byArray);
                String string = new String(byArray);
                if (string == null) {
                    throw new CorruptDataException("EXLOG_DAT");
                }
                vector.addElement(new DataRecord(l, n3, string, n4, this.file_version));
                l2 = l;
            }
            catch (EOFException eOFException) {
                if (n5 > 0) {
                    return vector;
                }
                throw eOFException;
            }
            ++n5;
            l = this.fileDescriptor.getFilePointer();
            if (n2 == 0) {
                long l4 = this.fileDescriptor.readLong();
                if (l4 > l) {
                    throw new CorruptDataException("EXLOG_DAT");
                }
                if (l4 == l2) {
                    return vector;
                }
                this.fileDescriptor.seek(l4);
                l = l4;
                continue;
            }
            long l5 = this.fileDescriptor.readLong();
            l = this.fileDescriptor.getFilePointer();
        }
        return vector;
    }

    protected synchronized DataRecord readSpecificRecordAsStr(long l, int n) throws InvalidRecordException, IOException, EOFException, CorruptDataException {
        if (this.totalNumRecords == 0L) {
            return null;
        }
        if ((l = this.checkOffset(l)) < 0L) {
            throw new InvalidRecordException("EXLOG_OFF");
        }
        this.fileDescriptor.seek(l);
        this.checkMark();
        int n2 = this.fileDescriptor.readInt();
        if (n2 != n) {
            throw new InvalidRecordException("EXLOG_HSH");
        }
        int n3 = this.fileDescriptor.readInt();
        if (n3 < 0) {
            throw new CorruptDataException("EXLOG_LEN");
        }
        byte[] byArray = new byte[n3];
        this.fileDescriptor.readFully(byArray);
        String string = new String(byArray);
        if (string == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        return new DataRecord(l, n2, string, n3, this.file_version);
    }

    long getCurrentEndOffset() {
        return this.currentEndOffset;
    }

    protected long getNumRecords() {
        return this.totalNumRecords;
    }

    protected String getFileName() {
        return this.logFileName;
    }

    protected void close() throws AdminLogException {
        try {
            this.fileDescriptor.close();
            return;
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
    }

    protected long getFileDate() {
        return this.startDate;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    protected String getVersion() {
        return this.file_version;
    }
}

