/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.apps;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.CorkBoard;
import com.sun.admin.fsmgr.client.apps.AppData;
import com.sun.admin.fsmgr.client.apps.Apps;
import com.sun.admin.fsmgr.client.apps.AppsActionsListener;
import com.sun.admin.fsmgr.client.apps.AppsCache;
import com.sun.admin.fsmgr.client.apps.AppsListView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class AppsIconView
extends AppsListView {
    private static int BTNS_PER_ROW = 3;
    private JPanel iconPanel;
    private Vector vButtons = new Vector();
    private Vector vSelectedBtns = new Vector();
    private AppsCache appsCache = Apps.getInstance().getAppsCache();
    private ButtonMouseListener buttonMouseListener = new ButtonMouseListener(this);

    public AppsIconView() {
        this.iconPanel = new JPanel();
        this.iconPanel.setBackground(Color.white);
        this.iconPanel.setLayout(new CorkBoard());
        JViewport jViewport = this.getViewport();
        jViewport.add(this.iconPanel);
        this.addMouseListener(new 1());
    }

    public void setAppsCache(AppsCache appsCache) {
        this.appsCache = this.appsCache;
    }

    protected int getViewType() {
        return 1;
    }

    public void populate() {
        this.clear();
        int n = 0;
        while (n < this.appsCache.size()) {
            AppData appData = (AppData)this.appsCache.elementAt(n);
            this.vButtons.addElement(new AppButton(appData));
            ++n;
        }
        this.adjustPane();
    }

    public void clear() {
        this.clearSelection();
        this.iconPanel.removeAll();
        this.vButtons.removeAllElements();
    }

    public void append(Vector vector) {
    }

    private void adjustPane() {
        this.iconPanel.removeAll();
        int n = this.vButtons.size() / BTNS_PER_ROW;
        if (this.vButtons.size() % BTNS_PER_ROW > 0) {
            ++n;
        }
        int n2 = 0;
        int n3 = 10;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 10;
            int n6 = 0;
            while (n6 < BTNS_PER_ROW) {
                if (n2 == this.vButtons.size()) {
                    n4 = n;
                    break;
                }
                AppButton appButton = (AppButton)this.vButtons.elementAt(n2);
                appButton.setBorderPainted(false);
                appButton.setFocusPainted(false);
                appButton.setBackground(Color.white);
                appButton.setHorizontalTextPosition(0);
                appButton.setVerticalTextPosition(3);
                appButton.setHorizontalAlignment(0);
                appButton.setVerticalAlignment(3);
                appButton.setLocation(n5, n3);
                this.iconPanel.add(appButton);
                appButton.addMouseListener(this.buttonMouseListener);
                Dimension dimension = appButton.getPreferredSize();
                n5 += dimension.width + 10;
                ++n2;
                ++n6;
            }
            n3 += 10;
            ++n4;
        }
        this.iconPanel.invalidate();
        this.iconPanel.validate();
        this.iconPanel.repaint();
    }

    private void select(AppButton appButton) {
        if (appButton.isSelected()) {
            return;
        }
        appButton.setBackground(Constants.ICONCOLOR);
        appButton.setSelected(true);
        this.vSelectedBtns.addElement(appButton);
        this.fireItemPressed(0);
    }

    public void clearSelection() {
        int n = 0;
        while (n < this.vSelectedBtns.size()) {
            AppButton appButton = (AppButton)this.vSelectedBtns.elementAt(n);
            appButton.setBackground(Color.white);
            appButton.setSelected(false);
            ++n;
        }
        this.vSelectedBtns.removeAllElements();
        this.fireItemPressed(0);
    }

    public void unselect(AppButton appButton) {
        if (!appButton.isSelected()) {
            return;
        }
        appButton.setBackground(Color.white);
        appButton.setSelected(false);
        int n = this.vSelectedBtns.indexOf(appButton);
        if (n < 0) {
            return;
        }
        this.vSelectedBtns.removeElementAt(n);
        this.fireItemPressed(0);
    }

    public void selectAll() {
        this.vSelectedBtns.removeAllElements();
        int n = 0;
        while (n < this.vButtons.size()) {
            AppButton appButton = (AppButton)this.vButtons.elementAt(n);
            appButton.setBackground(Color.lightGray);
            appButton.setSelected(true);
            this.vSelectedBtns.addElement(appButton);
            ++n;
        }
        this.fireItemPressed(0);
    }

    public Object getSelectedItem() {
        AppData appData = null;
        int n = 0;
        while (n < this.vSelectedBtns.size()) {
            AppButton appButton = (AppButton)this.vSelectedBtns.elementAt(n);
            appData = appButton.getAppData();
            ++n;
        }
        return appData;
    }

    public int getNumSelections() {
        return this.vSelectedBtns.size();
    }

    private class AppButton
    extends JButton {
        private AppData appData;

        public AppButton(AppData appData) {
            super(appData.getAppName(), appData.getAppIconLarge());
            AppsIconView.this = AppsIconView.this;
            this.appData = appData;
        }

        public AppData getAppData() {
            return this.appData;
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            AppsIconView.this.clearSelection();
        }

        /* synthetic */ 1() {
        }
    }

    class ButtonMouseListener
    extends MouseAdapter {
        AppsListView listView;

        public ButtonMouseListener(AppsListView appsListView) {
            AppsIconView.this = AppsIconView.this;
            this.listView = appsListView;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AppButton appButton = (AppButton)mouseEvent.getComponent();
            if (mouseEvent.isControlDown()) {
                if (appButton.isSelected()) {
                    AppsIconView.this.unselect(appButton);
                    return;
                }
                AppsIconView.this.select(appButton);
                return;
            }
            AppsIconView.this.clearSelection();
            AppsIconView.this.select(appButton);
            if (mouseEvent.getClickCount() == 2) {
                this.listView.fireItemPressed(2);
                ActionEvent actionEvent = new ActionEvent(this.listView, 1001, "Select");
                AppsActionsListener appsActionsListener = new AppsActionsListener();
                appsActionsListener.actionPerformed(actionEvent);
            }
        }
    }
}

