/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.client.AdminContext;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SolMailProps
extends UMgrPropsPanel {
    SolMailProps solMailProps = this;
    GenInfoPanel infoPanel;
    public static final Border emptyBorder5 = new EmptyBorder(5, 5, 5, 5);
    boolean isLocalScope;
    AdminMgmtScope ams;
    JTextField nsTextField;
    JLabel server;
    boolean needUpdate = false;

    public SolMailProps(UserObj userObj, GenInfoPanel genInfoPanel) {
        this.infoPanel = genInfoPanel;
        this.ams = AdminContext.instance().getAdminMgmtScope();
        this.setUpScopeContext();
        this.createGui(userObj);
        this.focusListener = new UMgrContextHelpListener(this.infoPanel, "uprop_mail");
        if (this.needUpdate && !this.isLocalScope) {
            this.nsTextField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "uprop_mail_server"));
        }
    }

    private void setUpScopeContext() {
        if (this.ams.getMgmtScopeType().equals("file") || this.ams.getMgmtScopeType().equals("dns")) {
            this.isLocalScope = true;
            return;
        }
        this.isLocalScope = false;
    }

    private void createGui(UserObj userObj) {
        SolServicesAttr solServicesAttr;
        String string = "";
        if (userObj.getSolServicesAttr() != null && (solServicesAttr = userObj.getSolServicesAttr()).getMailServer() != null) {
            string = solServicesAttr.getMailServer();
            if (solServicesAttr.getModifyMailServer()) {
                this.needUpdate = true;
            }
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("sol_mail_props_info"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(gridBagLayout);
        Constraints.constrain(this.solMailProps, jPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.4, 20, 16, 220, 16);
        JLabel jLabel = new JLabel(UMgrResourceStrings.getString("au_wiz_mail_lbl"));
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, jLabel, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 10, 24, 0, 0);
        if (this.needUpdate && !this.isLocalScope) {
            this.nsTextField = new JTextField(string, 15);
            this.nsTextField.setMinimumSize(this.nsTextField.getPreferredSize());
            Constraints.constrain(jPanel, this.nsTextField, 1, 0, 1, 1, 0, 17, 9.0, 0.0, 10, 16, 0, 0);
        } else {
            this.server = new JLabel(string);
            this.server.setForeground(Constants.PROPS_LABEL_COLOR);
            Constraints.constrain(jPanel, this.server, 1, 0, 1, 1, 0, 17, 9.0, 0.0, 10, 16, 0, 0);
        }
        JLabel jLabel2 = new JLabel(UMgrResourceStrings.getString("sol_mail_box"));
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel2.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, jLabel2, 0, 1, 1, 1, 0, 18, 1.0, 1.0, 10, 24, 0, 0);
        String string2 = new String(SolServicesAttr.DEFAULT_MAILBOX_DIRECTORY);
        string2 = string2.concat(userObj.getUserName());
        JLabel jLabel3 = new JLabel(string2);
        jLabel3.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(jPanel, jLabel3, 1, 1, 1, 1, 0, 18, 9.0, 1.0, 10, 16, 0, 0);
    }

    public boolean isMailSyntaxOK() {
        if (this.needUpdate && !this.isLocalScope) {
            if (CheckSyntax.isHomeDirServerOK(this.nsTextField.getText())) {
                return true;
            }
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, CheckSyntax.getErrorString());
            return false;
        }
        return true;
    }

    public UserObj updateSolMailProps(UserObj userObj) {
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (solServicesAttr == null) {
            solServicesAttr = new SolServicesAttr();
        }
        if (this.needUpdate && !this.isLocalScope) {
            String string = this.nsTextField.getText();
            solServicesAttr.setMailServer(string);
            userObj.setSolServicesAttr(solServicesAttr);
        }
        return userObj;
    }
}

