// -*- C++ -*-
/*
	Copyright 06/10/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _CTYPE_ISO_SUNWCC_H
#define _CTYPE_ISO_SUNWCC_H

#pragma ident "@(#)ctype_iso_SUNWCC.h	1.2  06/10/99 C++5.0"

extern "C" {

/********************************************/
/* IMPLEMENTATION DECLARATIONS              */
/********************************************/

#define	_U	0x00000001	/* Upper case */
#define	_L	0x00000002	/* Lower case */
#define	_N	0x00000004	/* Numeral (digit) */
#define	_S	0x00000008	/* Spacing character */
#define	_P	0x00000010	/* Punctuation */
#define	_C	0x00000020	/* Control character */
#define	_B	0x00000040	/* Blank */
#define	_X	0x00000080	/* heXadecimal digit */

#define	_ISUPPER	_U
#define	_ISLOWER	_L
#define	_ISDIGIT	_N
#define	_ISSPACE	_S
#define	_ISPUNCT	_P
#define	_ISCNTRL	_C
#define	_ISBLANK	_B
#define	_ISXDIGIT	_X
#define	_ISGRAPH	0x00002000
#define	_ISALPHA	0x00004000
#define	_ISPRINT	0x00008000
#define	_ISALNUM	(_ISALPHA | _ISDIGIT)

extern unsigned char	__ctype[];
extern unsigned int	*__ctype_mask;

/********************************************/
/* STANDARD DECLARATIONS IN NAMESPACE STD   */
/********************************************/
namespace std {

int tolower(int);
int toupper(int);

#if defined(__XPG4_CHAR_CLASS__) || defined(_XPG4_2) || \
	(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 == 4))
  inline int isalnum(int _c) { return __ctype_mask[_c] & _ISALNUM; }
  inline int isalpha(int _c) { return __ctype_mask[_c] & _ISALPHA; }
  inline int iscntrl(int _c) { return __ctype_mask[_c] & _ISCNTRL; }
  inline int isdigit(int _c) { return __ctype_mask[_c] & _ISDIGIT; }
  inline int isgraph(int _c) { return __ctype_mask[_c] & _ISGRAPH; }
  inline int islower(int _c) { return __ctype_mask[_c] & _ISLOWER; }
  inline int isprint(int _c) { return __ctype_mask[_c] & _ISPRINT; }
  inline int ispunct(int _c) { return __ctype_mask[_c] & _ISPUNCT; }
  inline int isspace(int _c) { return __ctype_mask[_c] & _ISSPACE; }
  inline int isupper(int _c) { return __ctype_mask[_c] & _ISUPPER; }
  inline int isxdigit(int _c){ return __ctype_mask[_c] & _ISXDIGIT; }
#else
  inline int isalnum(int _c) { return (__ctype+1)[_c] & (_U | _L | _N); }
  inline int isalpha(int _c) { return (__ctype+1)[_c] & (_U | _L); }
  inline int iscntrl(int _c) { return (__ctype+1)[_c] & _C; }
  inline int isdigit(int _c) { return (__ctype+1)[_c] & _N; }
  inline int isgraph(int _c) { return (__ctype+1)[_c] & (_P | _U | _L | _N); }
  inline int islower(int _c) { return (__ctype+1)[_c] & _L; }
  inline int isprint(int _c) { return (__ctype+1)[_c] & (_P | _U | _L | _N | _B); }
  inline int ispunct(int _c) { return (__ctype+1)[_c] & _P; }
  inline int isspace(int _c) { return (__ctype+1)[_c] & _S; }
  inline int isupper(int _c) { return (__ctype+1)[_c] & _U; }
  inline int isxdigit(int _c){ return (__ctype+1)[_c] & _X; }
#endif  /* defined(__XPG4_CHAR_CLASS__) || defined(_XPG4_2) || ... */

} /* end of namespace std */

} /* end of extern "C" */

#endif /* _CTYPE_ISO_SUNWCC_H */
