/*
	Copyright 06/10/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _SETJMP_ISO_SUNWCC_H
#define _SETJMP_ISO_SUNWCC_H

#pragma ident "@(#)setjmp_iso_SUNWCC.h	1.2  06/10/99 C++5.0"

extern "C" {

/*
 * The sizes of the jump-buffer (_JBLEN) and the sigjump-buffer
 * (_SIGJBLEN) are defined by the appropriate, processor specific,
 * ABI.
 */
#ifndef _JBLEN
  #if defined(i386) || defined(__i386)
    #define	_JBLEN		10	/* ABI value */
    #define	_SIGJBLEN	128	/* ABI value */
  #elif defined(__sparcv9)
    #define	_JBLEN		12	/* ABI value */
    #define	_SIGJBLEN	19	/* ABI value */
  #elif defined(sparc) || defined(__sparc)
    #define	_JBLEN		12	/* ABI value */
    #define	_SIGJBLEN	19	/* ABI value */
  #else
    #error "ISA not supported"
  #endif
#endif
  
namespace std {

  #if defined(i386) || defined(sparc) || defined(__i386) || defined(__sparc)
    #if defined(_LP64) || defined(_I32LPx)
      typedef	long	jmp_buf[_JBLEN];
    #else
      typedef int	jmp_buf[_JBLEN];
    #endif
  #else
    #error "ISA not supported"
  #endif

  extern void longjmp(jmp_buf, int);

} /* end of namespace std */

/* setjmp must be a macro, so is not in namespace std */
extern int setjmp(std::jmp_buf);
#pragma unknown_control_flow(setjmp)
#define setjmp(env) setjmp(env)

} /* end of extern "C" */

#endif /* _SETJMP_ISO_SUNWCC_H */
