/*
	Copyright 06/10/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _SIGNAL_ISO_SUNWCC_H
#define _SIGNAL_ISO_SUNWCC_H
  
#pragma ident "@(#)signal_iso_SUNWCC.h	1.2  06/10/99 C++5.0"

/* Other headers include <sys/signal.h>, which provides these macros.
 * But we must not prevent later inclusion of <sys/signal.h>
 */
#ifndef _SYS_SIGNAL_H

#define	SIGHUP	   1	/* hangup */
#define	SIGINT	   2	/* interrupt (rubout) */
#define	SIGQUIT	   3	/* quit (ASCII FS) */
#define	SIGILL	   4	/* illegal instruction (not reset when caught) */
#define	SIGTRAP	   5	/* trace trap (not reset when caught) */
#define	SIGIOT	   6	/* IOT instruction */
#define	SIGABRT    6	/* used by abort, replace SIGIOT in the future */
#define	SIGEMT	   7	/* EMT instruction */
#define	SIGFPE	   8	/* floating point exception */
#define	SIGKILL	   9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	  10	/* bus error */
#define	SIGSEGV	  11	/* segmentation violation */
#define	SIGSYS	  12	/* bad argument to system call */
#define	SIGPIPE	  13	/* write on a pipe with no one to read it */
#define	SIGALRM	  14	/* alarm clock */
#define	SIGTERM	  15	/* software termination signal from kill */
#define	SIGUSR1	  16	/* user defined signal 1 */
#define	SIGUSR2	  17	/* user defined signal 2 */
#define	SIGCLD	  18	/* child status change */
#define	SIGCHLD	  18	/* child status change alias (POSIX) */
#define	SIGPWR	  19	/* power-fail restart */
#define	SIGWINCH  20	/* window size change */
#define	SIGURG	  21	/* urgent socket condition */
#define	SIGPOLL   22	/* pollable event occured */
#define	SIGIO	SIGPOLL	/* socket I/O possible (SIGPOLL alias) */
#define	SIGSTOP   23	/* stop (cannot be caught or ignored) */
#define	SIGTSTP   24	/* user stop requested from tty */
#define	SIGCONT   25	/* stopped process has been continued */
#define	SIGTTIN   26	/* background tty read attempted */
#define	SIGTTOU   27	/* background tty write attempted */
#define	SIGVTALRM 28	/* virtual timer expired */
#define	SIGPROF   29	/* profiling timer expired */
#define	SIGXCPU   30	/* exceeded cpu limit */
#define	SIGXFSZ   31	/* exceeded file size limit */
#define	SIGWAITING 32	/* process's lwps are blocked */
#define	SIGLWP	  33	/* special signal used by thread library */
#define	SIGFREEZE 34	/* special signal used by CPR */
#define	SIGTHAW   35	/* special signal used by CPR */
#define	SIGCANCEL 36	/* thread cancellation signal used by libthread */

extern "C" {

  typedef void SIG_FUNC_TYP(int);
  typedef SIG_FUNC_TYP *SIG_TYP;
  #define SIG_PF SIG_TYP

  #define SIG_DFL	(SIG_PF)0
  #define SIG_ERR (SIG_PF)-1
  #define SIG_IGN	(SIG_PF)1
  #define SIG_HOLD (SIG_PF)2

  #define SIG_BLOCK	1
  #define SIG_UNBLOCK	2
  #define SIG_SETMASK	3

  #define SIGNO_MASK	0xFF
  #define SIGDEFER	0x100
  #define SIGHOLD		0x200
  #define SIGRELSE	0x400
  #define SIGIGNORE	0x800
  #define SIGPAUSE	0x1000

  long   _sysconf(int);

}

#include <sys/unistd.h>         /* needed for _SC_SIGRT_MIN/MAX */

extern "C" {

#if defined(__SunOS_5_5_1)
  #define _SIGRTMIN	37	/* first (highest-priority) realtime signal */
  #define _SIGRTMAX	44	/* last (lowest-priority) realtime signal */
  #define SIGRTMIN _sysconf(_SC_SIGRT_MIN)	/* first realtime signal */
  #define SIGRTMAX _sysconf(_SC_SIGRT_MAX)	/* last realtime signal */
#elif defined(__SunOS_5_6)
  #define SIGLOST	37	/* resource lost (eg, record-lock lost) */
  #define _SIGRTMIN	38	/* first (highest-priority) realtime signal */
  #define _SIGRTMAX	45	/* last (lowest-priority) realtime signal */
  #define SIGRTMIN _sysconf(_SC_SIGRT_MIN)	/* first realtime signal */
  #define SIGRTMAX _sysconf(_SC_SIGRT_MAX)	/* last realtime signal */
#else
  #define SIGLOST	37	/* resource lost (eg, record-lock lost) */
  #define _SIGRTMIN	38	/* first (highest-priority) realtime signal */
  #define _SIGRTMAX	45	/* last (lowest-priority) realtime signal */
  #define SIGRTMIN ((int)_sysconf(_SC_SIGRT_MIN)) /* first realtime signal */
  #define SIGRTMAX ((int)_sysconf(_SC_SIGRT_MAX)) /* last realtime signal */
#endif

}

#endif /* _SYS_SIGNAL_H */

namespace std {
  extern "C" {
    typedef int	sig_atomic_t;
    int    raise(int);
    SIG_PF signal(int, SIG_PF);
  }
}

#endif /* _SIGNAL_ISO_SUNWCC_H */
