/*
	Copyright 06/21/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _CTYPE_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "ctype.h"
#else
  
  #define _CTYPE_H
  #pragma ident "@(#)ctype.h	1.9  06/21/99 C++5.0"

  #include <ctype_iso_SUNWCC.h>
  
  extern "C" {
  
  #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
    extern long		*__trans_upper;
    extern long		*__trans_lower;
  #else
    extern int		*__trans_upper;
    extern int		*__trans_lower;
  #endif
  
  using std::isalnum;
  using std::isalpha;
  using std::iscntrl;
  using std::isdigit;
  using std::isgraph;
  using std::islower;
  using std::isprint;
  using std::ispunct;
  using std::isspace;
  using std::isupper;
  using std::isxdigit;
  using std::tolower;
  using std::toupper;
  
  #if defined(__EXTENSIONS__) ||  \
  		!defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE)
    int _tolower(int);
    int _toupper(int);
  #endif
  
  #if !#lint(on) && !defined(__lint)
    #if defined(__EXTENSIONS__) || (!defined(_POSIX_C_SOURCE)) || \
	  defined(_XOPEN_SOURCE) || defined(__XPG4_CHAR_CLASS__)
      inline int isascii(int _c) { return (!(_c & ~0177)); }
      inline int toascii(int _c) { return (_c & 0177); }
      #if defined(__XPG4_CHAR_CLASS__) || defined(_XPG4_2) || \
	    (defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 >= 4))
	#define	_toupper(c)	(__trans_upper[c])
	#define	_tolower(c)	(__trans_lower[c])
      #else
	#define	_toupper(c)	((__ctype + 258)[c])
	#define	_tolower(c)	((__ctype + 258)[c])
      #endif
    #endif
  #endif
  
  } /* end of extern "C" */
  
#endif /* _ISO_CPP_14882_1998 */

#endif	/* _CTYPE_H */
