/*
	Copyright 06/21/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _SIGNAL_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "signal.h"
#else

  #define _SIGNAL_H
  #pragma ident "@(#)signal.h	1.10  06/21/99 C++5.0"

  #include <sys/types.h> /* pid_t/uid_t/size_t/clock_t/caddr_t/pthread_t */

  #include <sys/signal.h>
  #include <signal_iso_SUNWCC.h>

  using std::sig_atomic_t;
  using std::raise;
  using std::signal;

  extern "C" {
    extern const char** _sys_siglistp;	/* signal descriptions */
    extern const int    _sys_siglistn;	/* # of signal descriptions */
    #if defined(__EXTENSIONS__) || \
	  (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))
      #define _sys_siglist    _sys_siglistp
      #define _sys_nsig       _sys_siglistn
    #endif
  }

  #ifndef _SYS_SIGNAL_H
  #define _SYS_SIGNAL_H
    #if defined(__SunOS_5_5_1)
      #include "./sig251_SUNWCC.h"
    #elif defined(__SunOS_5_6)
      #include "./sig26_SUNWCC.h"
    #else
      #include "./sig27_SUNWCC.h"
    #endif
  #endif

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	(_POSIX_C_SOURCE > 2)
    #include <sys/siginfo.h>
    #if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
      #include <time.h>
      extern "C" {
	int pthread_kill(pthread_t, int);
	int pthread_sigmask(int, const sigset_t*, sigset_t*);
      }
    #else
      #include <sys/time.h>
    #endif
  #endif

  extern "C" {

  int kill(pid_t, int);
  int sigaction(int, const sigaction *, sigaction *);

  #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
    #ifndef	sigaddset
      int sigaddset(sigset_t *, int);
    #endif
    #ifndef	sigdelset
      int sigdelset(sigset_t *, int);
    #endif
    #ifndef	sigemptyset
      int sigemptyset(sigset_t *);
    #endif
    #ifndef	sigfillset
      int sigfillset(sigset_t *);
    #endif
    #ifndef	sigismember
      int sigismember(const sigset_t *, int);
    #endif
  #else /* __SunOS >= 5_7 */
    #ifndef	_KERNEL
      int sigaddset(sigset_t *, int);
      int sigdelset(sigset_t *, int);
      int sigemptyset(sigset_t *);
      int sigfillset(sigset_t *);
      int sigismember(const sigset_t *, int);
    #endif
  #endif

  int sigpending(sigset_t *);
  int sigprocmask(int, const sigset_t *, sigset_t *);
  int sigsuspend(const sigset_t *);

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))
    #include <sys/procset.h>
    int gsignal(int);
    int (*ssignal(int, int (*)(int)))(int);
    int sigsend(idtype_t, id_t, int);
    int sigsendset(const procset_t *, int);
    int sig2str(int, char *);
    int str2sig(const char *, int *);
    #define	SIG2STR_MAX	32
  #endif

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	defined(_XPG4_2)
    void (*bsd_signal(int, void (*)(int)))(int);
    int killpg(pid_t, int);
    int siginterrupt(int, int);
    int sigaltstack(const stack_t *, stack_t *);
    int sighold(int);
    int sigignore(int);
    int sigpause(int);
    int sigrelse(int);
    void (*sigset(int, void (*)(int)))(int);
    int sigstack(struct sigstack *, struct sigstack *);
  #endif

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	(_POSIX_C_SOURCE > 2)
    int sigwaitinfo(const sigset_t *, siginfo_t *);
    int sigtimedwait(const sigset_t *, siginfo_t *, const timespec *);
    int sigqueue(pid_t, int, const union sigval);
  #endif

  #if	defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	(_POSIX_C_SOURCE - 0 >= 199506L) || defined(_POSIX_PTHREAD_SEMANTICS)

    #if	(_POSIX_C_SOURCE - 0 >= 199506L) || defined(_POSIX_PTHREAD_SEMANTICS)
      #ifdef __PRAGMA_REDEFINE_EXTNAME
	extern int sigwait(const sigset_t *, int *);
	#pragma redefine_extname sigwait __posix_sigwait
      #else
	static int
	sigwait(const sigset_t *__setp, int *__signo)
	{
	      extern int __posix_sigwait(const sigset_t *, int *);
	      return (__posix_sigwait(__setp, __signo));
	}
      #endif
    #else
      extern int sigwait(sigset_t *);
    #endif

  #endif

  } /* end of extern "C" */

#endif /* _ISO_CPP_14882_1998 */
#endif	/* _SIGNAL_H */
