/*
	Copyright 01/27/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _STRING_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "string.h"
#else
  
  #define _STRING_H
  #pragma ident "@(#)string.h	1.10  06/21/99 C++5.0"   /* SVr4.0 2.34.1.2 */

  #include <string_iso_SUNWCC.h>
 
  using std::size_t;
  using std::memchr;
  using std::memcmp;
  using std::memcpy;
  using std::memmove;
  using std::memset;
  using std::strcat;
  using std::strchr;
  using std::strcmp;
  using std::strcoll;
  using std::strcpy;
  using std::strcspn;
  using std::strerror;
  using std::strlen;
  using std::strncat;
  using std::strncmp;
  using std::strncpy;
  using std::strpbrk;
  using std::strrchr;
  using std::strspn;
  using std::strstr;
  using std::strtok;
  using std::strxfrm;
  
  
  extern "C" {
  
  #if	defined(__EXTENSIONS__) || defined(_REENTRANT) || \
  	    (_POSIX_C_SOURCE - 0 >= 199506L)
    char* strtok_r(char *, const char *, char **);
  #endif

  #if defined(__EXTENSIONS__) || \
  		defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE)
    void* memccpy(void *, const void *, int, size_t);
  #endif
  
  #if defined(__EXTENSIONS__) || \
      (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))
    char* strsignal(int);
    #if defined(__SunOS_5_5_1)
      int ffs(const int);
    #else
      int ffs(int);
    #endif
    int strcasecmp(const char *, const char *);
    int strncasecmp(const char *, const char *, size_t);
  #endif
  
  #if defined(__EXTENSIONS__) || defined(_XPG4_2) || \
		(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))
    char* strdup(const char *);
  #endif
  
  } /* end of extern "C" */
  
  
#endif /* _ISO_CPP_14882_1998 */

#endif	/* _STRING_H */
