/*
	Copyright 06/21/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _TIME_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "time.h"
#else

  #define _TIME_H
  #pragma ident "@(#)time.h	1.11  06/21/99 C++5.0"

  #include <time_iso_SUNWCC.h>

  using std::size_t;
  using std::clock_t;
  using std::time_t;
  using std::asctime;
  using std::clock;
  using std::ctime;
  using std::difftime;
  using std::gmtime;
  using std::localtime;
  using std::mktime;
  using std::strftime;
  using std::time;
  using std::tm;

  #ifndef _CLOCKID_T
  #define _CLOCKID_T
    typedef int	clockid_t;
  #endif

  #ifndef _TIMER_T
  #define _TIMER_T
    typedef int	timer_t;
  #endif

  #if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
      #include <sys/types.h>
  #endif

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	(_POSIX_C_SOURCE > 2)
    #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
      #include <sys/time.h>	/* needed for struct timespec */
      #include <sys/siginfo.h>	/* needed for struct sigevent */
    #else
      #include <sys/time_impl.h>
    #endif
  #endif

  extern "C" {

  #if defined(__EXTENSIONS__) || defined(_REENTRANT) || \
  	    (_POSIX_C_SOURCE - 0 >= 199506L)
    struct tm* gmtime_r(const time_t*, struct tm*);
    struct tm* localtime_r(const time_t*, struct tm*);
  #endif

  #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	(defined(_XOPEN_SOURCE) && _XOPEN_VERSION - 0 >= 4) || \
  	defined(__EXTENSIONS__)
    char* strptime(const char*, const char*, struct tm*);
  #endif

  #if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
    #ifndef	_SIGVAL
    #define	_SIGVAL
      union sigval {
	    int	  sival_int;
	    void* sival_ptr;
      };
    #endif
    #ifndef	_SIGEVENT
    #define	_SIGEVENT
      struct sigevent {
	  int		sigev_notify;
	  int		sigev_signo;
	  union sigval	sigev_value;
	  void		(*sigev_notify_function)(union sigval);
	  pthread_attr_t* sigev_notify_attributes;
	  int		__sigev_pad2;
      };
    #endif
  #endif

  #if defined(__EXTENSIONS__) || ( \
  	!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	(_POSIX_C_SOURCE > 2)
    int clock_getres(clockid_t, struct timespec*);
    int clock_gettime(clockid_t, struct timespec*);
    int clock_settime(clockid_t, const struct timespec*);
    int timer_create(clockid_t, struct sigevent*, timer_t*);
    int timer_delete(timer_t);
    int timer_getoverrun(timer_t);
    int timer_gettime(timer_t, struct itimerspec*);
    int timer_settime(timer_t, int, const struct itimerspec*,
		  struct itimerspec*);
    int nanosleep(const struct timespec*, struct timespec*);
  #endif

  extern void tzset(void);
  extern char* tzname[2];
  #ifndef CLK_TCK
    extern long _sysconf(int);
    #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
      #define	CLK_TCK	_sysconf(3)
    #else
      #define	CLK_TCK	((clock_t) _sysconf(3))
    #endif
  #endif
  #if defined(__EXTENSIONS__) || \
	(!defined(_POSIX_C_SOURCE)) || defined(_XOPEN_SOURCE)
    extern long timezone;
    extern int daylight;
  #endif

  #if !defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)
    int cftime(char*, char*, const time_t*);
    int ascftime(char*, const char*, const struct tm*);
    extern long altzone;
  #endif

  #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	defined(_XPG4_2) || defined(__EXTENSIONS__)
    struct tm* getdate(const char*);
    #ifdef	_REENTRANT
      #undef getdate_err
      #define	getdate_err* (int*)_getdate_err_addr()
      int* _getdate_err_addr(void);
    #else
      extern int getdate_err;
    #endif
  #endif

  #if	defined(__EXTENSIONS__) || defined(_REENTRANT) || \
  	(_POSIX_C_SOURCE - 0 >= 199506L) || defined(_POSIX_PTHREAD_SEMANTICS)
    #if	(_POSIX_C_SOURCE - 0 >= 199506L) || defined(_POSIX_PTHREAD_SEMANTICS)
      #ifdef __PRAGMA_REDEFINE_EXTNAME
	char* asctime_r(const struct tm*, char*);
	char* ctime_r(const time_t*, char*);
	#pragma redefine_extname ctime_r __posix_ctime_r
	#pragma redefine_extname asctime_r __posix_asctime_r
      #else 
	static char* asctime_r(const struct tm* __tm, char* __buf)
	{
	      extern char* __posix_asctime_r(const struct tm*, char*);
	      return (__posix_asctime_r(__tm, __buf));
	}
	static char* ctime_r(const time_t* __time, char* __buf)
	{
	      extern char* __posix_ctime_r(const time_t*, char*);
	      return (__posix_ctime_r(__time, __buf));
	}
      #endif

    #else
      char* asctime_r(const struct tm*, char*, int);
      char* ctime_r(const time_t*, char*, int);
    #endif
  #endif

  } /* end of extern "C" */

#endif /* _ISO_CPP_14882_1998 */

#endif	/* _TIME_H */
