/*
	Copyright 06/29/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _WCHAR_H
#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "wchar.h"
#else
  
  #define _WCHAR_H
  #pragma ident "@(#)wchar.h	1.14  06/29/99 C++5.0"
  
  #include <wchar_iso_SUNWCC.h>

  #if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6) && \
	defined(__EXTENSIONS__)
    #include <ctype.h>
    #include <stddef.h>
    #include <stdio.h>
  #endif
  
  using std::wint_t;
  using std::size_t;
  using std::tm;

  #if !defined(__SunOS_5_5_1)
    #if defined(__SunOS_5_6) || \
	(!(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 == 4)) && \
	defined(__PRAGMA_REDEFINE_EXTNAME))
      using std::fgetwc;
      using std::fgetws;
      using std::fputwc;
      using std::fputws;
      using std::getwc;
      using std::getwchar;
      using std::putwc;
      using std::putwchar;
      using std::ungetwc;
    #endif 
    /* otherwise these names are #defined to __xpg5 names */
  #endif 

  using std::wcstod;
  using std::wcstol;
  using std::wcscpy;
  using std::wcsncpy;
  using std::wcscat;
  using std::wcsncat;
  using std::wcscmp;
  using std::wcscoll;
  using std::wcsncmp;
  using std::wcsxfrm;
  using std::wcschr;
  using std::wcscspn;
  using std::wcspbrk;
  using std::wcsrchr;
  using std::wcsspn;
  using std::wcslen;
 
  #if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
    using std::mbstate_t;
    using std::wcstok;
    using std::wcsftime;
    using std::wmemchr;
    using std::wmemcmp;
    using std::wmemcpy;
    using std::wmemmove;
    using std::wmemset;
    using std::wcsstr;
    using std::fwide;
    using std::fwprintf;
    using std::fwscanf;
    using std::vfwprintf;
    using std::vwprintf;
    using std::vswprintf;
    using std::wprintf;
    using std::swscanf;
    using std::wscanf;
    using std::swprintf;
    using std::btowc;
    using std::wctob;
    using std::mbsinit;
    using std::mbrlen;
    using std::mbrtowc;
    using std::mbsrtowcs;
    using std::wcrtomb;
    using std::wcsrtombs;
  #endif

  /* Solaris extras */

  namespace std {
    extern "C" {
    typedef  int wctype_t;
    int      iswalpha(wint_t);
    int      iswupper(wint_t);
    int      iswlower(wint_t);
    int      iswdigit(wint_t);
    int      iswxdigit(wint_t);
    int      iswalnum(wint_t);
    int      iswspace(wint_t);
    int      iswpunct(wint_t);
    int      iswprint(wint_t);
    int      iswgraph(wint_t);
    int      iswcntrl(wint_t);
    int      iswctype(wint_t, wctype_t);
    wint_t   towlower(wint_t);
    wint_t   towupper(wint_t);
    wctype_t wctype(const char *);
    }
  }
  using std::wctype_t;
  using std::iswalpha;
  using std::iswupper;
  using std::iswlower;
  using std::iswdigit;
  using std::iswxdigit;
  using std::iswalnum;
  using std::iswspace;
  using std::iswpunct;
  using std::iswprint;
  using std::iswgraph;
  using std::iswcntrl;
  using std::iswctype;
  using std::towlower;
  using std::towupper;
  using std::wctype;

  extern "C" {
    wchar_t* wcswcs(const wchar_t *, const wchar_t *);
    int      wcswidth(const wchar_t *, size_t);
    int      wcwidth(const wchar_t);
  }

#endif /* _ISO_CPP_14882_1998 */
#endif	/* _WCHAR_H */
