/*
	Copyright 06/10/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _STDARG_ISO_SUNWCC_H
#define _STDARG_ISO_SUNWCC_H
  
#pragma ident "@(#)stdarg_iso_SUNWCC.h	1.2  06/10/99 C++5.0"

#ifndef	_SYS_VA_LIST_H
typedef void *__va_list;
#endif

extern "C" {

namespace std {
  typedef __va_list va_list;
}

#if (defined(__BUILTIN_VA_ARG_INCR) || defined(sparc) || defined(__sparc) || \
    defined(i386) || defined(__i386)) && !(defined(lint) || defined(__lint))
  #define va_start(list, name) (void)(list = (std::va_list) &__builtin_va_alist)
  #define va_arg(list, mode) ((mode *)__builtin_va_arg_incr((mode *)list))[0]
#else
  #define va_start(list, name) (void) (list = (void *)((char *)&name + \
	  ((sizeof (name) + (sizeof (int) - 1)) & ~(sizeof (int) - 1))))
  #define va_arg(list, mode) \
	  ((mode *)(list = (void *)((char *)list + sizeof (mode))))[-1]
#endif

extern void va_end(std::va_list);
#define	va_end(list) (void)0
					 
} /* end of extern "C" */

#endif	/* _STDARG_ISO_SUNWCC_H */
