/*
	Copyright 06/10/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef	_WCTYPE_ISO_SUNWCC_H
#define	_WCTYPE_ISO_SUNWCC_H

#pragma ident "@(#)wctype_iso_SUNWCC.h	1.2  06/10/99 C++5.0"

extern "C" {

  /* bit definition for character class */

#define	_E1	0x00000100	/* phonogram (international use) */
#define	_E2	0x00000200	/* ideogram (international use) */
#define	_E3	0x00000400	/* English (international use) */
#define	_E4	0x00000800	/* number (international use) */
#define	_E5	0x00001000	/* special (international use) */
#define	_E6	0x00002000	/* other characters (international use) */
#define	_E7	0x00004000	/* reserved (international use) */
#define	_E8	0x00008000	/* reserved (international use) */
#define	_E9	0x00010000
#define	_E10	0x00020000
#define	_E11	0x00040000
#define	_E12	0x00080000
#define	_E13	0x00100000
#define	_E14	0x00200000
#define	_E15	0x00400000
#define	_E16	0x00800000
#define	_E17	0x01000000
#define	_E18	0x02000000
#define	_E19	0x04000000
#define	_E20	0x08000000
#define	_E21	0x10000000
#define	_E22	0x20000000
#define	_E23	0x40000000
#define	_E24	0x80000000

namespace std {

#if defined(_LP64)
  typedef	int	wint_t;
#else
  typedef	long	wint_t;
#endif

typedef	int	wctype_t;

#if !defined(__SunOS_5_5_1)
  typedef unsigned int	wctrans_t;
#endif

#if (!(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 == 4)))
  #ifndef WEOF
    #define	WEOF	((wint_t) (-1))
  #endif
#endif

#if !defined(__SunOS_5_5_1)
  wctrans_t wctrans(const char *);
  wint_t    towctrans(wint_t, wctrans_t);
#endif

int    iswalpha(wint_t);
int    iswupper(wint_t);
int    iswlower(wint_t);
int    iswdigit(wint_t);
int    iswxdigit(wint_t);
int    iswalnum(wint_t);
int    iswspace(wint_t);
int    iswpunct(wint_t);
int    iswprint(wint_t);
int    iswgraph(wint_t);
int    iswcntrl(wint_t);
wint_t towlower(wint_t);
wint_t towupper(wint_t);
int    iswctype(wint_t, wctype_t);
wctype_t wctype(const char *);

} /* end of namespace std */

} /* end of extern "C" */

#endif	/* _WCTYPE_ISO_SUNWCC_H */
