/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.https;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.plugin.protocol.ProxyHandler;
import sun.plugin.protocol.ProxyInfo;
import sun.plugin.protocol.http.SocksSocket;
import sun.security.AuthContext;
import sun.security.ssl.SSLSocketImpl;
import sun.security.x509.X500Name;

public final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static String[] ciphers = null;
    private static final int httpsPortNumber = 443;
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSession session;
    static ProxyHandler handler;

    protected int getDefaultPort() {
        return 443;
    }

    public static synchronized void resetSecureProperties() {
        String string = System.getProperty("https.cipherSuites");
        if (string == null || "".equals(string)) {
            ciphers = null;
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        ciphers = new String[vector.size()];
        int n = 0;
        while (n < ciphers.length) {
            HttpsClient.ciphers[n] = (String)vector.elementAt(n);
            ++n;
        }
    }

    public static void setProxyHandler(ProxyHandler proxyHandler) {
        handler = proxyHandler;
    }

    public HttpsClient(URL uRL, String string, int n) throws IOException {
        super(uRL, true);
    }

    public HttpsClient(URL uRL) throws IOException {
        super(uRL, true);
    }

    public static HttpClient New(URL uRL) throws IOException {
        HttpsClient httpsClient = (HttpsClient)HttpClient.kac.get(uRL);
        if (httpsClient == null) {
            httpsClient = new HttpsClient(uRL);
        } else {
            httpsClient.url = uRL;
        }
        return httpsClient;
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        Object object;
        ProxyInfo proxyInfo = null;
        if (this.proxyDisabled) {
            this.instTunnelHost = null;
            this.instTunnelPort = -1;
            if (handler != null) {
                proxyInfo = handler.getProxyInfo(this.url);
            }
            if (proxyInfo != null) {
                this.instTunnelHost = proxyInfo.getProxy();
                this.instTunnelPort = proxyInfo.getPort();
            }
            this.instTunnelPort = this.instTunnelPort < 0 ? super.getDefaultPort() : this.instTunnelPort;
        }
        SSLSocket sSLSocket = null;
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        if (proxyInfo == null || !proxyInfo.isProxyUsed()) {
            sSLSocket = (SSLSocket)socketFactory.createSocket(string, n);
        } else {
            try {
                object = null;
                object = proxyInfo != null && proxyInfo.isSocksUsed() ? new SocksSocket(this.instTunnelHost, this.instTunnelPort, proxyInfo.getSocksProxy(), proxyInfo.getSocksPort()) : new Socket(this.instTunnelHost, this.instTunnelPort);
                this.doTunnelHandshake((Socket)object, string, n);
                sSLSocket = new SSLSocketImpl((Socket)object, AuthContext.getDefault(), string, n);
            }
            catch (IOException iOException) {
                try {
                    sSLSocket = (SSLSocket)socketFactory.createSocket(string, n);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
        }
        if (ciphers != null) {
            sSLSocket.setEnabledCipherSuites(ciphers);
        }
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.getOutputStream().write(new byte[0]);
        this.session = sSLSocket.getSession();
        object = null;
        try {
            X500Name x500Name = (X500Name)this.session.getPeerCertificateChain()[0].getSubjectDN();
            object = x500Name.getCommonName();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return sSLSocket;
        }
        if (object == null || !((String)object).equalsIgnoreCase(this.url.getHost())) {
            sSLSocket.close();
            this.session.invalidate();
            throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">, but cert says <" + (String)object + ">");
        }
        return sSLSocket;
    }

    public String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public X509Certificate[] getServerCertificateChain() {
        try {
            return this.session.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
    }

    private void doTunnelHandshake(Socket socket, String string, int n) throws IOException {
        String string2;
        byte[] byArray;
        OutputStream outputStream = socket.getOutputStream();
        String string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            byArray = string3.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string3.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        while (n3 < 2) {
            int n4 = inputStream.read();
            if (n4 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n4 == 10) {
                bl = true;
                ++n3;
                continue;
            }
            if (n4 == 13) continue;
            n3 = 0;
            if (bl || n2 >= byArray2.length) continue;
            byArray2[n2++] = (byte)n4;
        }
        try {
            string2 = new String(byArray2, 0, n2, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray2, 0, n2);
        }
        if (!string2.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + this.instTunnelHost + ":" + this.instTunnelPort + ".  Proxy returns \"" + string2 + "\"");
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.session = handshakeCompletedEvent.getSession();
    }

    static {
        HttpsClient.resetSecureProperties();
        handler = null;
    }
}

