/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.jdk12.https;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.cert.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.plugin.protocol.PluginProxyHandler;
import sun.plugin.protocol.ProxyHandler;
import sun.plugin.protocol.ProxyInfo;
import sun.plugin.protocol.jdk12.http.HttpURLConnection;
import sun.plugin.protocol.jdk12.https.Handler;
import sun.plugin.protocol.jdk12.https.HttpsClient;

public class HttpsURLConnection
extends HttpURLConnection {
    HttpsURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    public synchronized void connect() throws IOException {
        SecurityManager securityManager;
        if (this.connected) {
            return;
        }
        ProxyHandler proxyHandler = PluginProxyHandler.getDefaultProxyHandler();
        ProxyInfo proxyInfo = null;
        if (proxyHandler != null) {
            proxyInfo = proxyHandler.getProxyInfo(this.url);
        }
        if (proxyInfo != null) {
            this.proxy = proxyInfo.getProxy();
            this.proxyPort = proxyInfo.getPort();
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        try {
            AccessController.doPrivileged(new PrivilegedBlockAction(this));
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
        this.setUseCaches(false);
        this.connected = true;
    }

    public String getCipherSuite() {
        return ((HttpsClient)this.http).getCipherSuite();
    }

    protected HttpClient getNewClient(URL uRL) throws IOException {
        return new HttpsClient(uRL, this.proxy, this.proxyPort);
    }

    protected HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        throw new IOException("HTTPS proxying not supported");
    }

    public X509Certificate[] getServerCertificateChain() {
        return ((HttpsClient)this.http).getServerCertificateChain();
    }

    void privBlock() throws Exception {
        if ("https".equals(this.url.getProtocol())) {
            this.http = HttpsClient.New(this.url, this.proxy, this.proxyPort);
        } else {
            super.connect();
        }
    }

    class PrivilegedBlockAction
    implements PrivilegedExceptionAction {
        HttpsURLConnection conn;

        PrivilegedBlockAction(HttpsURLConnection httpsURLConnection2) {
            this.conn = httpsURLConnection2;
        }

        public Object run() throws Exception {
            this.conn.privBlock();
            return null;
        }
    }
}

