/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmpbridge;

import com.sun.symon.base.server.emitters.snmpbridge.SnmpJobBase;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcListUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

class Concentrator
implements Runnable {
    private InputStream InStream;
    private OutputStream OutStream;

    Concentrator(String string, int n) throws UnknownHostException, IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        Socket socket = new Socket(string, n);
        this.InStream = new BufferedInputStream(socket.getInputStream());
        this.OutStream = socket.getOutputStream();
        Thread thread = new Thread((Runnable)this, "Bridge-Reader");
        thread.start();
    }

    private void handleError(SnmpJobBase snmpJobBase, String string) {
        if (snmpJobBase == null) {
            UcDDL.logErrorMessage((String)string);
        } else {
            snmpJobBase.handleClientError(string);
        }
    }

    private void handleResponse(SnmpJobBase snmpJobBase, String string, String string2) {
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)string2, vector)) {
            UcDDL.logErrorMessage((String)("Invalid contents: '" + string2 + "' (not a TCL list)"));
            return;
        }
        if (vector.size() != 3) {
            UcDDL.logErrorMessage((String)("Invalid ARC argument count - " + vector.size()));
            UcDDL.logErrorMessage((String)("ARC contents: '" + string2 + "'"));
            return;
        }
        String string3 = (String)vector.elementAt(0);
        if (string3.compareTo("data") == 0) {
            String string4 = (String)vector.elementAt(2);
            if (snmpJobBase == null) {
                UcDDL.logWarningMessage((String)("No job registered for tid '" + string + "'"));
            } else {
                snmpJobBase.handleData(string4);
            }
        } else if (string3.compareTo("error") == 0 || string3.compareTo("warning") == 0) {
            String string5 = (String)vector.elementAt(2);
            this.handleError(snmpJobBase, string5);
        } else if (string3.compareTo("control") != 0) {
            UcDDL.logErrorMessage((String)("Invalid ARC code: '" + string3 + "'"));
        }
    }

    private void processBuffer(String string) {
        int n = string.indexOf("TYPE=");
        int n2 = string.indexOf("ID=");
        int n3 = string.indexOf("CONTENTS=");
        if (n < 0 || n2 <= n + 5 || n3 <= n2 + 3) {
            UcDDL.logErrorMessage((String)"Concentrator protocol tags out of order or missing");
            UcDDL.logErrorMessage((String)("Packet:" + string + ":"));
            return;
        }
        int n4 = string.indexOf(32, n += 5);
        if (n4 < 0) {
            UcDDL.logErrorMessage((String)"TYPE specifier missing spacer");
            UcDDL.logErrorMessage((String)("Packet:" + string + ":"));
            return;
        }
        String string2 = string.substring(n, n4);
        boolean bl = false;
        if (string2.compareTo("error") == 0) {
            bl = true;
        } else {
            if (string2.compareTo("data") == 0) {
                return;
            }
            if (string2.compareTo("response") != 0) {
                UcDDL.logErrorMessage((String)("Invalid TYPE specification - " + string2));
                return;
            }
        }
        n4 = string.indexOf(32, n2 += 3);
        if (n4 < 0) {
            UcDDL.logErrorMessage((String)"ID specifier missing spacer");
            UcDDL.logErrorMessage((String)("Packet:" + string + ":"));
            return;
        }
        String string3 = string.substring(n2, n4);
        SnmpJobBase snmpJobBase = SnmpJobBase.lookup(string3);
        String string4 = string.substring(n3 + 9);
        if (bl) {
            this.handleError(snmpJobBase, string4);
        } else {
            this.handleResponse(snmpJobBase, string3, string4);
        }
    }

    void removeJob(String string) {
        this.sendRequest(string, "");
    }

    public void run() {
        byte[] byArray = new byte[100];
        int n = 0;
        while (true) {
            int n2 = -1;
            try {
                n2 = this.InStream.read();
            }
            catch (IOException iOException) {
                UcDDL.croak((String)"Error receiving data return", (Throwable)iOException);
            }
            if (n2 < 0) {
                UcDDL.croak((String)"Concentrator connection closed.");
            }
            if (n2 == 4) {
                this.processBuffer(new String(byArray, 0, n));
                n = 0;
                continue;
            }
            if (n >= byArray.length - 1) {
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
            byArray[n++] = (byte)n2;
        }
    }

    void sendRequest(String string, String string2) {
        String string3 = "TYPE=request ID=" + string + " CONTENTS=" + string2;
        try {
            OutputStream outputStream = this.OutStream;
            synchronized (outputStream) {
                this.OutStream.write(string3.getBytes());
                this.OutStream.write(4);
                this.OutStream.flush();
            }
        }
        catch (IOException iOException) {
            UcDDL.croak((String)"Write exception during request ", (Throwable)iOException);
        }
    }
}

