/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.utility;

import com.sun.symon.base.utility.SystemClassLoader;
import com.sun.symon.base.utility.UcPropertyResourceBundle;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;

public abstract class UcResourceBundle {
    private static SystemClassLoader systemClassLoader = new SystemClassLoader();
    private static boolean debugFlag = false;
    protected UcResourceBundle parent = null;
    private static final Integer NOTFOUND = new Integer(-1);
    private static Hashtable cacheList = new Hashtable();

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("UcResourceBundle: " + string);
        }
    }

    private static UcResourceBundle findBundle(String string, StringBuffer stringBuffer, ClassLoader classLoader, boolean bl) {
        String string2 = stringBuffer.toString();
        String string3 = string.replace('.', '/');
        UcPropertyResourceBundle ucPropertyResourceBundle = null;
        Vector<String> vector = new Vector<String>();
        while (true) {
            int n;
            String string4 = String.valueOf(string) + string2;
            String string5 = "[" + Integer.toString(classLoader.hashCode()) + "]" + string4;
            ucPropertyResourceBundle = (UcPropertyResourceBundle)cacheList.get(string5);
            if (ucPropertyResourceBundle == NOTFOUND) {
                UcResourceBundle.debug("Found " + string4 + " in cache as NOTFOUND");
                stringBuffer.setLength(0);
                break;
            }
            if (ucPropertyResourceBundle != null) {
                UcResourceBundle.debug("Found " + string4 + " in cache");
                stringBuffer.setLength(0);
                break;
            }
            vector.addElement(string5);
            string4 = String.valueOf(string3) + string2 + ".properties";
            UcResourceBundle.debug("Searching for " + string4);
            InputStream inputStream = classLoader.getResourceAsStream(string4);
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
                try {
                    ucPropertyResourceBundle = new UcPropertyResourceBundle(inputStream);
                    break;
                }
                catch (Exception exception) {}
            }
            if ((n = string2.lastIndexOf(95)) == 0 && !bl || n == -1) break;
            string2 = string2.substring(0, n);
            stringBuffer.setLength(n);
        }
        if (ucPropertyResourceBundle != null) {
            int n = 0;
            while (n < vector.size()) {
                cacheList.put(vector.elementAt(n), ucPropertyResourceBundle);
                UcResourceBundle.debug("Adding " + vector.elementAt(n) + " to cache" + (ucPropertyResourceBundle == NOTFOUND ? " as NOTFOUND." : "."));
                ++n;
            }
        } else if (bl) {
            int n = 0;
            while (n < vector.size()) {
                cacheList.put(vector.elementAt(n), NOTFOUND);
                UcResourceBundle.debug("Adding " + vector.elementAt(n) + " to cache as NOTFOUND.");
                ++n;
            }
        }
        if (ucPropertyResourceBundle == NOTFOUND || ucPropertyResourceBundle == null) {
            return null;
        }
        return ucPropertyResourceBundle;
    }

    public static final UcResourceBundle getBundle(String string) throws MissingResourceException {
        return UcResourceBundle.getBundle(string, null, UcResourceBundle.getLoader());
    }

    public static final UcResourceBundle getBundle(String string, ClassLoader classLoader) throws MissingResourceException {
        return UcResourceBundle.getBundle(string, null, classLoader);
    }

    public static final UcResourceBundle getBundle(String string, Locale locale) {
        return UcResourceBundle.getBundle(string, locale, UcResourceBundle.getLoader());
    }

    public static synchronized UcResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        UcResourceBundle ucResourceBundle = null;
        StringBuffer stringBuffer = null;
        if (locale == null) {
            locale = Locale.getDefault();
            stringBuffer = new StringBuffer("_");
            stringBuffer.setLength(0);
            stringBuffer.append("_").append(locale.toString());
            ucResourceBundle = UcResourceBundle.findBundle(string, stringBuffer, classLoader, true);
            if (ucResourceBundle == null) {
                throw new MissingResourceException("can't find resource for " + string + "_" + locale, String.valueOf(string) + "_" + locale, "");
            }
        } else {
            stringBuffer = new StringBuffer("_").append(locale.toString());
            ucResourceBundle = UcResourceBundle.findBundle(string, stringBuffer, classLoader, false);
            if (ucResourceBundle == null) {
                stringBuffer.setLength(0);
                stringBuffer.append("_").append(Locale.getDefault().toString());
                ucResourceBundle = UcResourceBundle.findBundle(string, stringBuffer, classLoader, true);
                if (ucResourceBundle == null) {
                    throw new MissingResourceException("can't find resource for " + string + "_" + locale, String.valueOf(string) + "_" + locale, "");
                }
            }
        }
        UcResourceBundle ucResourceBundle2 = ucResourceBundle;
        while (ucResourceBundle2 != null && ucResourceBundle2.parent == null) {
            int n = stringBuffer.toString().lastIndexOf(95);
            if (n != -1) {
                stringBuffer.setLength(n);
                UcResourceBundle.debug("Searching for parent " + string + stringBuffer);
                ucResourceBundle2.setParent(UcResourceBundle.findBundle(string, stringBuffer, classLoader, true));
            }
            ucResourceBundle2 = ucResourceBundle2.parent;
        }
        return ucResourceBundle;
    }

    public abstract Enumeration getKeys();

    private static ClassLoader getLoader() {
        return systemClassLoader;
    }

    public final Object getObject(String string) throws MissingResourceException {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource", this.getClass().getName(), string);
            }
        }
        return object;
    }

    public final String getString(String string) throws MissingResourceException {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) throws MissingResourceException {
        return (String[])this.getObject(string);
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    protected void setParent(UcResourceBundle ucResourceBundle) {
        this.parent = ucResourceBundle;
    }
}

