/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.lv.console.presentation;

import com.sun.symon.apps.lv.console.presentation.SMLvDRListener;
import com.sun.symon.apps.lv.console.presentation.SMLvDataTree;
import com.sun.symon.apps.lv.console.presentation.SMLvNode;
import com.sun.symon.apps.lv.console.presentation.SMLvSearchListener;
import com.sun.symon.apps.lv.console.presentation.SMLvShowDetailsListener;
import com.sun.symon.apps.lv.console.presentation.SMLvTreeCellRenderer;
import com.sun.symon.apps.lv.console.presentation.SMLvTreeNode;
import com.sun.symon.apps.lv.console.presentation.SMLvUpdateBean;
import com.sun.symon.apps.pv.console.presentation.SMPvGlobals;
import com.sun.symon.apps.pv.console.tool.SMPvCompDetailPanel;
import com.sun.symon.base.client.SMLogin;
import com.sun.symon.base.client.SMPropertyData;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class SMLvBean
extends JPanel {
    int agentPort;
    String hostName;
    String moduleName;
    JLabel status;
    JLabel statusMsg = null;
    JPanel statusPanel = null;
    JPanel treePanel;
    JTree lvHierarchy = null;
    JButton showHideDetails;
    JCheckBox refreshDetails;
    SMPvCompDetailPanel lvDetails = null;
    SMLvDataTree dataTree = null;
    SMRawDataRequest dReq = null;
    SMResourceAccess resAcc = null;
    boolean compDetailsShowing = false;
    boolean searchOn = false;
    Object dataUpdateThread = null;
    Object alarmUpdateThread;
    JPanel main;
    JPanel hierarchyPanel;
    JPanel optionsPanel;
    Vector alarmCache = new Vector();

    public void cleanup() {
        this.stopDataUpdateThread();
        this.stopAlarmUpdateThread();
    }

    public SMPvCompDetailPanel createDetailsPanel() {
        SMPvCompDetailPanel sMPvCompDetailPanel = new SMPvCompDetailPanel(this.getModuleName());
        sMPvCompDetailPanel.setVisible(false);
        this.compDetailsShowing = false;
        return sMPvCompDetailPanel;
    }

    private JPanel createHierarchyPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10), BorderFactory.createLoweredBevelBorder()));
        jPanel.setSize(800, 800);
        this.lvHierarchy = null;
        this.lvHierarchy = new JTree(this.dataTree.getRoot().SMLvBuildHierarchy(null));
        this.lvHierarchy.setCellRenderer(new SMLvTreeCellRenderer());
        this.lvHierarchy.getSelectionModel().setSelectionMode(1);
        this.lvHierarchy.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SMLvBean.this.postNodeDetails();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.lvHierarchy);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createOptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(this.getI18NString("lvSearchNode"));
        jPanel2.add(jButton);
        jButton.addActionListener(new SMLvSearchListener(this));
        if (this.getModuleName().equals("Config-Reader4u")) {
            JButton jButton2 = new JButton(this.getI18NString("lvDR"));
            jPanel2.add(jButton2);
            jButton2.addActionListener(new SMLvDRListener(this));
        }
        this.showHideDetails = new JButton(this.getI18NString("lvShowDetails"));
        jPanel2.add(this.showHideDetails);
        this.showHideDetails.addActionListener(new SMLvShowDetailsListener(this));
        this.refreshDetails = new JCheckBox(this.getI18NString("lvRefreshDetails"), false);
        this.refreshDetails.setToolTipText(this.getI18NString("lvRefreshTip"));
        this.refreshDetails.setVisible(false);
        jPanel2.add(this.refreshDetails);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private JPanel createStatusPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        JLabel jLabel = new JLabel(this.getI18NString("lvComponent"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        jPanel.add((Component)jLabel, "West");
        this.status = new JLabel(this.getI18NString("lvComponentPath"));
        this.status.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        this.status.setForeground(Color.blue);
        jPanel.add((Component)this.status, "Center");
        return jPanel;
    }

    public String determineModuleName() {
        return new String("Config-Reader4u");
    }

    public void expandTreeForNode(String string) {
        SMLvNode sMLvNode = SMLvNode.searchNode(this.dataTree.getRoot(), string);
        if (sMLvNode == null) {
            this.postStatus(this.getI18NString("lvNodeNotFound"));
            return;
        }
        this.lvHierarchy.scrollPathToVisible(new TreePath(sMLvNode.getTreeNode().getPath()));
        this.lvHierarchy.setSelectionPath(new TreePath(sMLvNode.getTreeNode().getPath()));
        this.postDetails(sMLvNode);
        this.postPath(sMLvNode.getPath());
    }

    public String getAgentHost() {
        return this.hostName;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public Vector getComponentDetail(SMLvNode sMLvNode) {
        Object object;
        Vector vector;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector<String> vector5 = new Vector<String>();
        Vector vector6 = new Vector();
        String string = null;
        if (sMLvNode.getCompInfoDB() != null && !this.refreshNow()) {
            return sMLvNode.getCompInfoDB();
        }
        this.postStatus(this.getI18NString("lvLoadingComponentDetails"));
        String string2 = sMLvNode.getManagedObjectName();
        string = this.dataTree.isRawTreeCacheLoaded() ? new String(String.valueOf(string2) + "." + sMLvNode.getNodeInstance()) : string2;
        vector4 = (Vector)this.dataTree.getPropCache().get(string2);
        if (vector4 == null) {
            return null;
        }
        String string3 = this.dataTree.getBaseUrl();
        int n = 0;
        while (n < vector4.size()) {
            String string4 = ((SMPropertyData)vector4.elementAt(n)).getPropertyName();
            try {
                vector = SMRawDataRequest.createURL((String)string3, (String)string2, (String)string4, (String)"", (String)"");
                if (((SMPropertyData)vector4.elementAt(n)).getPropertyType()) {
                    vector5.addElement(String.valueOf(vector) + "#0");
                } else if (this.dataTree.isRawTreeCacheLoaded()) {
                    object = this.dataTree.getRawTreePropCache().get(String.valueOf(string) + ".SNMP").toString();
                    if (object == null) {
                        return null;
                    }
                    vector5.addElement(String.valueOf(vector) + "#" + (String)object);
                } else {
                    vector5.addElement((String)((Object)vector));
                }
            }
            catch (Exception exception) {
                return null;
            }
            vector3.addElement(vector4.elementAt(n));
            ++n;
        }
        if (vector5.size() == 0) {
            return null;
        }
        vector6 = (Vector)this.dataTree.getCompDataCache().get(string);
        if (vector6 == null || this.refreshNow()) {
            if (this.refreshNow()) {
                this.dataTree.getCompDataCache().remove(string2);
                sMLvNode.resetCompInfoDB();
            }
            try {
                vector2 = this.dReq.getURLValue(vector5);
            }
            catch (Exception exception) {
                return null;
            }
            if (vector2 == null || vector2.size() != vector3.size()) {
                SMPvGlobals.debug("something's lurking in the dark !!!!!");
                return null;
            }
            vector6 = new Vector();
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector = (Vector)vector2.elementAt(n2);
                if (vector != null) {
                    object = vector.elementAt(0).toString();
                    if (object != null && !((String)object).equals("") && !((String)object).equals(" ")) {
                        vector = new Vector();
                        UcListUtil.decomposeList((String)object, vector);
                        vector6.addElement(vector);
                    } else {
                        vector = new Vector();
                        vector.addElement("");
                        vector6.addElement(vector);
                    }
                }
                ++n2;
            }
            this.dataTree.getCompDataCache().put(string, vector6);
        }
        int n3 = 0;
        while (n3 < vector6.size()) {
            int n4;
            vector = ((SMPropertyData)vector3.elementAt(n3)).getPropertyName();
            object = (Vector)vector6.elementAt(n3);
            boolean bl = true;
            if (((SMPropertyData)vector3.elementAt(n3)).getPropertyType()) {
                n4 = 0;
            } else {
                bl = false;
                n4 = Integer.parseInt(sMLvNode.getNodeInstance()) - 1;
            }
            Vector<String> vector7 = new Vector<String>();
            vector7.addElement(String.valueOf(sMLvNode.getManagedObjectName()) + "." + vector);
            if (bl) {
                String string5 = new String("");
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    string5 = string5.concat(enumeration.nextElement().toString()).concat(" ");
                }
                vector7.addElement(string5);
            } else if (this.dataTree.isRawTreeCacheLoaded()) {
                vector7.addElement(((Vector)object).elementAt(0).toString());
            } else {
                vector7.addElement(((Vector)object).elementAt(n4).toString());
            }
            sMLvNode.compInfoDB.addElement(vector7);
            ++n3;
        }
        return sMLvNode.compInfoDB;
    }

    public SMPvCompDetailPanel getComponentDetailPanel() {
        return this.lvDetails;
    }

    public SMLvDataTree getDataTreeRef() {
        return this.dataTree;
    }

    protected boolean getDetailsFlag() {
        return this.compDetailsShowing;
    }

    public SMPvCompDetailPanel getDetailsPanel() {
        return this.lvDetails;
    }

    public Frame getFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    private JPanel getHierarchyPanel() {
        return this.hierarchyPanel;
    }

    public String getI18NString(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.apps.lv.console.presentation.LogicalView:" + string));
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected JButton getMoreButtonRef() {
        return this.showHideDetails;
    }

    public Dimension getPanelSize() {
        return new Dimension(this.lvHierarchy.getWidth() + this.lvDetails.getWidth(), this.lvHierarchy.getHeight());
    }

    public SMRawDataRequest getRawDataRequestHandle() {
        return this.dReq;
    }

    public SMLvNode getSelectedLvNode() {
        TreePath treePath = this.lvHierarchy.getSelectionPath();
        if (treePath != null) {
            this.lvHierarchy.scrollPathToVisible(treePath);
            SMLvTreeNode sMLvTreeNode = (SMLvTreeNode)treePath.getLastPathComponent();
            return sMLvTreeNode.getNode();
        }
        return null;
    }

    public JLabel getWindowStatusField() {
        return this.statusMsg;
    }

    public void hideComponentDetails() {
        this.compDetailsShowing = false;
        this.getComponentDetailPanel().setVisible(false);
        this.refreshDetails.setVisible(false);
        this.validate();
    }

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.main = new JPanel(new BorderLayout());
        this.main.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.dReq);
        try {
            if (!sMModuleRequest.isModuleLoaded(this.getAgentHost(), this.getAgentPort(), this.getModuleName())) {
                JLabel jLabel = new JLabel(this.getI18NString("lvNoLV"));
                this.postStatus(this.getI18NString("lvNoModule"));
                this.add(jLabel);
                this.getParent().validate();
                return;
            }
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel(this.getI18NString("lvNoLV"));
            this.postStatus(exception.getMessage());
            this.add(jLabel);
            this.getParent().validate();
            return;
        }
        this.postStatus(this.getI18NString("lvLoadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("lvLoadingHierarchyFailed"));
            return;
        }
        this.postStatus(this.getI18NString("lvLoadingConsole"));
        this.optionsPanel = this.createOptionsPanel();
        this.main.add((Component)this.optionsPanel, "North");
        this.hierarchyPanel = this.createHierarchyPanel();
        this.main.add((Component)this.hierarchyPanel, "Center");
        this.lvDetails = this.createDetailsPanel();
        this.main.add((Component)this.lvDetails, "East");
        this.add((Component)new JScrollPane(this.main), gridBagConstraints);
        this.statusPanel = this.createStatusPanel();
        this.main.add("South", this.statusPanel);
        this.postStatus("");
        try {
            this.dataUpdateThread = this.startDataUpdateThread();
            this.alarmUpdateThread = this.startAlarmUpdateThread();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean initDataTree() {
        try {
            if (this.dataTree == null) {
                this.dataTree = new SMLvDataTree();
                if (this.dataTree == null) {
                    return false;
                }
                this.dataTree.setRawDataRequestHandle(this.dReq);
                this.dataTree.setAgentHost(this.hostName);
                this.dataTree.setAgentPort(this.agentPort);
                this.dataTree.setModuleName(this.getModuleName());
            }
            this.dataTree.init();
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel(this.getI18NString("lvNoLV"));
            this.postStatus(this.getI18NString(exception.getMessage()));
            this.removeAll();
            this.revalidate();
            this.add(jLabel);
            this.getParent().validate();
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: SMLvBean agentHost agentPort serverHost");
            System.exit(1);
        }
        JFrame jFrame = new JFrame("Symon Logical View");
        SMLvBean sMLvBean = new SMLvBean();
        try {
            String string = "687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd";
            SMLogin sMLogin = new SMLogin();
            sMLogin.connect(stringArray[2], 0, "adetti", "hello", string);
            sMLvBean.setRawDataRequestHandle(sMLogin.getRawDataRequest());
            sMLvBean.setAgentHost(stringArray[0]);
            sMLvBean.setAgentPort(Integer.parseInt(stringArray[1]));
            sMLvBean.setModuleName("Config-Reader4u");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sMLvBean.init();
        jFrame.getContentPane().add(sMLvBean);
        jFrame.pack();
        jFrame.validate();
        jFrame.show();
    }

    private int mapAlarmStatus(String string) {
        if (string.indexOf("ERR") != -1) {
            return 1;
        }
        if (string.indexOf("WRN") != -1) {
            return 2;
        }
        if (string.indexOf("INF") != -1) {
            return 3;
        }
        return 0;
    }

    public void populateComponentDetails(Object object) {
        if (this.lvDetails != null && this.lvDetails.isShowing()) {
            this.lvDetails.populateDetailsTable(object);
        }
    }

    protected void postDetails(SMLvNode sMLvNode) {
        if (this.compDetailsShowing) {
            Vector vector = this.getComponentDetail(sMLvNode);
            if (vector == null) {
                this.postStatus(this.getI18NString("lvNoComponentDetails"));
            } else {
                this.postStatus("");
            }
            this.populateComponentDetails(vector);
        }
    }

    private void postNodeDetails() {
        this.postStatus("");
        SMLvNode sMLvNode = this.getSelectedLvNode();
        if (sMLvNode != null) {
            SMLvNode sMLvNode2;
            this.postPath(sMLvNode.getPath());
            if (sMLvNode.link_to != null && sMLvNode.link_to.length != 0 && (sMLvNode2 = SMLvNode.searchNode(this.dataTree.getRoot(), sMLvNode.link_to[0])) != null) {
                sMLvNode = sMLvNode2;
            }
            this.postDetails(sMLvNode);
        } else {
            this.postPath("");
        }
    }

    public void postPath(String string) {
        this.status.setText(string);
    }

    public void postStatus(String string) {
        if (this.statusMsg != null) {
            this.statusMsg.setText(string);
            this.statusMsg.validate();
        }
    }

    public void processAlarms(Vector vector) {
        Vector vector2;
        Vector<Vector> vector3 = new Vector<Vector>();
        int n = 0;
        while (n < vector.size()) {
            vector2 = SMPvGlobals.processRawAlarmData(vector.elementAt(n).toString());
            vector3.addElement(vector2);
            ++n;
        }
        vector2 = new Vector();
        int n2 = 0;
        while (n2 < vector3.size()) {
            Vector vector4 = (Vector)vector3.elementAt(n2);
            String string = vector4.elementAt(0).toString();
            if (string.indexOf("ERR") != -1 || string.indexOf("WRN") != -1 || string.indexOf("INF") != -1) {
                vector2.addElement(vector4);
            }
            ++n2;
        }
        vector3.removeAllElements();
        int n3 = 0;
        while (n3 < vector2.size()) {
            vector3.addElement((Vector)vector2.elementAt(n3));
            ++n3;
        }
        vector2.removeAllElements();
        vector2 = null;
        int n4 = vector3.size();
        int n5 = 0;
        while (n5 < this.alarmCache.size()) {
            Vector vector5 = (Vector)this.alarmCache.elementAt(n5);
            String string = vector5.elementAt(0).toString();
            String string2 = SMPvGlobals.getAlarmNodeName(vector5.elementAt(7).toString());
            boolean bl = false;
            int n6 = 0;
            while (n6 < n4) {
                Vector vector6 = (Vector)vector3.elementAt(n6);
                String string3 = vector6.elementAt(0).toString();
                String string4 = SMPvGlobals.getAlarmNodeName(vector6.elementAt(7).toString());
                if (string2.equals(string4) && string.equals(string3)) {
                    vector6.addElement("alarm_unchanged");
                    bl = true;
                    break;
                }
                if (string2.equals(string4)) {
                    vector5.addElement("alarm_closed");
                    vector3.addElement(vector5);
                    bl = true;
                    break;
                }
                bl = false;
                ++n6;
            }
            if (!bl) {
                vector5.addElement("alarm_closed");
                vector3.addElement(vector5);
            }
            ++n5;
        }
        this.alarmCache.removeAllElements();
        int n7 = 0;
        while (n7 < vector3.size()) {
            this.alarmCache.addElement(vector3.elementAt(n7));
            ++n7;
        }
        vector3.removeAllElements();
        vector3 = null;
    }

    public void processOneAlarm(Vector vector) {
        int n = 0;
        int n2 = 0;
        String string = SMPvGlobals.getAlarmNodeName(vector.elementAt(7).toString());
        String string2 = vector.elementAt(0).toString();
        String string3 = vector.lastElement().toString();
        int n3 = this.mapAlarmStatus(string2);
        SMLvNode sMLvNode = SMLvNode.findAlarmNode(this.dataTree.getRoot(), string);
        if (sMLvNode == null) {
            return;
        }
        if (!string3.equals("alarm_unchanged")) {
            sMLvNode.resetCompInfoDB();
            this.dataTree.getCompDataCache().remove(sMLvNode.getManagedObjectName());
            n = sMLvNode.getAlarmState();
            if (string3.equals("alarm_closed")) {
                sMLvNode.decAlarmCounts(n3);
            } else {
                sMLvNode.incAlarmCounts(n3);
            }
            n2 = sMLvNode.getChildRedCnt() > 0 || sMLvNode.getRedCnt() > 0 ? 1 : (sMLvNode.getChildYellowCnt() > 0 || sMLvNode.getYellowCnt() > 0 ? 2 : (sMLvNode.getChildBlueCnt() > 0 || sMLvNode.getBlueCnt() > 0 ? 3 : 0));
            if (n != n2) {
                sMLvNode.setAlarmState(n2);
                if (sMLvNode.getParentNode() != null) {
                    sMLvNode.getParentNode().propagateUp(n, n2);
                }
            }
        }
        this.lvHierarchy.repaint();
    }

    protected boolean refreshNow() {
        return this.refreshDetails.isSelected();
    }

    public void reinitializeBean() {
        this.searchOn = false;
        this.lvHierarchy = null;
        this.alarmCache = null;
        this.alarmCache = new Vector();
        this.stopDataUpdateThread();
        this.stopAlarmUpdateThread();
        this.getParent().setVisible(false);
        this.main.removeAll();
        this.postStatus(this.getI18NString("lvReloadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("lvLoadingHierarchyFailed"));
            this.getParent().setVisible(true);
            return;
        }
        this.postStatus(this.getI18NString("lvReloadingConsole"));
        this.main.add((Component)this.optionsPanel, "North");
        this.hierarchyPanel = this.createHierarchyPanel();
        this.main.add((Component)this.hierarchyPanel, "Center");
        this.main.add((Component)this.lvDetails, "East");
        this.postStatus("");
        this.main.revalidate();
        this.getParent().validate();
        this.getParent().setVisible(true);
        this.populateComponentDetails(new Vector());
        try {
            this.dataUpdateThread = this.startDataUpdateThread();
            this.alarmUpdateThread = this.startAlarmUpdateThread();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAgentHost(String string) {
        this.hostName = new String(string);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public void setModuleName(String string) {
        this.moduleName = new String(string);
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.dReq = sMRawDataRequest;
        this.resAcc = new SMResourceAccess(this.dReq);
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    public void showComponentDetails() {
        this.compDetailsShowing = true;
        this.getComponentDetailPanel().setVisible(true);
        this.postNodeDetails();
        this.refreshDetails.setVisible(true);
        this.validate();
    }

    private Object startAlarmUpdateThread() throws Exception {
        this.stopAlarmUpdateThread();
        String string = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
        Vector<String> vector = new Vector<String>();
        String string2 = SMRawDataRequest.buildShadowURL((String)string, (String)"statuslist", null);
        vector.addElement(string2);
        SMLvUpdateBean sMLvUpdateBean = new SMLvUpdateBean(this);
        return this.dReq.getURLValue(vector, "60", (SMRawDataResponse)sMLvUpdateBean, (Object)"alarmUpdate");
    }

    private Object startDataUpdateThread() throws Exception {
        try {
            if (this.dataUpdateThread != null) {
                this.dReq.removeURLRequest(this.dataUpdateThread);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
        Vector<String> vector = new Vector<String>();
        String string2 = SMRawDataRequest.createURL((String)string, (String)"system", (String)"total_config_changes#0", (String)"", (String)"");
        vector.addElement(string2);
        SMLvUpdateBean sMLvUpdateBean = new SMLvUpdateBean(this);
        return this.dReq.getURLValue(vector, "120", (SMRawDataResponse)sMLvUpdateBean, (Object)"dataTreeUpdate");
    }

    public void stopAlarmUpdateThread() {
        try {
            if (this.alarmUpdateThread != null) {
                this.dReq.removeURLRequest(this.alarmUpdateThread);
                this.alarmUpdateThread = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopDataUpdateThread() {
        try {
            if (this.dataUpdateThread != null) {
                this.dReq.removeURLRequest(this.dataUpdateThread);
                this.dataUpdateThread = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void toggleDetailsFlag() {
        this.compDetailsShowing ^= true;
    }

    public void updateBeanAlarms() {
        Vector vector;
        int n = 0;
        while (n < this.alarmCache.size()) {
            vector = (Vector)this.alarmCache.elementAt(n);
            this.processOneAlarm(vector);
            ++n;
        }
        vector = new Vector();
        int n2 = 0;
        while (n2 < this.alarmCache.size()) {
            Vector vector2 = (Vector)this.alarmCache.elementAt(n2);
            String string = vector2.lastElement().toString();
            if (!string.equals("alarm_closed")) {
                vector.addElement(vector2);
            }
            ++n2;
        }
        this.alarmCache.removeAllElements();
        int n3 = 0;
        while (n3 < vector.size()) {
            this.alarmCache.addElement(vector.elementAt(n3));
            ++n3;
        }
        vector.removeAllElements();
        vector = null;
    }
}

