/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.lv.console.presentation;

import com.sun.symon.apps.lv.console.presentation.SMLvTreeNode;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMLvNode {
    String moName;
    String url;
    SMLvNode first_child;
    SMLvNode last_child;
    SMLvNode brother;
    SMLvNode prev;
    SMLvNode parent;
    int[] state_count;
    int[] child_state_count;
    int state;
    int red_cnt;
    int yellow_cnt;
    int blue_cnt;
    int red_child_cnt;
    int yellow_child_cnt;
    int blue_child_cnt;
    String path;
    String nodeName;
    String pvParent;
    String[] link_to;
    boolean has_menu;
    boolean pv_ancestor_alarm;
    boolean pvParentFlag;
    int flag;
    Vector compInfoDB;
    String instance;
    SMLvTreeNode treeNode;

    public SMLvNode() {
        this.url = null;
        this.pvParent = "";
        this.parent = null;
        this.first_child = null;
        this.last_child = null;
        this.brother = null;
        this.nodeName = "";
        this.path = "";
        this.compInfoDB = new Vector();
        this.state_count = new int[3];
        this.child_state_count = new int[3];
        this.red_cnt = 0;
        this.yellow_cnt = 0;
        this.blue_cnt = 0;
        this.red_child_cnt = 0;
        this.yellow_child_cnt = 0;
        this.blue_child_cnt = 0;
        this.state = 0;
    }

    public SMLvNode(String string) {
        this.url = new String(string);
        this.moName = new String(string);
        this.pvParent = "";
        this.parent = null;
        this.first_child = null;
        this.last_child = null;
        this.brother = null;
        this.path = "";
        this.instance = "";
        this.compInfoDB = new Vector();
    }

    public SMLvTreeNode SMLvBuildHierarchy(SMLvTreeNode sMLvTreeNode) {
        SMLvTreeNode sMLvTreeNode2 = null;
        this.treeNode = new SMLvTreeNode(this);
        if (sMLvTreeNode != null) {
            sMLvTreeNode.add(this.treeNode);
        }
        SMLvNode sMLvNode = this.first_child;
        while (sMLvNode != null) {
            if (sMLvNode == this.first_child) {
                sMLvTreeNode2 = this.treeNode;
                sMLvTreeNode = sMLvNode.SMLvBuildHierarchy(this.treeNode);
            } else {
                sMLvTreeNode = sMLvNode.SMLvBuildHierarchy(sMLvTreeNode2);
            }
            sMLvNode = sMLvNode.brother;
        }
        return this.treeNode;
    }

    public void decAlarmCounts(int n) {
        switch (n) {
            case 1: {
                this.decRedCnt();
                break;
            }
            case 2: {
                this.decYellowCnt();
                break;
            }
            case 3: {
                this.decBlueCnt();
                break;
            }
        }
    }

    public void decBlueCnt() {
        if (this.getBlueCnt() <= 0) {
            return;
        }
        --this.blue_cnt;
    }

    public void decChildAlarmCounts(int n) {
        switch (n) {
            case 1: {
                this.decChildRedCnt();
                break;
            }
            case 2: {
                this.decChildYellowCnt();
                break;
            }
            case 3: {
                this.decChildBlueCnt();
                break;
            }
        }
    }

    public void decChildBlueCnt() {
        if (this.getChildBlueCnt() <= 0) {
            return;
        }
        --this.blue_child_cnt;
    }

    public void decChildRedCnt() {
        if (this.getChildRedCnt() <= 0) {
            return;
        }
        --this.red_child_cnt;
    }

    public void decChildYellowCnt() {
        if (this.getChildYellowCnt() <= 0) {
            return;
        }
        --this.yellow_child_cnt;
    }

    public void decRedCnt() {
        if (this.getRedCnt() <= 0) {
            return;
        }
        --this.red_cnt;
    }

    public void decYellowCnt() {
        if (this.getYellowCnt() <= 0) {
            return;
        }
        --this.yellow_cnt;
    }

    public static SMLvNode findAlarmNode(SMLvNode sMLvNode, String string) {
        if (sMLvNode == null || sMLvNode.getNodeName() == null) {
            return null;
        }
        if (sMLvNode.getNodeName().equals(string) || sMLvNode.getPath().equals(string)) {
            return sMLvNode;
        }
        SMLvNode sMLvNode2 = sMLvNode.first_child;
        while (sMLvNode2 != null) {
            SMLvNode sMLvNode3 = SMLvNode.findAlarmNode(sMLvNode2, string);
            if (sMLvNode3 != null) {
                return sMLvNode3;
            }
            sMLvNode2 = sMLvNode2.brother;
        }
        return null;
    }

    public SMLvNode findNode(String string) {
        if (this.getNodeName().equals(string)) {
            return this;
        }
        if (this.getParentNode() == null) {
            return null;
        }
        return this.getParentNode().findNode(string);
    }

    public void getAlarmCounts(int n) {
        switch (n) {
            case 1: {
                this.getRedCnt();
                break;
            }
            case 2: {
                this.getYellowCnt();
                break;
            }
            case 3: {
                this.getBlueCnt();
                break;
            }
        }
    }

    public int getAlarmState() {
        return this.state;
    }

    public int getBlueCnt() {
        return this.blue_cnt;
    }

    public SMLvNode getBrother() {
        return this.brother;
    }

    public void getChildAlarmCounts(int n) {
        switch (n) {
            case 1: {
                this.getChildRedCnt();
                break;
            }
            case 2: {
                this.getChildYellowCnt();
                break;
            }
            case 3: {
                this.getChildBlueCnt();
                break;
            }
        }
    }

    public int getChildBlueCnt() {
        return this.blue_child_cnt;
    }

    public int getChildRedCnt() {
        return this.red_child_cnt;
    }

    public int getChildYellowCnt() {
        return this.yellow_child_cnt;
    }

    public Vector getCompInfoDB() {
        if (this.compInfoDB.size() == 0) {
            return null;
        }
        return this.compInfoDB;
    }

    public SMLvNode getFirstChild() {
        return this.first_child;
    }

    public static String getInst(String string) {
        String string2 = "";
        try {
            string2 = string.substring(string.indexOf(40), string.indexOf(41));
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getManagedObjectName() {
        return this.moName;
    }

    public static String getName(String string) {
        String string2 = "";
        try {
            string2 = string.substring(0, string.indexOf(40));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return string;
        }
        return string2;
    }

    public String getNodeInstance() {
        return this.instance;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public SMLvNode getParentNode() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public String getPvParent() {
        return this.pvParent;
    }

    public int getRedCnt() {
        return this.red_cnt;
    }

    public SMLvTreeNode getTreeNode() {
        return this.treeNode;
    }

    public int getYellowCnt() {
        return this.yellow_cnt;
    }

    public void incAlarmCounts(int n) {
        switch (n) {
            case 1: {
                this.incRedCnt();
                break;
            }
            case 2: {
                this.incYellowCnt();
                break;
            }
            case 3: {
                this.incBlueCnt();
                break;
            }
        }
    }

    public void incBlueCnt() {
        ++this.blue_cnt;
    }

    public void incChildAlarmCounts(int n) {
        switch (n) {
            case 1: {
                this.incChildRedCnt();
                break;
            }
            case 2: {
                this.incChildYellowCnt();
                break;
            }
            case 3: {
                this.incChildBlueCnt();
                break;
            }
        }
    }

    public void incChildBlueCnt() {
        ++this.blue_child_cnt;
    }

    public void incChildRedCnt() {
        ++this.red_child_cnt;
    }

    public void incChildYellowCnt() {
        ++this.yellow_child_cnt;
    }

    public void incRedCnt() {
        ++this.red_cnt;
    }

    public void incYellowCnt() {
        ++this.yellow_cnt;
    }

    public void insertChild(SMLvNode sMLvNode) {
        if (this.last_child == null) {
            this.first_child = this.last_child = sMLvNode;
        } else {
            this.last_child.brother = sMLvNode;
            this.last_child = sMLvNode;
        }
        sMLvNode.parent = this;
    }

    public void printFullTree() {
        System.out.println("NodeName : " + this.nodeName);
        SMLvNode sMLvNode = this.first_child;
        while (sMLvNode != null) {
            sMLvNode.printTree();
            sMLvNode = sMLvNode.brother;
        }
    }

    public void printTree() {
        System.out.println("NodeName:" + this.nodeName);
        SMLvNode sMLvNode = this.first_child;
        while (sMLvNode != null) {
            sMLvNode.printTree();
            sMLvNode = sMLvNode.brother;
        }
    }

    public void propagateUp(int n, int n2) {
        int n3 = 0;
        this.decChildAlarmCounts(n);
        this.incChildAlarmCounts(n2);
        n3 = this.state;
        this.state = this.getChildRedCnt() > 0 || this.getRedCnt() > 0 ? 1 : (this.getChildYellowCnt() > 0 || this.getYellowCnt() > 0 ? 2 : (this.getChildBlueCnt() > 0 || this.getBlueCnt() > 0 ? 3 : 0));
        if (this.getParentNode() != null) {
            this.getParentNode().propagateUp(n3, this.state);
        }
    }

    public void propogateBlueCnt(int n) {
        this.blue_child_cnt += n;
        if (this.getParentNode() == null) {
            return;
        }
        this.getParentNode().propogateBlueCnt(n);
    }

    public void propogateRedCnt(int n) {
        this.red_child_cnt += n;
        if (this.getParentNode() == null) {
            return;
        }
        this.getParentNode().propogateRedCnt(n);
    }

    public void propogateYellowCnt(int n) {
        this.yellow_child_cnt += n;
        if (this.getParentNode() == null) {
            return;
        }
        this.getParentNode().propogateYellowCnt(n);
    }

    public void removeLvNodeChild(SMLvNode sMLvNode) {
        if (sMLvNode == null) {
            return;
        }
        SMLvNode sMLvNode2 = null;
        SMLvNode sMLvNode3 = this.first_child;
        while (sMLvNode3 != null) {
            if (sMLvNode3 == sMLvNode) break;
            sMLvNode2 = sMLvNode3;
            sMLvNode3 = sMLvNode3.brother;
        }
        if (sMLvNode3 == null) {
            return;
        }
        if (this.first_child != null && this.first_child == sMLvNode3) {
            this.first_child = sMLvNode3.brother;
        }
        if (this.last_child != null && this.last_child == sMLvNode3) {
            this.last_child = sMLvNode2;
        }
        if (sMLvNode2 != null) {
            sMLvNode2.brother = sMLvNode3.brother;
            sMLvNode3.brother = null;
        }
        sMLvNode.parent = null;
        sMLvNode.brother = null;
    }

    public void resetCompInfoDB() {
        if (this.compInfoDB != null) {
            this.compInfoDB.removeAllElements();
        }
    }

    public static SMLvNode searchNode(SMLvNode sMLvNode, String string) {
        if (sMLvNode.getPath().indexOf(string) != -1) {
            return sMLvNode;
        }
        SMLvNode sMLvNode2 = sMLvNode.first_child;
        while (sMLvNode2 != null) {
            SMLvNode sMLvNode3 = SMLvNode.searchNode(sMLvNode2, string);
            if (sMLvNode3 != null) {
                return sMLvNode3;
            }
            sMLvNode2 = sMLvNode2.brother;
        }
        return null;
    }

    public SMLvNode searchNodeOLD(String string) {
        SMLvNode sMLvNode;
        if (this.nodeName.indexOf(string) != -1) {
            return this;
        }
        if (this.first_child != null && (sMLvNode = this.first_child.searchNodeOLD(string)) != null) {
            return sMLvNode;
        }
        if (this.brother != null) {
            return this.brother.searchNodeOLD(string);
        }
        return null;
    }

    public void setAlarmState(int n) {
        this.state = n;
    }

    public void setHasMenu(String string) {
        this.has_menu = string.equals("true");
    }

    public void setLinkTo(String string) {
        if (string == null || string.equals("") || string.equals("null")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.link_to = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringTokenizer.countTokens()) {
            this.link_to[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    public void setNodeInstance(String string) {
        this.instance = new String(string);
    }

    public void setNodeName(String string) {
        this.nodeName = string == null || string.equals("") || string.equals("null") ? new String("") : new String(string);
    }

    public void setPath() {
        if (this.link_to != null && this.link_to.length != 0) {
            this.path = new String("LINK TO:");
            int n = 0;
            while (n < this.link_to.length) {
                this.path = this.path.concat(" " + this.link_to[n]);
                ++n;
            }
        } else {
            this.path = this.getParentNode() == null ? this.getNodeName() : this.path.concat(String.valueOf(this.getParentNode().getPath()) + "." + this.getNodeName());
        }
    }

    public void setPvParent(String string) {
        this.pvParent = string == null || string.equals("") || string.equals("null") ? new String("") : new String(string);
    }

    public void setState(int n) {
        this.state = n;
    }
}

