/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.didgets;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.module.SMModuleResponse;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CdModuleList
extends JList
implements ListSelectionListener,
AwxServiceManager,
SMModuleResponse {
    private String RefreshPeriod = "86400";
    private String AgentHost = null;
    private int AgentPort = 161;
    private SMRawDataRequest RawHandle = null;
    private SMModuleRequest ModuleHandle = null;
    private Object RequestHandle = null;
    private AwxServiceProvider SvcProvider = null;
    private SMModuleInfo[] ModuleInfo = null;

    public CdModuleList() {
        this.addListSelectionListener(this);
        this.setSelectionMode(0);
    }

    public void getLoadedModulesResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
    }

    public void getModuleInfoResponse(SMRequestStatus sMRequestStatus, SMModuleInfo[] sMModuleInfoArray) {
        if (sMRequestStatus.getReturnCode() != 0 || sMModuleInfoArray == null) {
            String[] stringArray = new String[]{sMRequestStatus.getReturnCode() == 7 ? "base.console.ConsoleGeneric:modules.noaccess" : "base.console.ConsoleGeneric:modules.error"};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        String string = null;
        if (this.getSelectedIndex() >= 0) {
            string = this.ModuleInfo[this.getSelectedIndex()].getModuleId();
        }
        this.ModuleInfo = sMModuleInfoArray;
        String[] stringArray = new String[this.ModuleInfo.length];
        int n = -1;
        int n2 = 0;
        while (n2 < this.ModuleInfo.length) {
            if (this.ModuleInfo[n2].canLoadAnother() && string != null && string.compareTo(this.ModuleInfo[n2].getModuleId()) == 0) {
                n = n2;
            }
            stringArray[n2] = !this.ModuleInfo[n2].canLoadAnother() ? MessageFormat.format(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:modules.alreadyload"), this.ModuleInfo[n2].getModuleName()) : (this.ModuleInfo[n2].getCurrentLoadCount() == 0 ? MessageFormat.format(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:modules.notload"), this.ModuleInfo[n2].getModuleName()) : MessageFormat.format(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:modules.isload"), this.ModuleInfo[n2].getModuleName(), new Integer(this.ModuleInfo[n2].getCurrentLoadCount())));
            ++n2;
        }
        this.setListData(stringArray);
        this.setSelectedIndex(n);
        String[] stringArray2 = new String[]{""};
        if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("message", stringArray2);
        }
        this.revalidate();
        this.repaint();
    }

    public void init() {
        try {
            this.RequestHandle = this.ModuleHandle.getModuleInfoRequest(this.AgentHost, this.AgentPort, this.RefreshPeriod, (SMModuleResponse)this);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)"Error requesting module info");
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = this.getSelectedIndex();
        if (mouseEvent.getID() == 500 && n >= 0 && this.ModuleInfo[n].canLoadAnother() && mouseEvent.getClickCount() > 1) {
            this.SvcProvider.triggerService("doubleSelect");
        }
        super.processMouseEvent(mouseEvent);
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
        if (awxServiceProvider == null) {
            if (this.RequestHandle != null && this.RawHandle != null) {
                try {
                    this.RawHandle.removeURLRequest(this.RequestHandle);
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)"Error removing module info request");
                }
            }
        } else {
            String[] stringArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:modules.wait")};
            this.SvcProvider.triggerService("message", stringArray);
        }
    }

    public void setAgentHost(String string) {
        this.AgentHost = string;
    }

    public void setAgentPort(int n) {
        this.AgentPort = n;
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.RawHandle = sMRawDataRequest;
        this.ModuleHandle = new SMModuleRequest(sMRawDataRequest);
    }

    public void setRefreshInterval(String string) {
        this.RefreshPeriod = string;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
        int n = this.getSelectedIndex();
        if (n < 0) {
            this.SvcProvider.triggerService("deselect");
        } else {
            if (!this.ModuleInfo[n].canLoadAnother()) {
                String[] stringArray2 = new String[]{"base.console.ConsoleGeneric:modules.onlyonce"};
                this.SvcProvider.triggerService("deselect");
                this.SvcProvider.triggerService("messageBell", stringArray2);
                return;
            }
            this.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        CdModuleList.this.SvcProvider.triggerService("enterKey");
                    }
                }
            });
            this.SvcProvider.triggerService("select");
            String[] stringArray3 = new String[]{this.ModuleInfo[n].getModuleId()};
            this.SvcProvider.triggerService("selectId", stringArray3);
        }
    }
}

