/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.logview;

import com.sun.symon.base.client.SMLogin;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.log.SMLogViewerRequest;
import com.sun.symon.base.console.logview.FileTypeListener;
import com.sun.symon.base.console.logview.Filter;
import com.sun.symon.base.console.logview.FilterListener;
import com.sun.symon.base.console.logview.ReloadListener;
import com.sun.symon.base.console.logview.Search;
import com.sun.symon.base.console.logview.SearchDownListener;
import com.sun.symon.base.console.logview.SearchUpListener;
import com.sun.symon.base.console.logview.TailListener;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LogPanel
extends JPanel {
    static final String[] fileNames = new String[]{"Syslog", "EntDiag"};
    private final Color buttonColor = new Color(230, 230, 230);
    private JComboBox fileType;
    private JTextField searchText;
    private JTextArea filterArea;
    private JTextArea tailArea;
    private SMLogin obj;
    private SMRawDataRequest rawReq;
    private SMLogViewerRequest logReq;
    private SMResourceAccess ra;
    private int agentPort;
    private String agentHost;
    private ImageIcon downArrow;
    private ImageIcon upArrow;
    private JPanel logfileTypePanel;
    private JLabel logfileTypeLabel;
    private JPanel logfileActionsPanel;
    private JLabel logfileActionsLabel;
    private Search search = new Search();
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JScrollPane logPane;
    private JScrollPane tailPane;
    private JSplitPane splitPane;
    private JLabel status;
    private boolean firstTime = true;
    private Filter filter = new Filter();
    private JButton filterButton;
    private JButton reloadButton;
    private JButton tailButton;
    private FilterListener filterListener;
    private TailListener tailListener;
    private String requestError;

    public void cleanUp() {
        this.logReq = null;
        this.rawReq = null;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    String getFileTypeSelection() {
        return fileNames[this.fileType.getSelectedIndex()];
    }

    Filter getFilter() {
        return this.filter;
    }

    String getFilterArea() {
        return this.filterArea.getText();
    }

    Frame getLogFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    SMLogViewerRequest getLogReq() {
        return this.logReq;
    }

    Window getLogWindow(Component component) {
        Window window = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Window)) continue;
            window = (Window)component;
            break;
        }
        return window;
    }

    public SMRawDataRequest getRawRequestHandle() {
        return this.rawReq;
    }

    JButton getReloadButton() {
        return this.reloadButton;
    }

    Search getSearch() {
        return this.search;
    }

    String getSearchText() {
        return this.searchText.getText();
    }

    String getTailArea() {
        return this.tailArea.getText();
    }

    public JLabel getWindowStatusField() {
        return this.status;
    }

    public void init() {
        Object[] objectArray = new Object[]{this.translate("ok")};
        try {
            this.logReq = new SMLogViewerRequest(this.rawReq, this.agentHost, this.agentPort);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.getLogWindow(this), String.valueOf(this.translate("requestHandleException")) + "\n" + exception.getMessage(), this.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
            this.logReq = null;
            return;
        }
        if (this.status != null) {
            this.status.setText("");
        }
        this.ra = new SMResourceAccess(this.getRawRequestHandle());
        this.downArrow = new ImageIcon(this.ra.getImage("stdimages/downArrow.gif"));
        this.upArrow = new ImageIcon(this.ra.getImage("stdimages/upArrow.gif"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.logfileTypePanel = new JPanel(new GridBagLayout());
        this.logfileTypeLabel = new JLabel(this.translate("logFileType"));
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridwidth = 0;
        this.logfileTypePanel.add((Component)this.logfileTypeLabel, gridBagConstraints2);
        this.fileType = new JComboBox();
        this.fileType.addItem(fileNames[0]);
        this.fileType.addItem(fileNames[1]);
        this.fileType.setSelectedIndex(0);
        this.fileType.setPreferredSize(new Dimension(100, 25));
        this.fileType.setToolTipText(this.translate("fileType1ToolTip"));
        FileTypeListener fileTypeListener = new FileTypeListener();
        fileTypeListener.setLogPanel(this);
        this.fileType.addItemListener(fileTypeListener);
        gridBagConstraints2.insets = new Insets(3, 6, 0, 0);
        this.logfileTypePanel.add((Component)this.fileType, gridBagConstraints2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(22, 9, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.logfileTypePanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.logfileActionsPanel = new JPanel(new GridBagLayout());
        this.logfileActionsLabel = new JLabel(this.translate("logFileActions"));
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridwidth = 0;
        this.logfileActionsPanel.add((Component)this.logfileActionsLabel, gridBagConstraints3);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.filterButton = new JButton(this.translate("filter"));
        this.filterButton.setToolTipText(this.translate("filterToolTip"));
        this.filterListener = new FilterListener(this, this.getLogFrame(this));
        this.filterButton.addActionListener(this.filterListener);
        jPanel.add(this.filterButton);
        this.reloadButton = new JButton(this.translate("reload"));
        this.reloadButton.setToolTipText(this.translate("reloadToolTip"));
        ReloadListener reloadListener = new ReloadListener();
        reloadListener.setLogPanel(this);
        this.reloadButton.addActionListener(reloadListener);
        jPanel.add(this.reloadButton);
        this.tailButton = new JButton(this.translate("monitor"));
        this.tailButton.setToolTipText(this.translate("monitorToolTip"));
        this.tailListener = new TailListener(this, this.getLogFrame(this));
        this.tailButton.addActionListener(this.tailListener);
        jPanel.add(this.tailButton);
        gridBagConstraints3.insets = new Insets(3, 0, 0, 0);
        this.logfileActionsPanel.add((Component)jPanel, gridBagConstraints3);
        gridBagConstraints.insets = new Insets(22, 0, 0, 10);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.logfileActionsPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(this.translate("filteredMessages"));
        gridBagConstraints.insets = new Insets(25, 15, 0, 0);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 0));
        jPanel2.add(new JLabel(this.translate("find")));
        this.searchText = new JTextField("", 10);
        this.searchText.setMargin(new Insets(1, 2, 1, 0));
        SearchDownListener searchDownListener = new SearchDownListener();
        searchDownListener.setLogPanel(this);
        this.searchText.addActionListener(searchDownListener);
        jPanel2.add(this.searchText);
        JButton jButton = new JButton(this.downArrow);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.addActionListener(searchDownListener);
        JButton jButton2 = new JButton(this.upArrow);
        jButton2.setMargin(new Insets(1, 1, 1, 1));
        SearchUpListener searchUpListener = new SearchUpListener();
        searchUpListener.setLogPanel(this);
        jButton2.addActionListener(searchUpListener);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(25, 0, 0, 10);
        this.add((Component)jPanel2, gridBagConstraints);
        this.topPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        this.topPanel.setLayout(gridBagLayout2);
        this.topPanel.setMinimumSize(new Dimension(200, 80));
        this.topPanel.setMaximumSize(new Dimension(900, 500));
        StringBuffer stringBuffer = null;
        if (this.status != null) {
            this.status.setText(this.translate("loadingMessages"));
        }
        try {
            stringBuffer = this.logReq.logSearch(this.getFileTypeSelection(), null, this.filter.getMaxMatches(), this.filter.getMaxLines(), this.filter.getStartTimeStamp(), this.filter.getEndTimeStamp(), this.filter.getFromLatest(), this.filter.getPattern(), 0);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.getLogWindow(this), String.valueOf(this.translate("requestException")) + "\n" + exception.getMessage(), this.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
            stringBuffer = null;
        }
        if (stringBuffer != null) {
            this.filterArea = new JTextArea(stringBuffer.toString());
            this.status.setText("");
        } else {
            this.filterArea = new JTextArea();
            if (this.status != null) {
                this.status.setText(this.translate("noSyslogMatches"));
            }
        }
        this.filterArea.setEditable(false);
        this.filterArea.setMargin(new Insets(5, 7, 5, 7));
        this.logPane = new JScrollPane(this.filterArea, 22, 30);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.gridwidth = 0;
        this.topPanel.add((Component)this.logPane, gridBagConstraints4);
        this.bottomPanel = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        this.bottomPanel.setLayout(gridBagLayout3);
        this.bottomPanel.setMinimumSize(new Dimension(200, 80));
        this.bottomPanel.setMaximumSize(new Dimension(900, 500));
        JLabel jLabel2 = new JLabel(this.translate("monitoredMessages"));
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.insets = new Insets(2, 2, 0, 0);
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.gridwidth = 0;
        this.bottomPanel.add((Component)jLabel2, gridBagConstraints5);
        this.tailArea = new JTextArea();
        this.tailArea.setEditable(false);
        this.tailArea.setMargin(new Insets(5, 7, 5, 7));
        this.tailPane = new JScrollPane(this.tailArea, 22, 30);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.gridwidth = 0;
        this.bottomPanel.add((Component)this.tailPane, gridBagConstraints5);
        this.splitPane = new JSplitPane(0, true, this.topPanel, this.bottomPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 15, 15, 15);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.splitPane, gridBagConstraints);
    }

    public void paint(Graphics graphics) {
        if (this.logReq == null) {
            return;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.splitPane.setDividerLocation(this.splitPane.getMaximumDividerLocation());
        }
        super.paint(graphics);
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    void setFileTypeToolTip(String string) {
        this.fileType.setToolTipText(string);
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    void setFilterArea(String string) {
        this.filterArea.setText(string);
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.rawReq = sMRawDataRequest;
    }

    void setSearchedText(int n, int n2) {
        this.filterArea.select(n, n2);
    }

    void setTailArea(String string) {
        if (string.length() > 0) {
            int n = this.tailArea.getText().length();
            int n2 = n + string.length();
            this.tailArea.append(string);
            this.tailArea.select(n, n2);
        } else {
            this.tailArea.setText("");
        }
    }

    public void setWindowStatusField(Object object) {
        this.status = (JLabel)object;
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.logview.LogBundle:" + string));
    }
}

