/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.module.SMModuleResponse;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.console.awx.AwxComponent;
import com.sun.symon.base.console.awx.AwxObject;
import com.sun.symon.base.console.awx.AwxSplitPane;
import com.sun.symon.base.console.manager.CmBrowserLoader;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.manager.CmNavigatorPanel;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.console.services.client.CsClientAPIStub;
import com.sun.symon.base.console.tools.buffer.CtTransferBuffer;
import com.sun.symon.base.console.views.CvContextPopupEvent;
import com.sun.symon.base.console.views.CvSelectionInfo;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyManager;
import com.sun.symon.base.console.views.hierarchy.CvHierarchySelectEvent;
import com.sun.symon.base.console.views.hierarchy.CvHierarchySelectListener;
import com.sun.symon.base.console.views.shells.CvContextPopup;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTableSelectEvent;
import com.sun.symon.base.console.views.table.CvTableSelectListener;
import com.sun.symon.base.console.views.topology.CvTopologySelectEvent;
import com.sun.symon.base.console.views.topology.CvTopologySelectListener;
import com.sun.symon.base.console.views.topology.CvTopologyView;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import com.sun.symon.base.xobject.XObjectBase;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class CmBrowserConsole
extends AwxObject
implements CvTableSelectListener,
CvTopologySelectListener,
CvHierarchySelectListener,
SMModuleResponse {
    private static int PanelIndex = 1;
    private SMRawDataRequest RawHandle = null;
    private SMManagedEntityRequest RequestHandle = null;
    private SMModuleRequest moduleRequestHandle = null;
    private Object moduleRequestId = null;
    private boolean FirstPanelInit = false;
    private boolean ConsoleChangeInProgress = false;
    private boolean SelectionChangeInProgress = false;
    private CtTransferBuffer TheBuffer = null;
    private CvSelectionInfo SelectInfo = null;
    private Object LastSelectionSource = null;
    private AwxSplitPane ViewPane = null;
    private XObjectBase PanelTemplate = null;
    private AwxComponent ActionZone = null;
    private String CurrentPanelUrl = null;
    private CmNavigatorPanel CurrentPanel = null;
    private CmTopologyPath CurrentPath = null;
    private Vector HistoricalUrls = new Vector();
    private Hashtable AllPanels = new Hashtable();
    private Vector previousModuleList = new Vector();

    public void activate() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = this.lookup("value", "dataSource", ".services.client");
        try {
            object4 = (CsClientAPIStub)this.locate(string, false);
            this.RawHandle = object4.getClientAPIInstance();
            this.RequestHandle = new SMManagedEntityRequest(this.RawHandle);
            this.moduleRequestHandle = new SMModuleRequest(this.RawHandle);
        }
        catch (Exception exception) {
            UcDDL.croak((String)"CmNavigatorConsole: Client API not found");
        }
        try {
            object4 = this.lookup("value", "viewPane", null);
            this.ViewPane = (AwxSplitPane)this.locate((String)object4, true);
            object3 = this.lookup("value", "panelTemplate", null);
            this.PanelTemplate = this.locate((String)object3, true);
            object2 = this.lookup("value", "transferBuffer", null);
            object = (AwxObject)this.locate((String)object2, true);
            this.TheBuffer = (CtTransferBuffer)object.getBean();
            String string2 = this.lookup("value", "actionZone", null);
            this.ActionZone = (AwxComponent)this.locate(string2, true);
        }
        catch (Exception exception) {
            UcDDL.croak((String)"CmNavigatorConsole: missing or invalid console management objects (viewPane, hierarchyTemplate, panelTemplate, actionZone or transferBuffer)");
        }
        object4 = this.getConsoleParameter("objectUrl");
        if (object4 != null) {
            object3 = new CmTopologyPath("root", null, UcURL.standardizeURL((String)object4));
            try {
                object2 = new UcURL((String)object4);
                object = object2.getHost();
                int n = Integer.parseInt(object2.getPort());
                this.moduleRequestId = this.moduleRequestHandle.getLoadedModules((String)object, n, "300", (SMModuleResponse)this);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)"Failed to set up module list request");
            }
            this.navigateToPathNow((CmTopologyPath)object3, null);
        }
    }

    public void consoleLoadComplete(CmTopologyPath cmTopologyPath, CmNavigatorPanel cmNavigatorPanel, String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.switchToPanel(cmTopologyPath, cmNavigatorPanel, string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new SwitchToPanelRunnable(cmTopologyPath, cmNavigatorPanel, string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.ConsoleChangeInProgress = false;
    }

    public void consoleLoadFailed() {
        this.ConsoleChangeInProgress = false;
    }

    private CmNavigatorPanel createNavPanelInstance() {
        String string;
        AwxObject awxObject = this;
        synchronized (awxObject) {
            string = "panel-" + PanelIndex++;
        }
        awxObject = new CmNavigatorPanel((XObjectBase)this.ViewPane, string, this.PanelTemplate);
        return awxObject;
    }

    private void defineUrlInfo(CvContextPopupEvent cvContextPopupEvent) {
        if (cvContextPopupEvent == null) {
            this.ActionZone.setConsoleParameter("selectedUrl", "");
            CvContextPopup.defineUrlInfo(this.ActionZone, "", "", "", null, "");
        } else {
            this.ActionZone.setConsoleParameter("selectedUrl", cvContextPopupEvent.getTargetUrl());
            CvContextPopup.defineUrlInfo(this.ActionZone, cvContextPopupEvent.getContextUrl(), cvContextPopupEvent.getNavigationUrl(), cvContextPopupEvent.getTargetUrl(), cvContextPopupEvent.getPathName(), cvContextPopupEvent.getNodeName());
        }
    }

    public void destruct() {
        try {
            if (this.RawHandle != null && this.moduleRequestId != null) {
                this.RawHandle.removeURLRequest(this.moduleRequestId);
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CmBrowserConsole: Error removing module request " + (Object)((Object)sMAPIException)));
        }
        super.destruct();
    }

    public void getLoadedModulesResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)"CmBrowserConsole: Error receiving module list");
            return;
        }
        if (this.previousModuleList == null) {
            this.previousModuleList = vector;
            return;
        }
        int n = 0;
        while (n < this.previousModuleList.size()) {
            if (vector.indexOf(this.previousModuleList.elementAt(n)) == -1) {
                this.handleModuleUnload((String)this.previousModuleList.elementAt(n));
            }
            ++n;
        }
        this.previousModuleList = vector;
    }

    public void getModuleInfoResponse(SMRequestStatus sMRequestStatus, SMModuleInfo[] sMModuleInfoArray) {
    }

    public void handleModuleUnload(String string) {
        Object object;
        boolean bl = false;
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        while (n < this.HistoricalUrls.size()) {
            UcAgentURL ucAgentURL = new UcAgentURL((String)this.HistoricalUrls.elementAt(n));
            if (ucAgentURL.getModuleSpec() != null && ucAgentURL.getModuleSpec().equals(string)) {
                object = (String)this.HistoricalUrls.elementAt(n);
                vector.addElement((String[])object);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            int n3;
            object = (String)vector.elementAt(n2);
            if (UcURL.areURLsEqual((String)object, (String)this.CurrentPanelUrl)) {
                bl = true;
            }
            if ((n3 = this.HistoricalUrls.indexOf(object)) != -1) {
                this.HistoricalUrls.removeElementAt(n3);
            }
            CmNavigatorPanel cmNavigatorPanel = (CmNavigatorPanel)this.AllPanels.get(object);
            this.AllPanels.remove(object);
            cmNavigatorPanel.recursiveDestruct();
            ++n2;
        }
        if (bl) {
            object = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.currentmodunload")};
            this.triggerService("messageBell", (String[])object);
            this.CurrentPanelUrl = null;
            this.CurrentPanel = null;
            this.CurrentPath = null;
        }
    }

    public void handleObjectSelection(int n, CvSelectionInfo cvSelectionInfo) {
        this.SelectInfo = cvSelectionInfo;
        this.triggerService("selectionExists", new String[]{"true"});
        this.triggerService("propertySelect", new String[]{"false"});
        this.triggerService("objectSelect", new String[]{"true"});
        if (n == 1) {
            SMFamilyCommands sMFamilyCommands = cvSelectionInfo.ContextInfo.getFamilyCommands();
            int n2 = 0;
            if (sMFamilyCommands != null) {
                String[] stringArray;
                String[] stringArray2 = sMFamilyCommands.getLocalCommandSpecs();
                if (stringArray2 != null) {
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (stringArray2[n3].trim().indexOf("probeview") == 0) {
                            ++n2;
                        }
                        ++n3;
                    }
                }
                if ((stringArray = sMFamilyCommands.getGlobalCommandSpecs()) != null) {
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (stringArray[n4].trim().indexOf("probeview") == 0) {
                            ++n2;
                        }
                        ++n4;
                    }
                }
            }
            if (n2 == 0) {
                this.triggerService("hasProbe", new String[]{"false"});
            } else {
                this.triggerService("hasProbe", new String[]{"true"});
            }
            this.defineUrlInfo(this.SelectInfo.ContextInfo);
            if (this.ActionZone != null) {
                CmConsoleSession.processFamilyExclusions(this.ActionZone, sMFamilyCommands);
            }
        } else {
            this.triggerService("hasProbe", new String[]{"false"});
            this.defineUrlInfo(null);
            this.triggerService("multiObjectSelect");
            if (this.ActionZone != null) {
                CmConsoleSession.processFamilyExclusions(this.ActionZone, null);
            }
        }
    }

    public void handlePropertySelection(int n, CvSelectionInfo cvSelectionInfo) {
        SMFamilyCommands sMFamilyCommands;
        this.SelectInfo = cvSelectionInfo;
        if (n >= 0) {
            this.triggerService("selectionExists", new String[]{"true"});
            this.triggerService("propertySelect", new String[]{"true"});
        } else {
            this.triggerService("selectionExists", new String[]{"false"});
            this.triggerService("propertySelect", new String[]{"false"});
        }
        this.triggerService("objectSelect", new String[]{"false"});
        if (n == 1) {
            sMFamilyCommands = cvSelectionInfo.ContextInfo.getFamilyCommands();
            int n2 = 0;
            if (sMFamilyCommands != null) {
                String[] stringArray;
                String[] stringArray2 = sMFamilyCommands.getLocalCommandSpecs();
                if (stringArray2 != null) {
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (stringArray2[n3].trim().indexOf("probeview") == 0) {
                            ++n2;
                        }
                        ++n3;
                    }
                }
                if ((stringArray = sMFamilyCommands.getGlobalCommandSpecs()) != null) {
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (stringArray[n4].trim().indexOf("probeview") == 0) {
                            ++n2;
                        }
                        ++n4;
                    }
                }
            }
            if (n2 == 0) {
                this.triggerService("hasProbe", new String[]{"false"});
            } else {
                this.triggerService("hasProbe", new String[]{"true"});
            }
            this.defineUrlInfo(this.SelectInfo.ContextInfo);
            CmConsoleSession.processContextExclusions(this.ActionZone, this.SelectInfo.ContextInfo.getExclusions());
        } else {
            this.triggerService("hasProbe", new String[]{"false"});
            if (n < 0) {
                this.defineUrlInfo(this.SelectInfo.ContextInfo);
            } else {
                this.defineUrlInfo(null);
            }
        }
        if (this.ActionZone != null) {
            sMFamilyCommands = cvSelectionInfo.ContextInfo.getFamilyCommands();
            CmConsoleSession.processFamilyExclusions(this.ActionZone, sMFamilyCommands);
        }
    }

    public void launchProbe() {
        Object object;
        if (this.SelectInfo == null || this.SelectInfo.ContextInfo == null) {
            return;
        }
        SMFamilyCommands sMFamilyCommands = this.SelectInfo.ContextInfo.getFamilyCommands();
        StringBuffer stringBuffer = new StringBuffer();
        if (sMFamilyCommands != null) {
            String[] stringArray;
            CharSequence charSequence;
            object = sMFamilyCommands.getLocalCommandSpecs();
            if (object != null) {
                int n = 0;
                while (n < ((String[])object).length) {
                    if (object[n].trim().indexOf("probeview") == 0) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        UcListUtil.appendElement((StringBuffer)stringBuffer2, (String)sMFamilyCommands.getLocalCommandLabels()[n], (boolean)true);
                        charSequence = object[n].trim();
                        UcListUtil.appendElement((StringBuffer)stringBuffer2, (String)charSequence);
                        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringBuffer2.toString());
                    }
                    ++n;
                }
            }
            if ((stringArray = sMFamilyCommands.getGlobalCommandSpecs()) != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].trim().indexOf("probeview") == 0) {
                        charSequence = new StringBuffer();
                        UcListUtil.appendElement((StringBuffer)charSequence, (String)sMFamilyCommands.getGlobalCommandLabels()[n], (boolean)true);
                        String string = stringArray[n].trim();
                        UcListUtil.appendElement((StringBuffer)charSequence, (String)string);
                        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)((StringBuffer)charSequence).toString());
                    }
                    ++n;
                }
            }
        }
        if (stringBuffer.length() == 0) {
            return;
        }
        object = this.ActionZone.substituteConsoleParameters(stringBuffer.toString());
        this.triggerService("probeSelect", new String[]{"!probeInfo=" + (String)object});
    }

    public void navigateToPath(String string, String string2) {
        CmTopologyPath cmTopologyPath;
        CmTopologyPath cmTopologyPath2 = CmTopologyPath.decode(string2);
        if (cmTopologyPath2 == null) {
            UcDDL.logErrorMessage((String)("Invalid path navigation info " + string2));
            return;
        }
        if (cmTopologyPath2.getLength() == 1 && cmTopologyPath2.getNodeId().compareTo("root") != 0) {
            cmTopologyPath = new CmTopologyPath(this.CurrentPath);
            cmTopologyPath.push(cmTopologyPath2.getNodeId(), cmTopologyPath2.getNodeName(), cmTopologyPath2.getNodeUrl());
        } else {
            cmTopologyPath = cmTopologyPath2;
        }
        String string3 = null;
        if (string.equals("true")) {
            if (cmTopologyPath.getLength() < 2) {
                UcDDL.logErrorMessage((String)"Path with select to root?");
                return;
            }
            string3 = cmTopologyPath.getEnd().getNodeId();
            cmTopologyPath.pop();
        }
        this.navigateToPathNow(cmTopologyPath, string3);
    }

    public void navigateToPathByName(String string, String string2) {
        CmTopologyPath cmTopologyPath = CmConsoleSession.pathRetrieve(string2, true);
        if (cmTopologyPath == null) {
            return;
        }
        String string3 = null;
        if (string.equals("true")) {
            if (cmTopologyPath.getLength() < 2) {
                UcDDL.logErrorMessage((String)"Path with select to root?");
                return;
            }
            string3 = cmTopologyPath.getEnd().getNodeId();
            cmTopologyPath.pop();
        }
        this.navigateToPathNow(cmTopologyPath, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void navigateToPathNow(CmTopologyPath cmTopologyPath, String string) {
        Object object = this;
        synchronized (object) {
            if (cmTopologyPath == null) {
                return;
            }
            if (this.ConsoleChangeInProgress) {
                return;
            }
            if (this.CurrentPath != null && this.CurrentPath.equals(cmTopologyPath)) {
                this.switchToPanel(this.CurrentPath, this.CurrentPanel, string);
            }
            this.ConsoleChangeInProgress = true;
        }
        try {
            object = cmTopologyPath.getEnd().getNodeUrl();
            object = UcURL.standardizeURL((String)object);
            if (this.AllPanels.containsKey(object)) {
                CmNavigatorPanel cmNavigatorPanel = (CmNavigatorPanel)this.AllPanels.get(object);
                this.switchToPanel(cmTopologyPath, cmNavigatorPanel, string);
                this.ConsoleChangeInProgress = false;
                return;
            }
            CmNavigatorPanel cmNavigatorPanel = this.createNavPanelInstance();
            if (cmNavigatorPanel == null) {
                this.showMessage("base.console.ConsoleMessages:newpanel.fail", true);
                this.ConsoleChangeInProgress = false;
                return;
            }
            CmBrowserLoader cmBrowserLoader = new CmBrowserLoader(this, cmTopologyPath, cmNavigatorPanel, this.RequestHandle, (String)object, string);
            Thread thread = new Thread((Runnable)cmBrowserLoader, "console-loader");
            thread.start();
            return;
        }
        catch (Exception exception) {
            this.showMessage("base.console.ConsoleMessages:conswitch.fail", true);
            this.ConsoleChangeInProgress = false;
        }
    }

    public void performCopy(String string) {
        if (this.SelectInfo == null) {
            return;
        }
        if (this.SelectInfo.BaseUrl != null) {
            this.TheBuffer.copyFromView(string, this.SelectInfo.BaseUrl, this.SelectInfo.SelectedEntityIds);
        } else {
            this.TheBuffer.copyFromContext(string, this.SelectInfo.ContextInfo.getContextUrl());
        }
    }

    public void selectionCleared() {
        this.SelectInfo = null;
        this.triggerService("selectionExists", new String[]{"false"});
        this.triggerService("hasProbe", new String[]{"false"});
    }

    public void selectionOccurred(CvHierarchySelectEvent cvHierarchySelectEvent) {
        Object object = this;
        synchronized (object) {
            if (this.SelectionChangeInProgress) {
                Object var3_3 = null;
                return;
            }
            this.SelectionChangeInProgress = true;
        }
        if (cvHierarchySelectEvent.getSelectCount() == 0) {
            if (cvHierarchySelectEvent.getSource() == this.LastSelectionSource) {
                this.selectionCleared();
            }
        } else {
            if (this.CurrentPanel != null) {
                this.CurrentPanel.triggerService("clearSelection");
            }
            this.LastSelectionSource = cvHierarchySelectEvent.getSource();
            object = (CvHierarchyManager)cvHierarchySelectEvent.getSource();
            CvSelectionInfo cvSelectionInfo = ((CvHierarchyManager)object).getSelectionInfo();
            this.handleObjectSelection(cvHierarchySelectEvent.getSelectCount(), cvSelectionInfo);
        }
        this.SelectionChangeInProgress = false;
    }

    public void selectionOccurred(CvTableSelectEvent cvTableSelectEvent) {
        Object object = this;
        synchronized (object) {
            if (this.SelectionChangeInProgress) {
                Object var3_3 = null;
                return;
            }
            this.SelectionChangeInProgress = true;
        }
        if (cvTableSelectEvent.getSelectCount() == 0) {
            if (cvTableSelectEvent.getSource() == this.LastSelectionSource) {
                this.selectionCleared();
            }
        } else {
            this.triggerService("clearHierarchySelection");
            this.LastSelectionSource = cvTableSelectEvent.getSource();
            object = (CvTable)cvTableSelectEvent.getSource();
            CvSelectionInfo cvSelectionInfo = ((CvTable)object).getSelectionInfo();
            if (cvSelectionInfo != null) {
                this.handlePropertySelection(cvTableSelectEvent.getSelectCount(), cvSelectionInfo);
            } else {
                this.selectionCleared();
            }
        }
        this.SelectionChangeInProgress = false;
    }

    public void selectionOccurred(CvTopologySelectEvent cvTopologySelectEvent) {
        Object object = this;
        synchronized (object) {
            if (this.SelectionChangeInProgress) {
                Object var3_3 = null;
                return;
            }
            this.SelectionChangeInProgress = true;
        }
        if (cvTopologySelectEvent.getSelectCount() == 0) {
            if (cvTopologySelectEvent.getSource() == this.LastSelectionSource) {
                this.selectionCleared();
            }
        } else {
            this.triggerService("clearHierarchySelection");
            this.LastSelectionSource = cvTopologySelectEvent.getSource();
            object = (CvTopologyView)cvTopologySelectEvent.getSource();
            CvSelectionInfo cvSelectionInfo = ((CvTopologyView)object).getSelectionInfo();
            this.handleObjectSelection(cvTopologySelectEvent.getSelectCount(), cvSelectionInfo);
        }
        this.SelectionChangeInProgress = false;
    }

    public void showMessage(String string, boolean bl) {
        String[] stringArray = new String[]{string};
        if (bl) {
            this.triggerService("messageBell", stringArray);
        } else {
            this.triggerService("message", stringArray);
        }
    }

    private void switchToPanel(CmTopologyPath cmTopologyPath, CmNavigatorPanel cmNavigatorPanel, String string) {
        Object object;
        Object object2;
        if (this.CurrentPanel != null) {
            this.CurrentPanel.triggerService("clearSelection");
        }
        String string2 = cmNavigatorPanel.getExactUrl();
        String string3 = cmNavigatorPanel.getObjectUrl();
        UcURL ucURL = new UcURL(string3);
        AwxObject awxObject = (AwxObject)this.superior();
        awxObject.setConsoleParameter("agentHost", ucURL.getHost());
        awxObject.setConsoleParameter("agentPort", ucURL.getPort());
        awxObject.setConsoleParameter("objectUrl", string3);
        awxObject.setConsoleParameter("exactUrl", string2);
        awxObject.setConsoleParameter("mainNavPath", cmTopologyPath.encode());
        awxObject.setConsoleParameter("pathName", cmTopologyPath.toString());
        int n = ((JSplitPane)this.ViewPane.getBean()).getDividerLocation();
        try {
            if (this.CurrentPanel != null) {
                this.CurrentPanel.recursiveRemoveComponent();
            }
            if (cmNavigatorPanel.getBean() == null) {
                cmNavigatorPanel.recursiveActivate();
            } else {
                cmNavigatorPanel.recursiveAddComponent();
                cmNavigatorPanel.triggerService("redisplay");
            }
            this.ViewPane.setRightComponent(cmNavigatorPanel);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CmNavigatorConsole: unexpected error realizing panel objects.");
        }
        ((JSplitPane)this.ViewPane.getBean()).setDividerLocation(n - 1);
        ((JSplitPane)this.ViewPane.getBean()).setDividerSize(6);
        ((JSplitPane)this.ViewPane.getBean()).setDividerSize(8);
        if (!this.FirstPanelInit) {
            this.FirstPanelInit = true;
            object2 = this.ViewPane.lookup("res", "dividerLocation", null);
            if (object2 != null) {
                try {
                    int n2 = Integer.parseInt((String)object2);
                    ((JSplitPane)this.ViewPane.getBean()).setDividerLocation(n2);
                }
                catch (Exception exception) {}
            }
            if ((object2 = this.ViewPane.lookup("res", "relDividerLocation", null)) != null) {
                try {
                    Double d = new Double((String)object2);
                    ((JSplitPane)this.ViewPane.getBean()).setDividerLocation(d);
                }
                catch (Exception exception) {}
            }
        }
        object2 = (Component)cmNavigatorPanel.getBean();
        ((Component)object2).invalidate();
        ((Component)object2).validate();
        ((Component)object2).repaint();
        this.CurrentPath = cmTopologyPath;
        this.CurrentPanel = cmNavigatorPanel;
        this.CurrentPanelUrl = string2;
        if (!this.AllPanels.containsKey(string2)) {
            this.AllPanels.put(string2, cmNavigatorPanel);
            this.HistoricalUrls.addElement(string2);
        }
        if (this.HistoricalUrls.size() > 1) {
            String string4 = (String)this.HistoricalUrls.elementAt(0);
            this.HistoricalUrls.removeElementAt(0);
            object = (CmNavigatorPanel)this.AllPanels.get(string4);
            this.AllPanels.remove(string4);
            object.recursiveDestruct();
        }
        String[] stringArray = new String[]{this.CurrentPanelUrl};
        this.triggerService("changeObjectUrl", stringArray);
        object = "";
        CmTopologyPath cmTopologyPath2 = this.CurrentPath;
        while (cmTopologyPath2 != null) {
            object = String.valueOf(object) + " " + cmTopologyPath2.getNodeId();
            cmTopologyPath2 = cmTopologyPath2.getNextStep();
        }
        String[] stringArray2 = new String[]{object};
        this.triggerService("markPath", stringArray2);
        if (string != null) {
            stringArray2 = new String[]{string};
            if (this.CurrentPanel != null) {
                this.CurrentPanel.triggerService("selectId", stringArray2);
            }
        }
        this.showMessage("", false);
    }

    class SwitchToPanelRunnable
    implements Runnable {
        CmTopologyPath path = null;
        CmNavigatorPanel panel = null;
        String selectId = null;

        SwitchToPanelRunnable(CmTopologyPath cmTopologyPath, CmNavigatorPanel cmNavigatorPanel, String string) {
            this.path = cmTopologyPath;
            this.panel = cmNavigatorPanel;
            this.selectId = string;
        }

        public void run() {
            CmBrowserConsole.this.switchToPanel(this.path, this.panel, this.selectId);
        }
    }
}

