/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.topology.SMTopologyEntityData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;

class CmTopologyRenameRunnable
implements Runnable {
    private SMTopologyRequest RequestHandle;
    private String BaseUrl;
    private String EntityId;
    private AwxServiceProvider SvcProvider;

    CmTopologyRenameRunnable(SMTopologyRequest sMTopologyRequest, String string, AwxServiceProvider awxServiceProvider) {
        this.RequestHandle = sMTopologyRequest;
        this.SvcProvider = awxServiceProvider;
        this.BaseUrl = null;
        this.EntityId = null;
        int n = string.indexOf(35);
        if (n < 0) {
            this.BaseUrl = string;
        } else {
            this.BaseUrl = string.substring(0, n);
            this.EntityId = string.substring(n + 1);
        }
    }

    CmTopologyRenameRunnable(SMTopologyRequest sMTopologyRequest, String string, String string2, AwxServiceProvider awxServiceProvider) {
        this.RequestHandle = sMTopologyRequest;
        this.SvcProvider = awxServiceProvider;
        this.BaseUrl = string;
        this.EntityId = string2;
    }

    public void run() {
        if (this.BaseUrl == null || this.EntityId == null) {
            return;
        }
        try {
            SMTopologyEntityData[] sMTopologyEntityDataArray = this.RequestHandle.getTopologyInfo(this.BaseUrl, new String[]{this.EntityId});
            String[] stringArray = new String[]{"desc=" + UcInternationalizer.translateKey((String)sMTopologyEntityDataArray[0].getDesc()), "entityId=" + this.EntityId, "baseUrl=" + this.BaseUrl};
            this.SvcProvider.triggerService("renameObject", stringArray);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)"Error getting topology object info", (Throwable)sMAPIException);
            String[] stringArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleTopology:objectrename.fail")};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }
}

