/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.table.SMTableColumnFormat;
import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.client.table.SMTableResponse;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.views.CvContextPopupEvent;
import com.sun.symon.base.console.views.CvContextPopupListener;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.CvPresentationView;
import com.sun.symon.base.console.views.CvSelectionInfo;
import com.sun.symon.base.console.views.table.CvTableSelectEvent;
import com.sun.symon.base.console.views.table.CvTableSelectListener;
import com.sun.symon.base.console.views.table.CvTblCell;
import com.sun.symon.base.console.views.table.CvTblSlider;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.console.views.table.CvTblTableColumn;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import com.sun.symon.base.console.views.table.CvTblTableHeader;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import com.sun.symon.base.console.views.table.CvTooBigNotify;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class CvTable
extends JScrollPane
implements CvPresentationView,
CvTblTableEventListener,
SMTableResponse,
AwxServiceManager {
    private AwxServiceProvider SvcProvider = null;
    public static final String ALARMMODE_DOT_LEFT = "dot_left";
    public static final String ALARMMODE_DOT_RIGHT = "dot_right";
    public static final String ALARMMODE_BACKGROUND = "background";
    protected static final String DEFAULT_ALARM_MODE = "background";
    protected static final Font DEFAULT_ALARM_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_HEADER_FONT = new Font("dialog", 1, 12);
    protected static final Font DEFAULT_NORMAL_FONT = new Font("dialog", 0, 12);
    protected static final Font DEFAULT_TITLE_FONT = new Font("dialog", 3, 14);
    protected static final int DEFAULT_TABLE_WIDTH = 335;
    protected static final int DEFAULT_COLUMN_WIDTH = 120;
    protected static final int MIN_COLUMN_WIDTH = -1;
    protected static final int LARGE_SIZE = 50;
    public static final int PAGE = 50;
    protected static final int DEFAULT_TITLE_JUSTIFICATION = 2;
    private Font normalFont = DEFAULT_NORMAL_FONT;
    private Font alarmFont = DEFAULT_ALARM_FONT;
    private Font headerFont = DEFAULT_HEADER_FONT;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private SMTableFormat[] tableFormat = null;
    private CvTblTableModel[] tableModels = null;
    private CvTblTable[] tables = null;
    private Vector sliders = new Vector();
    private JLabel[] tableTitles = null;
    private Object[] dataRequests = null;
    private Object[] statusRequests = null;
    private Vector selectListeners = new Vector();
    private Vector navigationListeners = new Vector();
    private Vector contextPopupListeners = new Vector();
    private JPanel tableHolder = new JPanel();
    private SMTableRequest dataSource = null;
    private SMRawDataRequest origDataSource = null;
    private String alarmMode = "background";
    private String stdRefreshPeriod = "never";
    private String fragment = "";
    private String managedObjectUrl = "";
    private int visibleLines = -1;
    private boolean fragmentMode = false;
    private boolean initialized = false;
    private boolean showHeader = true;
    private int maxDataWidth = 0;
    private int tableWidth = 335;
    private int defaultColumnWidth = 120;
    private Color titleBackground = new Color(102, 96, 170);
    private Color titleForeground = Color.white;
    private Color tableBackground = Color.white;
    private Color tableForeground = Color.black;
    private Color gridColor = Color.black;
    private boolean showHorizontalLines = true;
    private boolean showVerticalLines = true;
    private int titleJustification = 2;
    private String updated = "";
    private Icon acknowledgedIcon = null;
    private String i18nProperty = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.i18nProperty");
    private String i18nValue = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.i18nValue");
    private boolean cellSelectionAllowed = false;
    private boolean selectClearInProgress = false;
    public boolean tooBigDialogShowing = false;

    public CvTable() {
        this.tableHolder.setLayout(new BoxLayout(this.tableHolder, 1));
        this.tableHolder.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getViewport().add(this.tableHolder);
        this.tableHolder.setOpaque(true);
        this.updated = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.updated");
        int n = ((Component)this).getFontMetrics(this.normalFont).getAscent() + ((Component)this).getFontMetrics(this.normalFont).getDescent() + 4;
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
    }

    public void addCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        this.contextPopupListeners.addElement(cvContextPopupListener);
    }

    public void addCvNavigationListener(CvNavigationListener cvNavigationListener) {
        this.navigationListeners.addElement(cvNavigationListener);
    }

    public void addCvTableSelectListener(CvTableSelectListener cvTableSelectListener) {
        this.selectListeners.addElement(cvTableSelectListener);
    }

    private Color calculateAlternateColour(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2] * 0.9f));
    }

    public void cleanFootMessage() {
        if (this.SvcProvider != null) {
            String[] stringArray = new String[]{""};
            this.SvcProvider.triggerService("message", stringArray);
        }
    }

    public void clearSelection() {
        if (this.tables == null) {
            return;
        }
        int n = 0;
        while (n < this.tables.length) {
            if (this.tables[n] != null) {
                this.tables[n].setHeaderSelected(false);
                this.tables[n].clearSelection();
            }
            ++n;
        }
    }

    public void displayFootMessage() {
        if (this.SvcProvider != null) {
            String[] stringArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.loading")};
            this.SvcProvider.triggerService("message", stringArray);
        }
    }

    public void doLayout() {
        this.tableHolder.setSize(this.tableHolder.getPreferredSize());
        this.layoutTitles();
        super.doLayout();
    }

    public Icon getAcknowledgedIcon() {
        return this.acknowledgedIcon;
    }

    public Font getAlarmFont() {
        return this.alarmFont;
    }

    public String getAlarmMode() {
        return this.alarmMode;
    }

    public String getColumnHeading(int n, int n2) {
        if (this.tableFormat == null || n < 0 || n >= this.tableFormat.length) {
            return "";
        }
        SMTableColumnFormat sMTableColumnFormat = this.tableFormat[n].getColumn(n2);
        return sMTableColumnFormat != null ? sMTableColumnFormat.getColumnHeading() : "";
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public String getExclusionsFor(int n, int n2) {
        if (this.tableFormat == null || n < 0 || n >= this.tableFormat.length) {
            return null;
        }
        SMTableColumnFormat sMTableColumnFormat = this.tableFormat[n].getColumn(n2);
        return sMTableColumnFormat != null ? sMTableColumnFormat.getExclusionList() : null;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean getFragmentMode() {
        return this.fragmentMode;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public Insets getInsets() {
        return new Insets(2, 4, 4, 4);
    }

    public String getManagedObjectUrl() {
        return this.managedObjectUrl;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public int getNumTables() {
        return this.tableFormat != null ? this.tableFormat.length : 0;
    }

    public int getNumberColumnsForTable(int n) {
        if (n < 0 || this.tableFormat == null) {
            return 0;
        }
        return n < this.tableFormat.length ? this.tableFormat[n].getNumColumns() : 0;
    }

    public Dimension getPreferredSize() {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < this.tableHolder.getComponentCount()) {
            serializable = this.tableHolder.getComponent(n);
            Dimension dimension2 = serializable.getPreferredSize();
            dimension.width = dimension.width < dimension2.width ? dimension2.width : dimension.width;
            dimension.height += dimension2.height + 1;
            ++n;
        }
        this.tableHolder.setSize(dimension);
        serializable = this.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + 2;
        return dimension;
    }

    public CvSelectionInfo getSelectionInfo() {
        if (this.tables != null) {
            int n = 0;
            while (n < this.tables.length) {
                CvSelectionInfo cvSelectionInfo = this.tables[n].getSelectionInfo(this, this.getTableFormat(n));
                if (cvSelectionInfo != null) {
                    return cvSelectionInfo;
                }
                ++n;
            }
        }
        return null;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public String getStdRefreshPeriod() {
        return this.stdRefreshPeriod;
    }

    public CvTblTable getTable(int n) {
        return n >= 0 && n < this.tables.length ? this.tables[n] : null;
    }

    public void getTableAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            if (sMRequestStatus.getMessageText().indexOf("SNMP request returned error status 1 (too big)") != -1) {
                UcDDL.logErrorMessage((String)("Too Big Error receiving table alarm status data for table with url " + this.managedObjectUrl));
                UcDDL.logErrorMessage((String)"Maximum SNMP packet size (64kB) was exceeded.");
                if (this.tooBigDialogShowing) {
                    return;
                }
                Thread thread = new Thread((Runnable)new CvTooBigNotify(this), "tooBigNotify");
                thread.start();
            } else if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logErrorMessage((String)("Security Error receiving alarm status data for table with url " + this.managedObjectUrl));
            } else if (sMRequestStatus.getReturnCode() == 2) {
                UcDDL.logErrorMessage((String)("Invalid Url Error receiving alarm status data for table with url " + this.managedObjectUrl));
            } else {
                UcDDL.logErrorMessage((String)("Data Request Error receiving alarm status data for table with url " + this.managedObjectUrl));
            }
            return;
        }
        if (sMRequestStatus == null || object == null || sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
            if (sMRequestStatus == null) {
                UcDDL.logErrorMessage((String)("Null status received while retrieving alarm status data for table with url " + this.managedObjectUrl));
            }
            if (object == null) {
                UcDDL.logErrorMessage((String)("Null object identifier received while retrieving alarm status data for table with url " + this.managedObjectUrl));
            }
            if (sMAlarmStatusDataArray == null || sMAlarmStatusDataArray.length == 0) {
                UcDDL.logErrorMessage((String)("Null data received while retrieving alarm status data for table with url " + this.managedObjectUrl));
            }
            return;
        }
        if (!(object instanceof CvTblTableModel)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.tableModels.length && !bl) {
            bl = this.tableModels[n].equals(object);
            ++n;
        }
        if (!bl) {
            return;
        }
        ((CvTblTableModel)object).setStatusValues(sMAlarmStatusDataArray);
    }

    public Color getTableBackground() {
        return this.tableBackground == null ? this.getBackground() : this.tableBackground;
    }

    private void getTableData() {
        this.shutdownDataRequests();
        if (this.getFragment().length() == 0 && this.getFragmentMode()) {
            return;
        }
        this.dataRequests = new Object[this.tableModels.length];
        this.statusRequests = new Object[this.tableModels.length];
        int n = 0;
        while (n < this.tableModels.length) {
            String[] stringArray;
            String string;
            CvTblTableModel cvTblTableModel = this.tableModels[n];
            SMTableFormat sMTableFormat = this.tableFormat[n];
            String string2 = string = sMTableFormat.getRefreshInterval() != "" ? sMTableFormat.getRefreshInterval() : this.getStdRefreshPeriod();
            if (cvTblTableModel.getIsLarge()) {
                stringArray = this.tables[n];
                this.displayFootMessage();
                cvTblTableModel.setRefInterval(string);
                stringArray.initLargeTable();
            } else {
                stringArray = this.removeBlankURLs(cvTblTableModel.getDataURLs());
                if (stringArray != null) {
                    if (this.getFragmentMode()) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            stringArray[n2] = String.valueOf(stringArray[n2]) + "#" + this.getFragment();
                            ++n2;
                        }
                    }
                    try {
                        this.dataRequests[n] = this.dataSource.getTableFieldRequest(stringArray, sMTableFormat.getIsScalar() ^ true, string, (SMTableResponse)this, (Object)cvTblTableModel);
                        this.displayFootMessage();
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDDL.logWarningMessage((String)"CvTable:getTableData - received exception getting table data", (Throwable)sMAPIException);
                        this.cleanFootMessage();
                    }
                }
                if ((stringArray = this.removeBlankURLs(cvTblTableModel.getStatusURLs())) != null) {
                    try {
                        this.statusRequests[n] = this.dataSource.getTableAlarmStatusRequest(stringArray, sMTableFormat.getIsScalar() ^ true, string, (SMTableResponse)this, (Object)cvTblTableModel);
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDDL.logWarningMessage((String)"CvTable:getTableData - received exception getting table status", (Throwable)sMAPIException);
                    }
                }
            }
            ++n;
        }
    }

    public void getTableFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            if (sMRequestStatus.getMessageText().indexOf("SNMP request returned error status 1 (too big)") != -1) {
                UcDDL.logErrorMessage((String)("Too Big Error receiving table field data for table with url " + this.managedObjectUrl));
                UcDDL.logErrorMessage((String)"Maximum SNMP packet size (64kB) was exceeded.");
                if (this.tooBigDialogShowing) {
                    this.cleanFootMessage();
                    return;
                }
                Thread thread = new Thread((Runnable)new CvTooBigNotify(this), "tooBigNotify");
                thread.start();
            } else if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logErrorMessage((String)("Security Error receiving table field data for table with url " + this.managedObjectUrl));
            } else if (sMRequestStatus.getReturnCode() == 2) {
                UcDDL.logErrorMessage((String)("Invalid Url Error receiving table field data for table with url " + this.managedObjectUrl));
            } else {
                UcDDL.logErrorMessage((String)("Data Request Error receiving table field data for table with url " + this.managedObjectUrl));
            }
            this.cleanFootMessage();
            return;
        }
        if (sMRequestStatus == null || object == null || stringArray == null || stringArray.length == 0) {
            if (sMRequestStatus == null) {
                UcDDL.logErrorMessage((String)("Null status received while retrieving field data for table with url " + this.managedObjectUrl));
            }
            if (object == null) {
                UcDDL.logErrorMessage((String)("Null object identifier received while retrieving field data for table with url " + this.managedObjectUrl));
            }
            if (stringArray == null || stringArray.length == 0) {
                UcDDL.logErrorMessage((String)("Null data received while retrieving field data for table with url " + this.managedObjectUrl));
            }
            this.cleanFootMessage();
            return;
        }
        if (!(object instanceof CvTblTableModel)) {
            this.cleanFootMessage();
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.tableModels.length && !bl) {
            bl = this.tableModels[n].equals(object);
            ++n;
        }
        if (!bl) {
            this.cleanFootMessage();
            return;
        }
        ((CvTblTableModel)object).setDataValues(stringArray);
        this.cleanFootMessage();
    }

    public Color getTableForeground() {
        return this.tableForeground == null ? this.getForeground() : this.tableForeground;
    }

    public SMTableFormat[] getTableFormat() {
        return this.tableFormat;
    }

    public SMTableFormat getTableFormat(int n) {
        if (n < 0 || this.tableFormat == null) {
            return null;
        }
        return n < this.tableFormat.length ? this.tableFormat[n] : null;
    }

    public void getTableLayoutResponse(SMRequestStatus sMRequestStatus, SMTableFormat[] sMTableFormatArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            if (sMRequestStatus.getMessageText().indexOf("SNMP request returned error status 1 (too big)") != -1) {
                UcDDL.logErrorMessage((String)("Too Big Error receiving layout data for table with url " + this.managedObjectUrl));
                UcDDL.logErrorMessage((String)"Maximum SNMP packet size (64kB) was exceeded.");
                if (this.tooBigDialogShowing) {
                    return;
                }
                Thread thread = new Thread((Runnable)new CvTooBigNotify(this), "tooBigNotify");
                thread.start();
            } else if (sMRequestStatus.getReturnCode() == 1) {
                UcDDL.logErrorMessage((String)("Security Error receiving layout data for table with url " + this.managedObjectUrl));
            } else if (sMRequestStatus.getReturnCode() == 2) {
                UcDDL.logErrorMessage((String)("Invalid Url Error receiving layout data for table with url " + this.managedObjectUrl));
            } else {
                UcDDL.logErrorMessage((String)("Data Request Error receiving layout data for table with url " + this.managedObjectUrl));
            }
            return;
        }
        if (sMRequestStatus == null || object == null || sMTableFormatArray == null || sMTableFormatArray.length == 0) {
            if (sMRequestStatus == null) {
                UcDDL.logErrorMessage((String)("Null status received while retrieving layout data for table with url " + this.managedObjectUrl));
            }
            if (object == null) {
                UcDDL.logErrorMessage((String)("Null object identifier received while retrieving layout data for table with url " + this.managedObjectUrl));
            }
            if (sMTableFormatArray == null || sMTableFormatArray.length == 0) {
                UcDDL.logErrorMessage((String)("Null data received while retrieving layout data for table with url " + this.managedObjectUrl + " -> " + (sMTableFormatArray == null ? "null" : String.valueOf(sMTableFormatArray.length))));
            }
            return;
        }
        if (object == this) {
            this.setTableFormat(sMTableFormatArray);
            this.setupTables();
            this.getTableData();
            this.layoutTitles();
        } else {
            UcDDL.logWarningMessage((String)"Invalid identifier for table layout");
        }
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public int getVisibleLines() {
        return this.visibleLines;
    }

    public void init() {
        this.initialized = true;
        if (this.tableFormat == null) {
            this.setFragmentMode(false);
            try {
                this.dataSource.getTableLayoutRequest(this.managedObjectUrl, (SMTableResponse)this, (Object)this);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logWarningMessage((String)"CvTable:init - got exception getting table layout", (Throwable)sMAPIException);
            }
        } else {
            boolean bl = true;
            int n = 0;
            while (n < this.tableFormat.length) {
                bl &= this.tableFormat[n].getIsVertical() ^ true;
                ++n;
            }
            if (!bl) {
                this.setFragmentMode(false);
            }
            this.setupTables();
            this.getTableData();
        }
    }

    private void layoutTitles() {
        if (this.tableTitles != null && this.tables != null) {
            int n = 0;
            while (n < this.tableTitles.length) {
                if (this.tableTitles[n] != null && this.tables[n] != null) {
                    JLabel jLabel = this.tableTitles[n];
                    Dimension dimension = this.tables[n].getSize();
                    Dimension dimension2 = jLabel.getSize();
                    Dimension dimension3 = new Dimension(dimension2.width, dimension2.height);
                    jLabel.setSize(dimension3);
                }
                ++n;
            }
        }
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    private String[] removeBlankURLs(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2] != null && stringArray[n2].length() > 0 ? 1 : 0;
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null && stringArray[n3].length() > 0) {
                stringArray2[n++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }

    public void removeCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        this.contextPopupListeners.removeElement(cvContextPopupListener);
    }

    public void removeCvNavigationListener(CvNavigationListener cvNavigationListener) {
        this.navigationListeners.removeElement(cvNavigationListener);
    }

    public void removeCvTableSelectListener(CvTableSelectListener cvTableSelectListener) {
        this.selectListeners.removeElement(cvTableSelectListener);
    }

    public void setAcknowledgedIcon(Icon icon) {
        this.acknowledgedIcon = icon;
        if (this.tables != null) {
            int n = 0;
            while (n < this.tables.length) {
                this.tables[n].setAcknowledgedIcon(icon);
                ++n;
            }
        }
    }

    public void setAlarmFont(Font font) {
        this.alarmFont = font != null ? font : DEFAULT_ALARM_FONT;
        this.updateModelProperties();
    }

    public void setAlarmMode(String string) {
        if (string.equals(ALARMMODE_DOT_LEFT) || string.equals(ALARMMODE_DOT_RIGHT) || string.equals("background")) {
            this.alarmMode = string;
            this.updateModelProperties();
        }
    }

    public void setAllowCellSelect(boolean bl) {
        this.cellSelectionAllowed = bl;
        this.updateTableProperties();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.tableHolder != null) {
            this.tableHolder.setBackground(color);
        }
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.dataSource = new SMTableRequest(sMRawDataRequest);
        this.origDataSource = sMRawDataRequest;
    }

    public void setDefaultColumnWidth(int n) {
        this.defaultColumnWidth = n;
    }

    public void setFont(Font font) {
        this.setNormalFont(font);
    }

    public void setFragment(String string) {
        String string2 = this.fragment = string != null ? string : "";
        if (this.initialized && this.fragmentMode) {
            this.getTableData();
        }
    }

    public void setFragmentMode(boolean bl) {
        if (!this.initialized) {
            this.fragmentMode = bl;
        }
    }

    public void setGridColor(Color color) {
        if (color != null) {
            this.gridColor = color;
            this.updateTableProperties();
        }
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font != null ? font : DEFAULT_HEADER_FONT;
        this.updateModelProperties();
    }

    public void setManagedObjectUrl(String string) {
        this.managedObjectUrl = string != null ? string : "";
    }

    public void setNormalFont(Font font) {
        this.normalFont = font != null ? font : DEFAULT_NORMAL_FONT;
        int n = ((Component)this).getFontMetrics(this.normalFont).getAscent() + ((Component)this).getFontMetrics(this.normalFont).getDescent() + 4;
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
        this.updateModelProperties();
    }

    public void setShowHeader(boolean bl) {
        this.showHeader = bl;
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.updateTableProperties();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.updateTableProperties();
    }

    public void setStdRefreshPeriod(String string) {
        this.stdRefreshPeriod = string != null ? string : "";
    }

    public void setTableBackground(Color color) {
        if (color == null) {
            return;
        }
        this.tableBackground = color;
        if (this.tableModels != null) {
            int n = 0;
            while (n < this.tableModels.length) {
                this.tableModels[n].setBackground(color);
                ++n;
            }
        }
        if (this.tables != null) {
            Color color2 = this.calculateAlternateColour(color);
            int n = 0;
            while (n < this.tables.length) {
                this.tables[n].setBackground(color, color2);
                ++n;
            }
        }
    }

    public void setTableForeground(Color color) {
        int n;
        if (color == null) {
            return;
        }
        this.tableForeground = color;
        if (this.tableModels != null) {
            n = 0;
            while (n < this.tableModels.length) {
                this.tableModels[n].setForeground(color);
                ++n;
            }
        }
        if (this.tables != null) {
            n = 0;
            while (n < this.tables.length) {
                this.tables[n].setForeground(color);
                ++n;
            }
        }
    }

    public void setTableFormat(SMTableFormat[] sMTableFormatArray) {
        if (sMTableFormatArray == null) {
            this.tableFormat = null;
            return;
        }
        this.tableFormat = new SMTableFormat[sMTableFormatArray.length];
        int n = 0;
        while (n < sMTableFormatArray.length) {
            this.tableFormat[n] = sMTableFormatArray[n];
            ++n;
        }
    }

    public void setTableWidth(int n) {
        this.tableWidth = n > 0 ? n : 335;
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color != null ? color : this.titleBackground;
        int n = 0;
        while (n < this.tableTitles.length) {
            this.tableTitles[n].setBackground(this.titleBackground);
            ++n;
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font != null ? font : DEFAULT_TITLE_FONT;
        int n = 0;
        while (n < this.tableTitles.length) {
            this.tableTitles[n].setFont(this.titleFont);
            ++n;
        }
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color != null ? color : this.titleBackground;
        int n = 0;
        while (n < this.tableTitles.length) {
            this.tableTitles[n].setForeground(this.titleForeground);
            ++n;
        }
    }

    public void setTitleJustification(int n) {
        if (n == 2 || n == 4 || n == 0) {
            this.titleJustification = n;
            int n2 = 0;
            while (n2 < this.tableTitles.length) {
                this.tableTitles[n2].setHorizontalAlignment(this.titleJustification);
                ++n2;
            }
        }
    }

    public void setVisibleLines(int n) {
        if (n >= -1) {
            this.visibleLines = n;
            this.updateTableProperties();
        }
    }

    private void setupTables() {
        if (this.tableFormat == null) {
            return;
        }
        this.tableHolder.removeAll();
        this.tableModels = new CvTblTableModel[this.tableFormat.length];
        this.tables = new CvTblTable[this.tableFormat.length];
        this.tableTitles = new JLabel[this.tableFormat.length];
        Color color = this.calculateAlternateColour(this.getTableBackground());
        int n = 0;
        while (n < this.tableFormat.length) {
            Serializable serializable;
            int n2;
            int n3;
            int n4;
            Object object;
            JLabel jLabel;
            CvTblTable cvTblTable;
            CvTblTableModel cvTblTableModel;
            int n5 = 0;
            SMTableFormat sMTableFormat = this.tableFormat[n];
            int n6 = sMTableFormat.getNumColumns();
            int n7 = sMTableFormat.getWidth() > 0 ? sMTableFormat.getWidth() : this.tableWidth;
            int n8 = 0;
            int n9 = 0;
            this.tableModels[n] = cvTblTableModel = new CvTblTableModel(this, n);
            this.tables[n] = cvTblTable = new CvTblTable();
            this.tableTitles[n] = jLabel = new JLabel(sMTableFormat.getTitle());
            cvTblTableModel.setVertical(sMTableFormat.getIsVertical());
            cvTblTableModel.setIndexURLs(sMTableFormat.getIndexURLs());
            cvTblTableModel.setRealNumColumns(n6);
            cvTblTableModel.setBackground(this.getTableBackground());
            cvTblTableModel.setForeground(this.getTableForeground());
            cvTblTableModel.setAllProperties(this.getHeaderFont(), this.getNormalFont(), this.getAlarmFont(), this.getAlarmMode());
            cvTblTableModel.addTableEventListener(this);
            cvTblTable.setModel(cvTblTableModel);
            cvTblTable.setBackground(this.getTableBackground(), color);
            cvTblTable.setForeground(this.getTableForeground());
            cvTblTable.setShowHorizontalLines(this.showHorizontalLines);
            cvTblTable.setShowVerticalLines(this.showVerticalLines);
            cvTblTable.setVisibleLines(this.getVisibleLines());
            cvTblTable.addTableEventListener(this);
            cvTblTable.setAcknowledgedIcon(this.acknowledgedIcon);
            cvTblTable.setAllowCellSelect(this.cellSelectionAllowed);
            if (this.gridColor != null) {
                cvTblTable.setGridColor(this.gridColor);
            }
            jLabel.setForeground(this.titleForeground);
            jLabel.setBackground(this.titleBackground);
            jLabel.setFont(this.titleFont);
            jLabel.setHorizontalAlignment(this.titleJustification);
            jLabel.setLabelFor(cvTblTable);
            jLabel.setOpaque(true);
            Dimension dimension = jLabel.getSize();
            jLabel.setSize(n7, dimension.height);
            Dimension dimension2 = new Dimension(n7 * 2, 300);
            cvTblTable.setPreferredSize(dimension2);
            if (!cvTblTableModel.getVertical()) {
                object = new int[n6];
                n4 = 0;
                while (n4 < n6) {
                    SMTableColumnFormat sMTableColumnFormat = sMTableFormat.getColumn(n4);
                    n3 = sMTableColumnFormat.getColumnWidth();
                    if (n3 < 1) {
                        n3 = this.defaultColumnWidth;
                    }
                    if (n3 < 1) {
                        ++n8;
                        object[n4] = 0;
                    } else {
                        n9 += n3;
                        object[n4] = n3;
                    }
                    ++n4;
                }
                if (n8 > 0) {
                    int n10 = (n7 - n9) / n8;
                    if (n10 < -1) {
                        n10 = -1;
                    }
                    int n11 = 0;
                    while (n11 < n6) {
                        if (object[n11] == 0) {
                            object[n11] = n10;
                        }
                        ++n11;
                    }
                }
                n2 = 0;
                while (n2 < n6) {
                    SMTableColumnFormat sMTableColumnFormat = sMTableFormat.getColumn(n2);
                    cvTblTableModel.setURLs(n2, sMTableColumnFormat.getDataURL(), sMTableColumnFormat.getStatusURL());
                    serializable = new CvTblTableColumn(n2, sMTableColumnFormat.getColumnHeading(), sMTableColumnFormat.getDataType(), object[n2]);
                    cvTblTable.addColumn((TableColumn)serializable);
                    ((CvTblTableColumn)serializable).addTableEventListener(this);
                    ++n2;
                }
                n5 = this.dataSource.getTableDepth(cvTblTableModel.getDataURLs()[0]);
                if (n5 > 50 && this.dataSource.isLargeTableSupported(cvTblTableModel.getDataURLs()[0])) {
                    cvTblTableModel.setIsLarge(true);
                }
            } else {
                int n12 = 0;
                while (n12 < n6) {
                    SMTableColumnFormat sMTableColumnFormat = sMTableFormat.getColumn(n12);
                    cvTblTableModel.setURLs(n12, sMTableColumnFormat.getDataURL(), sMTableColumnFormat.getStatusURL());
                    cvTblTableModel.setValueAt(new CvTblCell(true, sMTableColumnFormat.getColumnHeading()), 0, n12);
                    n3 = sMTableColumnFormat.getColumnWidth();
                    if (n3 < 1) {
                        n3 = this.defaultColumnWidth;
                    }
                    if (n3 < 1) {
                        ++n8;
                    } else if (this.maxDataWidth < n3) {
                        this.maxDataWidth = n3;
                    }
                    ++n12;
                }
                n4 = 0;
                n2 = 0;
                if (n8 == n6) {
                    n4 = n7 / 2;
                    this.maxDataWidth = n2 = n7 / 2;
                } else {
                    n4 = n7 - this.maxDataWidth;
                    n2 = this.maxDataWidth;
                }
                CvTblTableColumn cvTblTableColumn = new CvTblTableColumn(0, this.i18nProperty, "string", n4);
                cvTblTable.addColumn(cvTblTableColumn);
                cvTblTableColumn.addTableEventListener(this);
                cvTblTableColumn = new CvTblTableColumn(1, this.i18nValue, "string", n2);
                cvTblTable.addColumn(cvTblTableColumn);
                cvTblTableColumn.addTableEventListener(this);
            }
            this.tableHolder.add(jLabel);
            this.tableHolder.add(Box.createRigidArea(new Dimension(3, 3)));
            if (cvTblTableModel.getIsLarge()) {
                object = cvTblTable.getPreferredSize();
                String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.row");
                JLabel jLabel2 = new JLabel(String.valueOf(string) + ":     ");
                jLabel2.setAlignmentX(0.0f);
                jLabel2.setForeground(Color.black);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                jPanel.setAlignmentX(0.0f);
                jPanel.setBackground(this.tableBackground);
                string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.page");
                serializable = new JLabel(String.valueOf(string) + ": 1   ");
                ((JComponent)serializable).setAlignmentY(0.0f);
                int n13 = 0;
                n13 = n5 % 50 > 0 ? n5 / 50 + 1 : n5 / 50;
                CvTblSlider cvTblSlider = new CvTblSlider(n13, jLabel2, (JLabel)serializable);
                cvTblSlider.setPreferredSize(new Dimension(350, 30));
                cvTblSlider.setBackground(this.tableBackground);
                cvTblSlider.setPaintLabels(true);
                cvTblSlider.setMinorTickSpacing(n13 - 1);
                cvTblSlider.setMajorTickSpacing(n13 - 1);
                cvTblSlider.setTable(cvTblTable);
                cvTblSlider.setTableRequest(this, this.origDataSource, this.dataSource);
                cvTblSlider.setAlignmentY(0.0f);
                cvTblSlider.repaint();
                cvTblTable.setSlider(cvTblSlider);
                this.sliders.addElement(cvTblSlider);
                jPanel.add((Component)serializable);
                jPanel.add(cvTblSlider);
                this.tableHolder.add(jPanel);
                this.tableHolder.add(jLabel2);
                this.tableHolder.add(Box.createRigidArea(new Dimension(3, 3)));
            }
            if (this.showHeader) {
                object = new CvTblTableHeader(cvTblTable.getColumnModel());
                cvTblTable.setTableHeader((JTableHeader)object);
                Dimension dimension3 = ((Component)object).getSize();
                int n14 = cvTblTable.getColumnModel().getTotalColumnWidth();
                int n15 = cvTblTable.getRowHeight();
                dimension3.width = n14;
                dimension3.height = n15;
                ((JComponent)object).setPreferredSize(dimension3);
                ((JComponent)object).setPreferredSize(dimension3);
                ((Component)object).addMouseListener(cvTblTable);
                ((JComponent)object).setAlignmentX(0.0f);
                ((JComponent)object).setAlignmentY(0.0f);
                this.tableHolder.add((Component)object);
            }
            cvTblTable.reallyDraw();
            this.tableHolder.add(cvTblTable);
            if (n < this.tableFormat.length - 1) {
                this.tableHolder.add(Box.createVerticalStrut(15));
            }
            ++n;
        }
        this.tableHolder.setSize(this.getPreferredSize());
        this.tableHolder.validate();
        this.layoutTitles();
    }

    public void shutdown() {
        this.selectListeners.removeAllElements();
        this.navigationListeners.removeAllElements();
        this.contextPopupListeners.removeAllElements();
        this.shutdownDataRequests();
        this.shutdownPageRequsts();
    }

    public void shutdownDataRequests() {
        int n;
        if (this.dataRequests != null) {
            n = 0;
            while (n < this.dataRequests.length) {
                if (this.dataRequests[n] != null) {
                    try {
                        this.origDataSource.removeURLRequest(this.dataRequests[n]);
                    }
                    catch (SMAPIException sMAPIException) {}
                }
                ++n;
            }
        }
        if (this.statusRequests != null) {
            n = 0;
            while (n < this.statusRequests.length) {
                if (this.statusRequests[n] != null) {
                    try {
                        this.origDataSource.removeURLRequest(this.statusRequests[n]);
                    }
                    catch (SMAPIException sMAPIException) {}
                }
                ++n;
            }
        }
    }

    public void shutdownPageRequsts() {
        if (this.sliders.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.sliders.size()) {
            CvTblSlider cvTblSlider = (CvTblSlider)this.sliders.get(n);
            if (cvTblSlider != null) {
                cvTblSlider.shutdownRequests();
            }
            ++n;
        }
    }

    public void tableEventOccurred(CvTblTableEvent cvTblTableEvent) {
        switch (cvTblTableEvent.getEventType()) {
            case 1: {
                this.tableHolder.validate();
                this.tableHolder.setSize(this.tableHolder.getSize());
                this.layoutTitles();
                int n = 0;
                while (n < this.tables.length) {
                    int n2;
                    this.tables[n].reallyDraw();
                    JTableHeader jTableHeader = this.tables[n].getTableHeader();
                    Dimension dimension = jTableHeader.getSize();
                    dimension.width = n2 = this.tables[n].getColumnModel().getTotalColumnWidth();
                    jTableHeader.setPreferredSize(dimension);
                    jTableHeader.setPreferredSize(dimension);
                    ++n;
                }
                break;
            }
            case 3: {
                SMFamilyCommands sMFamilyCommands = null;
                CvTblTable cvTblTable = (CvTblTable)cvTblTableEvent.getSource();
                int n = 0;
                while (n < this.tables.length) {
                    SMTableFormat sMTableFormat;
                    if (this.tables[n] == cvTblTable && (sMTableFormat = this.getTableFormat(n)) != null) {
                        sMFamilyCommands = sMTableFormat.getTableHdrCommands();
                    }
                    ++n;
                }
                CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this, "header", null, "", sMFamilyCommands, cvTblTableEvent.getXPos() - this.getHorizontalScrollBar().getValue(), cvTblTableEvent.getYPos() - this.getVerticalScrollBar().getValue(), this.managedObjectUrl, this.managedObjectUrl, this.managedObjectUrl, cvTblTableEvent.getExclusionInfo(), null);
                int n3 = 0;
                while (n3 < this.contextPopupListeners.size()) {
                    Object e = this.contextPopupListeners.elementAt(n3);
                    ((CvContextPopupListener)e).contextPopupOccurred(cvContextPopupEvent);
                    ++n3;
                }
                break;
            }
            case 2: {
                Object object;
                SMFamilyCommands sMFamilyCommands = null;
                CvTblTable cvTblTable = (CvTblTable)cvTblTableEvent.getSource();
                int n = 0;
                while (n < this.tables.length) {
                    if (this.tables[n] == cvTblTable && (object = this.getTableFormat(n)) != null) {
                        sMFamilyCommands = object.getTableRowCommands();
                    }
                    ++n;
                }
                CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this, null, null, cvTblTableEvent.getName(), sMFamilyCommands, cvTblTableEvent.getXPos() - this.getHorizontalScrollBar().getValue(), cvTblTableEvent.getYPos() - this.getVerticalScrollBar().getValue(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), cvTblTableEvent.getUrl(), cvTblTableEvent.getExclusionInfo(), null);
                n = 0;
                while (n < this.contextPopupListeners.size()) {
                    object = this.contextPopupListeners.elementAt(n);
                    ((CvContextPopupListener)object).contextPopupOccurred(cvContextPopupEvent);
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.tableModels.length) {
                    if (this.tableModels[n] == cvTblTableEvent.getSource()) {
                        CvTblTableColumn cvTblTableColumn = new CvTblTableColumn(cvTblTableEvent.getYPos(), "Value", "string", this.maxDataWidth);
                        this.tables[n].addColumn(cvTblTableColumn);
                        cvTblTableColumn.addTableEventListener(this);
                    }
                    ++n;
                }
                break;
            }
            case 5: 
            case 7: {
                this.selectClearInProgress = true;
                if (this.tables != null) {
                    int n = 0;
                    while (n < this.tables.length) {
                        if (this.tables[n] != (CvTblTable)cvTblTableEvent.getSource()) {
                            this.tables[n].clearSelection();
                            this.tables[n].setHeaderSelected(false);
                        }
                        ++n;
                    }
                }
                this.selectClearInProgress = false;
                Serializable serializable = new CvTableSelectEvent(this, cvTblTableEvent.getEventType() == 7 ? -1 : 1);
                int n = 0;
                while (n < this.selectListeners.size()) {
                    CvTableSelectListener cvTableSelectListener = (CvTableSelectListener)this.selectListeners.elementAt(n);
                    cvTableSelectListener.selectionOccurred((CvTableSelectEvent)serializable);
                    ++n;
                }
                serializable = (CvTblTable)cvTblTableEvent.getSource();
                ((Component)serializable).repaint();
                break;
            }
            case 6: {
                if (this.selectClearInProgress) break;
                CvTableSelectEvent cvTableSelectEvent = new CvTableSelectEvent(this, 1);
                int n = 0;
                while (n < this.selectListeners.size()) {
                    CvTableSelectListener cvTableSelectListener = (CvTableSelectListener)this.selectListeners.elementAt(n);
                    cvTableSelectListener.selectionOccurred(cvTableSelectEvent);
                    ++n;
                }
                break;
            }
        }
    }

    private void updateModelProperties() {
        if (this.tableModels == null) {
            return;
        }
        int n = 0;
        while (n < this.tableModels.length) {
            this.tableModels[n].setAllProperties(this.headerFont, this.normalFont, this.alarmFont, this.alarmMode);
            ++n;
        }
    }

    private void updateTableProperties() {
        if (this.tables == null) {
            return;
        }
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setVisibleLines(this.visibleLines);
            if (this.gridColor != null) {
                this.tables[n].setGridColor(this.gridColor);
            }
            this.tables[n].setShowHorizontalLines(this.showHorizontalLines);
            this.tables[n].setShowVerticalLines(this.showVerticalLines);
            this.tables[n].setAllowCellSelect(this.cellSelectionAllowed);
            ++n;
        }
    }
}

