/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.topology;

import com.sun.symon.base.console.views.topology.CvTopologyDisplayNode;
import com.sun.symon.base.console.views.topology.CvTopologyDisplayUnit;
import com.sun.symon.base.console.views.topology.CvTopologyLayoutManager;
import com.sun.symon.base.console.views.topology.CvTopologyViewPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class CvTopologySpokedRingLayout
implements CvTopologyLayoutManager {
    Point Center = null;
    int Radius = -1;
    int Nodecount = 0;
    int MaxDim = 0;

    public void draw(Graphics graphics, int n, int n2) {
        if (this.Nodecount == 0) {
            return;
        }
        graphics.setPaintMode();
        graphics.setColor(Color.black);
        graphics.drawArc(this.Center.x - this.Radius + n, this.Center.y - this.Radius + n2, 2 * this.Radius, 2 * this.Radius, 0, 360);
        int n3 = 0;
        while (n3 < this.Nodecount) {
            double d = 6.283 * (double)n3 / (double)this.Nodecount;
            double d2 = (double)n + (double)this.Radius * Math.sin(d) + (double)this.Center.x;
            double d3 = (double)n2 + (double)this.Radius * Math.cos(d) + (double)this.Center.y;
            double d4 = (double)n + (double)(this.Radius + 30 + this.MaxDim) * Math.sin(d) + (double)this.Center.x;
            double d5 = (double)n2 + (double)(this.Radius + 30 + this.MaxDim) * Math.cos(d) + (double)this.Center.y;
            graphics.drawLine((int)d2, (int)d3, (int)d4, (int)d5);
            ++n3;
        }
    }

    public void performLayout(CvTopologyViewPanel cvTopologyViewPanel, Vector vector, Dimension dimension, Point point) {
        Object object;
        this.Nodecount = 0;
        this.MaxDim = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
            cvTopologyDisplayUnit.setListAlignment(false);
            if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayNode)) continue;
            object = cvTopologyDisplayUnit.getBounds();
            double d = (double)((Dimension)object).width * (double)((Dimension)object).width + (double)((Dimension)object).height * (double)((Dimension)object).height;
            int n = (int)Math.sqrt(d);
            if (n > this.MaxDim) {
                this.MaxDim = n;
            }
            ++this.Nodecount;
        }
        if (this.Nodecount == 0) {
            this.Center = null;
            this.Radius = -1;
            return;
        }
        this.Center = point == null ? new Point(0, 0) : new Point(point.x, point.y);
        this.Center.x += 25;
        if (this.Nodecount == 1) {
            this.Center.y += 25;
        }
        this.Radius = (int)((double)((float)this.Nodecount * (float)this.MaxDim) / 6.283) - this.MaxDim / 2 - 30;
        if (this.Radius < 30) {
            this.Radius = 30;
        }
        int n = 0;
        this.MaxDim /= 2;
        object = vector.elements();
        while (object.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
            if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayNode)) continue;
            double d = 6.283 * (double)n / (double)this.Nodecount;
            double d2 = (double)(this.Radius + 30 + this.MaxDim) * Math.sin(d) + (double)this.Center.x;
            double d3 = (double)(this.Radius + 30 + this.MaxDim) * Math.cos(d) + (double)this.Center.y;
            cvTopologyDisplayUnit.setXOrigin((int)d2);
            cvTopologyDisplayUnit.setYOrigin((int)d3);
            ++n;
        }
    }

    public boolean showAdornments() {
        return false;
    }

    public boolean showLinks() {
        return false;
    }
}

