/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.utility.UcURL;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConfirmDialog;
import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import com.sun.symon.tools.discovery.console.presentation.IntegerTextField;
import com.sun.symon.tools.discovery.console.presentation.IpAddressTextField;
import com.sun.symon.tools.discovery.console.presentation.RequestFilterPanel;
import com.sun.symon.tools.discovery.console.presentation.TimeTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class RequestEditDialog
extends JDialog
implements ItemListener {
    String operation = null;
    DiscoverRequest request = null;
    JScrollPane monitorPanel;
    JScrollPane discoverPanel;
    JScrollPane prefPanel;
    JScrollPane filterPanel;
    RequestFilterPanel requestFilterPanel;
    JPanel buttonPanel;
    JPanel discoverNamePanel;
    JPanel discoverTopologyPanel;
    JPanel discoverPortPanel;
    JPanel discoverFilterPanel;
    JLabel discoverNameLabel;
    JTextField discoverNameTextField;
    IntegerTextField symonPortTextField;
    JCheckBox defaultPortCheckBox;
    DiscoverPanel parent;
    JTextArea messageText;
    JButton okbut;
    JButton cancelbut;
    JCheckBox loggingCheckBox;
    JCheckBox monitoringCheckBox;
    JLabel startTimeLabel;
    JTextField startTimeTextField;
    JLabel scheduleLabel;
    JComboBox scheduleComboBox;
    JLabel dayOfWeekLabel;
    JComboBox dayOfWeekComboBox;
    JLabel dayOfMonthLabel;
    IntegerTextField dayOfMonthTextField;
    private JLabel dTopMethLabel;
    private JComboBox dTopMethComboBox;
    private JLabel dTopStartIpLabel;
    private JLabel dTopStartIpTextLabel;
    private IpAddressTextField dTopStartIpTextField;
    private JLabel dTopEndIpLabel;
    private IpAddressTextField dTopEndIpTextField;
    private JLabel dTopNetmaskLabel;
    private IpAddressTextField dTopNetmaskTextField;
    private JLabel dTopNumHopsLabel;
    private IntegerTextField dTopNumHopsTextField;
    private JLabel snmpCommunityLabel;
    private JTextField snmpCommunityTextField;
    private JLabel pingTimeoutLabel;
    private IntegerTextField pingTimeoutTextField;
    private JLabel pingRetriesLabel;
    private IntegerTextField pingRetriesTextField;
    private JLabel snmpTimeoutLabel;
    private IntegerTextField snmpTimeoutTextField;
    private JLabel snmpRetriesLabel;
    private IntegerTextField snmpRetriesTextField;
    private JLabel maxHostsLabel;
    private IntegerTextField maxHostsTextField;
    private JLabel maxHostDiscoverLabel;
    private IntegerTextField maxHostDiscoverTextField;
    private DiscoverConfirmDialog confirmDialog = null;

    public RequestEditDialog(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest, String string) {
        super(discoverPanel.getParentFrame());
        this.parent = discoverPanel;
        this.operation = string;
        this.setModal(true);
        if (this.operation.equals("add")) {
            this.setTitle(this.parent.getI18NString("New_Discover_Request"));
            this.request = new DiscoverRequest(this.parent, this.parent.getDomain());
        } else if (this.operation.equals("duplicate")) {
            this.setTitle(this.parent.getI18NString("New_Discover_Request"));
            this.request = new DiscoverRequest(this.parent, discoverRequest);
        } else if (this.operation.equals("edit")) {
            this.request = discoverRequest;
            this.setTitle(String.valueOf(this.parent.getI18NString("Edit_Discover_Request_Id_")) + discoverRequest.getId());
        }
    }

    public void CancelPressed() {
        ((Component)this).setVisible(false);
        this.parent.closeRequestDialog();
    }

    public boolean CheckData() {
        int n;
        if (this.dTopMethComboBox.getSelectedIndex() == 0) {
            if (!UcURL.validateIpAddress((String)this.dTopStartIpTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("Error_in_Start_IP_Address"));
                return false;
            }
            if (!UcURL.validateIpAddress((String)this.dTopEndIpTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("Error_in_End_IP_Address"));
                return false;
            }
            if (!UcURL.validateIpAddress((String)this.dTopNetmaskTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("Error_in_Netmask"));
                return false;
            }
            if (!RequestEditDialog.compareIpAddress(this.dTopStartIpTextField.getText(), this.dTopEndIpTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("End_Ip_Addresss_gt_Start_Ip_Address"));
                return false;
            }
        }
        if (!this.defaultPortCheckBox.isSelected() && this.symonPortTextField.getText().equals("")) {
            this.parent.showError(this.parent.getI18NString("You_must_atleast_select_default_port_or_specify_symon_port_number"));
            return false;
        }
        if (this.CheckZero(this.symonPortTextField) && !this.symonPortTextField.getText().equals("")) {
            this.parent.showError(this.parent.getI18NString("Symon_Port_Number_cannot_be_zero"));
            return false;
        }
        boolean bl = true;
        String string = this.startTimeTextField.getText().trim();
        int n2 = string.length();
        if (n2 <= 5) {
            int n3 = 0;
            while (n3 < n2) {
                n = string.charAt(n3);
                if (!Character.isDigit((char)n) && n != 58) {
                    bl = false;
                    break;
                }
                if (n == 58 && (n3 > 2 || n3 == 0)) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            n = '\u0000';
            n = string.indexOf(58);
            if (n == -1) {
                bl = false;
            } else {
                int n4 = Integer.valueOf(string.substring(0, n));
                int n5 = Integer.valueOf(string.substring(n + 1));
                if (n4 > 23 || n5 > 59) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        if (!bl) {
            if (this.monitoringCheckBox.isSelected()) {
                this.parent.showError(this.parent.getI18NString("Error_in_Starting_Time"));
                return false;
            }
            this.startTimeTextField.setText("12:00");
        }
        String string2 = this.dayOfMonthTextField.getText();
        try {
            n = Integer.valueOf(string2);
            if (n > 31 || n < 1) {
                if (this.monitoringCheckBox.isSelected() && this.scheduleComboBox.getSelectedIndex() == 3) {
                    this.parent.showError(this.parent.getI18NString("Error_in_Day_of_Month"));
                    return false;
                }
                this.dayOfMonthTextField.setText("1");
            }
            if (n > 28 && n <= 31 && this.monitoringCheckBox.isSelected() && this.scheduleComboBox.getSelectedIndex() == 3) {
                this.parent.showError(this.parent.getI18NString("Error_in_Some_Days_of_Month"));
                this.dayOfMonthTextField.setText("1");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parent.showError(this.parent.getI18NString("Error_in_Day_of_Month"));
            return false;
        }
        if (this.CheckZero(this.pingTimeoutTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_PING_Timeout"));
            return false;
        }
        if (this.CheckZero(this.pingRetriesTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_PING_Retries"));
            return false;
        }
        if (this.CheckZero(this.snmpTimeoutTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_SNMP_Timeout"));
            return false;
        }
        if (this.CheckZero(this.snmpRetriesTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_SNMP_Retries"));
            return false;
        }
        if (this.CheckZero(this.maxHostsTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_Max_Hosts"));
            return false;
        }
        if (this.CheckZero(this.maxHostDiscoverTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_Max_Discover_Time"));
            return false;
        }
        String string3 = this.snmpCommunityTextField.getText().trim();
        if (string3.length() == 0) {
            this.parent.showError(this.parent.getI18NString("Error_in_NULL_SNMP_Community_String"));
            return false;
        }
        if (string3.indexOf(32) != -1 || string3.indexOf(9) != -1) {
            this.parent.showError(this.parent.getI18NString("Error_in_Space_SNMP_Community_String"));
            return false;
        }
        return true;
    }

    public boolean CheckZero(IntegerTextField integerTextField) {
        if (integerTextField.getText().length() == 0) {
            return true;
        }
        return Integer.parseInt(integerTextField.getText()) == 0;
    }

    public void OKPressed() {
        if (!this.CheckData()) {
            return;
        }
        if (!this.monitoringCheckBox.isSelected()) {
            if (this.operation.equals("add") || this.operation.equals("duplicate")) {
                this.parent.createConfirmDialog(this.request, this.parent.getI18NString("Do_you_want_to_start_the_request_upon_creation_?"), "add");
            } else {
                this.parent.createConfirmDialog(this.request, this.parent.getI18NString("Do_you_want_to_restart_the_request_upon_updating_the_data_?"), "edit");
            }
        } else {
            try {
                this.parent.doRequestOperation(this.request.getId(), this.operation, false);
            }
            catch (DiscoverGUIException discoverGUIException) {
                discoverGUIException.print();
            }
        }
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        this.okbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestEditDialog.this.OKPressed();
            }
        });
        this.cancelbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestEditDialog.this.CancelPressed();
            }
        });
        jPanel.add(this.okbut);
        jPanel.add(this.cancelbut);
        return jPanel;
    }

    private JPanel buildDiscoverPanel() {
        JPanel jPanel = new JPanel();
        this.discoverNamePanel = new JPanel();
        this.discoverNamePanel.setLayout(new GridLayout(1, 2, 20, 20));
        this.discoverNameLabel = new JLabel(this.parent.getI18NString("Request_Namecolon"));
        this.discoverNameLabel.setHorizontalAlignment(4);
        this.discoverNameTextField = new JTextField();
        this.discoverNameTextField.setText(this.request.getName());
        this.discoverNamePanel.add(this.discoverNameLabel);
        this.discoverNamePanel.add(this.discoverNameTextField);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.parent.getI18NString("Description"));
        this.discoverNamePanel.setBorder(titledBorder);
        this.discoverTopologyPanel = this.buildDiscoverTopologyPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.parent.getI18NString("Method"));
        this.discoverTopologyPanel.setBorder(titledBorder2);
        this.discoverPortPanel = this.buildDiscoverPortPanel();
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(this.parent.getI18NString("Ports"));
        this.discoverPortPanel.setBorder(titledBorder3);
        this.showTopologyDiscoveryOptions(this.request.getDiscoverTopologyMethod());
        jPanel.setLayout(new BorderLayout(20, 20));
        jPanel.add("North", this.discoverNamePanel);
        jPanel.add("Center", this.discoverTopologyPanel);
        jPanel.add("South", this.discoverPortPanel);
        JPanel jPanel2 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel2.setBorder(border);
        jPanel2.setLayout(new BorderLayout(20, 20));
        jPanel2.add("North", jPanel);
        return jPanel2;
    }

    private JPanel buildDiscoverPortPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 20, 20));
        jPanel2.setLayout(new BorderLayout(20, 20));
        jPanel3.setLayout(new GridLayout(1, 2, 20, 20));
        this.defaultPortCheckBox = new JCheckBox(this.parent.getI18NString("Use_Default_Port(161)"));
        this.defaultPortCheckBox.setSelected(this.request.getUseDefaultPort());
        this.defaultPortCheckBox.setHorizontalAlignment(0);
        JLabel jLabel = new JLabel(this.parent.getI18NString("Symon_Portcolon"));
        jLabel.setHorizontalAlignment(4);
        this.symonPortTextField = new IntegerTextField(this.request.getSymonPort(), 8);
        jPanel2.add("Center", this.defaultPortCheckBox);
        jPanel3.add(jLabel);
        jPanel3.add(this.symonPortTextField);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel buildDiscoverTopologyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2, 20, 20));
        String[] stringArray = new String[]{this.parent.getI18NString("Ping"), this.parent.getI18NString("Routing_Table")};
        this.dTopMethLabel = new JLabel(this.parent.getI18NString("Discover_Usingcolon"));
        this.dTopMethLabel.setHorizontalAlignment(4);
        this.dTopMethComboBox = new JComboBox<String>(stringArray);
        if (this.request.getDiscoverTopologyMethod().equals("ping")) {
            this.dTopMethComboBox.setSelectedIndex(0);
        } else if (this.request.getDiscoverTopologyMethod().equals("RoutingTable")) {
            this.dTopMethComboBox.setSelectedIndex(1);
        }
        this.dTopMethComboBox.addItemListener(this);
        this.dTopStartIpLabel = new JLabel(this.parent.getI18NString("Start_IP_Addresscolon"));
        this.dTopStartIpLabel.setHorizontalAlignment(4);
        this.dTopStartIpTextLabel = new JLabel(DiscoverPanel.getTopologyAgentIpAddress());
        this.dTopStartIpTextField = new IpAddressTextField(this.request.getStartIPAddress());
        this.dTopEndIpLabel = new JLabel(this.parent.getI18NString("End_IP_Addresscolon"));
        this.dTopEndIpLabel.setHorizontalAlignment(4);
        this.dTopEndIpTextField = new IpAddressTextField(this.request.getEndIPAddress());
        this.dTopNetmaskLabel = new JLabel(this.parent.getI18NString("Netmaskcolon"));
        this.dTopNetmaskLabel.setHorizontalAlignment(4);
        this.dTopNetmaskTextField = new IpAddressTextField(this.request.getNetmask());
        this.dTopNumHopsLabel = new JLabel(this.parent.getI18NString("Number_of_Hopscolon"));
        this.dTopNumHopsLabel.setHorizontalAlignment(4);
        this.dTopNumHopsTextField = new IntegerTextField(this.request.getNumberOfHops(), 3);
        jPanel.add(this.dTopMethLabel);
        jPanel.add(this.dTopMethComboBox);
        jPanel.add(this.dTopStartIpLabel);
        return jPanel;
    }

    private JPanel buildMonitorPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.parent.getI18NString("Scheduling"));
        jPanel.setBorder(titledBorder);
        this.monitoringCheckBox = new JCheckBox(this.parent.getI18NString("Discover_new_hosts_,_periodically_?"));
        this.monitoringCheckBox.setSelected(this.request.getMonitoring());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2, 20, 20));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.parent.getI18NString("Settings"));
        jPanel2.setBorder(titledBorder2);
        this.startTimeLabel = new JLabel(this.parent.getI18NString("Start_Time(hhcolonmm)colon"));
        this.startTimeLabel.setHorizontalAlignment(4);
        this.startTimeTextField = new TimeTextField(this.request.getStartingTime());
        String[] stringArray = new String[]{this.parent.getI18NString("Hourly"), this.parent.getI18NString("Daily"), this.parent.getI18NString("Weekly"), this.parent.getI18NString("Monthly")};
        this.scheduleLabel = new JLabel(this.parent.getI18NString("Frequencycolon"));
        this.scheduleLabel.setHorizontalAlignment(4);
        this.scheduleComboBox = new JComboBox<String>(stringArray);
        if (this.request.getSchedule().equals("hourly")) {
            this.scheduleComboBox.setSelectedIndex(0);
        } else if (this.request.getSchedule().equals("daily")) {
            this.scheduleComboBox.setSelectedIndex(1);
        } else if (this.request.getSchedule().equals("weekly")) {
            this.scheduleComboBox.setSelectedIndex(2);
        } else if (this.request.getSchedule().equals("monthly")) {
            this.scheduleComboBox.setSelectedIndex(3);
        }
        this.scheduleComboBox.addItemListener(this);
        this.dayOfWeekLabel = new JLabel(this.parent.getI18NString("Day_of_Weekcolon"));
        this.dayOfWeekLabel.setHorizontalAlignment(4);
        String[] stringArray2 = new String[this.request.getDayNamesOfWeek().length];
        int n = 0;
        while (n < this.request.getDayNamesOfWeek().length) {
            stringArray2[n] = this.parent.getI18NString(this.request.getDayNamesOfWeek()[n]);
            ++n;
        }
        this.dayOfWeekComboBox = new JComboBox<String>(stringArray2);
        this.dayOfWeekComboBox.setSelectedItem(this.parent.getI18NString(this.request.getDayOfWeek()));
        this.dayOfMonthLabel = new JLabel(this.parent.getI18NString("Day_of_Month_(1..28)colon"));
        this.dayOfMonthLabel.setHorizontalAlignment(4);
        this.dayOfMonthTextField = new IntegerTextField(this.request.getDayOfMonth(), 2);
        this.showScheduleOptions(this.request.getSchedule());
        jPanel.add(this.monitoringCheckBox);
        jPanel2.add(this.startTimeLabel);
        jPanel2.add(this.startTimeTextField);
        jPanel2.add(this.scheduleLabel);
        jPanel2.add(this.scheduleComboBox);
        jPanel2.add(this.dayOfWeekLabel);
        jPanel2.add(this.dayOfWeekComboBox);
        jPanel2.add(this.dayOfMonthLabel);
        jPanel2.add(this.dayOfMonthTextField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(20, 20));
        jPanel3.add("North", jPanel);
        jPanel3.add("South", jPanel2);
        JPanel jPanel4 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel4.setBorder(border);
        jPanel4.setLayout(new BorderLayout(20, 20));
        jPanel4.add("North", jPanel3);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.monitoringCheckBox.addItemListener(checkBoxListener);
        this.enableMonitorSettings(this.request.getMonitoring());
        return jPanel4;
    }

    private JPanel buildPrefPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 2, 20, 20));
        jPanel3.setLayout(new GridLayout(3, 2, 20, 20));
        jPanel4.setLayout(new GridLayout(2, 2, 20, 20));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.parent.getI18NString("Logging"));
        jPanel.setBorder(titledBorder);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.parent.getI18NString("PING"));
        jPanel2.setBorder(titledBorder2);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(this.parent.getI18NString("SNMP"));
        jPanel3.setBorder(titledBorder3);
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder(this.parent.getI18NString("General"));
        jPanel4.setBorder(titledBorder4);
        this.loggingCheckBox = new JCheckBox(this.parent.getI18NString("Log_discover_request_progress?"));
        this.loggingCheckBox.setSelected(this.request.getLogging());
        this.pingTimeoutLabel = new JLabel(this.parent.getI18NString("Timeout(sec.)colon"));
        this.pingTimeoutLabel.setHorizontalAlignment(4);
        this.pingTimeoutTextField = new IntegerTextField(this.request.getPingTimeout(), 5);
        this.pingRetriesLabel = new JLabel(this.parent.getI18NString("Retriescolon"));
        this.pingRetriesLabel.setHorizontalAlignment(4);
        this.pingRetriesTextField = new IntegerTextField(this.request.getPingRetries(), 5);
        this.snmpTimeoutLabel = new JLabel(this.parent.getI18NString("Timeout(sec.)colon"));
        this.snmpTimeoutLabel.setHorizontalAlignment(4);
        this.snmpTimeoutTextField = new IntegerTextField(this.request.getSnmpTimeout(), 5);
        this.snmpRetriesLabel = new JLabel(this.parent.getI18NString("Retriescolon"));
        this.snmpRetriesLabel.setHorizontalAlignment(4);
        this.snmpRetriesTextField = new IntegerTextField(this.request.getSnmpRetries(), 5);
        this.maxHostsLabel = new JLabel(this.parent.getI18NString("Maximum_Hostscolon"));
        this.maxHostsLabel.setHorizontalAlignment(4);
        this.maxHostsTextField = new IntegerTextField(this.request.getMaxHosts(), 9);
        this.maxHostDiscoverLabel = new JLabel(this.parent.getI18NString("Maximum_Time(sec.)colon"));
        this.maxHostDiscoverLabel.setHorizontalAlignment(4);
        this.maxHostDiscoverTextField = new IntegerTextField(this.request.getMaxDiscoveryTime(), 9);
        this.snmpCommunityLabel = new JLabel(this.parent.getI18NString("Community_Stringcolon"));
        this.snmpCommunityLabel.setHorizontalAlignment(4);
        this.snmpCommunityTextField = new JTextField(this.request.getCommunityString());
        jPanel.add(this.loggingCheckBox);
        jPanel2.add(this.pingTimeoutLabel);
        jPanel2.add(this.pingTimeoutTextField);
        jPanel2.add(this.pingRetriesLabel);
        jPanel2.add(this.pingRetriesTextField);
        jPanel3.add(this.snmpTimeoutLabel);
        jPanel3.add(this.snmpTimeoutTextField);
        jPanel3.add(this.snmpRetriesLabel);
        jPanel3.add(this.snmpRetriesTextField);
        jPanel3.add(this.snmpCommunityLabel);
        jPanel3.add(this.snmpCommunityTextField);
        jPanel4.add(this.maxHostsLabel);
        jPanel4.add(this.maxHostsTextField);
        jPanel4.add(this.maxHostDiscoverLabel);
        jPanel4.add(this.maxHostDiscoverTextField);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(20, 20));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(20, 20));
        jPanel5.add("North", jPanel);
        jPanel5.add("South", jPanel2);
        jPanel6.add("North", jPanel3);
        jPanel6.add("South", jPanel4);
        JPanel jPanel7 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel7.setBorder(border);
        jPanel7.setLayout(new BorderLayout(20, 20));
        jPanel7.add("North", jPanel5);
        jPanel7.add("South", jPanel6);
        return jPanel7;
    }

    /*
     * Unable to fully structure code
     */
    static boolean compareIpAddress(String var0, String var1_1) {
        var2_2 = new StringTokenizer(var0, ".");
        var3_3 = new StringTokenizer(var1_1, ".");
        if (var2_2.countTokens() != 4) {
            return false;
        }
        if (var3_3.countTokens() == 4) ** GOTO lbl21
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                var4_4 = Integer.parseInt(var2_2.nextToken());
                if (var4_4 < 0 || var4_4 > 255) {
                    return false;
                }
                var5_5 = Integer.parseInt(var3_3.nextToken());
                if (var5_5 < 0 || var5_5 > 255) {
                    return false;
                }
                if (var5_5 > var4_4) {
                    return true;
                }
                if (var4_4 > var5_5) {
                    return false;
                }
                continue;
            }
            catch (Exception v0) {
                return false;
            }
lbl21:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl22:
        // 1 sources

        return true;
    }

    public void confirmStart(boolean bl) {
        this.readMonitorPanel();
        this.readDiscoverPanel();
        this.readPrefPanel();
        this.requestFilterPanel.readFilterData();
        try {
            if (this.operation.equals("add") || this.operation.equals("duplicate")) {
                this.request.createInDatabase(this.parent.getSMDiscoveryRequestHandle(), bl);
            } else {
                this.request.updateInDatabase(this.parent.getSMDiscoveryRequestHandle(), bl);
            }
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
        }
        ((Component)this).setVisible(false);
    }

    void enableMonitorSettings(boolean bl) {
        this.startTimeLabel.setEnabled(bl);
        this.startTimeTextField.setEnabled(bl);
        this.scheduleLabel.setEnabled(bl);
        this.scheduleComboBox.setVisible(bl);
        this.startTimeLabel.repaint();
        this.startTimeTextField.repaint();
        this.scheduleLabel.repaint();
        this.scheduleComboBox.repaint();
        if (!bl) {
            this.dayOfWeekLabel.setEnabled(bl);
            this.dayOfWeekComboBox.setVisible(bl);
            this.dayOfMonthLabel.setEnabled(bl);
            this.dayOfMonthTextField.setEnabled(bl);
            this.dayOfWeekLabel.repaint();
            this.dayOfWeekComboBox.repaint();
            this.dayOfMonthLabel.repaint();
            this.dayOfMonthTextField.repaint();
        } else {
            switch (this.scheduleComboBox.getSelectedIndex()) {
                case 0: {
                    this.showScheduleOptions("hourly");
                    break;
                }
                case 1: {
                    this.showScheduleOptions("daily");
                    break;
                }
                case 2: {
                    this.showScheduleOptions("weekly");
                    break;
                }
                case 3: {
                    this.showScheduleOptions("monthly");
                    break;
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 600);
    }

    public void init() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.monitorPanel = new JScrollPane(this.buildMonitorPanel());
        this.discoverPanel = new JScrollPane(this.buildDiscoverPanel());
        this.prefPanel = new JScrollPane(this.buildPrefPanel());
        this.okbut = new JButton(this.parent.getI18NString("OK"));
        this.cancelbut = new JButton(this.parent.getI18NString("Close"));
        this.requestFilterPanel = new RequestFilterPanel(this.parent, this.request);
        this.filterPanel = new JScrollPane(this.requestFilterPanel);
        this.buttonPanel = this.buildButtonPanel();
        jTabbedPane.addTab(this.parent.getI18NString("Discover"), null, this.discoverPanel);
        jTabbedPane.addTab(this.parent.getI18NString("Preferences"), null, this.prefPanel);
        jTabbedPane.addTab(this.parent.getI18NString("Filters"), null, this.filterPanel);
        jTabbedPane.addTab(this.parent.getI18NString("Scheduling"), null, this.monitorPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(20, 20));
        jPanel.add("South", this.buttonPanel);
        jPanel.add("Center", jTabbedPane);
        this.getContentPane().add(jPanel);
        this.setLocationRelativeTo(this.parent);
        this.pack();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.scheduleComboBox && itemEvent.getStateChange() == 1) {
            switch (this.scheduleComboBox.getSelectedIndex()) {
                case 0: {
                    this.showScheduleOptions("hourly");
                    return;
                }
                case 1: {
                    this.showScheduleOptions("daily");
                    return;
                }
                case 2: {
                    this.showScheduleOptions("weekly");
                    return;
                }
                case 3: {
                    this.showScheduleOptions("monthly");
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (itemEvent.getSource() != this.dTopMethComboBox || itemEvent.getStateChange() != 1) return;
        switch (this.dTopMethComboBox.getSelectedIndex()) {
            case 0: {
                this.showTopologyDiscoveryOptions("ping");
                break;
            }
            case 1: {
                this.showTopologyDiscoveryOptions("RoutingTable");
            }
        }
    }

    private void readDiscoverPanel() {
        this.request.setName(this.discoverNameTextField.getText());
        this.readDiscoverTopologyPanel();
        this.readDiscoverPortPanel();
    }

    private void readDiscoverPortPanel() {
        this.request.setUseDefaultPort(this.defaultPortCheckBox.isSelected());
        this.request.setSymonPort(this.symonPortTextField.getText());
    }

    private void readDiscoverTopologyPanel() {
        String string = "0.0.0.0";
        switch (this.dTopMethComboBox.getSelectedIndex()) {
            case 0: {
                this.request.setDiscoverTopologyMethod("ping");
                string = this.dTopStartIpTextField.getText();
                break;
            }
            case 1: {
                this.request.setDiscoverTopologyMethod("RoutingTable");
                string = DiscoverPanel.getTopologyAgentIpAddress();
                break;
            }
        }
        this.request.setStartIPAddress(string);
        this.request.setDiscoveryHostIPAddress(string);
        this.request.setEndIPAddress(this.dTopEndIpTextField.getText());
        this.request.setNetmask(this.dTopNetmaskTextField.getText());
        this.request.setNumberOfHops(this.dTopNumHopsTextField.getText());
    }

    private void readMonitorPanel() {
        this.request.setMonitoring(this.monitoringCheckBox.isSelected());
        switch (this.scheduleComboBox.getSelectedIndex()) {
            case 0: {
                this.request.setSchedule("hourly");
                break;
            }
            case 1: {
                this.request.setSchedule("daily");
                break;
            }
            case 2: {
                this.request.setSchedule("weekly");
                break;
            }
            case 3: {
                this.request.setSchedule("monthly");
                break;
            }
        }
        this.request.setDayOfWeek(this.request.getDayNamesOfWeek()[this.dayOfWeekComboBox.getSelectedIndex()]);
        this.request.setDayOfMonth(this.dayOfMonthTextField.getText());
        this.request.setStartingTime(this.startTimeTextField.getText());
    }

    private void readPrefPanel() {
        this.request.setLogging(this.loggingCheckBox.isSelected());
        this.request.setPingTimeout(this.pingTimeoutTextField.getText());
        this.request.setPingRetries(this.pingRetriesTextField.getText());
        this.request.setSnmpTimeout(this.snmpTimeoutTextField.getText());
        this.request.setSnmpRetries(this.snmpRetriesTextField.getText());
        this.request.setCommunityString(this.snmpCommunityTextField.getText());
        this.request.setMaxHosts(this.maxHostsTextField.getText());
        this.request.setMaxDiscoveryTime(this.maxHostDiscoverTextField.getText());
    }

    public void setFont(Font font) {
        this.messageText.setFont(font);
    }

    public void setTextBackground(Color color) {
        this.messageText.setBackground(color);
    }

    public void setTextForeground(Color color) {
        this.messageText.setForeground(color);
    }

    public void showScheduleOptions(String string) {
        this.dayOfWeekLabel.setEnabled(false);
        this.dayOfWeekComboBox.setVisible(false);
        this.dayOfMonthLabel.setEnabled(false);
        this.dayOfMonthTextField.setEnabled(false);
        if (string.equals("weekly")) {
            this.dayOfWeekLabel.setEnabled(true);
            this.dayOfWeekComboBox.setVisible(true);
        } else if (string.equals("monthly")) {
            this.dayOfMonthLabel.setEnabled(true);
            this.dayOfMonthTextField.setEnabled(true);
        }
        this.dayOfWeekLabel.repaint();
        this.dayOfWeekComboBox.repaint();
        this.dayOfMonthLabel.repaint();
        this.dayOfMonthTextField.repaint();
    }

    public void showTopologyDiscoveryOptions(String string) {
        if (string.equals("ping")) {
            this.discoverTopologyPanel.add(this.dTopStartIpTextField);
            this.discoverTopologyPanel.add(this.dTopEndIpLabel);
            this.discoverTopologyPanel.add(this.dTopEndIpTextField);
            this.discoverTopologyPanel.add(this.dTopNetmaskLabel);
            this.discoverTopologyPanel.add(this.dTopNetmaskTextField);
            this.discoverTopologyPanel.remove(this.dTopStartIpTextLabel);
            this.discoverTopologyPanel.remove(this.dTopNumHopsLabel);
            this.discoverTopologyPanel.remove(this.dTopNumHopsTextField);
        } else {
            this.discoverTopologyPanel.remove(this.dTopStartIpTextField);
            this.discoverTopologyPanel.remove(this.dTopEndIpLabel);
            this.discoverTopologyPanel.remove(this.dTopEndIpTextField);
            this.discoverTopologyPanel.remove(this.dTopNetmaskLabel);
            this.discoverTopologyPanel.remove(this.dTopNetmaskTextField);
            this.discoverTopologyPanel.add(this.dTopStartIpTextLabel);
            this.discoverTopologyPanel.add(this.dTopNumHopsLabel);
            this.discoverTopologyPanel.add(this.dTopNumHopsTextField);
        }
        this.discoverTopologyPanel.validate();
        this.discoverTopologyPanel.repaint();
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = false;
            if (itemEvent.getStateChange() == 1) {
                bl = true;
            }
            RequestEditDialog.this.enableMonitorSettings(bl);
        }
    }
}

