/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConstants;
import com.sun.symon.tools.discovery.console.presentation.DiscoverErrorDialog;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import com.sun.symon.tools.discovery.console.presentation.FilterData;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class RequestFilterPanel
extends JPanel {
    DiscoverRequest request;
    DiscoverPanel parent;
    FilterData filterData;
    JRadioButton[] incRadioButton;
    JRadioButton[] excRadioButton;
    JList[] incExcList;
    JComponent[] incExcTextCombo;
    JButton[] incExcAddButton;
    JButton[] incExcDeleteButton;
    JPanel[] filterPanel;
    JCheckBox[] criteriaCheckBox;
    JPanel filterDetailsPanel;

    public RequestFilterPanel(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest) {
        this.parent = discoverPanel;
        this.request = discoverRequest;
        this.filterData = new FilterData(new SMResourceAccess(discoverPanel.getRequestHandle()));
        this.filterData.parseData();
        this.buildFilterPanel();
    }

    public void AddPressed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        JList jList = null;
        JComponent jComponent = null;
        int n = 0;
        while (n < 3) {
            if (jButton == this.incExcAddButton[n]) {
                jList = this.incExcList[n];
                jComponent = this.incExcTextCombo[n];
            }
            ++n;
        }
        this.addTexttoList(jList, jComponent);
    }

    public void DeletePressed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        JList jList = null;
        int n = 0;
        while (n < 3) {
            if (jButton == this.incExcDeleteButton[n]) {
                jList = this.incExcList[n];
            }
            ++n;
        }
        if (jList != null) {
            Object[] objectArray = jList.getSelectedValues();
            int n2 = 0;
            while (n2 < objectArray.length) {
                ((DefaultListModel)jList.getModel()).removeElement(objectArray[n2]);
                ++n2;
            }
        }
        jButton.setEnabled(false);
        jList.clearSelection();
        jList.validate();
        jList.repaint();
    }

    public void ListItemSelected(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList.getMinSelectionIndex() != -1) {
            int n = 0;
            while (n < 3) {
                if (jList == this.incExcList[n]) {
                    this.incExcDeleteButton[n].setEnabled(true);
                }
                ++n;
            }
        }
    }

    public void TextFieldPressed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        JList jList = null;
        int n = 0;
        while (n < 3) {
            if (jComponent == this.incExcTextCombo[n]) {
                jList = this.incExcList[n];
            }
            ++n;
        }
        this.addTexttoList(jList, jComponent);
    }

    private void addTexttoList(JList jList, JComponent jComponent) {
        if (jList != null && jComponent != null) {
            String string;
            if (jComponent instanceof JTextField) {
                string = ((JTextField)jComponent).getText();
            } else if (jComponent instanceof JComboBox) {
                string = (String)((JComboBox)jComponent).getSelectedItem();
            } else {
                return;
            }
            ListModel listModel = jList.getModel();
            int n = 0;
            while (n < listModel.getSize()) {
                if (listModel.getElementAt(n).equals(string)) {
                    JFrame jFrame = new JFrame();
                    DiscoverErrorDialog discoverErrorDialog = new DiscoverErrorDialog(this.parent, this.parent.getI18NString("Entry_already_exists_in_the_list"));
                    discoverErrorDialog.show();
                    return;
                }
                ++n;
            }
            ((DefaultListModel)jList.getModel()).addElement(string);
            jList.validate();
            jList.repaint();
            if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).setText("");
            }
        }
    }

    private void buildFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 20, 20));
        JLabel jLabel = new JLabel(this.parent.getI18NString("Select_Filter_Criteriacolon"));
        jLabel.setHorizontalAlignment(4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 20, 20));
        this.criteriaCheckBox = new JCheckBox[3];
        this.criteriaCheckBox[0] = new JCheckBox(this.parent.getI18NString("Host_Names"));
        this.criteriaCheckBox[1] = new JCheckBox(this.parent.getI18NString("Operating_System"));
        this.criteriaCheckBox[2] = new JCheckBox(this.parent.getI18NString("Platform_Type"));
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        int n = 0;
        while (n < 3) {
            this.criteriaCheckBox[n].addItemListener(checkBoxListener);
            jPanel2.add(this.criteriaCheckBox[n]);
            ++n;
        }
        jPanel.add(jLabel);
        jPanel.add(jPanel2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.parent.getI18NString("Criteria"));
        jPanel.setBorder(titledBorder);
        this.filterDetailsPanel = new JPanel();
        this.filterDetailsPanel.setLayout(new GridLayout(5, 1, 20, 20));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.parent.getI18NString("Filters"));
        this.filterDetailsPanel.setBorder(titledBorder2);
        this.incExcList = new JList[3];
        this.incExcTextCombo = new JComponent[3];
        this.incExcAddButton = new JButton[3];
        this.incExcDeleteButton = new JButton[3];
        this.incRadioButton = new JRadioButton[3];
        this.excRadioButton = new JRadioButton[3];
        this.filterPanel = new JPanel[3];
        this.filterPanel[0] = this.buildFilterPanelComponent(this.parent.getI18NString("Host_Names"), 0, false, null);
        this.filterPanel[1] = this.buildFilterPanelComponent(this.parent.getI18NString("OS"), 1, true, DiscoverConstants.OS_ARR);
        this.filterPanel[2] = this.buildFilterPanelComponent(this.parent.getI18NString("Platform_Type"), 2, true, this.filterData.i18nPlatforms);
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        this.setBorder(border);
        this.setLayout(new BorderLayout(20, 20));
        this.add("North", jPanel);
        this.add("Center", this.filterDetailsPanel);
        this.showFilterData();
    }

    private JPanel buildFilterPanelComponent(String string, int n, boolean bl, String[] stringArray) {
        JPanel jPanel = this.buildFilterPanelTemplate(string, n, bl, stringArray);
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel.setBorder(border);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(20, 20));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add("North", jPanel);
        jPanel2.add("Center", jSeparator);
        return jPanel2;
    }

    private JPanel buildFilterPanelTemplate(String string, int n, boolean bl, String[] stringArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(20, 20));
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel.setBorder(border);
        JLabel jLabel = new JLabel(string);
        this.incRadioButton[n] = new JRadioButton(this.parent.getI18NString("Include"));
        this.incRadioButton[n].setSelected(true);
        this.excRadioButton[n] = new JRadioButton(this.parent.getI18NString("Exclude"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.incRadioButton[n]);
        buttonGroup.add(this.excRadioButton[n]);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3, 20, 20));
        jPanel2.add(jLabel);
        jPanel2.add(this.incRadioButton[n]);
        jPanel2.add(this.excRadioButton[n]);
        this.incExcList[n] = new JList(new DefaultListModel());
        this.incExcAddButton[n] = new JButton(this.parent.getI18NString("Add"));
        this.incExcDeleteButton[n] = new JButton(this.parent.getI18NString("Delete"));
        this.incExcDeleteButton[n].setEnabled(false);
        if (!bl) {
            this.incExcAddButton[n].setEnabled(false);
            this.incExcTextCombo[n] = new JTextField();
            ((JTextField)this.incExcTextCombo[n]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestFilterPanel.this.TextFieldPressed(actionEvent);
                }
            });
            ((JTextField)this.incExcTextCombo[n]).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    RequestFilterPanel.this.enteredInTextField(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    RequestFilterPanel.this.enteredInTextField(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    RequestFilterPanel.this.enteredInTextField(documentEvent);
                }
            });
        } else {
            this.incExcTextCombo[n] = new JComboBox<String>(stringArray);
            ((JComboBox)this.incExcTextCombo[n]).setSelectedIndex(0);
        }
        this.incExcList[n].addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RequestFilterPanel.this.ListItemSelected(listSelectionEvent);
            }
        });
        this.incExcAddButton[n].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestFilterPanel.this.AddPressed(actionEvent);
            }
        });
        this.incExcDeleteButton[n].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestFilterPanel.this.DeletePressed(actionEvent);
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 20, 20));
        jPanel3.add(this.incExcAddButton[n]);
        jPanel3.add(this.incExcDeleteButton[n]);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(20, 20));
        JLabel jLabel2 = new JLabel(this.parent.getI18NString("Specify_Valuecolon"));
        jPanel4.add("West", jLabel2);
        jPanel4.add("Center", this.incExcTextCombo[n]);
        jPanel.add("North", jPanel2);
        jPanel.add("Center", this.incExcList[n]);
        jPanel.add("South", jPanel4);
        jPanel.add("East", jPanel3);
        return jPanel;
    }

    public void enteredInTextField(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        int n = 0;
        while (n < 3) {
            if (this.incExcTextCombo[n] instanceof JTextField && document == ((JTextField)this.incExcTextCombo[n]).getDocument()) {
                if (document.getLength() != 0) {
                    this.incExcAddButton[n].setEnabled(true);
                } else {
                    this.incExcAddButton[n].setEnabled(false);
                }
            }
            ++n;
        }
    }

    public void readFilterData() {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (this.criteriaCheckBox[n2].isSelected()) {
                ++n;
            }
            ++n2;
        }
        this.request.setNumFilterCriteria(n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < 3) {
            if (this.criteriaCheckBox[n4].isSelected()) {
                int n5;
                String[] stringArray;
                int n6;
                if (this.incRadioButton[n4].isSelected()) {
                    n6 = ((DefaultListModel)this.incExcList[n4].getModel()).getSize();
                    stringArray = new String[n6];
                    n5 = 0;
                    while (n5 < n6) {
                        if (n4 == 1) {
                            stringArray[n5] = (String)((DefaultListModel)this.incExcList[n4].getModel()).getElementAt(n5);
                            stringArray[n5] = stringArray[n5].substring(6);
                        } else {
                            stringArray[n5] = n4 == 2 ? this.filterData.getPlatformforI18N((String)((DefaultListModel)this.incExcList[n4].getModel()).getElementAt(n5)) : (String)((DefaultListModel)this.incExcList[n4].getModel()).getElementAt(n5);
                        }
                        ++n5;
                    }
                    this.request.setIncludeItemValue(n3, stringArray);
                } else {
                    n6 = ((DefaultListModel)this.incExcList[n4].getModel()).getSize();
                    stringArray = new String[n6];
                    n5 = 0;
                    while (n5 < n6) {
                        if (n4 == 1) {
                            stringArray[n5] = (String)((DefaultListModel)this.incExcList[n4].getModel()).getElementAt(n5);
                            stringArray[n5] = stringArray[n5].substring(6);
                        } else {
                            stringArray[n5] = n4 == 2 ? this.filterData.getPlatformforI18N((String)((DefaultListModel)this.incExcList[n4].getModel()).getElementAt(n5)) : (String)((DefaultListModel)this.incExcList[n4].getModel()).getElementAt(n5);
                        }
                        ++n5;
                    }
                    this.request.setExcludeItemValue(n3, stringArray);
                }
                this.request.setFilterCriteria(n3, n4);
                ++n3;
            }
            ++n4;
        }
    }

    public void showFilterData() {
        int n = this.request.getNumFilterCriteria();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this.request.getFilterCriteria(n2);
            this.criteriaCheckBox[n4].setSelected(true);
            this.filterDetailsPanel.add(this.filterPanel[n4]);
            String[] stringArray = this.request.getIncludeItemValue(n2);
            String[] stringArray2 = this.request.getExcludeItemValue(n2);
            if (stringArray2 != null && stringArray2.length > 0) {
                this.excRadioButton[n4].setSelected(true);
                n3 = 0;
                while (n3 < stringArray2.length) {
                    if (n4 == 1) {
                        ((DefaultListModel)this.incExcList[n4].getModel()).addElement("SunOS " + stringArray2[n3]);
                    } else if (n4 == 2) {
                        ((DefaultListModel)this.incExcList[n4].getModel()).addElement(this.parent.getI18NString(stringArray2[n3]));
                    } else {
                        ((DefaultListModel)this.incExcList[n4].getModel()).addElement(stringArray2[n3]);
                    }
                    ++n3;
                }
            } else {
                this.incRadioButton[n4].setSelected(true);
                if (stringArray != null) {
                    n3 = 0;
                    while (n3 < stringArray.length) {
                        if (n4 == 1) {
                            ((DefaultListModel)this.incExcList[n4].getModel()).addElement("SunOS " + stringArray[n3]);
                        } else if (n4 == 2) {
                            ((DefaultListModel)this.incExcList[n4].getModel()).addElement(this.parent.getI18NString(stringArray[n3]));
                        } else {
                            ((DefaultListModel)this.incExcList[n4].getModel()).addElement(stringArray[n3]);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Container container;
            boolean bl = false;
            if (itemEvent.getStateChange() == 1) {
                bl = true;
            }
            int n = 0;
            while (n < 3) {
                if (itemEvent.getSource() == RequestFilterPanel.this.criteriaCheckBox[n]) {
                    if (bl) {
                        RequestFilterPanel.this.filterDetailsPanel.add(RequestFilterPanel.this.filterPanel[n]);
                    } else {
                        RequestFilterPanel.this.filterDetailsPanel.remove(RequestFilterPanel.this.filterPanel[n]);
                    }
                }
                ++n;
            }
            int n2 = RequestFilterPanel.this.filterDetailsPanel.getComponentCount();
            if (n2 != 0) {
                RequestFilterPanel.this.filterDetailsPanel.setLayout(new GridLayout(n2, 1, 20, 20));
            } else {
                RequestFilterPanel.this.filterDetailsPanel.setLayout(new GridLayout(1, 1, 20, 20));
            }
            Container container2 = container = RequestFilterPanel.this.getParent();
            while (container != null) {
                container2 = container;
                container = container.getParent();
                container2.validate();
                container2.repaint();
            }
        }
    }
}

