/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmpbridge;

import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.emitters.snmpbridge.Concentrator;
import com.sun.symon.base.server.emitters.snmpbridge.Convertor;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StSnmpCounter;
import com.sun.symon.base.server.types.StSnmpGauge;
import com.sun.symon.base.server.types.StSnmpINTEGER;
import com.sun.symon.base.server.types.StSnmpIpAddress;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.server.types.StSnmpTimeTicks;
import com.sun.symon.base.server.types.StSnmpUInteger32;
import com.sun.symon.base.utility.UcListUtil;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SnmpJobBase {
    private static Concentrator Conc;
    private static Hashtable ConvertorFromSnmpLookup;
    private static Hashtable ConvertorToSnmpLookup;
    private static String ReadCommunity;
    private static long TidCounter;
    private static Hashtable TidTable;
    private static String WriteCommunity;
    private boolean GotResponse;
    private boolean OneShot;
    private String Tid;

    static {
        ConvertorFromSnmpLookup = new Hashtable();
        ConvertorToSnmpLookup = new Hashtable();
        SnmpJobBase.addConvertor("StSnmpCounter", new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpCounter(string);
            }

            public String toSnmpType(StObject stObject) {
                return "Counter";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        });
        SnmpJobBase.addConvertor("StSnmpGauge", new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpGauge(string);
            }

            public String toSnmpType(StObject stObject) {
                return "Gauge";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        });
        SnmpJobBase.addConvertor("StSnmpUInteger32", new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpUInteger32(string);
            }

            public String toSnmpType(StObject stObject) {
                return "UInteger32";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        });
        Convertor convertor = new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpINTEGER(string);
            }

            public String toSnmpType(StObject stObject) {
                return "INTEGER";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        };
        SnmpJobBase.addConvertor("StSnmpINTEGER", convertor);
        SnmpJobBase.addConvertor("StSnmpTimeTicks", new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpTimeTicks(string);
            }

            public String toSnmpType(StObject stObject) {
                return "TimeTicks";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        });
        SnmpJobBase.addConvertor("StSnmpOBJECT_IDENTIFIER", new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpOBJECT_IDENTIFIER(string);
            }

            public String toSnmpType(StObject stObject) {
                return "OBJECT IDENTIFIER";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        });
        SnmpJobBase.addConvertor("StSnmpIpAddress", new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpIpAddress(string);
            }

            public String toSnmpType(StObject stObject) {
                return "IpAddress";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        });
        Convertor convertor2 = new Convertor(){

            public StObject fromSnmp(String string) {
                return new StSnmpOCTET_STRING(string);
            }

            public String toSnmpType(StObject stObject) {
                return "DisplayString";
            }

            public String toSnmpValue(StObject stObject) {
                return stObject.toString();
            }
        };
        SnmpJobBase.addConvertor("StSnmpOCTET_STRING", convertor2);
        SnmpJobBase.addConvertor("StSnmpDisplayString", convertor2);
        SnmpJobBase.addConvertor("StString", convertor2);
        SnmpJobBase.addConvertor("StBytes", convertor2);
        SnmpJobBase.addConvertor("StInteger", convertor);
    }

    public SnmpJobBase(String string, int n, String string2, StObject[] stObjectArray) {
        Hashtable hashtable = TidTable;
        synchronized (hashtable) {
            this.Tid = "bid" + TidCounter;
            TidTable.put(this.Tid, this);
            ++TidCounter;
        }
        this.OneShot = string == null;
        this.GotResponse = false;
        this.sendRequest(n, string2, stObjectArray, string);
    }

    private static void addConvertor(String string, Convertor convertor) {
        if (string.startsWith("StSnmp")) {
            String string2 = string.substring(6).replace('_', ' ');
            ConvertorFromSnmpLookup.put(string2, convertor);
        }
        ConvertorToSnmpLookup.put(string, convertor);
    }

    private StObject cnvtConc2Data(String string) {
        Vector vector = new Vector();
        if (!SnmpJobBase.splitTCLList(string, vector)) {
            this.handleServerError("Invalid data: '" + string + "' (not a TCL list)");
            return null;
        }
        if (vector.size() != 3) {
            this.handleServerError("Invalid data: '" + string + "' (expecting 3 items in TCL list)");
            return null;
        }
        String string2 = (String)vector.elementAt(1);
        String string3 = (String)vector.elementAt(2);
        Convertor convertor = this.getConvertor(string2);
        return convertor == null ? null : convertor.fromSnmp(string3);
    }

    private StObject[] cnvtConc2Data(Vector vector) {
        StObject[] stObjectArray = new StObject[vector.size()];
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            stObjectArray[n2] = this.cnvtConc2Data((String)vector.elementAt(n2));
            ++n2;
        }
        return stObjectArray;
    }

    private Convertor getConvertor(StObject stObject) {
        Convertor convertor = (Convertor)ConvertorToSnmpLookup.get(stObject.getTypeName());
        if (convertor == null && (convertor = (Convertor)ConvertorToSnmpLookup.get(stObject.getBaseTypeName())) == null) {
            this.handleClientError("Don't know how to convert type '" + stObject.getTypeName() + "'");
        }
        return convertor;
    }

    private Convertor getConvertor(String string) {
        Convertor convertor = (Convertor)ConvertorFromSnmpLookup.get(string);
        if (convertor == null) {
            this.handleServerError("Don't know how to convert type '" + string + "'");
        }
        return convertor;
    }

    protected abstract void handleClientError(String var1);

    void handleData(String string) {
        Object var2_2 = null;
        Vector vector = new Vector();
        if (!SnmpJobBase.splitTCLList(string, vector)) {
            this.handleServerError("Invalid data: '" + string + "' (not a TCL list)");
            return;
        }
        this.GotResponse = true;
        this.handleResult(this.cnvtConc2Data(vector));
    }

    protected abstract void handleException(ScResponseException var1);

    protected abstract void handleResult(StObject[] var1);

    protected abstract void handleServerError(String var1);

    public static void init(String string, int n, String string2, String string3) throws IOException, UnknownHostException {
        Conc = new Concentrator(string, n);
        TidCounter = 0L;
        TidTable = new Hashtable();
        ReadCommunity = string2;
        WriteCommunity = string3;
    }

    static SnmpJobBase lookup(String string) {
        Hashtable hashtable = TidTable;
        synchronized (hashtable) {
            SnmpJobBase snmpJobBase = (SnmpJobBase)TidTable.get(string);
            Object var3_3 = null;
            return snmpJobBase;
        }
    }

    public void remove() {
        if (!this.GotResponse || !this.OneShot) {
            Conc.removeJob(this.Tid);
        }
        Hashtable hashtable = TidTable;
        synchronized (hashtable) {
            TidTable.remove(this.Tid);
        }
    }

    private void sendRequest(int n, String string, StObject[] stObjectArray, String string2) {
        String string3;
        String string4;
        String string5 = "";
        if (string2 == null) {
            string2 = "-1";
        }
        switch (n) {
            case 1: {
                string5 = "get";
                string4 = ReadCommunity;
                if (stObjectArray == null) break;
                this.handleClientError("Expecting requestData to be null with get request");
                return;
            }
            case 0: {
                String string6;
                string5 = "set";
                string4 = WriteCommunity;
                if (stObjectArray == null) {
                    string3 = "ASN NULL";
                    string6 = "";
                } else {
                    if (stObjectArray.length != 1) {
                        this.handleClientError("Expecting requestData to be of length 1 with set request");
                        return;
                    }
                    StObject stObject = stObjectArray[0];
                    Convertor convertor = this.getConvertor(stObject);
                    if (convertor == null) {
                        return;
                    }
                    string3 = convertor.toSnmpType(stObject);
                    string6 = convertor.toSnmpValue(stObject);
                }
                string = UcListUtil.composeList((String[])new String[]{string, string3, string6});
                string = UcListUtil.composeList((String[])new String[]{string});
                break;
            }
            default: {
                this.handleClientError("Invalid command: " + n);
                return;
            }
        }
        string3 = UcListUtil.composeList((String[])new String[]{string5, "", "0", string2, string, "-verbose", "-community", string4});
        Conc.sendRequest(this.Tid, string3);
    }

    private static boolean splitTCLList(String string, Vector vector) {
        return UcListUtil.decomposeList((String)string, (Vector)vector);
    }
}

