/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.snmp.v1;

import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.jni.SsPacket;
import com.sun.symon.base.server.snmp.v1.SsGetNextRequest;
import com.sun.symon.base.server.snmp.v1.SsGetRequest;
import com.sun.symon.base.server.snmp.v1.SsGetResponse;
import com.sun.symon.base.server.snmp.v1.SsSetRequest;
import com.sun.symon.base.server.snmp.v1.SsTrap;

public abstract class SsRequest
extends SsMessage {
    public static final int GET_REQUEST = 0;
    public static final int SET_REQUEST = 1;
    public static final int GET_NEXT_REQUEST = 2;
    public static final int GET_RESPONSE = 3;
    public static final int TRAP = 4;

    public SsRequest() {
    }

    public SsRequest(SsPacket ssPacket) throws SsDecodeException {
        this.setState(ssPacket.state);
        this.setHost(ssPacket.host);
        this.setPort(ssPacket.port);
        this.setContextName(ssPacket.context);
        this.setSecurityName(ssPacket.security);
        this.setText(ssPacket.printStatus());
        this.setSecurityLevel(ssPacket.level);
        this.setSecurityModel(ssPacket.model);
        this.setSendId(ssPacket.send);
        this.setRequestId(ssPacket.request);
        this.setVariableNames(ssPacket.name);
        this.setVariableValues(ssPacket.kind, ssPacket.value);
    }

    public static SsMessage decode(SsPacket ssPacket) throws SsDecodeException {
        switch (ssPacket.type) {
            case 0: {
                return new SsGetRequest(ssPacket);
            }
            case 1: {
                return new SsSetRequest(ssPacket);
            }
            case 2: {
                return new SsGetNextRequest(ssPacket);
            }
            case 3: {
                return new SsGetResponse(ssPacket);
            }
            case 4: {
                return new SsTrap(ssPacket);
            }
        }
        throw new SsDecodeException("unknown PDU type");
    }

    public int getVersion() {
        return 1;
    }

    public byte[] toBytestream() throws SsEncodeException {
        SsPacket ssPacket = new SsPacket();
        ssPacket.version = this.getVersion();
        ssPacket.state = this.getState();
        ssPacket.host = this.getHost();
        ssPacket.port = this.getPort();
        ssPacket.context = this.getContextName();
        ssPacket.security = this.getSecurityName();
        ssPacket.level = this.getSecurityLevel();
        ssPacket.model = this.getSecurityModel();
        ssPacket.type = this.getType();
        ssPacket.send = this.getSendId();
        ssPacket.request = this.getRequestId();
        ssPacket.name = this.getVariableNames();
        ssPacket.kind = this.getVariableTypes();
        ssPacket.value = this.getVariableValues();
        byte[] byArray = ssPacket.outgoing();
        ssPacket = null;
        return byArray;
    }
}

