/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMConnectionLostEvent;
import com.sun.symon.base.client.SMConnectionLostListener;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.console.awx.AwxComponent;
import com.sun.symon.base.console.awx.AwxLayoutFrame;
import com.sun.symon.base.console.awx.AwxLayoutRow;
import com.sun.symon.base.console.awx.AwxObject;
import com.sun.symon.base.console.awx.AwxSplitPane;
import com.sun.symon.base.console.manager.CmConsoleHistListener;
import com.sun.symon.base.console.manager.CmConsoleLoader;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.manager.CmNavigatorHierarchy;
import com.sun.symon.base.console.manager.CmNavigatorPanel;
import com.sun.symon.base.console.manager.CmTopoModuleMonitor;
import com.sun.symon.base.console.manager.CmTopologyControl;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.console.manager.CmViewDeletedRetryer;
import com.sun.symon.base.console.services.client.CsClientAPIStub;
import com.sun.symon.base.console.views.hierarchy.CvHierarchySelectEvent;
import com.sun.symon.base.console.views.hierarchy.CvHierarchySelectListener;
import com.sun.symon.base.console.views.topology.CvTopologySelectEvent;
import com.sun.symon.base.console.views.topology.CvTopologySelectListener;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import com.sun.symon.base.xobject.XObjectBase;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class CmNavigatorConsole
extends AwxLayoutFrame
implements CvHierarchySelectListener,
CvTopologySelectListener,
SMConnectionLostListener {
    private String InitialDomainName = null;
    private String InitialDomainUrl = null;
    private boolean NoDomains = true;
    private SMRawDataRequest RawHandle = null;
    private SMManagedEntityRequest EntityRequestHandle = null;
    private SMUserDomainRequest DomainRequestHandle = null;
    private int PanelIndex = 1;
    private int HierarchyIndex = 1;
    private boolean InitComplete = false;
    private boolean ConsoleChangeInProgress = false;
    private boolean SelectionChangeInProgress = false;
    private Object CurrentSelectionHolder = null;
    private AwxSplitPane ViewPane = null;
    private XObjectBase HierarchyTemplate = null;
    private XObjectBase PanelTemplate = null;
    private CmNavigatorPanel LeftDummy;
    private CmNavigatorPanel RightDummy;
    private AwxComponent HistoryMenuObj = null;
    private JMenu HistoryMenu = null;
    private AwxObject TopologyControlObj = null;
    private CmTopologyControl TopologyControl = null;
    private AwxComponent MenuZone = null;
    private AwxComponent LayoutMenuObj = null;
    private String CurrentDomainUrl = null;
    private int CurrentPanelIndex = -1;
    private String CurrentPanelUrl = null;
    private CmNavigatorPanel CurrentPanel = null;
    private CmNavigatorHierarchy CurrentHierarchy = null;
    private CmTopologyPath CurrentPath = null;
    private Vector HistoricalPanels = new Vector();
    private Vector HistoricalPaths = new Vector();
    private Hashtable HierarchyPanels = new Hashtable();
    private Hashtable AllPanels = new Hashtable();
    private Vector ListPaths = new Vector();

    public CmNavigatorConsole(XObjectBase xObjectBase, String string) {
        super(xObjectBase, string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeToDomain(String string, String string2) {
        Object object = this;
        synchronized (object) {
            if (string2 == null) {
                return;
            }
            string2 = UcURL.standardizeURL((String)string2);
            if (this.InitialDomainUrl == null) {
                this.InitialDomainName = string;
                this.InitialDomainUrl = string2;
            }
            if (!this.InitComplete) {
                return;
            }
            if (this.ConsoleChangeInProgress) {
                return;
            }
            if (this.CurrentDomainUrl != null && string2.compareTo(this.CurrentDomainUrl) == 0) {
                return;
            }
        }
        object = new CmTopologyPath("root", string, string2);
        this.navigateToPathNow((CmTopologyPath)object, true, null);
    }

    public void connectionLost(SMConnectionLostEvent sMConnectionLostEvent) {
        String string = "base.console.ConsoleMessages:server.connectionlost";
        String string2 = UcInternationalizer.translateKey((String)string);
        String string3 = UcInternationalizer.translateKey((String)(String.valueOf(string) + ".title"));
        Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.exitapp")};
        JOptionPane.showOptionDialog(null, string2, string3, -1, 2, null, objectArray, objectArray[0]);
        System.exit(0);
    }

    public void consoleLoadComplete(CmTopologyPath cmTopologyPath, CmNavigatorHierarchy cmNavigatorHierarchy, CmNavigatorPanel cmNavigatorPanel, String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.switchToPanel(cmTopologyPath, cmNavigatorHierarchy, cmNavigatorPanel, string, -1);
        } else {
            try {
                SwingUtilities.invokeAndWait(new SwitchToPanelRunnable(cmTopologyPath, cmNavigatorHierarchy, cmNavigatorPanel, string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.ConsoleChangeInProgress = false;
    }

    public void consoleLoadFailed() {
        this.ConsoleChangeInProgress = false;
    }

    private CmNavigatorHierarchy createNavHierarchyInstance(String string) {
        String string2;
        AwxComponent awxComponent = this;
        synchronized (awxComponent) {
            string2 = "hierarchy-" + this.HierarchyIndex++;
        }
        awxComponent = new CmNavigatorHierarchy((XObjectBase)this.ViewPane, string2, this.HierarchyTemplate);
        ((CmNavigatorHierarchy)awxComponent).setRootUrl(string);
        return awxComponent;
    }

    private CmNavigatorPanel createNavPanelInstance() {
        String string;
        AwxLayoutRow awxLayoutRow = this;
        synchronized (awxLayoutRow) {
            string = "panel-" + this.PanelIndex++;
        }
        awxLayoutRow = new CmNavigatorPanel((XObjectBase)this.ViewPane, string, this.PanelTemplate);
        return awxLayoutRow;
    }

    public void deselectAll() {
        if (this.CurrentPanel != null) {
            this.CurrentPanel.triggerService("clearSelection");
        }
        if (this.CurrentHierarchy != null) {
            this.CurrentHierarchy.triggerService("clearSelection");
        }
    }

    public void domainDeleted(String string) {
        this.viewDeleted(string, true);
    }

    public void initConsole() {
        Object object;
        Object object2;
        XObjectBase xObjectBase = this.locate(".templates.consoles.navigator", false);
        if (xObjectBase == null) {
            UcDDL.croak((String)"No navigator console template definition found");
        }
        this.recursiveInherit(xObjectBase);
        String string = this.lookup("value", "dataSource", ".services.client");
        try {
            object2 = (CsClientAPIStub)this.locate(string, false);
            this.RawHandle = ((CsClientAPIStub)((Object)object2)).getClientAPIInstance();
            this.RawHandle.addSMConnectionLostListener((SMConnectionLostListener)this);
            this.EntityRequestHandle = new SMManagedEntityRequest(this.RawHandle);
            this.DomainRequestHandle = new SMUserDomainRequest(this.RawHandle);
        }
        catch (Exception exception) {
            UcDDL.croak((String)"CmNavigatorConsole: Client API not found");
        }
        object2 = "120";
        String[] stringArray = new String[]{String.valueOf(this.RawHandle.getTopologyBaseURL()) + "sym/base/mibman/modules/serverSupport/moduleTable/moduleEntry/modspec", String.valueOf(this.RawHandle.getTopologyBaseURL()) + "sym/base/mibman/modules/serverSupport/moduleTable/moduleEntry/url"};
        try {
            this.RawHandle.getURLValue(stringArray, (String)object2, (SMRawDataResponse)new CmTopoModuleMonitor(this), null);
        }
        catch (SMAPIException sMAPIException) {}
        try {
            object = this.lookup("value", "viewPane", null);
            this.ViewPane = (AwxSplitPane)this.locate((String)object, true);
            this.ViewPane.define("activate", "inferiors", "false");
            String string2 = this.lookup("value", "hierarchyTemplate", null);
            this.HierarchyTemplate = this.locate(string2, true);
            this.HierarchyTemplate.define("activate", "inferiors", "false");
            String string3 = this.lookup("value", "panelTemplate", null);
            this.PanelTemplate = this.locate(string3, true);
            this.PanelTemplate.define("activate", "inferiors", "false");
            String string4 = this.lookup("value", "historyMenu", null);
            this.HistoryMenuObj = (AwxComponent)this.locate(string4, true);
            this.HistoryMenu = (JMenu)this.HistoryMenuObj.getBean();
            String string5 = this.lookup("value", "topologyMngr", null);
            this.TopologyControlObj = (AwxObject)this.locate(string5, true);
            this.TopologyControl = (CmTopologyControl)this.TopologyControlObj.getBean();
            String string6 = this.lookup("value", "menuZone", null);
            this.MenuZone = (AwxComponent)this.locate(string6, true);
            String string7 = this.lookup("value", "layoutMenu", null);
            this.LayoutMenuObj = (AwxComponent)this.locate(string7, true);
        }
        catch (Exception exception) {
            UcDDL.croak((String)"CmNavigatorConsole: missing or invalid console management objects (viewPane, hierarchyTemplate, panelTemplate, historyMenu or menuZone)");
        }
        this.recursiveActivate();
        this.LeftDummy = new CmNavigatorPanel((XObjectBase)this.ViewPane, "leftDummy", null);
        this.LeftDummy.inherit(this.HierarchyTemplate);
        this.LeftDummy.define("res", "objectUrl", "");
        this.LeftDummy.define("resType", "datasource", "ignore");
        this.LeftDummy.define("resType", "buffer", "ignore");
        this.LeftDummy.define("event", "ignoreAll", "true");
        this.LeftDummy.recursiveActivate();
        this.RightDummy = new CmNavigatorPanel((XObjectBase)this.ViewPane, "rightDummy", null);
        this.RightDummy.inherit(this.PanelTemplate);
        this.RightDummy.recursiveActivate();
        this.ViewPane.setLeftComponent(this.LeftDummy);
        this.ViewPane.setRightComponent(this.RightDummy);
        object = this;
        synchronized (object) {
            this.InitComplete = true;
            if (this.InitialDomainUrl != null && this.InitialDomainUrl.compareTo("") != 0) {
                this.changeToDomain(this.InitialDomainName, this.InitialDomainUrl);
            } else if (this.NoDomains) {
                this.triggerService("launchDomainManager");
            } else {
                this.triggerService("launchNoHomeDomainStart");
            }
        }
    }

    public void navigateHome() {
        SMUserDomainData sMUserDomainData = null;
        try {
            sMUserDomainData = this.DomainRequestHandle.getDefaultDomainInfo();
        }
        catch (Exception exception) {
            this.showMessage("base.console.ConsoleMessages:gohome.fail", true);
        }
        if (sMUserDomainData == null) {
            this.triggerService("launchNoHomeDomainDuring");
        } else {
            this.changeToDomain(sMUserDomainData.getDomainName(), sMUserDomainData.getDomainRootUrl());
        }
    }

    public void navigateNext() {
        this.navigateToIndex(this.CurrentPanelIndex + 1);
    }

    public void navigatePrevious() {
        this.navigateToIndex(this.CurrentPanelIndex - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void navigateToIndex(int n) {
        Object object = this;
        synchronized (object) {
            if (n < 0) return;
            if (n >= this.HistoricalPanels.size()) {
                return;
            }
            if (n == this.CurrentPanelIndex) {
                return;
            }
            if (this.ConsoleChangeInProgress) {
                return;
            }
            this.ConsoleChangeInProgress = true;
        }
        object = (CmTopologyPath)this.HistoricalPaths.elementAt(n);
        String string = ((CmTopologyPath)object).getRoot().getNodeUrl();
        string = UcURL.standardizeURL((String)string);
        CmNavigatorHierarchy cmNavigatorHierarchy = (CmNavigatorHierarchy)this.HierarchyPanels.get(string);
        CmNavigatorPanel cmNavigatorPanel = (CmNavigatorPanel)this.HistoricalPanels.elementAt(n);
        this.switchToPanel((CmTopologyPath)object, cmNavigatorHierarchy, cmNavigatorPanel, null, n);
        this.ConsoleChangeInProgress = false;
    }

    public void navigateToPath(String string, String string2) {
        CmTopologyPath cmTopologyPath;
        CmTopologyPath cmTopologyPath2 = CmTopologyPath.decode(string2);
        if (cmTopologyPath2 == null) {
            UcDDL.logErrorMessage((String)("Invalid path navigation info " + string2));
            return;
        }
        if (cmTopologyPath2.getLength() == 1 && cmTopologyPath2.getNodeId().compareTo("root") != 0) {
            cmTopologyPath = new CmTopologyPath(this.CurrentPath);
            cmTopologyPath.push(cmTopologyPath2.getNodeId(), cmTopologyPath2.getNodeName(), cmTopologyPath2.getNodeUrl());
        } else {
            cmTopologyPath = cmTopologyPath2;
        }
        String string3 = null;
        if (string.equals("true")) {
            if (cmTopologyPath.getLength() < 2) {
                UcDDL.logErrorMessage((String)"Path with select to root?");
                return;
            }
            string3 = cmTopologyPath.getEnd().getNodeId();
            cmTopologyPath.pop();
        }
        this.navigateToPathNow(cmTopologyPath, false, string3);
    }

    public void navigateToPathByName(String string, String string2) {
        CmTopologyPath cmTopologyPath = CmConsoleSession.pathRetrieve(string2, true);
        if (cmTopologyPath == null) {
            return;
        }
        String string3 = null;
        if (string.equals("true")) {
            if (cmTopologyPath.getLength() < 2) {
                UcDDL.logErrorMessage((String)"Path with select to root?");
                return;
            }
            string3 = cmTopologyPath.getEnd().getNodeId();
            cmTopologyPath.pop();
        }
        this.navigateToPathNow(cmTopologyPath, false, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void navigateToPathNow(CmTopologyPath cmTopologyPath, boolean bl, String string) {
        Object object = this;
        synchronized (object) {
            if (cmTopologyPath == null) {
                return;
            }
            if (this.ConsoleChangeInProgress) {
                return;
            }
            if (this.CurrentPath != null && this.CurrentPath.equals(cmTopologyPath)) {
                this.switchToPanel(this.CurrentPath, this.CurrentHierarchy, this.CurrentPanel, string, this.CurrentPanelIndex);
            }
            this.ConsoleChangeInProgress = true;
        }
        try {
            CmNavigatorHierarchy cmNavigatorHierarchy;
            object = cmTopologyPath.getRoot().getNodeUrl();
            object = UcURL.standardizeURL((String)object);
            if (this.HierarchyPanels.containsKey(object)) {
                cmNavigatorHierarchy = (CmNavigatorHierarchy)this.HierarchyPanels.get(object);
            } else {
                cmNavigatorHierarchy = this.createNavHierarchyInstance((String)object);
                if (cmNavigatorHierarchy == null) {
                    this.showMessage("base.console.ConsoleMessages:newtree.fail", true);
                    this.ConsoleChangeInProgress = false;
                    return;
                }
                cmNavigatorHierarchy.recursiveActivate();
                this.HierarchyPanels.put(object, cmNavigatorHierarchy);
            }
            String string2 = cmTopologyPath.getEnd().getNodeUrl();
            string2 = UcURL.standardizeURL((String)string2);
            if (this.AllPanels.containsKey(string2)) {
                CmNavigatorPanel cmNavigatorPanel = (CmNavigatorPanel)this.AllPanels.get(string2);
                this.switchToPanel(cmTopologyPath, cmNavigatorHierarchy, cmNavigatorPanel, string, -1);
                this.ConsoleChangeInProgress = false;
                return;
            }
            CmNavigatorPanel cmNavigatorPanel = this.createNavPanelInstance();
            if (cmNavigatorPanel == null) {
                this.showMessage("base.console.ConsoleMessages:newpanel.fail", true);
                this.ConsoleChangeInProgress = false;
                return;
            }
            CmConsoleLoader cmConsoleLoader = new CmConsoleLoader(this, cmTopologyPath, cmNavigatorHierarchy, cmNavigatorPanel, this.EntityRequestHandle, string2, string, bl, this.CurrentDomainUrl);
            Thread thread = new Thread((Runnable)cmConsoleLoader, "console-loader");
            thread.start();
            return;
        }
        catch (Exception exception) {
            if (bl) {
                this.showMessage("base.console.ConsoleMessages:conswitch.fail", true);
            } else {
                this.showMessage("base.console.ConsoleMessages:domainswitch.fail", true);
            }
            this.ConsoleChangeInProgress = false;
        }
    }

    public void navigateUp() {
        if (this.CurrentPath.getLength() == 1) {
            return;
        }
        CmTopologyPath cmTopologyPath = new CmTopologyPath(this.CurrentPath);
        cmTopologyPath.pop();
        this.navigateToPathNow(cmTopologyPath, false, null);
    }

    public void pasteInto(String[] stringArray) {
        this.triggerService("bufferPasteInto", stringArray);
    }

    private void prunePanels(CmNavigatorHierarchy cmNavigatorHierarchy, CmNavigatorPanel cmNavigatorPanel) {
        Object object;
        Object object2;
        Object object3;
        this.HistoricalPaths.setSize(this.CurrentPanelIndex + 1);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        while (n < this.HistoricalPaths.size()) {
            object3 = (CmTopologyPath)this.HistoricalPaths.elementAt(n);
            hashtable.put(((CmTopologyPath)object3).getRoot().getNodeUrl(), object3);
            ++n;
        }
        object3 = this.HierarchyPanels.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (hashtable.containsKey(object2) || (object = (CmNavigatorHierarchy)this.HierarchyPanels.get(object2)) == cmNavigatorHierarchy) continue;
            object.recursiveDestruct();
            this.HierarchyPanels.remove(object2);
        }
        this.HistoricalPanels.setSize(this.CurrentPanelIndex + 1);
        object2 = this.AllPanels.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            CmNavigatorPanel cmNavigatorPanel2 = (CmNavigatorPanel)this.AllPanels.get(object);
            if (cmNavigatorPanel2 == cmNavigatorPanel || this.HistoricalPanels.contains(cmNavigatorPanel2)) continue;
            cmNavigatorPanel2.recursiveDestruct();
            this.AllPanels.remove(object);
        }
    }

    public void selectAll() {
        if (this.CurrentPanel != null) {
            this.CurrentPanel.triggerService("selectAll");
        }
    }

    public void selectionOccurred(CvHierarchySelectEvent cvHierarchySelectEvent) {
        CmNavigatorConsole cmNavigatorConsole = this;
        synchronized (cmNavigatorConsole) {
            if (this.SelectionChangeInProgress) {
                Object var3_3 = null;
                return;
            }
            this.SelectionChangeInProgress = true;
        }
        if (this.TopologyControl == null) {
            this.TopologyControl = (CmTopologyControl)this.TopologyControlObj.getBean();
        }
        if (cvHierarchySelectEvent.getSelectCount() == 0) {
            if (cvHierarchySelectEvent.getSource() == this.CurrentSelectionHolder) {
                if (this.TopologyControl != null) {
                    this.TopologyControl.selectionCleared(this.MenuZone);
                }
                this.CurrentSelectionHolder = null;
            }
        } else {
            if (this.CurrentPanel != null) {
                this.CurrentPanel.triggerService("clearSelection");
            }
            if (this.TopologyControl != null) {
                this.TopologyControl.selectionOccurred(cvHierarchySelectEvent, this.MenuZone);
            }
            this.CurrentSelectionHolder = cvHierarchySelectEvent.getSource();
        }
        this.SelectionChangeInProgress = false;
    }

    public void selectionOccurred(CvTopologySelectEvent cvTopologySelectEvent) {
        CmNavigatorConsole cmNavigatorConsole = this;
        synchronized (cmNavigatorConsole) {
            if (this.SelectionChangeInProgress) {
                Object var3_3 = null;
                return;
            }
            this.SelectionChangeInProgress = true;
        }
        if (this.TopologyControl == null) {
            this.TopologyControl = (CmTopologyControl)this.TopologyControlObj.getBean();
        }
        if (cvTopologySelectEvent.getSelectCount() == 0) {
            if (cvTopologySelectEvent.getSource() == this.CurrentSelectionHolder) {
                if (this.TopologyControl != null) {
                    this.TopologyControl.selectionCleared(this.MenuZone);
                }
                this.CurrentSelectionHolder = null;
            }
        } else {
            if (this.CurrentHierarchy != null) {
                this.CurrentHierarchy.triggerService("clearSelection");
            }
            if (this.TopologyControl != null) {
                this.TopologyControl.selectionOccurred(cvTopologySelectEvent, this.MenuZone);
            }
            this.CurrentSelectionHolder = cvTopologySelectEvent.getSource();
        }
        this.SelectionChangeInProgress = false;
    }

    public void setInitialDomainInfo(String string, String string2, boolean bl) {
        this.InitialDomainName = string;
        this.InitialDomainUrl = string2 = UcURL.standardizeURL((String)string2);
        this.NoDomains = bl;
    }

    public void setLayout(String string) {
        String[] stringArray = new String[]{string};
        if (this.CurrentPanel != null) {
            this.CurrentPanel.triggerService("layout", stringArray);
        }
    }

    public void showMessage(String string, boolean bl) {
        String[] stringArray = new String[]{string};
        if (bl) {
            this.triggerService("messageBell", stringArray);
        } else {
            this.triggerService("message", stringArray);
        }
    }

    private void switchToPanel(CmTopologyPath cmTopologyPath, CmNavigatorHierarchy cmNavigatorHierarchy, CmNavigatorPanel cmNavigatorPanel, String string, int n) {
        String[] stringArray;
        if (this.CurrentPanelIndex >= 0 && n < 0) {
            this.prunePanels(cmNavigatorHierarchy, cmNavigatorPanel);
        }
        if (this.CurrentPanel != null) {
            this.CurrentPanel.triggerService("clearSelection");
        }
        if (this.CurrentHierarchy != null) {
            this.CurrentHierarchy.triggerService("clearSelection");
        }
        String string2 = cmNavigatorPanel.getExactUrl();
        String string3 = cmNavigatorPanel.getObjectUrl();
        UcURL ucURL = new UcURL(string3);
        this.setConsoleParameter("agentHost", ucURL.getHost());
        this.setConsoleParameter("agentPort", ucURL.getPort());
        this.setConsoleParameter("objectUrl", string3);
        this.setConsoleParameter("exactUrl", string2);
        this.setConsoleParameter("domainUrl", cmNavigatorHierarchy.getRootUrl());
        this.setConsoleParameter("mainNavPath", cmTopologyPath.encode());
        this.setConsoleParameter("pathName", cmTopologyPath.toString());
        int n2 = ((JSplitPane)this.ViewPane.getBean()).getDividerLocation();
        try {
            if (this.CurrentPanel != null) {
                this.CurrentPanel.recursiveRemoveComponent();
            }
            if (cmNavigatorPanel.getBean() == null) {
                cmNavigatorPanel.recursiveActivate();
            } else {
                cmNavigatorPanel.recursiveAddComponent();
                cmNavigatorPanel.triggerService("redisplay");
            }
            this.ViewPane.setLeftComponent(cmNavigatorHierarchy);
            this.ViewPane.setRightComponent(cmNavigatorPanel);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CmNavigatorConsole: unexpected error realizing panel objects.");
        }
        ((JSplitPane)this.ViewPane.getBean()).setDividerLocation(n2 - 1);
        Component component = (Component)cmNavigatorPanel.getBean();
        component.invalidate();
        component.validate();
        component.repaint();
        this.CurrentPath = cmTopologyPath;
        this.CurrentPanel = cmNavigatorPanel;
        this.CurrentHierarchy = cmNavigatorHierarchy;
        this.CurrentPanelUrl = string2;
        if (n < 0) {
            this.HistoricalPaths.addElement(cmTopologyPath);
            this.HistoricalPanels.addElement(cmNavigatorPanel);
            this.CurrentPanelIndex = this.HistoricalPanels.size() - 1;
            this.AllPanels.put(string2, cmNavigatorPanel);
            if (this.HistoricalPaths.size() > 5) {
                this.HistoricalPaths.removeElementAt(0);
                this.HistoricalPanels.removeElementAt(0);
                --this.CurrentPanelIndex;
                this.prunePanels(this.CurrentHierarchy, this.CurrentPanel);
            }
        } else {
            this.CurrentPanelIndex = n;
        }
        int n3 = -1;
        if (this.ListPaths != null) {
            int n4 = 0;
            while (n4 < this.ListPaths.size()) {
                if (this.CurrentPath.equals((CmTopologyPath)this.ListPaths.elementAt(n4))) {
                    n3 = n4;
                }
                ++n4;
            }
        }
        if (n3 != -1) {
            this.ListPaths.removeElementAt(n3);
            this.ListPaths.addElement(this.CurrentPath);
        } else {
            this.ListPaths.addElement(this.CurrentPath);
        }
        if (this.ListPaths.size() > 15) {
            this.ListPaths.removeElementAt(0);
        }
        String string4 = this.CurrentDomainUrl;
        this.CurrentDomainUrl = cmNavigatorHierarchy.getRootUrl();
        if (string4 == null || this.CurrentDomainUrl.compareTo(string4) != 0) {
            stringArray = new String[]{this.CurrentDomainUrl};
            this.triggerService("changeDomainUrl", stringArray);
        }
        this.triggerService("domainAvail", new String[]{"true"});
        stringArray = new String[]{this.CurrentPanelUrl};
        this.triggerService("changeObjectUrl", stringArray);
        cmNavigatorHierarchy.setManagedObjectUrl(this.CurrentPanelUrl);
        String string5 = "";
        CmTopologyPath cmTopologyPath2 = this.CurrentPath;
        while (cmTopologyPath2 != null) {
            string5 = String.valueOf(string5) + " " + cmTopologyPath2.getNodeId();
            cmTopologyPath2 = cmTopologyPath2.getNextStep();
        }
        String[] stringArray2 = new String[]{string5};
        if (this.CurrentHierarchy != null) {
            this.CurrentHierarchy.triggerService("markPath", stringArray2);
        }
        if (string != null) {
            stringArray2 = new String[]{string};
            if (this.CurrentPanel != null) {
                this.CurrentPanel.triggerService("selectId", stringArray2);
            }
        }
        this.showMessage("", false);
        String[] stringArray3 = this.CurrentPanelIndex <= 0 ? new String[]{"false"} : new String[]{"true"};
        this.triggerService("allowPrevious", stringArray3);
        stringArray3 = this.CurrentPanelIndex >= this.HistoricalPanels.size() - 1 ? new String[]{"false"} : new String[]{"true"};
        this.triggerService("allowNext", stringArray3);
        stringArray3 = this.CurrentPath.getLength() > 1 ? new String[]{"true"} : new String[]{"false"};
        this.triggerService("allowUp", stringArray3);
        if (this.HistoryMenu == null) {
            try {
                this.HistoryMenu = (JMenu)this.HistoryMenuObj.getBean();
            }
            catch (Exception exception) {}
        }
        if (this.HistoryMenu != null) {
            this.HistoryMenu.removeAll();
            int n5 = this.ListPaths.size() - 1;
            while (n5 >= 0) {
                CmTopologyPath cmTopologyPath3 = (CmTopologyPath)this.ListPaths.elementAt(n5);
                String string6 = cmTopologyPath3.toString();
                JMenuItem jMenuItem = new JMenuItem(string6);
                this.HistoryMenu.add(jMenuItem);
                jMenuItem.addActionListener(new CmConsoleHistListener(this, cmTopologyPath3));
                --n5;
            }
        }
    }

    public void updateLayoutMenu(String string) {
        if (this.LayoutMenuObj == null) {
            return;
        }
        Vector vector = this.LayoutMenuObj.inferiors();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            Object e = vector.elementAt(n);
            if (e instanceof AwxComponent && (object = ((AwxComponent)e).getBean()) instanceof JMenuItem) {
                String string2 = ((XObjectBase)e).lookup("value", "layoutType", "");
                if (string2.equals(string)) {
                    ((JMenuItem)object).setSelected(true);
                } else {
                    ((JMenuItem)object).setSelected(false);
                }
            }
            ++n;
        }
    }

    public void viewDeleted(String string, boolean bl) {
        CmNavigatorPanel cmNavigatorPanel;
        AwxComponent awxComponent;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector<CmNavigatorPanel> vector4 = new Vector<CmNavigatorPanel>();
        int n = this.CurrentPanelIndex;
        boolean bl2 = false;
        Object object3 = this;
        synchronized (object3) {
            if (this.ConsoleChangeInProgress) {
                Thread thread = new Thread((Runnable)new CmViewDeletedRetryer(string, bl, this), "CmViewDeletedRetryer");
                thread.start();
                Object var11_15 = null;
                return;
            }
            this.ConsoleChangeInProgress = true;
        }
        int n2 = 0;
        while (n2 < this.HistoricalPaths.size()) {
            object3 = (CmTopologyPath)this.HistoricalPaths.elementAt(n2);
            object2 = null;
            object2 = bl ? ((CmTopologyPath)object3).getRoot().getNodeUrl() : ((CmTopologyPath)object3).getEnd().getNodeUrl();
            if (UcURL.areURLsEqual((String)object2, (String)string)) {
                if (n2 <= this.CurrentPanelIndex) {
                    --n;
                }
                if (n2 == this.CurrentPanelIndex) {
                    bl2 = true;
                }
            } else {
                vector.addElement(object3);
                vector2.addElement(this.HistoricalPanels.elementAt(n2));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.ListPaths.size()) {
            object2 = (CmTopologyPath)this.ListPaths.elementAt(n3);
            object = null;
            object = bl ? ((CmTopologyPath)object2).getRoot().getNodeUrl() : ((CmTopologyPath)object2).getEnd().getNodeUrl();
            if (UcURL.areURLsEqual((String)object, (String)string)) {
                this.ListPaths.removeElement(object2);
            }
            ++n3;
        }
        object2 = this.AllPanels.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            awxComponent = (CmNavigatorPanel)this.AllPanels.get(object);
            if (vector2.contains(awxComponent)) continue;
            vector4.addElement((CmNavigatorPanel)awxComponent);
            this.AllPanels.remove(object);
        }
        this.HistoricalPanels = vector2;
        this.HistoricalPaths = vector;
        if (this.HistoricalPaths.size() == 0) {
            this.CurrentDomainUrl = null;
            this.CurrentPanelIndex = -1;
            this.CurrentPanelUrl = null;
            this.CurrentPanel = null;
            this.CurrentPath = null;
            this.CurrentHierarchy = null;
            int n4 = ((JSplitPane)this.ViewPane.getBean()).getDividerLocation();
            this.ViewPane.setLeftComponent(this.LeftDummy);
            this.ViewPane.setRightComponent(this.RightDummy);
            ((JSplitPane)this.ViewPane.getBean()).setDividerLocation(n4 - 1);
            this.triggerService("domainAvail", new String[]{"false"});
        } else {
            if (n < 0) {
                n = 0;
            }
            object = (CmTopologyPath)this.HistoricalPaths.elementAt(n);
            awxComponent = (CmNavigatorHierarchy)this.HierarchyPanels.get(((CmTopologyPath)object).getRoot().getNodeUrl());
            cmNavigatorPanel = (CmNavigatorPanel)this.HistoricalPanels.elementAt(n);
            this.switchToPanel((CmTopologyPath)object, (CmNavigatorHierarchy)awxComponent, cmNavigatorPanel, null, n);
        }
        this.ConsoleChangeInProgress = false;
        String string2 = UcURL.standardizeURL((String)string);
        awxComponent = (CmNavigatorHierarchy)this.HierarchyPanels.get(string2);
        this.HierarchyPanels.remove(string2);
        if (awxComponent != null) {
            awxComponent.recursiveDestruct();
        }
        n2 = 0;
        while (n2 < vector4.size()) {
            cmNavigatorPanel = (CmNavigatorPanel)vector4.elementAt(n2);
            cmNavigatorPanel.recursiveDestruct();
            ++n2;
        }
        if (bl2 && !bl) {
            this.showMessage("base.console.ConsoleMessages:view.deleted", true);
        }
    }

    class SwitchToPanelRunnable
    implements Runnable {
        CmTopologyPath path = null;
        CmNavigatorHierarchy tree = null;
        CmNavigatorPanel panel = null;
        String selectId = null;

        SwitchToPanelRunnable(CmTopologyPath cmTopologyPath, CmNavigatorHierarchy cmNavigatorHierarchy, CmNavigatorPanel cmNavigatorPanel, String string) {
            this.path = cmTopologyPath;
            this.tree = cmNavigatorHierarchy;
            this.panel = cmNavigatorPanel;
            this.selectId = string;
        }

        public void run() {
            CmNavigatorConsole.this.switchToPanel(this.path, this.tree, this.panel, this.selectId, -1);
        }
    }
}

