/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.console.views.graph.CvAxisEditor;
import com.sun.symon.base.console.views.graph.CvBordersEditor;
import com.sun.symon.base.console.views.graph.CvGraph;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.console.views.graph.CvGraphOpenManager;
import com.sun.symon.base.console.views.graph.CvGraphSaveManager;
import com.sun.symon.base.console.views.graph.CvLabelEditor;
import com.sun.symon.base.console.views.graph.CvLegendEditor;
import com.sun.symon.base.console.views.graph.CvStyleEditor;
import com.sun.symon.base.console.views.graph.CvTitleEditor;
import com.sun.symon.base.console.views.graph.NewDialog;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCLegend;
import jclass.chart.JCTitle;

public class CvGraphManager
implements AwxServiceManager,
Runnable,
KeyListener,
ActionListener,
DocumentListener {
    private AwxServiceProvider SvcProvider = null;
    private CvGraph graph = null;
    private String editType = "";
    private CvTitleEditor headerEditor;
    private CvTitleEditor footerEditor;
    private CvLabelEditor xLabelEditor;
    private CvLabelEditor yLabelEditor;
    private CvLegendEditor legendEditor;
    private CvBordersEditor borderEditor;
    private CvStyleEditor styleEditor;
    private CvAxisEditor axesEditor;
    private CvGraphSaveManager saveTemManager;
    private CvGraphSaveManager saveGraphManager;
    private CvGraphOpenManager openGraphManager;
    private CvGraphOpenManager deleteGraphManager;
    private CvGraphOpenManager applyTemManager;
    private CvGraphOpenManager deleteTemManager;
    private boolean success = true;
    private JTextField fileName;
    private JList fileList;
    private JCheckBoxMenuItem showHeader;
    private JCheckBoxMenuItem showFooter;
    private JCheckBoxMenuItem showTitle;
    private JCheckBoxMenuItem showAxes;
    private JCheckBoxMenuItem showGrids;
    private JCheckBoxMenuItem showLegend;
    private JCheckBoxMenuItem liveDataItem;
    private boolean closeOnSuccess = true;
    private NewDialog confirmDialog1;
    private NewDialog confirmDialog2;
    private String temName;
    private String graName;
    private JButton yes1 = new JButton(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:overwriteButt"));
    private JButton yes2 = new JButton(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:overwriteButt"));
    private JButton cancel1 = new JButton(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:cancelButt"));
    private JButton cancel2 = new JButton(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:cancelButt"));
    private String warn = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:warn");
    private String overT = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:overwriteT");
    private String overG = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:overwriteG");
    private JButton okButt;

    static /* synthetic */ boolean access$6(CvGraphManager cvGraphManager) {
        return cvGraphManager.success;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.SvcProvider.triggerService("enterKey");
    }

    public void applyPressed() {
        if (this.graph == null) {
            return;
        }
        this.closeOnSuccess = false;
        Thread thread = new Thread((Runnable)this, "apply pressed");
        thread.start();
    }

    private void applyTem() {
        String string = this.graph.getGraphUserId();
        String string2 = this.applyTemManager.getFileName();
        try {
            this.graph.applyTemplate(string, string2);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        this.resetCheckMenuItems();
    }

    public void cancelPressed() {
        this.SvcProvider.triggerService("destroyWindow");
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.clearMessage();
    }

    private void clearMessage() {
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
    }

    private void deleteGraph() {
        String string = this.graph.getGraphUserId();
        String string2 = this.deleteGraphManager.getFileName();
        this.graph.deleteGraph(string, string2);
        this.success = true;
    }

    private void deleteTem() {
        String string = this.graph.getGraphUserId();
        String string2 = this.deleteTemManager.getFileName();
        this.graph.deleteTemplate(string, string2);
        this.success = true;
    }

    private Window getTopWindow(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Window) {
                return (Window)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public void init() {
        if (this.editType.equals("header")) {
            this.initHeader();
        } else if (this.editType.equals("xlabel")) {
            this.initXLabel();
        } else if (this.editType.equals("footer")) {
            this.initFooter();
        } else if (this.editType.equals("ylabel")) {
            this.initYLabel();
        } else if (this.editType.equals("legend")) {
            this.initLegend();
        } else if (this.editType.equals("border")) {
            this.initBorder();
        } else if (this.editType.equals("style")) {
            this.initStyle();
        } else if (this.editType.equals("savetem")) {
            this.initSaveTem();
        } else if (this.editType.equals("savegraph")) {
            this.initSaveGraph();
        } else if (this.editType.equals("opengraph")) {
            this.initOpenGraph();
        } else if (this.editType.equals("deletegraph")) {
            this.initDeleteGraph();
        } else if (this.editType.equals("deletetem")) {
            this.initDeleteTem();
        } else if (this.editType.equals("applytem")) {
            this.initApplyTem();
        } else if (this.editType.equals("axes")) {
            this.initAxes();
        } else {
            this.resetCheckMenuItems();
            if (this.graph.hasHistoryData()) {
                String[] stringArray = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:hasHistoricalData")};
                this.SvcProvider.triggerService("messageBell", stringArray);
            }
        }
    }

    private void initApplyTem() {
        String[] stringArray = this.graph.getAllTemplates();
        this.applyTemManager.setDescription(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:availabletemplates"));
        if (stringArray == null || stringArray.length == 0) {
            this.okButt.setEnabled(false);
            String[] stringArray2 = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:noTemplates")};
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        this.applyTemManager.setFileNames(stringArray);
        this.fileList = this.applyTemManager.getFileList();
        this.fileList.addKeyListener(this);
    }

    private void initAxes() {
        String string = this.graph.getGraphFormat().getXAxisFormat().getConfiguration();
        String string2 = this.graph.getCurrentYAxisConfiguration();
        try {
            this.axesEditor.setXConfiguration(string);
            this.axesEditor.setYConfiguration(string2);
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            UcDDL.logDebugMessage((String)("CvGraphManager::initAxes  " + cvGraphInvalidInputException.getMessage()));
        }
        this.axesEditor.getXGridField().getDocument().addDocumentListener(this);
        this.axesEditor.getMinutesField().getDocument().addDocumentListener(this);
        this.axesEditor.getXTickField().getDocument().addDocumentListener(this);
        this.axesEditor.getYGridField().getDocument().addDocumentListener(this);
        this.axesEditor.getMinField().getDocument().addDocumentListener(this);
        this.axesEditor.getMaxField().getDocument().addDocumentListener(this);
        this.axesEditor.getYLabelField().getDocument().addDocumentListener(this);
        this.axesEditor.getYTickField().getDocument().addDocumentListener(this);
        this.axesEditor.getXAutoScale().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CvGraphManager.this.axesEditor.getXAutoScale().isSelected()) {
                    JCAxis jCAxis = CvGraphManager.this.graph.getChartArea().getXAxis(0);
                    Double d = new Double(jCAxis.getMax() - jCAxis.getMin());
                    CvGraphManager.this.axesEditor.updateXFields(d.intValue() / 60, jCAxis.getTickSpacing() / 60.0, jCAxis.getGridSpacing() / 60.0);
                } else {
                    CvGraphManager.this.axesEditor.disableXFields();
                }
            }
        });
        this.axesEditor.getAutoScale().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CvGraphManager.this.axesEditor.getAutoScale().isSelected()) {
                    JCAxis jCAxis = CvGraphManager.this.graph.getChartArea().getYAxis(0);
                    CvGraphManager.this.axesEditor.updateYFields(jCAxis.getMin(), jCAxis.getMax(), jCAxis.getNumSpacing(), jCAxis.getTickSpacing(), jCAxis.getGridSpacing());
                } else {
                    CvGraphManager.this.axesEditor.disableYFields();
                }
            }
        });
    }

    private void initBorder() {
        this.borderEditor.setBorderType(this.graph.getBorderType(), this.graph.getChartArea().getBorderType());
        this.borderEditor.setBorderWidth(this.graph.getBorderWidth(), this.graph.getChartArea().getBorderWidth());
        this.borderEditor.getInsideWidthField().getDocument().addDocumentListener(this);
        this.borderEditor.getOutsideWidthField().getDocument().addDocumentListener(this);
    }

    private void initDeleteGraph() {
        String[] stringArray = this.graph.getAllGraphs();
        this.deleteGraphManager.setDescription(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:savedgraphs"));
        if (stringArray == null || stringArray.length == 0) {
            String[] stringArray2 = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:noGraphs")};
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        if (stringArray.length != 0) {
            this.deleteGraphManager.setFileNames(stringArray);
        }
        this.fileList = this.deleteGraphManager.getFileList();
        this.fileList.addKeyListener(this);
    }

    private void initDeleteTem() {
        String[] stringArray = this.graph.getAllTemplates();
        this.deleteTemManager.setDescription(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:savedtemplates"));
        if (stringArray == null || stringArray.length == 0) {
            String[] stringArray2 = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:noTemplates")};
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        if (stringArray.length != 0) {
            this.deleteTemManager.setFileNames(stringArray);
        }
        this.fileList = this.deleteTemManager.getFileList();
        this.fileList.addKeyListener(this);
    }

    private void initFooter() {
        JCTitle jCTitle = this.graph.getFooter();
        this.footerEditor.setTitleFont(jCTitle.getFont());
        this.footerEditor.setTitleText(jCTitle.getText());
        this.footerEditor.setBorderType(jCTitle.getBorderType());
        this.footerEditor.setBorderWidth(jCTitle.getBorderWidth());
        this.footerEditor.setTitleOrientation(jCTitle.getRotation());
        this.footerEditor.setShowTitle(jCTitle.getIsShowing());
        this.footerEditor.getBorderWidthField().getDocument().addDocumentListener(this);
        this.footerEditor.getBorderWidthField().getDocument().addDocumentListener(this);
    }

    private void initHeader() {
        JCTitle jCTitle = this.graph.getHeader();
        this.headerEditor.setTitleFont(jCTitle.getFont());
        this.headerEditor.setTitleText(jCTitle.getText());
        this.headerEditor.setBorderType(jCTitle.getBorderType());
        this.headerEditor.setBorderWidth(jCTitle.getBorderWidth());
        this.headerEditor.setTitleOrientation(jCTitle.getRotation());
        this.headerEditor.setShowTitle(jCTitle.getIsShowing());
        this.headerEditor.getBorderWidthField().getDocument().addDocumentListener(this);
    }

    private void initLegend() {
        JCLegend jCLegend = this.graph.getLegend();
        String[] stringArray = this.graph.getLegendTexts();
        this.legendEditor.setLegendFont(jCLegend.getFont());
        this.legendEditor.setLegendTexts(stringArray);
        this.legendEditor.setBorderType(jCLegend.getBorderType());
        this.legendEditor.setBorderWidth(jCLegend.getBorderWidth());
        this.legendEditor.setLegendSite(jCLegend.getAnchor());
        this.legendEditor.setShowLegend(jCLegend.getIsShowing());
    }

    private void initOpenGraph() {
        String[] stringArray = this.graph.getAllGraphs();
        this.openGraphManager.setDescription(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:availablegraphs"));
        if (stringArray == null || stringArray.length == 0) {
            this.okButt.setEnabled(false);
            String[] stringArray2 = new String[]{UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:noGraphs")};
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        this.openGraphManager.setFileNames(stringArray);
        this.fileList = this.openGraphManager.getFileList();
        this.fileList.addKeyListener(this);
    }

    private void initSaveGraph() {
        String[] stringArray = this.graph.getAllGraphs();
        this.saveGraphManager.setDescription(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:graphname"));
        this.saveGraphManager.setListDescription(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:existgraphs"));
        String[] stringArray2 = this.graph.getLegendTexts();
        int n = 0;
        while (n < stringArray2.length) {
            if (n == 0) {
                this.saveGraphManager.addTwo(0, new JLabel(this.saveGraphManager.getDescLabel()), new JLabel(stringArray2[n]));
            } else {
                this.saveGraphManager.addTwo(2 * n, new JLabel(""), new JLabel(stringArray2[n]));
            }
            ++n;
        }
        this.saveGraphManager.addOne(2 * stringArray2.length, new JSeparator());
        if (stringArray != null && stringArray.length != 0) {
            this.saveGraphManager.setFileNames(stringArray);
        }
        this.fileName = this.saveGraphManager.getFileNameField();
        this.fileName.addActionListener(this);
        this.fileName.addKeyListener(this);
    }

    private void initSaveTem() {
        String[] stringArray = this.graph.getAllTemplates();
        if (stringArray.length != 0) {
            this.saveTemManager.setFileNames(stringArray);
        }
        this.fileName = this.saveTemManager.getFileNameField();
        this.fileName.addActionListener(this);
        this.fileName.addKeyListener(this);
    }

    private void initStyle() {
        int n = this.graph.getDataView(0).getChartType();
        this.styleEditor.setStyle(n);
    }

    private void initXLabel() {
        JCAxisTitle jCAxisTitle = this.graph.getDataView(0).getXAxis().getTitle();
        this.xLabelEditor.setLabelFont(jCAxisTitle.getFont());
        this.xLabelEditor.setLabelText(jCAxisTitle.getText());
        this.xLabelEditor.setBorderType(jCAxisTitle.getBorderType());
        this.xLabelEditor.setBorderWidth(jCAxisTitle.getBorderWidth());
        this.xLabelEditor.setLabelOrientation(jCAxisTitle.getRotation());
        this.xLabelEditor.setLabelSite(jCAxisTitle.getPlacement());
        this.xLabelEditor.setShowLabel(jCAxisTitle.getIsShowing());
        this.xLabelEditor.getBorderWidthField().getDocument().addDocumentListener(this);
        this.xLabelEditor.getBorderWidthField().getDocument().addDocumentListener(this);
    }

    private void initYLabel() {
        JCAxisTitle jCAxisTitle = this.graph.getDataView(0).getYAxis().getTitle();
        this.yLabelEditor.setLabelFont(jCAxisTitle.getFont());
        this.yLabelEditor.setLabelText(jCAxisTitle.getText());
        this.yLabelEditor.setBorderType(jCAxisTitle.getBorderType());
        this.yLabelEditor.setBorderWidth(jCAxisTitle.getBorderWidth());
        this.yLabelEditor.setLabelOrientation(jCAxisTitle.getRotation());
        this.yLabelEditor.setLabelSite(jCAxisTitle.getPlacement());
        this.yLabelEditor.setShowLabel(jCAxisTitle.getIsShowing());
        this.yLabelEditor.getBorderWidthField().getDocument().addDocumentListener(this);
        this.yLabelEditor.getBorderWidthField().getDocument().addDocumentListener(this);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.clearMessage();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.SvcProvider.triggerService("enterKey");
            return;
        }
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
    }

    public void okPressed() {
        if (this.graph == null) {
            return;
        }
        this.closeOnSuccess = true;
        Thread thread = new Thread((Runnable)this, "ok pressed");
        thread.start();
    }

    private void openGraph() {
        String string = this.graph.getGraphUserId();
        String string2 = this.openGraphManager.getFileName();
        try {
            this.graph.openGraph(string, string2);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        this.resetCheckMenuItems();
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.clearMessage();
    }

    private void resetAxes() {
        String string = this.axesEditor.getXConfiguration();
        String string2 = this.axesEditor.getYConfiguration();
        try {
            this.graph.setAxisConfiguration(String.valueOf(string) + "|" + string2);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting axes failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetBorder() {
        String string = this.borderEditor.getConfiguration();
        try {
            this.graph.setBorderConfiguration(string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetCheckMenuItems() {
        this.showHeader.setState(this.graph.getHeaderShown());
        this.showFooter.setState(this.graph.getFooterShown());
        this.showTitle.setState(this.graph.getTitleShown());
        this.showAxes.setState(this.graph.getAxesShown());
        this.showLegend.setState(this.graph.getLegendShown());
        this.showGrids.setState(this.graph.getGridShown());
        this.liveDataItem.setState(this.graph.getDataState());
    }

    private void resetFooter() {
        String string = this.footerEditor.getFooterConfiguration();
        String string2 = this.footerEditor.getTitleText();
        try {
            this.graph.setFooterConfiguration(string2, string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting type failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetHeader() {
        String string = this.headerEditor.getHeaderConfiguration();
        String string2 = this.headerEditor.getTitleText();
        try {
            this.graph.setHeaderConfiguration(string2, string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting header failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetLegend() {
        JCLegend jCLegend = this.graph.getLegend();
        String string = this.legendEditor.getConfiguration();
        int n = this.legendEditor.getSelectedIndex();
        String string2 = this.legendEditor.getText();
        try {
            this.graph.setLegendConfiguration(n, string2, string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting x label failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetStyle() {
        String string = this.styleEditor.getConfiguration();
        try {
            this.graph.setStyleConfiguration(string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting type failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetXLabel() {
        String string = this.xLabelEditor.getXConfiguration();
        String string2 = this.xLabelEditor.getLabelText();
        try {
            this.graph.setXLabelConfiguration(string2, string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting x label failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void resetYLabel() {
        String string = this.yLabelEditor.getYConfiguration();
        String string2 = this.yLabelEditor.getLabelText();
        try {
            this.graph.setYLabelConfiguration(string2, string);
            this.success = true;
        }
        catch (CvGraphInvalidInputException cvGraphInvalidInputException) {
            this.success = false;
            String[] stringArray = new String[]{cvGraphInvalidInputException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
        catch (Exception exception) {
            this.success = false;
            String[] stringArray = new String[]{" resetting y label failed"};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    public void run() {
        if (this.editType.equals("header")) {
            this.resetHeader();
        } else if (this.editType.equals("footer")) {
            this.resetFooter();
        } else if (this.editType.equals("xlabel")) {
            this.resetXLabel();
        } else if (this.editType.equals("ylabel")) {
            this.resetYLabel();
        } else if (this.editType.equals("legend")) {
            this.resetLegend();
        } else if (this.editType.equals("border")) {
            this.resetBorder();
        } else if (this.editType.equals("style")) {
            this.resetStyle();
        } else if (this.editType.equals("savetem")) {
            this.saveTemplate();
        } else if (this.editType.equals("savegraph")) {
            this.saveGraph();
        } else if (this.editType.equals("opengraph")) {
            this.openGraph();
        } else if (this.editType.equals("deletegraph")) {
            this.deleteGraph();
        } else if (this.editType.equals("deletetem")) {
            this.deleteTem();
        } else if (this.editType.equals("applytem")) {
            this.applyTem();
        } else if (this.editType.equals("axes")) {
            this.resetAxes();
        }
        if (this.closeOnSuccess && this.success) {
            this.SvcProvider.triggerService("destroyWindow");
        }
    }

    private void saveGraph() {
        this.graName = this.saveGraphManager.getFileName();
        if (!UcListUtil.isAsciiString((String)this.graName)) {
            this.success = false;
            String string = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:graAscii");
            String[] stringArray = new String[]{string};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        if (!this.validFileName(this.graName)) {
            this.success = false;
            String string = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidGraph");
            String[] stringArray = new String[]{string};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        try {
            boolean bl = this.graph.saveGraph(this.graName);
            if (!bl) {
                this.success = false;
                this.confirmDialog1 = new NewDialog(this.getTopWindow(this.saveGraphManager), this.warn, false);
                JLabel jLabel = new JLabel(this.overG);
                this.cancel1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        CvGraphManager.this.confirmDialog1.dispose();
                        CvGraphManager.this.success = false;
                    }
                });
                CtMarginPanel ctMarginPanel = new CtMarginPanel(new Insets(5, 0, 5, 0));
                ctMarginPanel.add(this.yes1);
                ctMarginPanel.add(new JLabel("      "));
                ctMarginPanel.add(this.cancel1);
                CtMarginPanel ctMarginPanel2 = new CtMarginPanel(new Insets(5, 0, 5, 0));
                ctMarginPanel2.setLayout(new BorderLayout());
                ctMarginPanel2.add("North", new JSeparator());
                ctMarginPanel2.add("Center", ctMarginPanel);
                CtMarginPanel ctMarginPanel3 = new CtMarginPanel(new Insets(10, 0, 0, 0));
                ctMarginPanel3.add(jLabel);
                this.confirmDialog1.getContentPane().add("Center", ctMarginPanel3);
                this.confirmDialog1.getContentPane().add("South", ctMarginPanel2);
                this.confirmDialog1.pack();
                this.confirmDialog1.show();
                this.yes1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            CvGraphManager.this.graph.overwriteGraph(CvGraphManager.this.graName);
                        }
                        catch (SMAPIException sMAPIException) {
                            UcDDL.logErrorMessage((String)("CvGraphManager::saveGraph -- " + sMAPIException.toString()));
                        }
                        CvGraphManager.this.confirmDialog1.dispose();
                        CvGraphManager.this.SvcProvider.triggerService("destroyWindow");
                    }
                });
            } else {
                this.success = true;
            }
        }
        catch (SMAPIException sMAPIException) {
            this.success = false;
            String[] stringArray = new String[]{sMAPIException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    private void saveTemplate() {
        this.temName = this.saveTemManager.getFileName();
        if (!UcListUtil.isAsciiString((String)this.temName)) {
            this.success = false;
            String string = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:temAscii");
            String[] stringArray = new String[]{string};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        if (!this.validFileName(this.temName)) {
            this.success = false;
            String string = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidTemp");
            String[] stringArray = new String[]{string};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        try {
            boolean bl = this.graph.saveTemplate(this.temName);
            if (!bl) {
                this.success = false;
                this.confirmDialog2 = new NewDialog(this.getTopWindow(this.saveTemManager), this.warn, false);
                JLabel jLabel = new JLabel(this.overT);
                this.cancel2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        CvGraphManager.this.confirmDialog2.dispose();
                    }
                });
                CtMarginPanel ctMarginPanel = new CtMarginPanel(new Insets(5, 0, 5, 0));
                ctMarginPanel.add(this.yes2);
                ctMarginPanel.add(new JLabel("      "));
                ctMarginPanel.add(this.cancel2);
                CtMarginPanel ctMarginPanel2 = new CtMarginPanel(new Insets(5, 0, 5, 0));
                ctMarginPanel2.setLayout(new BorderLayout());
                ctMarginPanel2.add("North", new JSeparator());
                ctMarginPanel2.add("Center", ctMarginPanel);
                CtMarginPanel ctMarginPanel3 = new CtMarginPanel(new Insets(10, 0, 0, 0));
                ctMarginPanel3.add(jLabel);
                this.confirmDialog2.getContentPane().add("Center", ctMarginPanel3);
                this.confirmDialog2.getContentPane().add("South", ctMarginPanel2);
                this.confirmDialog2.pack();
                this.confirmDialog2.show();
                this.yes2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            CvGraphManager.this.graph.overwriteTemplate(CvGraphManager.this.temName);
                        }
                        catch (SMAPIException sMAPIException) {
                            UcDDL.logDebugMessage((String)"CvGraphManager -- failed to overwrite temp");
                        }
                        CvGraphManager.this.confirmDialog2.dispose();
                        CvGraphManager.this.SvcProvider.triggerService("destroyWindow");
                    }
                });
            } else {
                this.success = true;
            }
        }
        catch (SMAPIException sMAPIException) {
            this.success = false;
            String[] stringArray = new String[]{sMAPIException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
        }
    }

    public void setApplyTemManager(Object object) {
        try {
            this.applyTemManager = (CvGraphOpenManager)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"applyTemManager : invalid graph instance");
            this.applyTemManager = null;
        }
    }

    public void setAxesCheckMenuItem(Object object) {
        try {
            this.showAxes = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.showAxes = null;
        }
    }

    public void setAxesEditor(Object object) {
        try {
            this.axesEditor = (CvAxisEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"axisEditor : invalid axis editor instance");
            this.axesEditor = null;
        }
    }

    public void setBorderEditor(Object object) {
        try {
            this.borderEditor = (CvBordersEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"borderEditor : invalid graph instance");
            this.borderEditor = null;
        }
    }

    public void setDataStateCheckMenuItem(Object object) {
        try {
            this.liveDataItem = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.liveDataItem = null;
        }
    }

    public void setDeleteGraphManager(Object object) {
        try {
            this.deleteGraphManager = (CvGraphOpenManager)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"deleteGraphManager : invalid graph instance");
            this.deleteGraphManager = null;
        }
    }

    public void setDeleteTemManager(Object object) {
        try {
            this.deleteTemManager = (CvGraphOpenManager)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"deleteTemManager : invalid graph instance");
            this.deleteTemManager = null;
        }
    }

    public void setEditType(String string) {
        this.editType = string;
    }

    public void setFooterCheckMenuItem(Object object) {
        try {
            this.showFooter = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.showFooter = null;
        }
    }

    public void setFooterEditor(Object object) {
        try {
            this.footerEditor = (CvTitleEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"footerEditor : invalid graph instance");
            this.footerEditor = null;
        }
    }

    public void setGraphBean(Object object) {
        try {
            this.graph = (CvGraph)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid graph instance");
            this.graph = null;
        }
    }

    public void setGridsCheckMenuItem(Object object) {
        try {
            this.showGrids = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.showGrids = null;
        }
    }

    public void setHeaderCheckMenuItem(Object object) {
        try {
            this.showHeader = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.showHeader = null;
        }
    }

    public void setHeaderEditor(Object object) {
        try {
            this.headerEditor = (CvTitleEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"headerEditor : invalid graph instance");
            this.headerEditor = null;
        }
    }

    public void setLegendCheckMenuItem(Object object) {
        try {
            this.showLegend = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.showLegend = null;
        }
    }

    public void setLegendEditor(Object object) {
        try {
            this.legendEditor = (CvLegendEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"legendEditor : invalid graph instance");
            this.legendEditor = null;
        }
    }

    public void setOkButton(Object object) {
        try {
            this.okButt = (JButton)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid button instance");
            this.okButt = null;
        }
    }

    public void setOpenGraphManager(Object object) {
        try {
            this.openGraphManager = (CvGraphOpenManager)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"openGraphManager : invalid graph instance");
            this.openGraphManager = null;
        }
    }

    public void setSaveGraphManager(Object object) {
        try {
            this.saveGraphManager = (CvGraphSaveManager)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraph: invalid graph instance");
            this.saveGraphManager = null;
        }
    }

    public void setSaveTemManager(Object object) {
        try {
            this.saveTemManager = (CvGraphSaveManager)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraph: invalid graph instance");
            this.saveTemManager = null;
        }
    }

    public void setStyleEditor(Object object) {
        try {
            this.styleEditor = (CvStyleEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"styleEditor : invalid graph instance");
            this.styleEditor = null;
        }
    }

    public void setTitleCheckMenuItem(Object object) {
        try {
            this.showTitle = (JCheckBoxMenuItem)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CvGraphManager -- invalid JCheckBoxMenuItem");
            this.showTitle = null;
        }
    }

    public void setXLabelEditor(Object object) {
        try {
            this.xLabelEditor = (CvLabelEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"xLabelEditor : invalid graph instance");
            this.xLabelEditor = null;
        }
    }

    public void setYLabelEditor(Object object) {
        try {
            this.yLabelEditor = (CvLabelEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"yLabelEditor : invalid graph instance");
            this.yLabelEditor = null;
        }
    }

    private boolean validFileName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.indexOf("\"") == -1 && string.indexOf("\\") == -1 && string.indexOf("<") == -1 && string.indexOf(">") == -1 && string.indexOf("#") == -1 && string.indexOf("%") == -1 && string.indexOf("{") == -1 && string.indexOf("}") == -1 && string.indexOf("|") == -1 && string.indexOf("^") == -1 && string.indexOf("~") == -1 && string.indexOf("`") == -1 && string.indexOf("[") == -1 && string.indexOf("]") == -1 && string.indexOf(" ") == -1;
    }
}

