/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.table.SMTablePageRequest;
import com.sun.symon.base.client.table.SMTablePageResponse;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import com.sun.symon.base.console.views.table.TablePageResponse;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CvTblSlider
extends JSlider
implements ChangeListener,
MouseListener,
Runnable {
    JSlider slider;
    JLabel rowLabel;
    JLabel pageLabel;
    int value;
    private int currentPage = 0;
    private int currentRow = 0;
    private int ctableDepth = 0;
    boolean MReleased = false;
    private CvTblTable table = null;
    private CvTblTableModel model = null;
    private CvTable ownTable;
    private SMTableRequest tabObj = null;
    private SMTablePageRequest tabreq = null;
    private SMRawDataRequest origDataSource = null;
    private TablePageResponse responser = null;
    private static final int PAGESIZE = 50;
    private static final int PAGE = 50;
    private Object[] pageRequests = null;
    private Object[] pageStatusRequests = null;
    String[] dataUrls = null;
    String[] statusUrls = null;
    Thread thread;
    private int initMax = 0;

    public CvTblSlider(int n, JLabel jLabel, JLabel jLabel2) {
        super(1, n, 1);
        this.addChangeListener(this);
        this.addMouseListener(this);
        this.setEnabled(false);
        this.rowLabel = jLabel;
        this.pageLabel = jLabel2;
        this.initMax = n;
        this.slider = this;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = 350 * this.getMaximum() / this.initMax + 5;
        return dimension;
    }

    public void getPageData(int n) {
        this.currentRow = n;
        if (this.thread != null) {
            try {
                this.thread.stop();
            }
            catch (Exception exception) {}
        }
        this.shutdownRequests();
        this.thread = new Thread((Runnable)this, "thread1");
        this.thread.start();
    }

    public void initTablePageRequest() {
        this.pageRequests = new Object[2];
        this.pageStatusRequests = new Object[2];
        if (this.tabObj == null) {
            UcDDL.logErrorMessage((String)" data source is null");
            return;
        }
        try {
            this.tabreq = this.tabObj.getTablePageRequest(this.dataUrls, this.statusUrls, 50);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)"CvTblSlider:getTableRequest  received exception", (Throwable)sMAPIException);
        }
        this.responser = new TablePageResponse(this.model);
        this.getPageData(0);
        this.slider.setEnabled(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.MReleased = true;
        this.fireStateChanged();
    }

    private String[] removeBlankURLs(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2] != null && stringArray[n2].length() > 0 ? 1 : 0;
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null && stringArray[n3].length() > 0) {
                stringArray2[n++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }

    public void run() {
        int n;
        int n2 = 50;
        int n3 = 0;
        this.ownTable.displayFootMessage();
        this.rowLabel.setForeground(Color.red);
        String[] stringArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.row"), UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.loadInfo")};
        this.rowLabel.setText(String.valueOf(stringArray[0]) + ": " + stringArray[1]);
        int n4 = this.tabObj.getTableDepth(this.dataUrls[0]);
        n3 = n4 % 50 > 0 ? n4 / 50 + 1 : n4 / 50;
        if (n4 == 0 || this.currentRow > n4) {
            this.rowLabel.setForeground(Color.red);
            this.rowLabel.setText(String.valueOf(stringArray[0]) + ": ");
            UcDDL.logWarningMessage((String)"CvTblSlider: current table Depth is 0 ");
            return;
        }
        if (n4 - this.currentRow < 50) {
            n2 = n4 - this.currentRow;
            this.model.shrinkSize(n2);
        }
        int n5 = this.currentRow + n2;
        String string = String.valueOf(stringArray[0]) + ": " + this.currentRow + " - " + n5 + " of " + n4;
        if (n4 < 50) {
            this.slider.setEnabled(false);
        } else if (!this.slider.isEnabled()) {
            this.slider.setEnabled(true);
        }
        if (n3 != this.slider.getMaximum()) {
            n = n3;
            String string2 = String.valueOf(n);
            this.slider.getLabelTable().remove(new Integer(this.slider.getMaximum()));
            this.slider.getLabelTable().put(new Integer(n), new JLabel(string2, 0));
            this.slider.setLabelTable(this.slider.getLabelTable());
            this.slider.setMaximum(n);
            this.slider.setMinorTickSpacing(n - 1);
            this.slider.setMajorTickSpacing(n - 1);
        }
        n = 0;
        int n6 = this.currentRow;
        String string3 = this.model.getRefInterval();
        int n7 = 0;
        n7 = n2 % 50 > 0 ? n2 / 50 + 1 : n2 / 50;
        int n8 = 0;
        while (n8 < n7) {
            int n9 = n2 > 50 ? 50 : n2;
            Vector<Integer> vector = new Vector<Integer>(n);
            vector.add(0, new Integer(n));
            vector.add(1, new Integer(this.currentPage));
            String[] stringArray2 = this;
            synchronized (stringArray2) {
                try {
                    this.pageRequests[n8] = this.tabreq.getTablePageFieldRequest(n6, n9, string3, (SMTablePageResponse)this.responser, vector);
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logWarningMessage((String)"CvTblSlider:getPageData - received exception getting table data", (Throwable)sMAPIException);
                }
            }
            try {
                this.responser.waitRowIndex();
            }
            catch (Exception exception) {}
            stringArray2 = this.responser.getRowIndex();
            String[] stringArray3 = this;
            synchronized (stringArray3) {
                try {
                    this.pageStatusRequests[n8] = this.tabreq.getTablePageAlarmStatusRequest(stringArray2, string3, (SMTablePageResponse)this.responser, vector);
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logWarningMessage((String)"CvTblSlider:getPageData - received exception getting table data", (Throwable)sMAPIException);
                }
            }
            n += 50;
            n6 += 50;
            n2 -= 50;
            ++n8;
        }
        this.rowLabel.setForeground(Color.black);
        this.rowLabel.setText(string);
        this.ownTable.cleanFootMessage();
    }

    public void setTable(CvTblTable cvTblTable) {
        this.table = cvTblTable;
        this.model = (CvTblTableModel)this.table.getModel();
        this.dataUrls = this.removeBlankURLs(this.model.getDataURLs());
        this.statusUrls = this.removeBlankURLs(this.model.getStatusURLs());
    }

    public void setTableRequest(CvTable cvTable, SMRawDataRequest sMRawDataRequest, SMTableRequest sMTableRequest) {
        this.ownTable = cvTable;
        this.tabObj = sMTableRequest;
        this.origDataSource = sMRawDataRequest;
    }

    public void shutdownRequests() {
        CvTblSlider cvTblSlider = this;
        synchronized (cvTblSlider) {
            try {
                int n = 0;
                while (n < this.pageRequests.length) {
                    if (this.pageRequests[n] != null) {
                        this.origDataSource.removeURLRequest(this.pageRequests[n]);
                        this.pageRequests[n] = null;
                    }
                    if (this.pageStatusRequests[n] != null) {
                        this.origDataSource.removeURLRequest(this.pageStatusRequests[n]);
                        this.pageStatusRequests[n] = null;
                    }
                    ++n;
                }
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logWarningMessage((String)("CvTblSlider: error to remove old request" + (Object)((Object)sMAPIException)));
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl = false;
        if (this.MReleased) {
            bl = true;
            this.MReleased = false;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        this.value = jSlider.getValue();
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.page");
        if (this.value < 10) {
            this.pageLabel.setText(String.valueOf(string) + ": " + this.value + "   ");
        } else if (this.value >= 10 && this.value < 100) {
            this.pageLabel.setText(String.valueOf(string) + ": " + this.value + "  ");
        } else if (this.value >= 100) {
            this.pageLabel.setText(String.valueOf(string) + ": " + this.value + " ");
        }
        if (!bl) {
            return;
        }
        if (this.value != this.currentPage) {
            this.currentPage = this.value;
            this.responser.setCurPage(this.currentPage);
            this.getPageData((this.currentPage - 1) * 50);
        }
    }
}

