/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.console.views.CvContextPopupEvent;
import com.sun.symon.base.console.views.CvSelectionInfo;
import com.sun.symon.base.console.views.CvToolTip;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTblSlider;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import com.sun.symon.base.console.views.table.CvTblTableUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

public class CvTblTable
extends JTable
implements MouseListener,
MouseMotionListener,
ListSelectionListener {
    private int visibleLines = -1;
    private Vector tableEventListeners = new Vector();
    private CvTblSlider slider = null;
    private int oldRow = -1;
    private int oldColumn = -1;
    private int oldSelectRow = -1;
    private int oldSelectColumn = -1;
    private boolean headerSelected = false;
    private boolean headerSelectAllowed = false;
    private Color alternateBackground = Color.white;
    private Icon acknowledgedIcon = null;

    public CvTblTable() {
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setAutoCreateColumnsFromModel(false);
        this.setGridColor(Color.black);
        this.setShowGrid(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBorder(new LineBorder(Color.black, 1));
        this.setRowSelectionAllowed(false);
        this.setUI(new CvTblTableUI());
    }

    public void addTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.addElement(cvTblTableEventListener);
    }

    public void clearSelection() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel2.clearSelection();
    }

    public JToolTip createToolTip() {
        return new CvToolTip();
    }

    public Icon getAcknowledgedIcon() {
        return this.acknowledgedIcon;
    }

    public Color getAlternateBackground() {
        return this.alternateBackground;
    }

    public boolean getHeaderSelected() {
        return this.headerSelected;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.height = (this.getRowHeight() + 1) * this.getRowCount();
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.height = (this.getRowHeight() + 1) * this.getRowCount();
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = (this.getRowHeight() + 1) * this.getRowCount();
        return dimension;
    }

    public int getRowHeight() {
        return super.getRowHeight() + 4;
    }

    public CvSelectionInfo getSelectionInfo(CvTable cvTable, SMTableFormat sMTableFormat) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        if (listSelectionModel.isSelectionEmpty() || listSelectionModel2.isSelectionEmpty()) {
            if (this.headerSelected) {
                SMFamilyCommands sMFamilyCommands = null;
                if (sMTableFormat != null) {
                    sMFamilyCommands = sMTableFormat.getTableHdrCommands();
                }
                String string = cvTable.getManagedObjectUrl();
                CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this, null, null, "header", sMFamilyCommands, 0, 0, string, string, string, null, null);
                return new CvSelectionInfo("", new String[]{""}, cvContextPopupEvent);
            }
            return null;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel2.getMinSelectionIndex();
        int n3 = this.convertColumnIndexToModel(n2);
        CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
        String string = cvTblTableModel.getFullURL(n, n3);
        String string2 = cvTblTableModel.getFullName(n, n3);
        String string3 = cvTblTableModel.getExclusionInfo(n, n3);
        SMFamilyCommands sMFamilyCommands = null;
        if (sMTableFormat != null) {
            sMFamilyCommands = sMTableFormat.getTableRowCommands();
        }
        CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this, null, null, string2, sMFamilyCommands, 0, 0, string, string, string, string3, null);
        return new CvSelectionInfo("", new String[]{""}, cvContextPopupEvent);
    }

    public int getVisibleLines() {
        return this.visibleLines;
    }

    public void initLargeTable() {
        if (this.slider == null) {
            return;
        }
        int n = 50;
        CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
        cvTblTableModel.initLargeTable(n);
        this.slider.initTablePageRequest();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (mouseEvent.getSource() == this.getTableHeader()) {
                Point point = this.getTableHeader().getLocation();
                CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 3, null, null, mouseEvent.getPoint().x + point.x, mouseEvent.getPoint().y + point.y);
                int n = 0;
                while (n < this.tableEventListeners.size()) {
                    Object e = this.tableEventListeners.elementAt(n);
                    ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                    ++n;
                }
                return;
            }
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            int n3 = this.convertColumnIndexToModel(n2);
            if (n == -1 || n2 == -1 || n3 == -1) {
                return;
            }
            CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
            if (cvTblTableModel.getVertical() && n3 == 0) {
                return;
            }
            Point point = this.getLocation();
            CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 2, cvTblTableModel.getFullURL(n, n3), cvTblTableModel.getFullName(n, n3), mouseEvent.getPoint().x + point.x, mouseEvent.getPoint().y + point.y);
            cvTblTableEvent.setExclusionInfo(cvTblTableModel.getExclusionInfo(n, n3));
            int n4 = 0;
            while (n4 < this.tableEventListeners.size()) {
                Object e = this.tableEventListeners.elementAt(n4);
                ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                ++n4;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        boolean bl = false;
        if (n != this.oldRow || n2 != this.oldColumn) {
            bl = true;
        }
        this.oldRow = n;
        this.oldColumn = n2;
        if (this.oldRow == -1 || this.oldColumn == -1) {
            return;
        }
        Object object = this.getValueAt(this.oldRow, this.oldColumn);
        if (object == null || !(object instanceof JComponent)) {
            this.setToolTipText(null);
            return;
        }
        String string = ((JComponent)object).getToolTipText();
        String string2 = this.getToolTipText();
        if (bl) {
            this.setToolTipText(string);
        } else if (string != null && string2 == null || string == null && string2 != null) {
            this.setToolTipText(string);
        } else if (string != null && string2 != null && !string.equals(string2)) {
            this.setToolTipText(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void reallyDraw() {
        int n;
        Dimension dimension = this.getSize();
        dimension.width = n = this.columnModel.getTotalColumnWidth();
        dimension.height = (this.getRowHeight() + 1) * this.getRowCount();
        this.setPreferredSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void removeTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.removeElement(cvTblTableEventListener);
    }

    public void setAcknowledgedIcon(Icon icon) {
        this.acknowledgedIcon = icon;
    }

    public void setAllowCellSelect(boolean bl) {
        if (bl) {
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            this.setRowSelectionAllowed(true);
            ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
            listSelectionModel2.setSelectionMode(0);
            this.setColumnSelectionAllowed(true);
            this.setCellSelectionEnabled(true);
            listSelectionModel.addListSelectionListener(this);
            listSelectionModel2.addListSelectionListener(this);
            this.headerSelectAllowed = true;
        } else {
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setCellSelectionEnabled(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            ListSelectionModel listSelectionModel3 = this.getColumnModel().getSelectionModel();
            listSelectionModel.removeListSelectionListener(this);
            listSelectionModel3.removeListSelectionListener(this);
            this.setHeaderSelected(false);
            this.headerSelectAllowed = false;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.alternateBackground = color.darker();
        this.repaint();
    }

    public void setBackground(Color color, Color color2) {
        super.setBackground(color);
        this.alternateBackground = color2;
        this.repaint();
    }

    public void setHeaderSelected(boolean bl) {
        if (this.headerSelectAllowed) {
            this.headerSelected = bl;
            if (bl) {
                this.clearSelection();
                CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 7, "", "", 0, 0);
                int n = 0;
                while (n < this.tableEventListeners.size()) {
                    Object e = this.tableEventListeners.elementAt(n);
                    ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                    ++n;
                }
            }
        }
        this.getTableHeader().resizeAndRepaint();
    }

    public void setSlider(CvTblSlider cvTblSlider) {
        this.slider = cvTblSlider;
    }

    public void setVisibleLines(int n) {
        this.visibleLines = n >= -1 ? n : -1;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.resizeAndRepaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty() && !listSelectionModel2.isSelectionEmpty()) {
            bl = true;
            n = listSelectionModel.getMinSelectionIndex();
            n2 = listSelectionModel2.getMinSelectionIndex();
            int n3 = this.convertColumnIndexToModel(n2);
            CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
            if (cvTblTableModel.getVertical() && n3 == 0) {
                this.clearSelection();
                return;
            }
        }
        if (n == this.oldSelectRow && n2 == this.oldSelectColumn) {
            return;
        }
        this.oldSelectRow = n;
        this.oldSelectColumn = n2;
        CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, !bl ? 6 : 5, "", "", 0, 0);
        if (bl) {
            this.setHeaderSelected(false);
        }
        int n4 = 0;
        while (n4 < this.tableEventListeners.size()) {
            Object e = this.tableEventListeners.elementAt(n4);
            ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
            ++n4;
        }
    }
}

