/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client;

import com.sun.symon.base.bootstrap.BsRMIClassLoader;
import com.sun.symon.base.client.GetBulkResponser;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMConnectionLostEvent;
import com.sun.symon.base.client.SMConnectionLostListener;
import com.sun.symon.base.client.SMLicenseStatus;
import com.sun.symon.base.client.SMPeriodicRequestHandler;
import com.sun.symon.base.client.SMRawDataBulkResponse;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMRawDataResponseAdapter;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1BulkResponse;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Response;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import com.sun.symon.base.utility.UcURL;
import com.sun.symon.base.xobject.XObjectBase;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SMRawDataRequest {
    private RMIClientLevel1 handle;
    private Hashtable clientDataCache;
    private ResourceBundle resBundle;
    String eventurl;
    String configurl;
    String topourl;
    String serverESDIR;
    String imageSubpath;
    private XObjectBase serverVersionXObject;
    private Method exitMethod = null;
    private Object exitObject = null;
    private Object[] exitArgs = null;
    public boolean timeoutDialogShowing = false;
    private Vector smConnectionLostListeners_ = null;

    public SMRawDataRequest(RMIClientLevel1 rMIClientLevel1) {
        this.handle = rMIClientLevel1;
        this.clientDataCache = new Hashtable();
        this.topourl = null;
        this.configurl = null;
        this.eventurl = null;
        UcInternationalizer.setLoader((ClassLoader)new BsRMIClassLoader(this.handle));
        this.resBundle = ResourceBundle.getBundle("com.sun.symon.base.client.ClientApiMessages", Locale.getDefault());
        if (this.handle != null) {
            this.checkServerAlive();
        }
    }

    public synchronized void addSMConnectionLostListener(SMConnectionLostListener sMConnectionLostListener) {
        if (this.smConnectionLostListeners_ == null) {
            this.smConnectionLostListeners_ = new Vector();
            this.smConnectionLostListeners_.addElement(sMConnectionLostListener);
        } else if (!this.smConnectionLostListeners_.contains(sMConnectionLostListener)) {
            this.smConnectionLostListeners_.addElement(sMConnectionLostListener);
        }
    }

    public static String buildShadowURL(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        String string4 = null;
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            string4 = string.substring(n);
            string = string.substring(0, n);
        }
        String string5 = null;
        n = string.lastIndexOf(63);
        if (n >= 0) {
            string5 = string.substring(n);
            string = string.substring(0, n);
        }
        if (string2 != null) {
            string5 = "?" + string2;
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string3 != null) {
            string4 = "#" + string3;
        }
        if (string4 == null) {
            string4 = "";
        }
        return String.valueOf(string) + string5 + string4;
    }

    public void cacheClientData(String string, String string2, Object object) {
        this.clientDataCache.put(String.valueOf(string) + string2, object);
    }

    private void checkServerAlive() {
        int n = this.handle.getServerPingInterval();
        UcTickerTimer ucTickerTimer = null;
        try {
            ucTickerTimer = new UcTickerTimer((long)n, new UcTickerTimerResponse(){

                public void processTick() {
                    if (!SMRawDataRequest.this.handle.isServerAlive()) {
                        SMRawDataRequest.this.serverDied();
                    }
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {}
        ucTickerTimer.start();
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.symon.base.client.ClientApiMessages", Locale.getDefault());
        if (n == 0) {
            n = 17010;
        }
        stringBuffer.append("probe://" + string + ":" + n + "/mod/");
        if (string2 == null || string2.length() == 0) {
            throw new SMAPIException(2, resourceBundle.getString("RawDataRequest.ModuleNameParameterIsInvalid"));
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(String.valueOf(string2) + "+" + string3 + "/");
        } else {
            stringBuffer.append(String.valueOf(string2) + "/");
        }
        if (string4 == null || string4.length() == 0) {
            throw new SMAPIException(2, resourceBundle.getString("RawDataRequest.KeyParameterIsInvalid"));
        }
        stringBuffer.append(string4);
        if (string5 == null || string5.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(";args=" + string5);
        return stringBuffer.toString();
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.symon.base.client.ClientApiMessages", Locale.getDefault());
        if (n == 0) {
            n = 161;
        }
        stringBuffer.append("snmp://" + string + ":" + n + "/mod/");
        if (string2 == null || string2.length() == 0) {
            throw new SMAPIException(2, resourceBundle.getString("RawDataRequest.ModuleNameParameterIsInvalid"));
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(String.valueOf(string2) + "+" + string3);
        } else {
            stringBuffer.append(string2);
        }
        if (string4 == null || string4.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("/" + string4 + "/");
        if (string5 == null || string5.length() == 0) {
            throw new SMAPIException(2, resourceBundle.getString("RawDataRequest.PropertyNameParameterIsInvalid"));
        }
        stringBuffer.append(string5);
        if (string6 != null && string6.length() > 0) {
            stringBuffer.append("?" + string6);
        }
        if (string7 != null && string7.length() > 0) {
            stringBuffer.append("#" + string7);
        }
        return stringBuffer.toString();
    }

    public static String createURL(String string, int n, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7) throws SMAPIException {
        if (bl) {
            return SMRawDataRequest.createURL(string, n, string2, string3, string4, string5, string6, string7);
        }
        if (string5 == null || string5.equals("")) {
            return SMRawDataRequest.createURL(string, n, string2, string3, string4, string5, string6, string7);
        }
        return SMRawDataRequest.createURL(string, n, string2, string3, string4, String.valueOf(string5) + "#", string6, string7);
    }

    public static String createURL(String string, String string2, String string3, String string4, String string5) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.symon.base.client.ClientApiMessages", Locale.getDefault());
        stringBuffer.append(string);
        if (!string.endsWith("/")) {
            stringBuffer.append("/");
        }
        if (string2 == null || string2.length() == 0) {
            throw new SMAPIException(2, resourceBundle.getString("RawDataRequest.ManagedObjectNameParameterIsInvalid"));
        }
        stringBuffer.append(String.valueOf(string2) + "/");
        if (string3 == null || string3.length() == 0) {
            throw new SMAPIException(2, resourceBundle.getString("RawDataRequest.PropertyNameParameterIsInvalid"));
        }
        stringBuffer.append(string3);
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append("?" + string4);
        }
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append("#" + string5);
        }
        return stringBuffer.toString();
    }

    public static String createURL(String string, String string2, String string3, boolean bl, String string4, String string5) throws SMAPIException {
        if (bl) {
            return SMRawDataRequest.createURL(string, string2, string3, string4, string5);
        }
        if (string3 == null || string3.equals("")) {
            return SMRawDataRequest.createURL(string, string2, string3, string4, string5);
        }
        return SMRawDataRequest.createURL(string, string2, string3, string4, string5);
    }

    public void disconnect() {
        String[] stringArray = new String[]{"exit://clientIsExiting/"};
        StObject[][] stObjectArray = new StString[1][1];
        stObjectArray[0][0] = new StString("goodbye");
        SMRawDataResponseAdapter sMRawDataResponseAdapter = new SMRawDataResponseAdapter();
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, sMRawDataResponseAdapter, new Object(), true);
        try {
            this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        }
        catch (SMAPIException sMAPIException) {}
    }

    private final void dispatchRequest(int n, String[] stringArray, int n2, int n3, String string, RMIClientLevel1BulkResponse rMIClientLevel1BulkResponse) throws SMAPIException {
        try {
            this.handle.newBulkRequest(n2, n3, stringArray, string, rMIClientLevel1BulkResponse);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    private final void dispatchRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, RMIClientLevel1Response rMIClientLevel1Response) throws SMAPIException {
        try {
            switch (n) {
                case 0: {
                    this.handle.newRequest(1, stringArray, null, string, rMIClientLevel1Response);
                    break;
                }
                case 1: {
                    this.handle.newRequest(0, stringArray, stObjectArray, null, rMIClientLevel1Response);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (RMISecurityException rMISecurityException) {
            String string2;
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = this.resBundle.getString("RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost");
                    break;
                }
                case 2: {
                    string2 = this.resBundle.getString("RawDataRequest.DataRequestHasBeenDenied");
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = this.resBundle.getString("RawDataRequest.UnknownException");
                }
            }
            throw new SMAPIException(1, string2);
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
    }

    protected void fireSMConnectionLost() {
        Vector vector = null;
        if (this.smConnectionLostListeners_ == null) {
            return;
        }
        Object object = this.smConnectionLostListeners_;
        synchronized (object) {
            vector = (Vector)this.smConnectionLostListeners_.clone();
        }
        object = new SMConnectionLostEvent(this);
        int n = 0;
        while (n < vector.size()) {
            SMConnectionLostListener sMConnectionLostListener = (SMConnectionLostListener)vector.elementAt(n);
            sMConnectionLostListener.connectionLost((SMConnectionLostEvent)object);
            ++n;
        }
    }

    public String getAgentVersion(String string, int n, String string2) throws SMAPIException {
        String[] stringArray = new String[]{"snmp://" + string + ":" + Integer.toString(n) + "/sym/base/info/agent/general/oaversion#0"};
        StObject[][] stObjectArray = this.getURLValue(stringArray);
        if (stObjectArray.length == 1 && stObjectArray[0].length == 1 && stObjectArray[0][0] != null) {
            Vector vector = new Vector();
            String string3 = ((StString)stObjectArray[0][0]).toString();
            UcListUtil.decomposeList((String)string3, vector);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (string3.equals("PrimeAlert v4.1")) {
                string4 = "2.0";
                string8 = "2_0_00_00";
            } else if (vector.size() == 6) {
                string4 = (String)vector.elementAt(1);
                string5 = (String)vector.elementAt(2);
                string6 = (String)vector.elementAt(3);
                string7 = (String)vector.elementAt(4);
                string8 = (String)vector.elementAt(5);
            } else {
                throw new SMAPIException("Invald return value when requesting version of agent at " + string + ":" + n);
            }
            if (string2.equals("overall")) {
                return string4;
            }
            if (string2.equals("date")) {
                return string5;
            }
            if (string2.equals("buildnumber")) {
                return string6;
            }
            if (string2.equals("desc")) {
                return string7;
            }
            if (string2.equals("revision")) {
                return string8;
            }
            return null;
        }
        throw new SMAPIException("Invald return value when requesting version of agent at " + string + ":" + n);
    }

    public String getAgentVersion(String string, String string2) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string3 = ucURL.getHost();
        String string4 = ucURL.getPort();
        if (string3 == null || string4 == null) {
            throw new SMAPIException("Could not extract host and port from url: " + string + " while requesting agent version");
        }
        int n = Integer.parseInt(ucURL.getPort());
        return this.getAgentVersion(string3, n, string2);
    }

    public Object getCachedClientData(String string, String string2) {
        return this.clientDataCache.get(String.valueOf(string) + string2);
    }

    public String getConfigurationBaseURL() {
        if (this.configurl != null) {
            return this.configurl;
        }
        try {
            this.configurl = this.handle.getConfigurationBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain cfgserver location. Using localhost:165 instead", (Throwable)exception);
            return "snmp://localhost:165/";
        }
        return this.configurl;
    }

    public String getEventBaseURL() {
        if (this.eventurl != null) {
            return this.eventurl;
        }
        try {
            this.eventurl = this.handle.getEventBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain event server location. Using localhost:163 instead", (Throwable)exception);
            return "snmp://localhost:163/";
        }
        return this.eventurl;
    }

    public Method getExitMethod() {
        return this.exitMethod;
    }

    public Object[] getExitMethodArgs() {
        return this.exitArgs;
    }

    public Object getExitTarget() {
        return this.exitObject;
    }

    public RMIClientLevel1 getHandle() {
        return this.handle;
    }

    public String getImageSubpath() {
        if (this.imageSubpath != null) {
            return this.imageSubpath;
        }
        try {
            this.imageSubpath = this.handle.getImageSubpath();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain the image subpath");
        }
        return this.imageSubpath;
    }

    public SMLicenseStatus getLicenseStatus() throws SMAPIException {
        UcURL ucURL = null;
        try {
            ucURL = new UcURL(this.getTopologyBaseURL());
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        String string = ucURL.getHost();
        String string2 = ucURL.getPort();
        String string3 = "snmp://" + string + ":" + string2 + "/mod/topology-license/topoObjectStats/";
        Vector vector = new Vector();
        String[] stringArray = new String[]{new String(String.valueOf(string3) + "topoLicenseStatus#0"), new String(String.valueOf(string3) + "topoAvailAgents#0"), new String(String.valueOf(string3) + "topoTotalAgents#0"), new String(String.valueOf(string3) + "topoMaxAgents#0"), new String(String.valueOf(string3) + "topoValidUntil#0")};
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        StObject[][] stObjectArray = null;
        SMLicenseStatus sMLicenseStatus = null;
        try {
            stObjectArray = this.getURLValue(stringArray);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        string4 = stObjectArray[0][0].toString();
        string6 = stObjectArray[1][0].toString();
        string7 = stObjectArray[2][0].toString();
        string5 = stObjectArray[3][0].toString();
        string8 = stObjectArray[4][0].toString();
        sMLicenseStatus = new SMLicenseStatus(string4, string5, string7, string6, string8);
        return sMLicenseStatus;
    }

    public ResourceBundle getResourceBundle() {
        return this.resBundle;
    }

    public String getServerESDIR() {
        if (this.serverESDIR != null) {
            return this.serverESDIR;
        }
        try {
            this.serverESDIR = this.handle.getESDIR();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain server's ESDIR property");
        }
        return this.serverESDIR;
    }

    public String getServerVersion(String string) {
        Object object;
        if (this.serverVersionXObject == null) {
            try {
                object = this.getURLValue(new String[]{"xfile:/version-j.x"});
                String string2 = object[0][0].toString();
                this.serverVersionXObject = XObjectBase.createRoot();
                boolean bl = UcDDL.channelIsActive((int)UcDDL.channelLookup((String)"info"));
                UcDDL.channelActivate((String)"info", (boolean)false);
                this.serverVersionXObject.importData(true, "version", string2);
                if (bl) {
                    UcDDL.channelActivate((String)"info", (boolean)true);
                }
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("Unable to request server version: " + exception));
                return null;
            }
        }
        if (string.equals("overall") || string.equals("date") || string.equals("buildnumber") || string.equals("desc") || string.equals("revision")) {
            object = this.serverVersionXObject.ilookup("version", string, null);
            if (object == null && string.equals("revision")) {
                object = "2_0_00_00";
            }
            return object;
        }
        return null;
    }

    public String getTopologyBaseURL() {
        if (this.topourl != null) {
            return this.topourl;
        }
        try {
            this.topourl = this.handle.getTopologyBaseURL();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Unable to obtain topology server location. Using localhost:164 instead", (Throwable)exception);
            return "snmp://localhost:164/";
        }
        return this.topourl;
    }

    public Vector getURLValue(Vector vector) throws SMAPIException {
        Vector[] vectorArray = new Vector[1];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        Object object = new Object();
        vectorArray[0] = null;
        sMRequestStatusArray[0] = null;
        class InnerMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ Vector[] val$data;

            InnerMOResponseImpl(Vector[] vectorArray, SMRequestStatus[] sMRequestStatusArray) {
                this.val$data = vectorArray;
                this.val$stat = sMRequestStatusArray;
            }

            public void getURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        Vector<Vector<E>> vector = new Vector<Vector<E>>();
                        if (stObjectArray != null) {
                            int n = 0;
                            while (n < stObjectArray.length) {
                                Vector<StObject> vector2 = new Vector<StObject>();
                                int n2 = 0;
                                while (stObjectArray[n].length == 0 || n2 < stObjectArray[n].length) {
                                    vector2.addElement(stObjectArray[n][n2]);
                                    if (stObjectArray[n].length == 0) break;
                                    ++n2;
                                }
                                vector.addElement(vector2);
                                ++n;
                            }
                        }
                        this.val$data[0] = vector;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    try {
                        if (this.val$data[0] == null && this.val$stat[0] == null) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        InnerMOResponseImpl innerMOResponseImpl2 = new InnerMOResponseImpl(vectorArray, sMRequestStatusArray);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, null, innerMOResponseImpl2, object, true);
        this.dispatchRequest(0, stringArray, null, null, sMPeriodicRequestHandler);
        innerMOResponseImpl2.waitForMessage();
        if (vectorArray[0] == null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        return vectorArray[0];
    }

    public Object getURLValue(Vector vector, int n, String string, SMRawDataBulkResponse sMRawDataBulkResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = vector.elementAt(n2).toString();
            ++n2;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(2, stringArray, string, sMRawDataBulkResponse, object, false);
        this.dispatchRequest(2, stringArray, 0, n, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public Object getURLValue(Vector vector, String string, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, string, sMRawDataResponse, object, false);
        this.dispatchRequest(0, stringArray, null, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public StObject[][] getURLValue(String[] stringArray) throws SMAPIException {
        StObject[][][] stObjectArray = new StObject[1][][];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        Object object = new Object();
        stObjectArray[0] = null;
        sMRequestStatusArray[0] = null;
        class InnerMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ StObject[][][] val$data;

            InnerMOResponseImpl(StObject[][][] stObjectArray, SMRequestStatus[] sMRequestStatusArray) {
                this.val$data = stObjectArray;
                this.val$stat = sMRequestStatusArray;
            }

            public void getURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        this.val$data[0] = stObjectArray;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnerMOResponseImpl innerMOResponseImpl2 = this;
                synchronized (innerMOResponseImpl2) {
                    try {
                        if (this.val$data[0] == null && this.val$stat[0] == null) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        InnerMOResponseImpl innerMOResponseImpl2 = new InnerMOResponseImpl(stObjectArray, sMRequestStatusArray);
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, null, innerMOResponseImpl2, object, true);
        this.dispatchRequest(0, stringArray, null, null, sMPeriodicRequestHandler);
        innerMOResponseImpl2.waitForMessage();
        if (stObjectArray[0] == null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        return stObjectArray[0];
    }

    public Object getURLValue(String[] stringArray, int n, String string, SMRawDataBulkResponse sMRawDataBulkResponse, Object object) throws SMAPIException {
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(2, stringArray, string, sMRawDataBulkResponse, object, true);
        this.dispatchRequest(2, stringArray, 0, n, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public StObject[][] getURLValue(String[] stringArray, int n, String[][][] stringArray2, SMRequestStatus[] sMRequestStatusArray) throws SMAPIException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.symon.base.client.ClientApiMessages", Locale.getDefault());
        String string = resourceBundle.getString("RawDataRequest.UnknownException");
        Object object = new Object();
        GetBulkResponser getBulkResponser = new GetBulkResponser();
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(2, stringArray, null, getBulkResponser, object, false);
        this.dispatchRequest(2, stringArray, 0, n, null, sMPeriodicRequestHandler);
        getBulkResponser.waitForMessage();
        StObject[][] stObjectArray = getBulkResponser.getData();
        sMRequestStatusArray[0] = getBulkResponser.getStat();
        StObject[][] stObjectArray2 = getBulkResponser.getOids();
        if (stObjectArray == null || stObjectArray.length == 0 || stObjectArray2 == null || stObjectArray2.length == 0) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        String[][] stringArray3 = null;
        if (sMRequestStatusArray[0].getReturnCode() == 0) {
            int n2 = stObjectArray2.length;
            int n3 = stObjectArray2[0].length;
            stringArray3 = new String[n2][n3];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n3) {
                    stringArray3[n4][n5] = stObjectArray2[n4][n5].toString();
                    ++n5;
                }
                ++n4;
            }
        }
        stringArray2[0] = stringArray3;
        return stObjectArray;
    }

    public Object getURLValue(String[] stringArray, String string, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(0, stringArray, string, sMRawDataResponse, object, true);
        this.dispatchRequest(0, stringArray, null, string, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public String getUserId() {
        return this.handle.getUserId();
    }

    public boolean isClientDataCached(String string, String string2) {
        return this.clientDataCache.containsKey(String.valueOf(string) + string2);
    }

    public void launchTimeoutNotification(String string) {
        if (this.timeoutDialogShowing) {
            return;
        }
        class SMTimeoutNotify
        implements Runnable {
            private SMRawDataRequest Parent;
            private String Component;

            public SMTimeoutNotify(SMRawDataRequest sMRawDataRequest, String string) {
                this.Parent = sMRawDataRequest;
                this.Component = string;
            }

            public void run() {
                this.Parent.timeoutDialogShowing = true;
                UcURL ucURL = null;
                String string = null;
                if (this.Component.equals("topology")) {
                    ucURL = new UcURL(this.Parent.getTopologyBaseURL());
                    string = String.valueOf(ucURL.getHost()) + ":" + ucURL.getPort();
                } else if (this.Component.equals("cfgserver")) {
                    ucURL = new UcURL(this.Parent.getConfigurationBaseURL());
                    string = String.valueOf(ucURL.getHost()) + ":" + ucURL.getPort();
                } else if (this.Component.equals("both")) {
                    ucURL = new UcURL(this.Parent.getTopologyBaseURL());
                    string = String.valueOf(ucURL.getHost()) + ":" + ucURL.getPort();
                    ucURL = new UcURL(this.Parent.getConfigurationBaseURL());
                    string = String.valueOf(string) + "\n" + "                    " + ucURL.getHost() + ":" + ucURL.getPort();
                } else {
                    return;
                }
                String string2 = "base.console.ConsoleMessages:timeout." + this.Component + "1";
                String string3 = "base.console.ConsoleMessages:timeout." + this.Component + "2";
                String string4 = String.valueOf(UcInternationalizer.translateKey((String)string2)) + "\n" + "                    " + string + "\n" + UcInternationalizer.translateKey((String)string3);
                String string5 = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:timeout.title");
                Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.ok")};
                JOptionPane.showOptionDialog(null, string4, string5, -1, 2, null, objectArray, objectArray[0]);
                this.Parent.timeoutDialogShowing = false;
            }
        }
        Thread thread = new Thread((Runnable)new SMTimeoutNotify(this, string), "TimeoutNotify");
        thread.start();
    }

    public Socket probeConnect(String string, String[] stringArray) throws SMAPIException {
        Socket socket;
        try {
            socket = this.handle.probeConnect(string, stringArray);
        }
        catch (RMISecurityException rMISecurityException) {
            String string2;
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = this.resBundle.getString("RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost");
                    break;
                }
                case 2: {
                    string2 = this.resBundle.getString("RawDataRequest.DataRequestHasBeenDenied");
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = this.resBundle.getString("RawDataRequest.UnknownException");
                }
            }
            throw new SMAPIException(1, string2);
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
        catch (IOException iOException) {
            UcDDL.logWarningMessage((String)"Probe socket connection failed. Retrying...");
            String string3 = iOException.getMessage();
            try {
                Thread.sleep(1000L);
                socket = this.handle.probeConnect(string, stringArray);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)"Probe socket connection failed on second attempt.");
                throw new SMAPIException(string3);
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        return socket;
    }

    public Socket[] probeConnectWithStderr(String string, String[] stringArray) throws SMAPIException {
        Socket[] socketArray = null;
        try {
            socketArray = this.handle.probeConnectWithStderr(string, stringArray);
        }
        catch (RMISecurityException rMISecurityException) {
            String string2;
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string2 = this.resBundle.getString("RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost");
                    break;
                }
                case 2: {
                    string2 = this.resBundle.getString("RawDataRequest.DataRequestHasBeenDenied");
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string2 = this.resBundle.getString("RawDataRequest.UnknownException");
                }
            }
            throw new SMAPIException(1, string2);
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
        catch (IOException iOException) {
            UcDDL.logWarningMessage((String)"Probe socket connection failed. Retrying...");
            String string3 = iOException.getMessage();
            try {
                Thread.sleep(1000L);
                socketArray = this.handle.probeConnectWithStderr(string, stringArray);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)"Probe socket connection failed on second attempt.");
                throw new SMAPIException(string3);
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        return socketArray;
    }

    public void removeCachedClientData(String string, String string2) {
        this.clientDataCache.remove(String.valueOf(string) + string2);
    }

    public synchronized void removeSMConnectionLostListener(SMConnectionLostListener sMConnectionLostListener) {
        if (this.smConnectionLostListeners_ == null) {
            return;
        }
        this.smConnectionLostListeners_.removeElement(sMConnectionLostListener);
    }

    public void removeURLRequest(Object object) throws SMAPIException {
        try {
            Object object2 = object;
            synchronized (object2) {
                if (object instanceof RMIClientLevel1Response) {
                    this.handle.deleteRequest((RMIClientLevel1Response)object);
                }
                ((SMPeriodicRequestHandler)object).detachOriginator();
            }
        }
        catch (RMISecurityException rMISecurityException) {
            String string;
            switch (rMISecurityException.getReason()) {
                case 1: {
                    string = this.resBundle.getString("RawDataRequest.AuthenticationHasNotBeenPerformedOrTicketIsLost");
                    break;
                }
                case 2: {
                    string = this.resBundle.getString("RawDataRequest.DataRequestHasBeenDenied");
                    this.fireSMConnectionLost();
                    break;
                }
                default: {
                    string = this.resBundle.getString("RawDataRequest.UnknownException");
                }
            }
            throw new SMAPIException(1, string);
        }
        catch (ConnectException connectException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(connectException.getMessage());
        }
        catch (UnmarshalException unmarshalException) {
            this.fireSMConnectionLost();
            throw new SMAPIException(unmarshalException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    private void serverDied() {
        this.fireSMConnectionLost();
    }

    public void setExitAction(Object object, String string, Object[] objectArray) throws SMAPIException {
        Class[] classArray;
        if (objectArray != null) {
            classArray = new Class[objectArray.length - 1];
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null) {
                    throw new SMAPIException(new IllegalArgumentException().getMessage());
                }
                classArray[n] = objectArray[n].getClass();
                ++n;
            }
            this.exitArgs = objectArray;
        } else {
            classArray = null;
            this.exitArgs = null;
        }
        if (object == null) {
            throw new SMAPIException(new IllegalArgumentException().getMessage());
        }
        try {
            this.exitMethod = object.getClass().getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        this.exitObject = object;
    }

    public boolean setURLValue(Vector vector, Vector vector2) throws SMAPIException {
        Object object;
        boolean[] blArray = new boolean[1];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        Object object2 = new Object();
        blArray[0] = false;
        sMRequestStatusArray[0] = null;
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        StObject[][] stObjectArray = new StObject[vector2.size()][];
        int n2 = 0;
        while (n2 < vector2.size()) {
            object = (Vector)vector2.elementAt(n2);
            stObjectArray[n2] = new StObject[((Vector)object).size()];
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                stObjectArray[n2][n3] = (StObject)((Vector)object).elementAt(n3);
                ++n3;
            }
            ++n2;
        }
        class InnersetMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ boolean[] val$result;

            InnersetMOResponseImpl(boolean[] blArray, SMRequestStatus[] sMRequestStatusArray) {
                this.val$result = blArray;
                this.val$stat = sMRequestStatusArray;
            }

            public void setURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        this.val$result[0] = true;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    try {
                        if (this.val$stat[0] == null && !this.val$result[0]) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        object = new InnersetMOResponseImpl(blArray, sMRequestStatusArray);
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, object, object2, true);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        ((InnersetMOResponseImpl)object).waitForMessage();
        if (sMRequestStatusArray[0] != null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        return blArray[0];
    }

    public Object setURLValue(Vector vector, Vector vector2, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        StObject[][] stObjectArray = new StObject[vector2.size()][];
        int n2 = 0;
        while (n2 < vector2.size()) {
            Vector vector3 = (Vector)vector2.elementAt(n2);
            stObjectArray[n2] = new StObject[vector3.size()];
            int n3 = 0;
            while (n3 < vector3.size()) {
                stObjectArray[n2][n3] = (StObject)vector3.elementAt(n3);
                ++n3;
            }
            ++n2;
        }
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, sMRawDataResponse, object, false);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public StObject[][] setURLValue(String[] stringArray, StObject[][] stObjectArray) throws SMAPIException {
        StObject[][][] stObjectArray2 = new StObject[1][][];
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        boolean[] blArray = new boolean[1];
        Object object = new Object();
        blArray[0] = true;
        stObjectArray2[0] = null;
        sMRequestStatusArray[0] = null;
        class InnersetMOResponseImpl
        extends SMRawDataResponseAdapter {
            private final /* synthetic */ boolean[] val$timeoutflag;
            private final /* synthetic */ SMRequestStatus[] val$stat;
            private final /* synthetic */ StObject[][][] val$result;

            InnersetMOResponseImpl(StObject[][][] stObjectArray, SMRequestStatus[] sMRequestStatusArray, boolean[] blArray) {
                this.val$result = stObjectArray;
                this.val$stat = sMRequestStatusArray;
                this.val$timeoutflag = blArray;
            }

            public void setURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    if (sMRequestStatus.getReturnCode() == 0) {
                        this.val$result[0] = stObjectArray;
                    } else {
                        this.val$stat[0] = sMRequestStatus;
                    }
                    this.val$timeoutflag[0] = false;
                    this.notify();
                }
            }

            public final void waitForMessage() throws SMAPIException {
                InnersetMOResponseImpl innersetMOResponseImpl2 = this;
                synchronized (innersetMOResponseImpl2) {
                    try {
                        if (this.val$stat[0] == null && this.val$result[0] == null) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        throw new SMAPIException(exception.getMessage());
                    }
                }
            }
        }
        InnersetMOResponseImpl innersetMOResponseImpl2 = new InnersetMOResponseImpl(stObjectArray2, sMRequestStatusArray, blArray);
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, innersetMOResponseImpl2, object, true);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        innersetMOResponseImpl2.waitForMessage();
        if (sMRequestStatusArray[0] != null) {
            throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
        }
        if (blArray[0]) {
            throw new SMAPIException(3, this.resBundle.getString("RawDataRequest.TimeoutHasOccurred"));
        }
        return stObjectArray2[0];
    }

    public Object setURLValue(String[] stringArray, StObject[][] stObjectArray, SMRawDataResponse sMRawDataResponse, Object object) throws SMAPIException {
        SMPeriodicRequestHandler sMPeriodicRequestHandler = new SMPeriodicRequestHandler(1, stringArray, null, sMRawDataResponse, object, true);
        this.dispatchRequest(1, stringArray, stObjectArray, null, sMPeriodicRequestHandler);
        return sMPeriodicRequestHandler;
    }

    public void versionCheck(String string) {
        String string2 = this.getServerVersion("overall");
        if (string2 == null) {
            return;
        }
        if (string2.trim().equals(string.trim())) {
            return;
        }
        String string3 = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:version.notify.message", (boolean)true);
        string3 = MessageFormat.format(string3, string2, string);
        String string4 = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:version.notify.title", (boolean)true);
        Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:okbutt", (boolean)true)};
        JOptionPane.showOptionDialog(null, string3, string4, -1, 2, null, objectArray, objectArray[0]);
    }
}

