# Copyright 01 June 1998 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident   "@(#)kernel-reader-models-d.x 1.17     98/10/22 SMI"

#
#	Kernel Reader Models File
#

type = reference

_rules = { [ use PROC ]
	[ source kernel-reader-d.rul ] 
}

#
# User Information
#
user = { [ use MANAGED-OBJECT ]

        mediumDesc              = User Statistics
    	consoleHint:mediumDesc = base.modules.kernel-reader:user


        consoleUser = { [ use STRING MANAGED-PROPERTY ]
            shortDesc   = User
            mediumDesc  = Console User
            fullDesc    = User currently logged in on the console
	    consoleHint:mediumDesc = base.modules.kernel-reader:user.consoleUser


        }

        numUsers = { [ use INTHI MANAGED-PROPERTY ]
            shortDesc   = "#Users"
            mediumDesc  = Number Of Users
            fullDesc    = Number of unique users currently logged in
	    consoleHint:mediumDesc = base.modules.kernel-reader:user.numUsers
        }

        numSessions = { [ use INTHI MANAGED-PROPERTY ]
            shortDesc   = Sessions
            mediumDesc  = Number Of User Sessions
            fullDesc    = Number of currently active user sessions
	    consoleHint:mediumDesc = base.modules.kernel-reader:user.numSessions
        }

        primaryUser = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = User
            mediumDesc          = Primary User
            fullDesc            = The login name of the primary user
	    consoleHint:mediumDesc = base.modules.kernel-reader:user.primaryUser

        }
}

#
# Interprocess Communication Information
#
ipc = { [ use MANAGED-OBJECT ]

        mediumDesc      = IPC Facilities
	consoleHint:mediumDesc = base.modules.kernel-reader:ipc

        msg = { [ use MANAGED-PROPERTY-CLASS ]

            mediumDesc          = IPC Message Queues
            mibTextPrefix       = msg
            consoleHint:mediumDesc = base.modules.kernel-reader:ipc.msg


            total = { [ use INT MANAGED-PROPERTY ]
                shortDesc       = Ttl MsgQs
                mediumDesc      = Total Msg Queues
                fullDesc        = Total number of messages queues initially available for use
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.msg.total

            }

            avail = { [ use INTLO MANAGED-PROPERTY ]
                shortDesc       = MsgQ Avail
                mediumDesc      = Avail Msg Queues
                fullDesc        = Number of currently available messages queues
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.msg.avail

            }

            pctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
                shortDesc       = %MsgQs Use
                mediumDesc      = Msg Queues Used
                fullDesc        = Messages queues used as a percentage of the to tal message queues
                units           = %
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.msg.pctUsed
                consoleHint:i18nunits = base.modules.kernel-reader:units.%

            }
        }

        shm = { [ use MANAGED-PROPERTY-CLASS ]

            mediumDesc  = IPC Shared Mem
            mibTextPrefix = shm
            consoleHint:mediumDesc = base.modules.kernel-reader:ipc.shm

            total = { [ use INT MANAGED-PROPERTY ]
                shortDesc       = Ttl ShMemS
                mediumDesc      = Total Shared Mem Segs
                fullDesc        = Total number of shared memory segments initial ly available for use
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.shm.total

            }

            avail = { [ use INTLO MANAGED-PROPERTY ]
                shortDesc       = ShMem Avl
                mediumDesc      = Avail Shared Mem Segs
                fullDesc        = Number of currently available shared memory se gments
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.shm.avail

            }

            pctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
                shortDesc       = %ShMem Use
                mediumDesc      = Shared Mem Segs Used
                fullDesc        = Shared memory segments used as a percentage of the total
                units           = %
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.shm.pctUsed
                consoleHint:i18nunits = base.modules.kernel-reader:units.%

            }
        }

        sem = { [ use MANAGED-PROPERTY-CLASS ]

            mediumDesc  = IPC Semaphores
            mibTextPrefix = sem
            consoleHint:mediumDesc = base.modules.kernel-reader:ipc.sem

            total = { [ use INT MANAGED-PROPERTY ]
                shortDesc       = Ttl Sems
                mediumDesc      = Total Semaphores
                fullDesc        = Total number of semaphores
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.sem.total

            }

            avail = { [ use INTLO MANAGED-PROPERTY ]
                shortDesc       = Sems Avail
                mediumDesc      = Avail Semaphores
                fullDesc        = Number of currently available semaphores
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.sem.avail

            }

            pctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
                shortDesc       = %Sems Use
                mediumDesc      = Semaphores Used
                fullDesc        = Semaphores used as a percentage of the total semaphores
                units           = %
                consoleHint:mediumDesc = base.modules.kernel-reader:ipc.sem.pctUsed
                consoleHint:i18nunits = base.modules.kernel-reader:units.%

            }
        }
}

#
# Disk Information
#

disk = { [ use MANAGED-OBJECT ]

    mediumDesc	= Disk Statistics 
    consoleHint:mediumDesc = base.modules.kernel-reader:disk

    disk-detail = { [ use MANAGED-OBJECT ]

        mediumDesc  = Disk Details 
        consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail

    	diskDetailTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= Disk Detail Table
            consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable

	    diskDetailEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        mediumDesc	= Disk Detail Entry
            consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry
	        nameColumn = diskname
	        childDimension = vector

#	        status.mediumDesc	= disk Status
	        index = diskname

	        diskname = { [ use STRING MANAGED-PROPERTY ]
		    shortDesc	= Diskname
		    mediumDesc	= Diskname
		    fullDesc	= Name of the disk (sd0 etc ...)
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.diskname
	        }
	        diskalias = { [ use STRING MANAGED-PROPERTY ]
		    shortDesc       = Diskalias
		    mediumDesc       = Diskalias
		    fullDesc        = Name of the disk (c0t0d0 etc)
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.diskalias
	        }
	        reads = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Reads
		    mediumDesc	= Read Operation Per Sec 
		    fullDesc	= read operation per sec 
		    units		= op/sec
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.reads
		    consoleHint:i18nunits = base.modules.kernel-reader:units.op/sec
	        }
	        writes = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Writes
		    mediumDesc	= Writes Operation Per Sec 
		    fullDesc	= writes operation per sec 
		    units	= op/sec
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.writes
		    consoleHint:i18nunits = base.modules.kernel-reader:units.op/sec
	        }
	        ops = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Ops
		    mediumDesc	= Operation Per Sec ( read + write)
		    fullDesc	= operation per sec ( read + write)
		    units	= op/sec
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.ops
		    consoleHint:i18nunits = base.modules.kernel-reader:units.op/sec
	        }
	        nread = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Nread
		    mediumDesc	= Number Of Bytes Read 
		    fullDesc	= number of bytes read 
		    units	= KB/sec
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.nread
		    consoleHint:i18nunits = base.modules.kernel-reader:units.KB/sec
	        }
	        nwritten = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Nwritten
		    mediumDesc	= Number Of Bytes Written
		    fullDesc	= number of bytes written
		    units	= KB/sec
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.nwritten
		    consoleHint:i18nunits = base.modules.kernel-reader:units.KB/sec
	        }
	        ntotal = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Ntotal
		    mediumDesc	= Number Of Bytes Transferrd (r+w)
		    fullDesc	= number of bytes transferrd (r+w)
		    units	= KB/sec
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.ntotal
		    consoleHint:i18nunits = base.modules.kernel-reader:units.KB/sec
	        }
	        avw = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Avw
		    mediumDesc	= Average Number Of Transactions Waiting
		    fullDesc	= average number of transactions waiting
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.avw
	        }
	        avr = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Avr
		    mediumDesc	= Average Number Of Transactions Running
		    fullDesc	= average number of transactions running
		    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-detail.diskDetailTable.diskDetailEntry.avr
	        }
	    }
	}
   }
    disk-srvtime = { [ use MANAGED-OBJECT ]

        mediumDesc  = Disk Service Time
	consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime

        diskSrvTable = { [ use MANAGED-OBJECT-TABLE ]

            mediumDesc  = Disk Service Time Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable

            diskSrvEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

                mediumDesc      = Disk Service Time Entry
                nameColumn = diskname
                childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry

#                status.mediumDesc       = disk Status
                index = diskname

                diskname = { [ use STRING MANAGED-PROPERTY ]
                    shortDesc   = Diskname
                    mediumDesc  = Diskname
                    fullDesc    = Name of the disk (sd0 etc ...)
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.diskname
                }
	        w_pct = { [ use PERCENTRULE MANAGED-PROPERTY _rules ]
		    shortDesc	= W_pct
		    mediumDesc	= Percentage Of Time There Is A Transaction Waiting For Service
		    fullDesc	= % of time there is a transaction waiting for service (wait queue length)
		    units	= %
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.w_pct
		    consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        } 
	        b_pct = { [ use PERCENTRULE MANAGED-PROPERTY _rules ]
		    shortDesc	= R_pct
		    mediumDesc	= Percentage Of Time The Disk Is Busy 
		    fullDesc	= % of time the disk is busy (transaction running)
		    units	= %
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.b_pct
		    consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        }
	        wsvc_t = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Wserv
		    mediumDesc	= Average Wait Service Time 
		    fullDesc	= average wait service time 
		    units	= msec
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.wsvc_t
		    consoleHint:i18nunits = base.modules.kernel-reader:units.msec
	        }
	        asvc_t = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Rserv
		    mediumDesc	= Average Run Service Time 
		    fullDesc	= average run service time 
		    units	= msec
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.asvc_t
		    consoleHint:i18nunits = base.modules.kernel-reader:units.msec
	        }
	        svc_t = { [ use FLOAT MANAGED-PROPERTY ]
		    shortDesc	= Serv
		    mediumDesc	= Average Service Time 
		    fullDesc	= average service time 
		    units	= msec
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.svc_t
		    consoleHint:i18nunits = base.modules.kernel-reader:units.msec
	        }
                rknrd404 = { [ use RULE MANAGED-PROPERTY _rules ]
                    shortDesc   = rknrd404
                    mediumDesc  = Rule 404
                    fullDesc    = Meta Disk Rule
		    consoleHint:hidden = true
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:disk.disk-srvtime.diskSrvTable.diskSrvEntry.rknrd404
                }
	    }
	}
    }
}

#
# Filesystem information
#
filesystem = { [ use MANAGED-OBJECT ]

   mediumDesc	= Filesystem Usage
   consoleHint:mediumDesc = base.modules.kernel-reader:filesystem

   ufsFileSystem = { [ use MANAGED-OBJECT ]
    mediumDesc = UFS Filesystem Usage
    consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs
    
    fileTable = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc	= Filesystem Usage Table
        consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable

	fileEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    mediumDesc	= Filesystem
	    childDimension	= vector
            consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry
#	    status.mediumDesc	= Filesystem Status
	    index = index
#	    nameColumn	= mount
	    descColumn = mount

	    index = { [ use STRING MANAGED-PROPERTY ]
		shortDesc	= Mount Pt Idx
		mediumDesc	= Mount Point Index
		fullDesc	= The mount point index for the filesystem 
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.index
                consoleHint:hidden  = true
	    }
	    mount = { [ use STRING MANAGED-PROPERTY ]
		shortDesc	= Mount Pt
		mediumDesc	= Mount Point 
		fullDesc	= The mount point for the filesystem 
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.mount
	    }
	    diskname = { [ use STRING MANAGED-PROPERTY ]
		shortDesc	= Disk Name
		mediumDesc	= Disk Name
		fullDesc	= The name of the device (/dev/dsk/...)
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.diskname
	    }
	    ksize = { [ use INT MANAGED-PROPERTY ]
		shortDesc	= Filesys Sz 
		mediumDesc	= Size (KB)
		fullDesc	= The total size of the filesystem in KBytes 
		units		= KB
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.ksize
		consoleHint:i18nunits = base.modules.kernel-reader:units.KB
	    }
	    kfree = { [ use INTLO MANAGED-PROPERTY ]
		shortDesc	= FilesysFree 
		mediumDesc	= Free (KB)
		fullDesc	= Available disk space in KBytes
		units		= KB
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.kfree
		consoleHint:i18nunits = base.modules.kernel-reader:units.KB
	    }
	    kavail = { [ use INTLO MANAGED-PROPERTY ]
		shortDesc	= FilesysAvl 
		mediumDesc	= Free KB(Non Root)
		fullDesc	= Available disk space for non-superusers in KBytes
		units		= KB
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.kavail
		consoleHint:i18nunits = base.modules.kernel-reader:units.KB
	    }
	    kpctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
		shortDesc	= Disk Used
		mediumDesc	= Percent Used
		fullDesc	= Percentage of Disk Space Used
		units		= %
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.kpctUsed
		consoleHint:i18nunits = base.modules.kernel-reader:units.%
	    }
	    isize = { [ use INT MANAGED-PROPERTY ]
		shortDesc	= Filesys Sz 
		mediumDesc	= Total Inodes 
		fullDesc	= The total size of the filesystem in KBytes 
		units		= inodes
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.isize
		consoleHint:i18nunits = base.modules.kernel-reader:units.inodes
	    }
	    iavail = { [ use INTLO MANAGED-PROPERTY ]
		shortDesc	= FilesysAvl 
		mediumDesc	= Availabe Inodes
		fullDesc	= Available disk space for the file system in KBytes
		units		= inodes
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.iavail
		consoleHint:i18nunits = base.modules.kernel-reader:units.inodes
	    }

	    ipctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
		shortDesc	= Inodes Used
		mediumDesc	= Percentage Of Inodes Used
		fullDesc	= Percentage of Inodes Used
		units		= %
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.ufs.fileTable.fileEntry.ipctUsed
		consoleHint:i18nunits = base.modules.kernel-reader:units.%
	    }

	}
    }
  }
  vxfsFileSystem = { [ use MANAGED-OBJECT ]
    mediumDesc = VXFS Filesystem Usage
    consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs
    
    fileTable = { [ use MANAGED-OBJECT-TABLE ]

	mediumDesc	= Filesystem Usage Table
        consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable

	fileEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    mediumDesc	= Filesystem
	    childDimension	= vector
            consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry
#	    status.mediumDesc	= Filesystem Status
	    index = index
#	    nameColumn	= mount
	    descColumn = mount

	    index = { [ use STRING MANAGED-PROPERTY ]
		shortDesc	= Mount Pt Idx
		mediumDesc	= Mount Point Index
		fullDesc	= The mount point index for the filesystem 
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.index
                consoleHint:hidden  = true
	    }
	    mount = { [ use STRING MANAGED-PROPERTY ]
		shortDesc	= Mount Pt
		mediumDesc	= Mount Point 
		fullDesc	= The mount point for the filesystem 
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.mount
	    }
	    diskname = { [ use STRING MANAGED-PROPERTY ]
		shortDesc	= Disk Name
		mediumDesc	= Disk Name
		fullDesc	= The name of the device (/dev/dsk/...)
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.diskname
	    }
	    ksize = { [ use INT MANAGED-PROPERTY ]
		shortDesc	= Filesys Sz 
		mediumDesc	= Size (KB)
		fullDesc	= The total size of the filesystem in KBytes 
		units		= KB
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.ksize
		consoleHint:i18nunits = base.modules.kernel-reader:units.KB
	    }
	    kfree = { [ use INTLO MANAGED-PROPERTY ]
		shortDesc	= FilesysFree 
		mediumDesc	= Free (KB)
		fullDesc	= Available disk space in KBytes
		units		= KB
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.kfree
		consoleHint:i18nunits = base.modules.kernel-reader:units.KB
	    }
	    kavail = { [ use INTLO MANAGED-PROPERTY ]
		shortDesc	= FilesysAvl 
		mediumDesc	= Free KB(Non Root)
		fullDesc	= Available disk space for non-superusers in KBytes
		units		= KB
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.kavail
		consoleHint:i18nunits = base.modules.kernel-reader:units.KB
	    }
	    kpctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
		shortDesc	= Disk Used
		mediumDesc	= Percent Used
		fullDesc	= Percentage of Disk Space Used
		units		= %
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.kpctUsed
		consoleHint:i18nunits = base.modules.kernel-reader:units.%
	    }
	    isize = { [ use INT MANAGED-PROPERTY ]
		shortDesc	= Filesys Sz 
		mediumDesc	= Total Inodes 
		fullDesc	= The total size of the filesystem in KBytes 
		units		= inodes
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.isize
		consoleHint:i18nunits = base.modules.kernel-reader:units.inodes
	    }
	    iavail = { [ use INTLO MANAGED-PROPERTY ]
		shortDesc	= FilesysAvl 
		mediumDesc	= Availabe Inodes
		fullDesc	= Available disk space for the file system in KBytes
		units		= inodes
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.iavail
		consoleHint:i18nunits = base.modules.kernel-reader:units.inodes
	    }

	    ipctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
		shortDesc	= Inodes Used
		mediumDesc	= Percentage Of Inodes Used
		fullDesc	= Percentage of Inodes Used
		units		= %
		alarmSeverity	= 6
		consoleHint:mediumDesc = base.modules.kernel-reader:filesystem.vxfs.fileTable.fileEntry.ipctUsed
		consoleHint:i18nunits = base.modules.kernel-reader:units.%
	    }

	}
    }
  }
}

#
# CPU Information
#
cpu-detail = { [ use MANAGED-OBJECT ] 

    mediumDesc	= CPU Statistics
    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail

    cpu-util = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Utilization
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util

    	cpuUtilTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Utilization Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable

	    cpuUtilEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry

	        #status.mediumDesc = CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
		    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.cpu-instance
	        }

	        # the sysinfo_t structure ...

	        cpu_delta = { [ use FLOATHI MANAGED-PROPERTY ]  	
		    	consoleHint:hidden = true
	        }				
	        cpu_idle = { [ use FLOATHILO MANAGED-PROPERTY ]  	#  CPU idle time
                	mediumDesc  = % CPU Idle Time
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.cpu_idle
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        }				
	        cpu_user = { [ use FLOATHI MANAGED-PROPERTY ] 	#  CPU user time
			mediumDesc  = % CPU User Time
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.cpu_user
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        }		
	        cpu_kernel = { [ use FLOATHI MANAGED-PROPERTY ] 	#  CPU kernel time
			mediumDesc  = % CPU Kernel Time
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.cpu_kernel
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
                }		
	        cpu_wait = { [ use FLOATHI MANAGED-PROPERTY ]  	#  CPU wait time
	    		mediumDesc = % CPU Wait Time
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.cpu_wait
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        }
	        wait_io = { [ use FLOATHI MANAGED-PROPERTY ]  	#  CPU wait time breakdown	
		 	mediumDesc = % CPU Wait Time On I/O
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.wait_io
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        }		
	        wait_swap = { [ use FLOATHI MANAGED-PROPERTY ] 	#  CPU wait time breakdown	
			mediumDesc = % CPU Wait Time On Swap
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.wait_swap
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
	        }
	        wait_pio = { [ use FLOATHI MANAGED-PROPERTY ]  	#  CPU wait time breakdown	
			mediumDesc = % CPU Wait Time On Pio
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.wait_pio
			units = %
			consoleHint:i18nunits = base.modules.kernel-reader:units.%
                }
	        idlethread = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  times idle thread scheduled	
			mediumDesc = Times Idle Thread Scheduled
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.idlethread
	        }
                rknrd403 = { [ use RULE MANAGED-PROPERTY _rules ]
                	shortDesc   = rknrd403
                	mediumDesc  = Rule 403
                	fullDesc    = Meta CPU Rule
			consoleHint:hidden = true
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-util.cpuUtilTable.cpuUtilEntry.rknrd403
                }
	    }
	}
    }
    cpu-process = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Process
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-process

        cpu-procs = { [ use MANAGED-PROPERTY-CLASS ]

	    mediumDesc          = Process Info
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-process.cpu-procs

	    runqueue = { [ use INTRULE MANAGED-PROPERTY _rules ]
	        mediumDesc      = Processes In Run Queue
	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-process.cpu-procs.runqueue
	    }
	    waiting = { [ use INTHI MANAGED-PROPERTY ]
	        mediumDesc      = Processes Waiting
	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-process.cpu-procs.waiting
	    }
	    swapqueue = { [ use INTHI MANAGED-PROPERTY ]
	        mediumDesc      = Processes Swapped
	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-process.cpu-procs.swapqueue
	    }
            numcpus = { [ use INT MANAGED-PROPERTY ]
                mediumDesc      = Total Number Of CPUs
                consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-process.cpu-procs.numcpus
            }
        }
    }

    cpu-io = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU I/O
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io

    	cpuIoTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU I/O Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable

	    cpuIoEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
		    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.cpu-instance
	        }

	        bread = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  physical block reads
			mediumDesc = Physical Block Reads
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.bread
	        }

	        bwrite = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  physical block writes (sync+async)
       			mediumDesc = Physical Block Writes
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.bwrite
	        }
	        lread = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  logical block reads
			mediumDesc =  Logical Block Reads
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.lread
	        }
	        lwrite = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  logical block writes
			 mediumDesc =  Logical Block Writes
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.lwrite
	        }
	        phread = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  raw I/O reads
			mediumDesc =  Raw I/O Reads
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.phread
	        }
	        phwrite = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  raw I/O writes
			mediumDesc =  Raw I/O Writes
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.phwrite
	        }

	        readch = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  bytes read by rdwr()
			mediumDesc = Bytes Read By Rdwr()
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.readch
	        }
	        writech = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  bytes written by rdwr()	
			mediumDesc =  Bytes Written By Rdwr()   
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.writech
	        }
                rcvint = { [ use COUNTER64 MANAGED-PROPERTY ]         #  XXX: UNUSED
                        consoleHint:hidden = true
                }
                xmtint = { [ use COUNTER64 MANAGED-PROPERTY ]         #  XXX: UNUSED
                        consoleHint:hidden = true
                }
                mdmint = { [ use COUNTER64 MANAGED-PROPERTY ]         #  XXX: UNUSED
                        consoleHint:hidden = true
                }
	        rawch = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  terminal input characters	
			mediumDesc = Terminal Input Characters 
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.rawch
	        }
	        canch = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  chars handled in canonical mode
			mediumDesc =  Chars Handled In Canonical Mode
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.canch
	        }
	        outch = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  terminal output characters	
			mediumDesc = Terminal Output Characters   
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.outch
	        }
	        bawrite = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  physical block writes (async)
			mediumDesc = Physical Block Writes
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.bawrite
	        }
	        # the cpu_syswait structure...
	        physio = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  procs waiting for block I/O
			mediumDesc =  Procs Waiting For Block I/O
		    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-io.cpuIoTable.cpuIoEntry.physio
	        }		
	    }
        }
    }

    cpu-interrupts = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Interrupts
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts

    	cpuIntrTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Interrupts Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable

	    cpuIntrEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry.cpu-instance
	        }
	        pswitch = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  context switches
			mediumDesc =  Context Switches
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry.pswitch
	        }
	        trap = { [ use COUNTER64 MANAGED-PROPERTY ] 		#  traps	
			mediumDesc =  Traps
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry.trap
	        }
	        intr = { [ use COUNTER64 MANAGED-PROPERTY ] 		#  device interrupts
			mediumDesc =   Device Interrupts
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry.intr
	        }
	        intrthread = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  interrupts as threads (below clock)
			mediumDesc = Interrupts As Threads
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry.intrthread
	        }
	        intrblk = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  intrs blkd/prempted/released (swtch)
			mediumDesc = Intrs Blkd/Prempted/Released
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-interrupts.cpuIntrTable.cpuIntrEntry.intrblk
	        }
	    }
        }
    }

    cpu-syscall = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Syscalls
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall

    	cpuSysTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Systemcall Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable

	    cpuSysEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.cpu-instance
	        }
	        syscall = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  system calls	
			mediumDesc =  System Calls 
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.syscall
	        }
	        sysread = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  read() + readv() system calls
			mediumDesc =  Read+Readv System Calls
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.sysread
	        }
	        syswrite = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  write() + writev() system calls
			 mediumDesc =  Write+Writev System Calls
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.syswrite
	        }
	        sysfork = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  forks	
			 mediumDesc =  Forks
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.sysfork
	        }
	        sysvfork = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  vforks	
			mediumDesc = Vforks
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.sysvfork
	        }
	        sysexec = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  execs	
			mediumDesc = Execs
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.sysexec
	        }
	        msg = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  msg count (msgrcv()+msgsnd() calls)
			mediumDesc =  Msg Count
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.msg
	        }
	        sema = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  semaphore ops count (semop() calls)
			 mediumDesc =  Semaphore Ops Count
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.sema
	        }
	        namei = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pathname lookups
			mediumDesc = Pathname Lookups
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.namei
	        }
	        ufsiget = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  ufs_iget() calls
			mediumDesc = Ufs_iget() Calls
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.ufsiget
	        }
	        ufsdirblk = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  directory blocks read	
			mediumDesc = Directory Blocks Read
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.ufsdirblk
	        }
	        ufsipage = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  inodes taken with attached pages
			mediumDesc = Inodes Taken With Attached Pages
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.ufsipage
	        }
	        ufsinopage = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  inodes taked with no attached pages
			mediumDesc = Indoes Taken With No Attached Pages
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.ufsinopage
	        }	
	        inodeovf = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  inode table overflows	
			 mediumDesc = Inode Table Overflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.inodeovf
	        }
	        fileovf = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  file table overflows
			mediumDesc = File Table Overflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.fileovf
	        }
	        procovf = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  proc table overflows
			mediumDesc = Proc Table Overflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-syscall.cpuSysTable.cpuSysEntry.procovf
	        }
	    }
	}
    }

    cpu-misc = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Misc
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc

    	cpuMiscTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Misc Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable

	    cpuMiscEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.cpu-instance
	        }
	        inv_swtch = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  involuntary ctx switches	
			mediumDesc =   Involuntary Ctx Switches
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.inv_swtch
	        }
	        nthreads = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  thread_create()s
		 	mediumDesc =   Thread_create()s
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.nthreads
	        }
	        cpumigrate = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  cpu migrations by threads 	
			mediumDesc = Cpu Migrations By Threads
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.cpumigrate
	        }
	        xcalls = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  xcalls to other cpus 	
			mediumDesc = Xcalls To Other Cpus
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.xcalls
	        }
	        mutex_adenters = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  failed mutex enters (adaptive)
			mediumDesc = Failed Mutex Enters (adaptive)
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.mutex_adenters
	        }
	        rw_rdfails = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  rw reader failures
			mediumDesc = Rw Reader Failures
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.rw_rdfails
	        }
	        rw_wrfails = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  rw writer failures
			mediumDesc = Rw Write Failures
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.rw_wrfails
	        }
	        modload = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  times loadable module loaded	
			mediumDesc = Loadable Module Loaded
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.modload
	        }
	        modunload = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  times loadable module unloaded 
			mediumDesc = Loadable Module Unloaded
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.modunload
	        }
# Following are gathered only under #ifdef STATISTICS in source
	        rw_enters = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  tries to acquire rw lock	
			mediumDesc = Tries To Acquire RW Lock  
	    	        consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-misc.cpuMiscTable.cpuMiscEntry.rw_enters
	        }
	    }
	}
    }

    cpu-regwindow = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Regwindow
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow

    	cpuRegTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Reg Window Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable

	    cpuRegEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry.cpu-instance
	        }
	        win_uo_cnt = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  reg window user overflows	
			mediumDesc = User Overflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry.win_uo_cnt
	        }
	        win_uu_cnt = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  reg window user underflows	
			mediumDesc = User Underflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry.win_uu_cnt
	        }
	        win_so_cnt = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  reg window system overflows	
			mediumDesc =  System Overflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry.win_so_cnt
	        }
	        win_su_cnt = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  reg window system underflows	
			mediumDesc =  System Underflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry.win_su_cnt
	        }
	        win_suo_cnt = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  reg window system user overflows
			mediumDesc =  System User Overflows
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-regwindow.cpuRegTable.cpuRegEntry.win_suo_cnt
	        }
	    }
	}
    }

    cpu-pginfo = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Pageinfo
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo

    	cpuPgTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Page Info Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable

	    cpuPgEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.cpu-instance
	        }
	    	# the cpu_vminfo structure...
	        pgrec = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  page reclaims (includes pageout)
			 mediumDesc = Reclaims
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgrec
	        }
	        pgfrec = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  page reclaims from free list
			mediumDesc =  Reclaims From Free List
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgfrec
	        }
	        pgin = { [ use COUNTER64 MANAGED-PROPERTY ]  		#  pageins		
			 mediumDesc =  Pageins
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgin
	        }
	        pgpgin = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pages paged in	
			mediumDesc = Pages Paged In
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgpgin
	        }				
	        pgout = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pageouts		
			 mediumDesc = Pageouts
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgout
	        }
	        pgpgout = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pages paged out	
			mediumDesc = Pages Paged Out
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgpgout
	        }
	        swapin = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  swapins		
			mediumDesc = Swapins
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.swapin
	        }
	        pgswapin = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pages swapped in	
			mediumDesc =  Pages Swapped In    
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgswapin
	        }
	        swapout = { [ use COUNTER64RULE MANAGED-PROPERTY _rules ]  	#  swapouts		
			mediumDesc =  Swapouts
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.swapout
	        }
	        pgswapout = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pages swapped out	
			mediumDesc =   Pages Swapped Out  
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgswapout
	        }
	        zfod = { [ use COUNTER64 MANAGED-PROPERTY ] 		#  pages zero filled on demand
			mediumDesc =  Pages Zero Filled On Demand
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.zfod
	        }
	        dfree = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  pages freed by daemon or auto
			mediumDesc =  Pages Freed By Daemon
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.dfree
	        }
	        scan = { [ use COUNTER64 MANAGED-PROPERTY ]  		#  pages examined by pageout daemon
			 mediumDesc = Pages Examined By Pageout Daemon
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.scan
	        }
	        rev = { [ use COUNTER64 MANAGED-PROPERTY ]  		#  revolutions of the page daemon hand
			mediumDesc = Revolutions Of The Page Daemon Hand
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.rev
	        }
	    	pgrrun = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  times pager scheduled
			mediumDesc = Times Pager Scheduled
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-pginfo.cpuPgTable.cpuPgEntry.pgrrun
	    	}
	    }
	}
    }

    cpu-faults = { [ use MANAGED-OBJECT ]

	mediumDesc  = CPU Faults
	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults

    	cpuFaultTable = { [ use MANAGED-OBJECT-TABLE ]

	    mediumDesc	= CPU Fault Table
	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable

	    cpuFaultEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]

	        nameColumn = cpu-instance
	        childDimension = vector
	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry

	        #status.mediumDesc	= CPU Status
	        index = cpu-instance

	        cpu-instance = { [ use INT MANAGED-PROPERTY ]
		    shortDesc	= instance
		    mediumDesc	= CPU Number
		    fullDesc	= The CPU number
	    	    consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.cpu-instance
	        }
	    	hat_fault = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  minor page faults via hat_fault()
			mediumDesc = Minor Page Faults Via  hat_fault()
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.hat_fault
	    	}
	    	as_fault = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  minor page faults via as_fault()
	        	mediumDesc = Minor Page Faults Via  as_fault()
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.as_fault
	    	}
	    	maj_fault = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  major page faults	
		 	mediumDesc =  Major Page Faults 
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.maj_fault
	    	}
	    	cow_fault = { [ use COUNTER64 MANAGED-PROPERTY ] 	#  copy-on-write faults	
			mediumDesc =   Copy-on-write Faults
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.cow_fault
	    	}
	    	prot_fault = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  protection faults	
		 	mediumDesc =  Protection Faults
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.prot_fault
	    	}
	    	softlock = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  faults due to software locking req
			mediumDesc = Faults Due To Software Locking Req
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.softlock
	    	}
	    	kernel_asflt = { [ use COUNTER64 MANAGED-PROPERTY ]  	#  as_fault()s in kernel addr space
		 	mediumDesc = As_fault()s In Kernel Addr Space
	    	    	consoleHint:mediumDesc = base.modules.kernel-reader:cpu-detail.cpu-faults.cpuFaultTable.cpuFaultEntry.kernel_asflt
	    	}
	    }
	}
    }
}

memory-usage = { [ use MANAGED-OBJECT ] 

    mediumDesc	= Memory Usage Statistics
    consoleHint:mediumDesc = base.modules.kernel-reader:memory-usage

    mem-avail = { [ use INT MANAGED-PROPERTY ]
	    mediumDesc	= Physical Memory Available (MB)
	    fullDesc	= Physical memory available
	    units	= MB
	    consoleHint:mediumDesc = base.modules.kernel-reader:memory-usage.mem-avail
	    consoleHint:i18nunits = base.modules.kernel-reader:units.MB
    }
    mem-inuse = { [ use INTHI MANAGED-PROPERTY ]
	    mediumDesc	= Physical Memory In Use (MB)
	    fullDesc	= Physical memory in use
	    units	= MB
	    consoleHint:mediumDesc = base.modules.kernel-reader:memory-usage.mem-inuse
	    consoleHint:i18nunits = base.modules.kernel-reader:units.MB
    }
    pctUsed = { [ use PERCENTHI MANAGED-PROPERTY ]
	mediumDesc	= Percent Memory Used
	    consoleHint:mediumDesc = base.modules.kernel-reader:memory-usage.pctUsed
    }
    mem-free = { [ use INTLO MANAGED-PROPERTY ]
	    mediumDesc	= Physical Memory Free (MB)
	    fullDesc	= Physical memory free
	    units	= MB
	    consoleHint:mediumDesc = base.modules.kernel-reader:memory-usage.mem-free
	    consoleHint:i18nunits = base.modules.kernel-reader:units.MB
    }
    pctFree = { [ use PERCENTLO MANAGED-PROPERTY ]
	mediumDesc	= Percent Memory Free
	    consoleHint:mediumDesc = base.modules.kernel-reader:memory-usage.pctFree
    }
}

swap-detail = { [ use MANAGED-OBJECT ] 

    mediumDesc	= Swap Statistics
    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail

    swap-avail = { [ use INTRULE MANAGED-PROPERTY _rules ]
	    shortDesc	= swapavail
	    mediumDesc	= Available  KB ( Anon Memory Not Reserved )
	    fullDesc	= Swap available(Total SWAP - RESERVED)
	    units	= KiloBytes
    	    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.swap-avail
	    consoleHint:i18nunits = base.modules.kernel-reader:units.KiloBytes
    }
    swap-resv = { [ use INT MANAGED-PROPERTY ]
	    shortDesc	= swapresv
	    mediumDesc	= Reserved  KB ( Anon Memory Reserved But Not Allocated )
	    fullDesc	= Swap reserved
	    units	= KiloBytes
    	    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.swap-resv
	    consoleHint:i18nunits = base.modules.kernel-reader:units.KiloBytes
    }
    swap-alloc = { [ use INT MANAGED-PROPERTY ]
	    shortDesc	= swapalloc
	    mediumDesc	= Allocated  KB ( Anon Memory Not Free )
	    fullDesc	= Swap allocated
	    units	= KiloBytes
    	    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.swap-alloc
	    consoleHint:i18nunits = base.modules.kernel-reader:units.KiloBytes
    }
    swap-used = { [ use UINTHI MANAGED-PROPERTY ]
	    shortDesc	= swapused
	    mediumDesc	= Used KB
	    fullDesc	= Swap Used
	    units	= KiloBytes
    	    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.swap-used
	    consoleHint:i18nunits = base.modules.kernel-reader:units.KiloBytes
    }
    swap-total = { [ use INT MANAGED-PROPERTY ]
	    shortDesc	= swaptotal
	    mediumDesc	= Total KB ( Used + Available )
	    fullDesc	= Swap total
	    units	= KiloBytes
    	    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.swap-total
	    consoleHint:i18nunits = base.modules.kernel-reader:units.KiloBytes
    }
    pctUsed = { [ use PERCENTRULE MANAGED-PROPERTY _rules ]
	    shortDesc	= pctswapused
	    mediumDesc	= Percent Swap Used
	    units	= %
    	    consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.pctUsed
	    consoleHint:i18nunits = base.modules.kernel-reader:units.%
    }
    rknrd405 = { [ use RULE MANAGED-PROPERTY _rules ]
           shortDesc   = rknrd405
           mediumDesc  = Rule 405
           fullDesc    = Meta Swap Rule
	   consoleHint:hidden = true
    	   consoleHint:mediumDesc = base.modules.kernel-reader:swap-detail.rknrd405
    }
}

streams-detail = { [ use MANAGED-OBJECT ] 

    mediumDesc	= STREAMS Statistics
    consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail

    template-s = {
	type = reference
        consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s
	kma-instance = { [ use STRING MANAGED-PROPERTY ]
		fullDesc	= The name of the cache
		mediumDesc	= The Name Of The Cache
        	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s.kma-instance
	}
	current = { [ use INT MANAGED-PROPERTY ]
		fullDesc	= Current usage (total - avail)
		mediumDesc	= Current Usage (total - avail)
        	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s.current
	}
	maximum = { [ use INT MANAGED-PROPERTY ]
		fullDesc	= Maximum capacity
		mediumDesc	= Maximum Capacity
        	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s.maximum
	}
	total = { [ use INT MANAGED-PROPERTY ]
		fullDesc	= Cumulative total of allocations
		mediumDesc	= Cumulative Total Of Allocations
        	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s.total
	}
	failures = { [ use INT MANAGED-PROPERTY ]
		fullDesc	= Number of allocation failures
		mediumDesc	= Number Of Allocation Failures
        	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s.failures
	}
	pctUsed = { [ use PERCENT MANAGED-PROPERTY ]
            mediumDesc	= Percent Used
        	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.template-s.pctUsed
	}

    }

    stream_head_cache = { [ use MANAGED-OBJECT ]
	shortDesc	= Stream Head
	mediumDesc	= Stream Head Cache
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.stream_head_cache
    }
    queue_cache = { [ use MANAGED-OBJECT ]
	shortDesc	= Queue Head
	mediumDesc	= Queue Cache
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.queue_cache
    }
    streams_msg = { [ use MANAGED-OBJECT ]
	shortDesc	= Streams Msgs
	mediumDesc	= Streams Msgs
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.streams_msg
    }
    linkinfo_cache = { [ use MANAGED-OBJECT ]
	shortDesc	= Linkinfo Cache
	mediumDesc	= Linkinfo Cache
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.linkinfo_cache
    }
    strevent_cache = { [ use MANAGED-OBJECT ]
	shortDesc	= Strevent Cache
	mediumDesc	= Strevent Cache
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.strevent_cache
    }
    syncq_cache = { [ use MANAGED-OBJECT ]
	shortDesc	= Syncq Cache
	mediumDesc	= Syncq Cache
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.syncq_cache
    }
    qband_cache = { [ use MANAGED-OBJECT ]
	shortDesc	= Qband Cache
	mediumDesc	= Qband Cache
	consoleHint:mediumDesc = base.modules.kernel-reader:streams-detail.qband_cache
    }
}

load = { [ use MANAGED-OBJECT ] 
    mediumDesc	= System Load Statistics
    consoleHint:mediumDesc = base.modules.kernel-reader:load

    avg_1min = { [ use FLOATHI MANAGED-PROPERTY ]
	    shortDesc	= Avg. 1 Min
            mediumDesc	= Load Averages Over The Last 1 Minute
	    fullDesc	= Load average over the last 1 minute.
	    units	= Jobs
	    consoleHint:mediumDesc = base.modules.kernel-reader:load.avg_1min
	    consoleHint:i18nunits = base.modules.kernel-reader:units.Jobs
    }
    avg_5min = { [ use FLOATHI MANAGED-PROPERTY ]
	    shortDesc	= Avg. 5 Min
	    mediumDesc	= Load Average Over The Last 5 Minutes
	    fullDesc	= Load average over the last 5 minutes.
	    units	= Jobs
	    consoleHint:mediumDesc = base.modules.kernel-reader:load.avg_5min
	    consoleHint:i18nunits = base.modules.kernel-reader:units.Jobs
    }
    avg_15min = { [ use FLOATHI MANAGED-PROPERTY ]
	    shortDesc	= Avg. 15 Min
	    mediumDesc	= Load Average Over The Last 15 Minutes
	    fullDesc	= Load average over the last 15 minutes.
	    units	= Jobs
	    consoleHint:mediumDesc = base.modules.kernel-reader:load.avg_15min
	    consoleHint:i18nunits = base.modules.kernel-reader:units.Jobs
    }
}

software-rules = { [ use MANAGED-OBJECT ]

	mediumDesc = Software Rules
	consoleHint:mediumDesc = base.modules.kernel-reader:software-rules

	rknrd105 = { [ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc        =  Rule rknrd105
		consoleHint:mediumDesc = base.modules.kernel-reader:software-rules.rknrd105
	}
	rknrd106 = { [ use RULE _rules MANAGED-PROPERTY ]
		mediumDesc        =  Rule rknrd106
		consoleHint:mediumDesc = base.modules.kernel-reader:software-rules.rknrd106
	}
}

[ load kernel-reader-ruleinit-d.x ]
[ load kernel-reader-ruletext-d.x ]



hardware-rules = { [ use MANAGED-OBJECT ]

        mediumDesc = Hardware Rules
	consoleHint:hidden = true
	consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules

 rknrd204 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  UE Error 
		consoleHint:mediumDesc = base.modules.kernel-reader:hardware-rules.rknrd204
        }

 rknrd205 = { [ use RULE _rules MANAGED-PROPERTY ]
                mediumDesc        =  CE Error
		consoleHint:mediumDesc = base.modules.Config-Reader4u:hardware-rules.rknrd205
        }

}
