/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.payflex;

import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.payflex.PayFlexConstants;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class PayFlexPassThruCardService
extends CardService {
    int apdu_status;

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    private ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(commandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    private ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    private void setupPassThruService() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == PayFlexConstants.payflexAccessAID) {
            return;
        }
        cardChannel.setState(PayFlexConstants.payflexAccessAID);
    }

    public void testMyself(byte[] byArray) {
        try {
            try {
                this.setupPassThruService();
                ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(byArray));
                System.out.println("resp data" + responseAPDU.data());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var3_4 = null;
            this.releaseCardChannel();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.releaseCardChannel();
            throw throwable;
        }
    }
}

