/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Slot;
import opencard.core.util.HexString;

public class CardID {
    protected byte[] atr;
    protected byte[] historicals;
    protected Slot slot = null;
    protected String cachedResult = null;

    public CardID(Slot slot, byte[] byArray) throws CardTerminalException {
        this(byArray);
        this.slot = slot;
    }

    public CardID(byte[] byArray) throws CardTerminalException {
        this.atr = (byte[])byArray.clone();
        if (this.atr.length < 2) {
            throw new CardTerminalException("Illegal ATR response (length " + this.atr.length + " < 2): " + HexString.hexify(byArray));
        }
        if ((this.atr[1] & 0xF) > 0) {
            this.historicals = new byte[this.atr[1] & 0xF];
            System.arraycopy(this.atr, this.atr.length - 1 - this.historicals.length, this.historicals, 0, this.historicals.length);
            int n = this.historicals.length - 1;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof CardID)) {
            return false;
        }
        CardID cardID = (CardID)object;
        if (cardID.atr.length != this.atr.length) {
            return false;
        }
        int n = 0;
        while (n < this.atr.length) {
            if (this.atr[n] != cardID.atr[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public byte[] getATR() {
        return this.atr != null ? (byte[])this.atr.clone() : null;
    }

    public byte[] getHistoricals() {
        return this.historicals != null ? (byte[])this.historicals.clone() : null;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public String toString() {
        if (this.cachedResult == null) {
            this.cachedResult = String.valueOf(super.toString()) + " ATR: " + HexString.hexify(this.atr);
        }
        return this.cachedResult;
    }
}

