/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.core;

import com.scmmicro.smartos.core.ATR;
import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.util.Buffer;

class ReaderAcces {
    private ATR m_rATR;

    ReaderAcces(ATR aTR) {
        this.m_rATR = aTR;
    }

    void deactivateContacts(Buffer buffer, Drive drive) throws CommunicationException, CardException, TimeOutException {
        byte[] byArray = new byte[2];
        byArray[0] = -112;
        byte[] byArray2 = byArray;
        try {
            drive.setParameter((byte)22, 1L);
        }
        catch (BadParameterException badParameterException) {
            throw new CommunicationException();
        }
        catch (BadParameterValueException badParameterValueException) {
            throw new CommunicationException();
        }
        buffer.setData(byArray2);
    }

    ATR getATR() {
        return this.m_rATR;
    }

    void reset(Buffer buffer, Buffer buffer2, Drive drive) throws CommunicationException, CardException, BadParameterValueException, TimeOutException {
        this.m_rATR.reset(false, buffer, buffer2, drive);
    }

    void sendCommand(byte by, Buffer buffer, Buffer buffer2, Drive drive) throws CommunicationException, CardException, BadParameterValueException, TimeOutException {
        if (by == 0) {
            this.reset(buffer, buffer2, drive);
        } else if (by == 1) {
            this.warmReset(buffer, buffer2, drive);
        } else if (by == 2) {
            this.deactivateContacts(buffer2, drive);
        }
    }

    void setATR(ATR aTR) {
        this.m_rATR = aTR;
    }

    void warmReset(Buffer buffer, Buffer buffer2, Drive drive) throws CommunicationException, CardException, BadParameterValueException, TimeOutException {
        this.m_rATR.reset(true, buffer, buffer2, drive);
    }
}

