/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.apps.util.slm.dsw;

import com.sun.dae.components.util.ExceptionUtil;
import com.sun.esm.apps.util.slm.dsw.DswPairInfo;
import com.sun.esm.apps.util.slm.dsw.DswPairInfoAccess;
import com.sun.esm.apps.util.slm.dsw.Transition;
import com.sun.esm.mo.dsw.DswVolException;
import com.sun.esm.mo.dsw.DswVolImplProxy;
import com.sun.esm.util.Services;
import com.sun.esm.util.slm.dsw.DswModifierCodes;
import java.io.Serializable;

public class DswPairHealth
implements Serializable,
DswPairInfoAccess {
    static final long serialVersionUID = -8846915791498765197L;
    private DswVolImplProxy dswVolProxy;
    private DswPairInfo myHealth;
    private transient Transition myTransitions;
    static final String sccs_id = "@(#)DswPairHealth.java 1.60    00/08/04 SMI";

    public DswPairHealth(DswVolImplProxy dswVolImplProxy) {
        this.dswVolProxy = dswVolImplProxy;
        this.myHealth = new DswPairInfo(this.dswVolProxy.getMasterName(), this.dswVolProxy.getShadowName());
        this.trace("DswPairHealth master = " + this.getMasterName() + " shadow = " + this.getShadowName());
        this.myTransitions = new Transition(this);
    }

    public int getActivityState() {
        return this.myHealth.activityState;
    }

    public String getBitmapName() {
        this.myHealth.bitmapName = this.dswVolProxy.getBitmapName();
        this.trace("getBitmapName returning");
        return this.myHealth.bitmapName;
    }

    public float getCachedPercentCopied() {
        this.myHealth.percentCopied = this.dswVolProxy.getPercentCopied();
        this.trace("getCachedPercentCopied returning " + this.myHealth.percentCopied);
        return this.myHealth.percentCopied;
    }

    public float getCachedPercentDifferent() {
        this.myHealth.percentDifferent = this.dswVolProxy.getPercentDifferent();
        this.trace("getCachedPercentDifferent returning " + this.myHealth.percentDifferent);
        return this.myHealth.percentDifferent;
    }

    public float getCachedPercentSame() {
        this.myHealth.percentSame = this.dswVolProxy.getPercentSame();
        this.trace("getCachedPercentSame returning " + this.myHealth.percentSame);
        return this.myHealth.percentSame;
    }

    public float getCachedPercentUnCopied() {
        this.myHealth.percentUnCopied = this.dswVolProxy.getPercentUnCopied();
        this.trace("getCachedPercentUnCopied returning " + this.myHealth.percentUnCopied);
        return this.myHealth.percentUnCopied;
    }

    public void getDswBitmap() {
        try {
            this.dswVolProxy.getDswBitmap();
        }
        catch (DswVolException dswVolException) {
            this.trace("getDswBitmap Exception: " + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
            this.log("`some_exception`", new Object[]{"getDswBitmap", this.getShadowName()}, (Throwable)((Object)dswVolException));
        }
        this.trace("getDswBitmap returning");
    }

    public DswPairInfo getDswPairInfo() {
        return this.myHealth;
    }

    public boolean getDswStatus() {
        boolean bl = false;
        try {
            this.dswVolProxy.getDswStatus();
            bl = true;
        }
        catch (DswVolException dswVolException) {
            this.trace("getDswStatus Exception: " + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
            this.log("`some_exception`", new Object[]{"getDswStatus", this.getShadowName()}, (Throwable)((Object)dswVolException));
        }
        this.trace("getDswStatus returning " + bl);
        return bl;
    }

    public byte[] getMasterBitmap() {
        this.trace("getMasterBitmap");
        this.getDswBitmap();
        return this.dswVolProxy.getCopyBitmap();
    }

    public int getMasterCapacity() {
        this.myHealth.masterCapacity = this.dswVolProxy.getMasterCapacity();
        this.trace("getMasterCapacity returning " + this.myHealth.masterCapacity);
        return this.myHealth.masterCapacity;
    }

    public String getMasterHostName() {
        this.myHealth.masterHostName = this.dswVolProxy.getMasterHostname();
        this.trace("getMasterHostName returning" + this.myHealth.masterHostName);
        return new String(this.myHealth.masterHostName);
    }

    public String getMasterName() {
        return new String(this.myHealth.masterName);
    }

    public int getMasterState() {
        this.myHealth.masterState = this.dswVolProxy.getMasterState();
        return this.myHealth.masterState;
    }

    public float getPercentCopied() {
        this.trace("getPercentCopied");
        this.getDswBitmap();
        return this.getCachedPercentCopied();
    }

    public float getPercentDifferent() {
        this.trace("getPercentDifferent");
        this.getDswBitmap();
        return this.getCachedPercentDifferent();
    }

    public float getPercentSame() {
        this.trace("getPercentSame");
        this.getDswBitmap();
        return this.getCachedPercentSame();
    }

    public float getPercentUnCopied() {
        this.trace("getPercentUnCopied");
        this.getDswBitmap();
        return this.getCachedPercentUnCopied();
    }

    public int getPreviousActivityState() {
        return this.myHealth.previousActivityState;
    }

    public int getPreviousCopyState() {
        return this.myHealth.previousCopyState;
    }

    public byte[] getShadowBitmap() {
        this.getDswBitmap();
        this.trace("getShadowBitmap returning");
        return this.dswVolProxy.getShadowBitmap();
    }

    public int getShadowCapacity() {
        this.myHealth.shadowCapacity = this.dswVolProxy.getShadowCapacity();
        this.trace("getShadowCapacity returning " + this.myHealth.shadowCapacity);
        return this.myHealth.shadowCapacity;
    }

    public String getShadowHostName() {
        this.myHealth.shadowHostName = this.dswVolProxy.getShadowHostname();
        this.trace("getShadowHostName returning " + this.myHealth.shadowHostName);
        return new String(this.myHealth.shadowHostName);
    }

    public String getShadowName() {
        return new String(this.myHealth.shadowName);
    }

    public int getShadowState() {
        this.myHealth.shadowState = this.dswVolProxy.getShadowState();
        return this.myHealth.shadowState;
    }

    public int getState() {
        return this.myHealth.state;
    }

    public int getStatus() {
        return this.myHealth.status;
    }

    public void hydrate() {
        this.trace("DswPairHealth hydrate started");
        this.myTransitions = new Transition(this);
        this.trace("DswPairHealth hydrate complete");
    }

    public synchronized boolean isActivityStateTransitionValid(int n) {
        return this.myTransitions.isActivityStateTransitionValid(n);
    }

    public boolean isDependent() {
        this.trace("isDependent " + this.myHealth.dependent);
        return this.myHealth.dependent;
    }

    public synchronized boolean isStateTransitionValid(int n) {
        return this.myTransitions.isStateTransitionValid(n);
    }

    private void log(String string) {
        Services.log((String)string, (Object[])new Object[]{this.getShadowName()}, this.getClass(), (String)"`InstantImage`");
    }

    private void log(String string, Throwable throwable) {
        Services.log((String)string, (Object[])new Object[]{this.getShadowName()}, this.getClass(), (String)"`InstantImage`", (Throwable)throwable);
    }

    private void log(String string, Object[] objectArray) {
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`");
    }

    private void log(String string, Object[] objectArray, Throwable throwable) {
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`", (Throwable)throwable);
    }

    public void queryDependent() {
        this.myHealth.dependent = !this.dswVolProxy.isEnabledIndependent();
        this.trace("queryDependent " + this.myHealth.dependent);
    }

    public synchronized void setActivityState(int n) {
        this.trace("setActivityState " + DswModifierCodes.stateName[n]);
        if (this.myHealth.activityState == n) {
            return;
        }
        switch (this.myHealth.activityState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.myHealth.previousCopyState = this.myHealth.activityState;
                this.trace("setPreviousCopyState " + DswModifierCodes.stateName[this.myHealth.previousCopyState]);
            }
            default: {
                this.myHealth.previousActivityState = this.myHealth.activityState;
                this.trace("setPreviousActivityState " + DswModifierCodes.stateName[this.myHealth.previousActivityState]);
            }
            case 11: 
            case 12: 
        }
        this.myHealth.activityState = n;
    }

    public synchronized void setState(int n) {
        this.myHealth.state = n;
    }

    public synchronized void setStatus(int n) {
        this.myHealth.status = n;
    }

    private void trace(String string) {
        Services.trace((String)(String.valueOf(string) + " " + this.getShadowName()), (String)this.getClass().getName(), (int)100, (int)32);
    }

    public synchronized boolean transitionToActivityState(int n) {
        return this.myTransitions.transitionToActivityState(n);
    }

    public synchronized boolean transitionToState(int n) {
        return this.myTransitions.transitionToState(n);
    }
}

