/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.mo.dsw;

import com.sun.esm.util.Services;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class BitmapFile
implements Serializable {
    static final long serialVersionUID = 3438879039587534805L;
    private boolean bitmapSupplied = false;
    private File bitmapFile = null;
    public static final int MAXBUFSZ = 8192;
    static final int BLKSIZE = 512;
    static final int FILESIZE = 262144;
    static final int HEADER = 8192;
    static final int BMSIZE = 8192;
    static final String sccs_id = "@(#)BitmapFile.java 1.4    98/12/09 SMI";

    BitmapFile(String string) {
        if (string == null) {
            return;
        }
        this.bitmapFile = new File(string);
    }

    public int calculateBitmapFileSize(long l) {
        int n = (int)(8192L + 2L * (8192L + l / 262144L + 1L));
        this.trace("bitmapFileSize = " + n + " masterVolSize = " + l);
        return n;
    }

    public boolean createBitmapDirectory(String string) {
        if (this.bitmapFile == null) {
            this.bitmapFile = new File(string);
        }
        return this.bitmapFile.exists() || this.bitmapFile.mkdirs();
    }

    public boolean createBitmapFile(String string, File file) {
        try {
            this.bitmapFile = File.createTempFile(string, "b", file);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean deleteBitmapFile() {
        if (this.bitmapFile != null) {
            return this.bitmapFile.delete();
        }
        return false;
    }

    public boolean expandBitmapFile(long l) {
        FileOutputStream fileOutputStream;
        this.trace("expandBitmapFile, mstrVolSize = " + l);
        int n = this.calculateBitmapFileSize(l);
        int n2 = 0;
        int n3 = 0;
        try {
            fileOutputStream = new FileOutputStream(this.bitmapFile);
        }
        catch (IOException iOException) {
            return false;
        }
        if (n > 8192) {
            n2 = 8192;
            n3 = n / n2;
            if (n % n2 > 0) {
                ++n3;
            }
        } else {
            n2 = n;
            n3 = 1;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = 0;
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            try {
                fileOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public String getBitmapFileName() {
        return this.bitmapFile.getAbsolutePath();
    }

    public File getBitmapFileObj() {
        return this.bitmapFile;
    }

    public void setBitmapSupplied() {
        this.bitmapSupplied = true;
        this.trace("setBitmapSupplied = " + this.bitmapSupplied);
    }

    private void trace(String string) {
        Services.trace((String)string, (String)this.getClass().getName(), (int)100, (int)32);
    }

    public boolean wasBitmapSupplied() {
        return this.bitmapSupplied;
    }
}

