/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.mo.dsw;

import com.sun.dae.components.event.Delegate;
import com.sun.dae.components.lang.CompositeException;
import com.sun.dae.components.util.ExceptionUtil;
import com.sun.dae.components.util.timing.Duratab;
import com.sun.dae.components.util.timing.EventTimer;
import com.sun.dae.components.util.timing.TimedEvent;
import com.sun.dae.components.util.timing.TimedEventControl;
import com.sun.dae.components.util.timing.TimedEventListener;
import com.sun.dae.sdok.ByReference;
import com.sun.dae.sdok.PersistenceException;
import com.sun.esm.library.spcs.dsw.Dsw;
import com.sun.esm.library.spcs.dsw.DswHandle;
import com.sun.esm.mo.MO;
import com.sun.esm.mo.MOImpl;
import com.sun.esm.mo.MOManagerConditionEventObject;
import com.sun.esm.mo.dsw.BitmapFile;
import com.sun.esm.mo.dsw.DswConditionEventObject;
import com.sun.esm.mo.dsw.DswMOBitmapException;
import com.sun.esm.mo.dsw.DswMODupMasterException;
import com.sun.esm.mo.dsw.DswMODupShadowException;
import com.sun.esm.mo.dsw.DswMOPairNotFoundException;
import com.sun.esm.mo.dsw.DswVolException;
import com.sun.esm.mo.dsw.DswVolImpl;
import com.sun.esm.mo.dsw.DswVolImplProxy;
import com.sun.esm.mo.dsw.DswVolsMO;
import com.sun.esm.mo.dsw.DswVolsMOConditionListener;
import com.sun.esm.mo.dsw.DswVolsMOEvent;
import com.sun.esm.mo.dsw.DswVolsMOImplProxy;
import com.sun.esm.mo.dsw.DswVolsMOListener;
import com.sun.esm.mo.sv.SvImplProxy;
import com.sun.esm.util.Boot;
import com.sun.esm.util.Condition;
import com.sun.esm.util.Services;
import com.sun.esm.util.slm.MountUtil;
import com.sun.esm.util.slm.TraceUtil;
import com.sun.esm.util.slm.Traceable;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;

public class DswVolsMOImpl
extends MOImpl
implements DswVolsMO,
TimedEventListener,
Traceable,
Serializable {
    static final long serialVersionUID = 2658008053149966922L;
    private static final Object mutateLock = new Object();
    private boolean debug;
    private boolean verbose;
    private boolean pretend;
    protected DswVolsMOImpl dswVolsMO = null;
    private String version;
    private String hostName = null;
    private BitmapFile bitmapDirectory = null;
    private static final String bitmapFilePrefix = "dsw";
    private final Hashtable dswVolsProxies = new Hashtable();
    private String dswVolsMOName = null;
    private int state;
    private int status;
    private int modifier;
    private int logLevel = 0;
    private TimedEventControl schedule = null;
    private transient EventTimer timer = null;
    private DswHandle handle;
    private static final int DEF_DAQ_INTERVAL = 30000;
    private int daqInterval = 30000;
    private final Delegate volsListenerDelegate = new Delegate(class$com$sun$esm$mo$dsw$DswVolsMOListener != null ? class$com$sun$esm$mo$dsw$DswVolsMOListener : (class$com$sun$esm$mo$dsw$DswVolsMOListener = DswVolsMOImpl.class$("com.sun.esm.mo.dsw.DswVolsMOListener")));
    private final Delegate dswVolsMOConditionListenerDelegate = new Delegate(class$com$sun$esm$mo$dsw$DswVolsMOConditionListener != null ? class$com$sun$esm$mo$dsw$DswVolsMOConditionListener : (class$com$sun$esm$mo$dsw$DswVolsMOConditionListener = DswVolsMOImpl.class$("com.sun.esm.mo.dsw.DswVolsMOConditionListener")));
    static final String sccs_id = "@(#)DswVolsMOImpl.java 1.84    99/10/26 SMI";
    static /* synthetic */ Class class$com$sun$esm$mo$dsw$DswVolsMOListener;
    static /* synthetic */ Class class$com$sun$esm$mo$dsw$DswVolsMOConditionListener;

    public DswVolsMOImpl(String string, String string2) {
        super(string, string2);
        this.dswMOTrace("constructor");
        if (!Boot.isTraceOn()) {
            TraceUtil.setSLMTraceLevel(0);
        }
        this.dswVolsMOName = string;
        this.daqInterval = 30000;
        this.dswVolsMO = this;
        this.debug = System.getProperty("ESMDEBUG") != null;
        this.dswMOTrace("debug = " + this.debug);
        this.verbose = System.getProperty("ESMVERBOSE") != null;
        this.dswMOTrace("verbose = " + this.verbose);
        this.pretend = System.getProperty("com.sun.esm.slm.dsw.DBL") != null;
        this.dswMOTrace("pretend = " + this.pretend);
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.log("`unknown_host`", new Object[0], unknownHostException);
        }
        this.dswMOTrace("Hostname found");
        try {
            this.manage();
        }
        catch (PersistenceException persistenceException) {
            this.log("`manage_persistence`", new Object[0], persistenceException);
        }
        this.scheduleDAQ();
        if (this.state != 1) {
            this.start();
        }
        this.dswMOTrace("state is STARTING");
        this.log("`initial_start`", new Object[0]);
    }

    public void aboutToStop(MOManagerConditionEventObject mOManagerConditionEventObject) {
        this.dswMOTrace("aboutToStop");
    }

    public void addDswVolsMOConditionListener(DswVolsMOConditionListener dswVolsMOConditionListener) {
        this.dswMOTrace("addDswVolsMOConditionListener");
        this.dswVolsMOConditionListenerDelegate.addListener((EventListener)dswVolsMOConditionListener);
        this.pickle();
        this.dswMOTrace("addDswVolsMOConditionListener returning");
    }

    public void addDswVolsMOListener(DswVolsMOListener dswVolsMOListener) {
        this.dswMOTrace("addDswVolsMOListener");
        this.volsListenerDelegate.addListener((EventListener)dswVolsMOListener);
        this.pickle();
        Object object = mutateLock;
        synchronized (object) {
            try {
                this.volsListenerDelegate.send((EventObject)new DswVolsMOEvent(this.getDswVolProxies()), "managedVols", false);
                this.dswMOTrace("addDswVolsMOListener sending managedVols w/proxy[]");
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.log("`send_event`", new Object[]{"managedVols"});
            }
        }
        this.dswMOTrace("addDswVolsMOListener returning");
    }

    public synchronized DswVolImplProxy addSuspendedDswPair(SvImplProxy svImplProxy, SvImplProxy svImplProxy2, String string) throws DswMODupShadowException, DswMOBitmapException, DswVolException {
        DswVolImpl dswVolImpl = null;
        DswVolImplProxy dswVolImplProxy = null;
        BitmapFile bitmapFile = null;
        this.dswMOTrace("createSuspendedDswPair");
        if (this.dswVolsProxies.containsKey(svImplProxy2.getVolName())) {
            this.dswMOTrace(String.valueOf(svImplProxy2.getVolName()) + " shadow exists");
            throw new DswMODupShadowException(svImplProxy.getVolName(), svImplProxy2.getVolName());
        }
        if (string == null) {
            this.dswMOTrace("no bitmap file specified");
            throw new DswMOBitmapException("bitmapFile");
        }
        this.dswMOTrace("bitmap supplied");
        bitmapFile = new BitmapFile(string);
        bitmapFile.setBitmapSupplied();
        this.dswMOTrace("create a Vol instance ");
        dswVolImpl = new DswVolImpl(svImplProxy, svImplProxy2, bitmapFile);
        dswVolImplProxy = (DswVolImplProxy)dswVolImpl.newProxy();
        this.dswMOTrace("register Vol handles");
        dswVolImpl.dswVolRegisterHandle();
        dswVolImpl.changingDswVolModifier(12);
        this.dswVolsProxies.put(svImplProxy2.getVolName(), dswVolImplProxy);
        this.pickle();
        this.printDswPairs("addSuspendedDswPair");
        this.dswMOTrace("sending proxy to volsManaged listeners");
        try {
            this.volsListenerDelegate.send((EventObject)new DswVolsMOEvent(dswVolImplProxy), "volsManaged", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswMOTrace("Illegal Access exception " + illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswMOTrace("No such method exception " + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswMOTrace("Invocation Exception " + invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            this.dswMOTrace("Exception caught " + nullPointerException);
        }
        this.dswMOTrace("addSuspendedDswPair returning proxy " + dswVolImplProxy);
        return dswVolImplProxy;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean createBitmapDirectory(String string) {
        this.dswMOTrace("DswVolsMOImpl createBitmapDirectory method ");
        BitmapFile bitmapFile = new BitmapFile(string);
        if (!bitmapFile.createBitmapDirectory(string)) {
            this.log("`bitmap_createerr`", new Object[]{string});
            return false;
        }
        if (!bitmapFile.getBitmapFileObj().canRead() || !bitmapFile.getBitmapFileObj().canWrite()) {
            this.log("`bitmap_accesserr`", new Object[]{string});
            return false;
        }
        this.bitmapDirectory = bitmapFile;
        return true;
    }

    public synchronized DswVolImplProxy createDswPair(SvImplProxy svImplProxy, SvImplProxy svImplProxy2, boolean bl, String string) throws DswMODupMasterException, DswMODupShadowException, DswMOBitmapException, DswVolException {
        DswVolImpl dswVolImpl = null;
        DswVolImplProxy dswVolImplProxy = null;
        BitmapFile bitmapFile = null;
        this.dswMOTrace("createDswPair");
        if (this.dswVolsProxies.containsKey(svImplProxy2.getVolName()) || this.dswVolsProxies.containsKey(svImplProxy.getVolName())) {
            this.dswMOTrace(String.valueOf(svImplProxy2.getVolName()) + " shadow exists");
            throw new DswMODupShadowException(svImplProxy.getVolName(), svImplProxy2.getVolName());
        }
        DswVolImplProxy dswVolImplProxy2 = null;
        Enumeration enumeration = this.dswVolsProxies.elements();
        while (enumeration.hasMoreElements()) {
            dswVolImplProxy2 = (DswVolImplProxy)enumeration.nextElement();
            if (svImplProxy.getVolName().compareTo(dswVolImplProxy2.getMasterProxy().getVolName()) != 0 && svImplProxy2.getVolName().compareTo(dswVolImplProxy2.getMasterProxy().getVolName()) != 0) continue;
            this.dswMOTrace(String.valueOf(svImplProxy2.getVolName()) + " shadow exists as master");
            throw new DswMODupMasterException(svImplProxy.getVolName(), svImplProxy2.getVolName());
        }
        if (string == null) {
            this.dswMOTrace("make the bitmap file");
            bitmapFile = new BitmapFile(null);
            if (this.bitmapDirectory == null) {
                throw new DswMOBitmapException("bitmapDirectory");
            }
            if (!bitmapFile.createBitmapFile(bitmapFilePrefix, this.bitmapDirectory.getBitmapFileObj())) {
                throw new DswMOBitmapException("bitmapDirectory");
            }
            if (!bitmapFile.expandBitmapFile((long)svImplProxy.getVolSize() * 512L)) {
                throw new DswMOBitmapException("bitmapDirectory");
            }
        } else {
            this.dswMOTrace("bitmap supplied");
            bitmapFile = new BitmapFile(string);
            bitmapFile.setBitmapSupplied();
        }
        this.dswMOTrace("make a Vol instance");
        dswVolImpl = new DswVolImpl(svImplProxy, svImplProxy2, bitmapFile);
        dswVolImplProxy = (DswVolImplProxy)dswVolImpl.newProxy();
        this.dswMOTrace("register Vol handle");
        dswVolImpl.dswVolRegisterHandle();
        if (bl) {
            this.dswMOTrace("calling vol fullCopyEnableNoWait");
            dswVolImpl.fullCopyEnableNoWait();
            try {
                try {
                    Thread.sleep(1500L);
                }
                catch (Exception exception) {}
                this.dswMOTrace("calling tryEnabling to check for open error");
                dswVolImpl.tryEnabling();
            }
            catch (DswVolException dswVolException) {
                this.dswMOTrace("DswVolException " + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
                if (bitmapFile.wasBitmapSupplied()) {
                    this.dswMOTrace("bitmap was supplied; not deleted");
                } else {
                    this.dswMOTrace("deleting bitmap file");
                    if (!bitmapFile.deleteBitmapFile()) {
                        this.dswMOTrace("problem deleting bitmap file");
                    }
                }
                dswVolImpl.dispose();
                dswVolImpl = null;
                dswVolImplProxy = null;
                throw dswVolException;
            }
        }
        try {
            dswVolImpl.enable();
        }
        catch (DswVolException dswVolException) {
            this.dswMOTrace("DswVolException " + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
            if (bitmapFile.wasBitmapSupplied()) {
                this.dswMOTrace("bitmap was supplied; not deleted");
            } else {
                this.dswMOTrace("deleting bitmap file");
                if (!bitmapFile.deleteBitmapFile()) {
                    this.dswMOTrace("problem deleting bitmap file");
                }
            }
            dswVolImpl.dispose();
            dswVolImpl = null;
            dswVolImplProxy = null;
            throw dswVolException;
        }
        this.dswMOTrace("add to hash table");
        this.dswVolsProxies.put(svImplProxy2.getVolName(), dswVolImplProxy);
        this.pickle();
        this.dswMOTrace("send proxy to all listeners");
        try {
            this.volsListenerDelegate.send((EventObject)new DswVolsMOEvent(dswVolImplProxy), "volsManaged", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswMOTrace("IllegalAccessException " + illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswMOTrace("DswPair(create): No such method exception " + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswMOTrace("DswPair(create): Invocation Exception " + invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            ExceptionUtil.printException((String)"DswPair(create): Exception caught ", (Throwable)nullPointerException);
        }
        this.dswMOTrace("createDswPair returning proxy " + dswVolImplProxy);
        return dswVolImplProxy;
    }

    public synchronized void deleteDswPair(DswVolImplProxy dswVolImplProxy) throws DswMOPairNotFoundException, DswVolException {
        if (this.dswVolsProxies.containsKey(dswVolImplProxy.getShadowProxy().getVolName())) {
            this.dswMOTrace("deleteDswPair");
            try {
                this.dswMOTrace("calling Vol disable");
                dswVolImplProxy.disable();
            }
            catch (DswVolException dswVolException) {
                this.dswMOTrace("DswVolException " + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
                throw dswVolException;
            }
            dswVolImplProxy.dispose();
            this.dswMOTrace("sending volsUnManaged notification to listeners");
            try {
                this.volsListenerDelegate.send((EventObject)new DswVolsMOEvent(dswVolImplProxy), "volsUnManaged", true);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.dswMOTrace("Illegal Access exception ");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.dswMOTrace("No such method exception ");
            }
            catch (InvocationTargetException invocationTargetException) {
                this.dswMOTrace("Invocation Exception ");
            }
            catch (NullPointerException nullPointerException) {
                ExceptionUtil.printException((String)"Null Exception", (Throwable)nullPointerException);
            }
            if (dswVolImplProxy.getBitmapFile().wasBitmapSupplied()) {
                this.dswMOTrace("bitmap was supplied; not deleted");
            } else {
                this.dswMOTrace("deleting bitmap file");
                if (!dswVolImplProxy.getBitmapFile().deleteBitmapFile()) {
                    this.dswMOTrace("problem deleting bitmap file");
                }
            }
        } else {
            throw new DswMOPairNotFoundException(dswVolImplProxy.getMasterProxy().getVolName(), dswVolImplProxy.getShadowProxy().getVolName());
        }
        this.dswVolsProxies.remove(dswVolImplProxy.getShadowProxy().getVolName());
        this.printDswPairs("pairs remaining");
        this.pickle();
        this.dswMOTrace("releasing proxy " + dswVolImplProxy);
        dswVolImplProxy = null;
        this.dswMOTrace("deleteDswPair returning");
    }

    public void diagnose() {
    }

    private void dswMOTrace(String string) {
        TraceUtil.trace(string, this.getClass().getName());
    }

    public void eventTimed(TimedEvent timedEvent) {
        this.performDAQ();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void finalizer() throws Throwable {
        super.finalize();
    }

    public Condition getCondition() {
        return new Condition(this.state, this.modifier, this.status);
    }

    public int getDAQInterval() {
        return this.daqInterval;
    }

    public DswVolImplProxy[] getDswVolProxies() {
        this.dswMOTrace("getDswVolProxies");
        DswVolImplProxy[] dswVolImplProxyArray = new DswVolImplProxy[this.dswVolsProxies.size()];
        Enumeration enumeration = this.dswVolsProxies.elements();
        int n = 0;
        while (n < this.dswVolsProxies.size()) {
            dswVolImplProxyArray[n] = (DswVolImplProxy)enumeration.nextElement();
            dswVolImplProxyArray[n].print("getDswVolProxies");
            ++n;
        }
        return dswVolImplProxyArray;
    }

    public String getMOName() {
        this.dswMOTrace("getMOName = " + this.dswVolsMOName);
        return this.dswVolsMOName;
    }

    public int getSLMTraceLevel() {
        return TraceUtil.getSLMTraceLevel();
    }

    public int getState() {
        return this.state;
    }

    public String getVersionLib() {
        return this.version;
    }

    public void hydrate() {
        this.log("`hydrate_start`", new Object[0]);
        super.hydrate();
        this.dswMOTrace("hydrate");
        if (!Boot.isTraceOn()) {
            TraceUtil.setSLMTraceLevel(0);
        }
        this.state = 1;
        this.modifier = 1;
        this.status = 1;
        this.scheduleDAQ();
        this.log("`hydrate_finish`", new Object[0]);
        this.dswMOTrace("hydrate returning");
    }

    public boolean isDswVolsMOConditionListener(DswVolsMOConditionListener dswVolsMOConditionListener) {
        this.dswMOTrace("isDswVolsMOConditionListener");
        return this.dswVolsMOConditionListenerDelegate.isListener((EventListener)dswVolsMOConditionListener);
    }

    public boolean isDswVolsMOListener(DswVolsMOListener dswVolsMOListener) {
        this.dswMOTrace("isDswVolsMOListener");
        return this.volsListenerDelegate.isListener((EventListener)dswVolsMOListener);
    }

    public boolean isMounted(String string) {
        return MountUtil.isMounted(string);
    }

    public boolean isSLMTraceOn() {
        return TraceUtil.isSLMTraceOn();
    }

    private void log(String string, Object[] objectArray) {
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`");
    }

    private void log(String string, Object[] objectArray, Throwable throwable) {
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`", (Throwable)throwable);
    }

    protected MO newProxy() {
        if (this.proxy == null) {
            this.proxy = (MO)ByReference.wrap((Object)this);
        }
        return this.proxy;
    }

    public synchronized void performDAQ() {
        Hashtable hashtable = (Hashtable)this.dswVolsProxies.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((DswVolImplProxy)enumeration.nextElement()).performVolDAQ();
            }
            catch (Exception exception) {}
        }
    }

    protected void pickle() {
        this.dswMOTrace("pickle");
        try {
            super.pickle();
        }
        catch (PersistenceException persistenceException) {
            this.dswMOTrace("pickle PersistenceException");
        }
    }

    public void printDswPairs(String string) {
        this.dswMOTrace(string);
        Enumeration enumeration = this.dswVolsProxies.keys();
        while (enumeration.hasMoreElements()) {
            this.dswMOTrace(enumeration.nextElement().toString());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void removeDswVolsMOConditionListener(DswVolsMOConditionListener dswVolsMOConditionListener) {
        this.dswMOTrace("removeDswVolsMOConditionListener");
        this.dswVolsMOConditionListenerDelegate.removeListener((EventListener)dswVolsMOConditionListener);
        this.pickle();
        this.dswMOTrace("removeDswVolsMOConditionListener returning");
    }

    public void removeDswVolsMOListener(DswVolsMOListener dswVolsMOListener) {
        this.dswMOTrace("removeDswVolsMOListener");
        this.volsListenerDelegate.removeListener((EventListener)dswVolsMOListener);
        this.pickle();
        this.dswMOTrace("removeDswVolsMOListener returning");
    }

    public void running(MOManagerConditionEventObject mOManagerConditionEventObject) {
        this.dswMOTrace("running");
    }

    protected void scheduleDAQ() {
        this.schedule = new Duratab();
        this.schedule.setMode(4);
        ((Duratab)this.schedule).setDuration((long)this.daqInterval);
        this.timer = new EventTimer((TimedEventListener)this, this.schedule);
    }

    public void setDAQInterval(int n) {
        this.daqInterval = n;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public void setSLMTrace(boolean bl) {
        TraceUtil.setSLMTrace(bl);
    }

    public void setSLMTraceLevel(int n) {
        TraceUtil.setSLMTraceLevel(n);
    }

    public void setup() {
    }

    public void shutdown() {
        this.dswMOTrace("shutdown");
        DswHandle dswHandle = new DswHandle();
        Dsw dsw = new Dsw();
        Hashtable hashtable = (Hashtable)this.dswVolsProxies.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DswVolImplProxy)enumeration.nextElement()).stopping();
        }
        try {
            if (!this.pretend) {
                dswHandle.register();
                dsw.shutdown(dswHandle);
                dswHandle.release();
                this.log("`shutdown_appliance`", new Object[0]);
            } else {
                this.dswMOTrace("request ignored");
            }
        }
        catch (CompositeException compositeException) {
            this.dswMOTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
            this.log("`shutdown_appliance`", new Object[0], compositeException);
        }
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            ((DswVolImplProxy)enumeration2.nextElement()).stopped();
        }
        this.dswMOTrace("shutdown returning");
    }

    public void start() {
        try {
            try {
                this.state = 1;
                this.modifier = 1;
                this.status = 1;
                if (this.dswVolsMOConditionListenerDelegate != null) {
                    this.dswVolsMOConditionListenerDelegate.send((EventObject)((Object)new DswConditionEventObject((DswVolsMOImplProxy)this.getProxy(), this.getCondition())), "isRunning", true);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.dswMOTrace("IllegalAccessException");
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.dswMOTrace("NoSuchMethodException");
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.dswMOTrace("InvocationTargetException");
                invocationTargetException.printStackTrace();
            }
            Object var2_4 = null;
            this.dswMOTrace("start returning");
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.dswMOTrace("start returning");
            throw throwable;
        }
    }

    public void starting(MOManagerConditionEventObject mOManagerConditionEventObject) {
        this.dswMOTrace("starting");
    }

    public void stop() {
        try {
            try {
                this.state = 10;
                if (this.dswVolsMOConditionListenerDelegate != null) {
                    this.dswVolsMOConditionListenerDelegate.send((EventObject)((Object)new DswConditionEventObject((DswVolsMOImplProxy)this.getProxy(), this.getCondition())), "isStopping", true);
                }
                this.state = 2;
                if (this.dswVolsMOConditionListenerDelegate != null) {
                    this.dswVolsMOConditionListenerDelegate.send((EventObject)((Object)new DswConditionEventObject((DswVolsMOImplProxy)this.getProxy(), this.getCondition())), "isStopped", true);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.dswMOTrace("IllegalAccessException");
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.dswMOTrace("NoSuchMethodException");
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.dswMOTrace("InvocationTargetException");
                invocationTargetException.printStackTrace();
            }
            Object var2_4 = null;
            this.dswMOTrace("start returning");
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.dswMOTrace("start returning");
            throw throwable;
        }
    }

    public void stopped(MOManagerConditionEventObject mOManagerConditionEventObject) {
        this.dswMOTrace("stopped");
    }

    public void stopping(MOManagerConditionEventObject mOManagerConditionEventObject) {
        this.dswMOTrace("stopping");
    }
}

