# Copyright 09 May 1998 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident   "@(#)kernel-reader-ruleinit-d.x 1.8     00/08/08 SMI"

_rules = {
        rule:rknrd100-group = Kernel Reader
        rule:rknrd100-version = 0.1
        rule:rknrd100-shortmsg = Disk Busy & increasing wait queue
        rule:rknrd100-longmsg = Disk busy with an increasing wait queue
        rule:rknrd100-editparm = busy-th1 queue-length1 busy-th2 queue-length2
        rule:rknrd100-keypath = base.modules.kernel-reader
        ruledatatype:rknrd100-busy-th1 = "uint"
        ruledatatype:rknrd100-queue-length1 = "uint"
        ruledatatype:rknrd100-busy-th2 = "uint"
        ruledatatype:rknrd100-queue-length2 = "uint"
        alarmlimit:rknrd100-busy-th1 = 70
        alarmlimit:rknrd100-queue-length1 = 8
        alarmlimit:rknrd100-busy-th2 = 75
        alarmlimit:rknrd100-queue-length2 = 10

        rule:rknrd102-group = Kernel Reader
        rule:rknrd102-version = 0.1
        rule:rknrd102-shortmsg = Swap space in use
        rule:rknrd102-longmsg = Swap space in use
        rule:rknrd102-editparm = swap-used1 swap-used2
        rule:rknrd102-keypath = base.modules.kernel-reader
        ruledatatype:rknrd102-swap-used1 = "uint"
        ruledatatype:rknrd102-swap-used2 = "uint"
        alarmlimit:rknrd102-swap-used1 = 90
        alarmlimit:rknrd102-swap-used2 = 80
        
        rule:rknrd103-group = Kernel Reader
        rule:rknrd103-version = 0.1
        rule:rknrd103-shortmsg = CPU usage
        rule:rknrd103-longmsg = CPU usage
        rule:rknrd103-editparm = pagein1 pageout1 pagein2 pageout2
        rule:rknrd103-keypath = base.modules.kernel-reader
        ruledatatype:rknrd103-pagein1 = "uint"
        ruledatatype:rknrd103-pageout1 = "uint"
        ruledatatype:rknrd103-pagein2 = "uint"
        ruledatatype:rknrd103-pageout2 = "uint"
        alarmlimit:rknrd103-pagein1 = 10
        alarmlimit:rknrd103-pageout1 = 10
        alarmlimit:rknrd103-pagein2 = 8
        alarmlimit:rknrd103-pageout2 = 8

        rule:rknrd104-group = Kernel Reader
        rule:rknrd104-version = 0.1
        rule:rknrd104-shortmsg = CPU Load
        rule:rknrd104-longmsg = CPU Load
        rule:rknrd104-editparm = load1 runq1 load2 runq2
        rule:rknrd104-keypath = base.modules.kernel-reader
        ruledatatype:rknrd104-load1 = "uint"
        ruledatatype:rknrd104-runq1 = "uint"
        ruledatatype:rknrd104-load2 = "uint"
        ruledatatype:rknrd104-runq2 = "uint"
        alarmlimit:rknrd104-load1 = 5
        alarmlimit:rknrd104-runq1 = 4
        alarmlimit:rknrd104-load2 = 10
        alarmlimit:rknrd104-runq2 = 2

        rule:rknrd105-group = Kernel Reader
        rule:rknrd105-version = 0.1
        rule:rknrd105-shortmsg = FileSystem Full
        rule:rknrd105-longmsg = FileSystem Full
        rule:rknrd105-keypath = base.modules.kernel-reader

        rule:rknrd106-group = Kernel Reader
        rule:rknrd106-version = 0.1
        rule:rknrd106-shortmsg = No Swap Space
        rule:rknrd106-longmsg = No Swap Space
        rule:rknrd106-keypath = base.modules.kernel-reader

        rule:rknrd400-group = Kernel Reader
        rule:rknrd400-version = 0.1
        rule:rknrd400-shortmsg = CPU Load
        rule:rknrd400-longmsg = CPU Load: Checks for continuous CPU load over 6 per CPU for 4 hours
        rule:rknrd400-editparm = cpuload-thresh
        rule:rknrd400-keypath = base.modules.kernel-reader
        ruledatatype:rknrd400-cpuload-thresh = "uint"
        alarmlimit:rknrd400-cpuload-thresh = 6

        rule:rknrd401-group = Kernel Reader
        rule:rknrd401-version = 0.1
        rule:rknrd401-shortmsg = Disk Busy
        rule:rknrd401-longmsg = Disk busy: more than 90% of the file for 4 hours
        rule:rknrd401-editparm = disk-thresh
        rule:rknrd401-keypath = base.modules.kernel-reader
        ruledatatype:rknrd401-disk-thresh = "uint"
        alarmlimit:rknrd401-disk-thresh = 90

        rule:rknrd402-group = Kernel Reader
        rule:rknrd402-version = 0.1
        rule:rknrd402-shortmsg = Swap Rule
        rule:rknrd402-longmsg = Swap low: below 10% for 2 hours
        rule:rknrd402-editparm = swap-thresh
        rule:rknrd402-keypath = base.modules.kernel-reader
        ruledatatype:rknrd402-swap-thresh = "float"
        alarmlimit:rknrd402-swap-thresh = 10.0

        rule:rknrd403-group = Kernel Reader
        rule:rknrd403-version = 0.1
        rule:rknrd403-shortmsg = Meta CPU event
        rule:rknrd403-longmsg = Meta CPU event 
        rule:rknrd403-keypath = base.modules.kernel-reader

        rule:rknrd404-group = Kernel Reader
        rule:rknrd404-version = 0.1
        rule:rknrd404-shortmsg = Meta Disk event
        rule:rknrd404-longmsg = Meta DisK event 
        rule:rknrd404-keypath = base.modules.kernel-reader

        rule:rknrd405-group = Kernel Reader
        rule:rknrd405-version = 0.1
        rule:rknrd405-shortmsg = Meta Swap event
        rule:rknrd405-longmsg = Meta Swap event 
        rule:rknrd405-keypath = base.modules.kernel-reader


        rule:rknrd204-group = Kernel Reader
        rule:rknrd204-version = 0.1
        rule:rknrd204-shortmsg = UE Error
        rule:rknrd204-longmsg = Uncorrectable Memory Error
        rule:rknrd204-keypath = base.modules.kernel-reader

        rule:rknrd205-group = Kernel Reader
        rule:rknrd205-version = 0.1
        rule:rknrd205-shortmsg = CE Error
        rule:rknrd205-longmsg = Corrected Memory Error
        rule:rknrd205-keypath = base.modules.kernel-reader

}
