/*
 * Copyright (c) 1995, 1997-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_TSOL_TPROC_H
#define	_SYS_TSOL_TPROC_H

#pragma ident	"@(#)tproc.h	7.5	01/01/04 SMI; TSOL 2.x"

#include <sys/mutex.h>
#include <sys/proc.h>
#include <sys/tsol/label.h>
#include <sys/tsol/priv.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define	TPROC_EXT_VERS	1		/* uses version 1 extensions */

/*
 * Process Privilege Extension Structure
 */
typedef struct proc_privs {
	priv_set_t prpriv_forced;	/* forced set of executable */
	priv_set_t prpriv_allowed;	/* allowed set of executable */
	priv_set_t prpriv_new_privs;	/* new priv set of exec */
} proc_privs_t;

extern ext_key_t	proc_priv_key;

#define	PR_PRIVS(p)	((proc_privs_t *)procx_get(p, proc_priv_key))
#define	PR_FORCED(p)	(&(PR_PRIVS(p)->prpriv_forced))
#define	PR_ALLOWED(p)	(&(PR_PRIVS(p)->prpriv_allowed))
#define	PR_NEWPRIVS(p)	(&(PR_PRIVS(p)->prpriv_new_privs))

/*
 * Process Miscellaneous Extension Structure
 */
typedef struct tsol_proc_misc {
	uint32_t	tpr_flags;		/* tproc flags */
	uid_t		tpr_start_uid;		/* starting effective uid */
} tsol_proc_misc_t;

extern ext_key_t	proc_misc_key;

/*
 * Macro to access miscellaneous structure
 */
#define	PR_MISC(p)	((tsol_proc_misc_t *)procx_get(p, proc_misc_key))

/*
 *	values for tpr_flags
 */
#define	TPR_TRANQUIL	0x00000001	/* require process SL stable */
#define	TPR_PRIV	0x00000002	/* is exec()ing image priv'd? */
#define	TPR_EXEC_PRIV	0x00000004	/* is new image priv'd? */
#define	TPR_VNODE_PRIV	0x00000008	/* new image privs from vnode? */

#ifdef	_KERNEL
extern void	tproc_init(void);
extern void	tproc_tranquil_lock(struct proc *);
extern void	tproc_tranquil_unlock(struct proc *);
#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_TSOL_TPROC_H */
