/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.ConfigurationException;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Locale;

public class ConfigManagement {
    protected static String configDir = "toolboxes/";
    protected static String configDirAbs;
    protected static String configDirRemote;
    protected static Hashtable defaultConfigNames;

    static {
        try {
            String string = System.getProperty("viper.rthome");
            File file = new File(String.valueOf(string) + "/" + configDir);
            configDirAbs = String.valueOf(file.getAbsolutePath()) + "/";
            if (file.exists()) {
                if (!file.isDirectory()) {
                    file.delete();
                    file.mkdir();
                } else {
                    file.mkdirs();
                }
            }
            if (System.getProperty("viper.server.url") != null) {
                configDirRemote = String.valueOf(System.getProperty("viper.server.url")) + configDir;
            }
        }
        catch (AccessControlException accessControlException) {
            configDirAbs = null;
            configDirRemote = null;
        }
        defaultConfigNames = new Hashtable(3);
        defaultConfigNames.put("TC_APPLICATION_GUI", "this_computer");
        defaultConfigNames.put("TC_APPLICATION_NONGUI", "default_cli");
        defaultConfigNames.put("TC_APPLET_GUI", "default_applet");
    }

    private ConfigManagement() {
    }

    public static void add(String string, String string2, Locale locale) throws ConfigurationException {
        try {
            File file = new File(ConfigManagement.getConfigPath(string2, locale));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Failed to create configuration " + string2, iOException);
        }
    }

    public static String aliasifyPath(String string) {
        if (!string.endsWith(".tbx")) {
            return string;
        }
        string = string.substring(0, string.lastIndexOf(".tbx"));
        int n = -1;
        int n2 = string.lastIndexOf(47);
        String string2 = "";
        String string3 = string.substring(n2 + 1);
        if (n2 != -1 && (string2 = string.substring((n = string.lastIndexOf(47, n2 - 1)) + 1, n2)).equals(string3)) {
            string = string.substring(0, n2);
        }
        string = String.valueOf(string) + ".tbx";
        return string;
    }

    public static URL aliasifyURL(URL uRL) {
        URL uRL2;
        if (uRL == null || !uRL.toString().startsWith("http")) {
            return uRL;
        }
        String string = uRL.getFile();
        string = ConfigManagement.aliasifyPath(string);
        try {
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static void delete(String string, Locale locale) throws ConfigurationException {
        File file = new File(ConfigManagement.getConfigPath(string, locale));
        file.delete();
    }

    public static String getConfigPath(String string, Locale locale) {
        return String.valueOf(configDirAbs) + ConfigManagement.getFilename(string, locale);
    }

    public static String getConfigURL(String string, Locale locale) {
        return String.valueOf(configDirRemote) + ConfigManagement.getFilename(string, locale);
    }

    public static String getDTDLocation(URL uRL) {
        if (uRL == null) {
            return ConfigManagement.getFileURL("toolbox.dtd");
        }
        if (!uRL.getProtocol().equals("http")) {
            return "file:" + ConfigManagement.getFilePath("toolbox.dtd");
        }
        if (configDirRemote != null) {
            return ConfigManagement.getFileURL("toolbox.dtd");
        }
        return String.valueOf(uRL.getProtocol()) + "://" + uRL.getHost() + (uRL.getPort() != -1 ? ":" + uRL.getPort() : "") + "/toolboxes/toolbox.dtd";
    }

    public static String getDefaultId(String string) throws ConfigurationException {
        return (String)defaultConfigNames.get(string);
    }

    public static String getFilePath(String string) {
        return String.valueOf(configDirAbs) + string;
    }

    public static String getFileURL(String string) {
        return String.valueOf(configDirRemote) + string;
    }

    protected static String getFilename(VBaseConfiguration vBaseConfiguration, Locale locale) {
        return ConfigManagement.getFilename(vBaseConfiguration.getID(), locale);
    }

    protected static String getFilename(String string, Locale locale) {
        String string2;
        int n = string.lastIndexOf(47);
        String string3 = "";
        if (n != -1) {
            string3 = String.valueOf(string.substring(0, n)) + "/";
            string = string.substring(n + 1);
        }
        if (locale == null) {
            return String.valueOf(string3) + string + "/" + string + ".tbx";
        }
        int n2 = 0;
        String string4 = locale.getVariant();
        if (string4 == null || string4.length() == 0) {
            ++n2;
        }
        if ((string2 = locale.getCountry()) == null || string2.length() == 0) {
            ++n2;
        }
        String string5 = "";
        int n3 = n2;
        while (n3 < 5) {
            string5 = String.valueOf(string3) + string + "/" + string + ConfigManagement.getLocaleSuffix(locale, n3) + ".tbx";
            File file = new File(String.valueOf(configDirAbs) + string5);
            if (file.exists()) break;
            ++n3;
        }
        return string5;
    }

    protected static String getLocaleSuffix(Locale locale, int n) {
        switch (n) {
            case 0: {
                return "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
            }
            case 1: {
                return "_" + locale.getLanguage() + "_" + locale.getCountry();
            }
            case 2: {
                return "_" + locale.getLanguage();
            }
            case 3: {
                return "_C";
            }
        }
        return "";
    }

    public static URL getURL(String string, Locale locale) throws ConfigurationException {
        try {
            return new URL(ConfigManagement.getConfigURL(string, locale));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("Failed to construct configuration URL for " + string, malformedURLException);
        }
    }

    protected static boolean isAliasedPath(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        int n2 = string2.indexOf(".tbx");
        if (n2 == -1) {
            return false;
        }
        string2 = string2.substring(0, n2);
        return !string3.endsWith(string2);
    }

    public static VConfigurationInfo list(String string, Locale locale, boolean bl) throws ConfigurationException {
        try {
            URL uRL = bl ? new URL(ConfigManagement.getConfigURL(string, locale)) : new File(ConfigManagement.getConfigPath(string, locale)).toURL();
            VConfigurationInfo vConfigurationInfo = VBaseConfiguration.createConfiguration(uRL, false).getInfo();
            vConfigurationInfo.setId(string);
            return vConfigurationInfo;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Failed to list configuration \"" + string + "\"", exception);
        }
        catch (Throwable throwable) {
            throw new ConfigurationException("Failed to list configuration \"" + string + "\"");
        }
    }

    public static VConfigurationInfo[] list(Locale locale, boolean bl) throws ConfigurationException {
        Object object;
        File file = new File(configDirAbs);
        String[] stringArray = file.list(new ConfigFilenameFilter(locale));
        VConfigurationInfo[] vConfigurationInfoArray = stringArray == null ? new VConfigurationInfo[]{} : new VConfigurationInfo[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < vConfigurationInfoArray.length) {
            try {
                object = bl ? new URL(ConfigManagement.getConfigURL(stringArray[n2], locale)) : new File(ConfigManagement.getConfigPath(stringArray[n2], locale)).toURL();
                VConfigurationInfo vConfigurationInfo = VBaseConfiguration.createConfiguration((URL)object, false).getInfo();
                vConfigurationInfo.setId(stringArray[n2]);
                vConfigurationInfoArray[n2] = vConfigurationInfo;
            }
            catch (MalformedURLException malformedURLException) {
                ++n;
                Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)("Failed to list configuration " + stringArray[n2]), (Throwable)malformedURLException);
            }
            catch (ConfigurationException configurationException) {
                ++n;
                Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)("Failed to list configuration " + stringArray[n2]), (Throwable)((Object)configurationException));
            }
            ++n2;
        }
        if (n == 0) {
            return vConfigurationInfoArray;
        }
        object = new VConfigurationInfo[vConfigurationInfoArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < vConfigurationInfoArray.length && n4 < ((VConfigurationInfo[])object).length) {
            if (vConfigurationInfoArray[n3] != null) {
                object[n4++] = vConfigurationInfoArray[n3];
            }
            ++n3;
        }
        return object;
    }

    public static String unaliasifyPath(String string) {
        if (!string.endsWith(".tbx")) {
            return string;
        }
        string = string.substring(0, string.lastIndexOf(".tbx"));
        int n = string.lastIndexOf(47);
        String string2 = string.substring(n + 1);
        string = String.valueOf(string) + "/" + string2 + ".tbx";
        return string;
    }

    public static URL unaliasifyURL(URL uRL) {
        URL uRL2;
        if (uRL == null || !uRL.toString().startsWith("http")) {
            return uRL;
        }
        String string = uRL.getFile();
        if (!ConfigManagement.isAliasedPath(string)) {
            return uRL;
        }
        string = ConfigManagement.unaliasifyPath(string);
        try {
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    protected static class ConfigFilenameFilter
    implements FilenameFilter {
        private Locale locale;

        public ConfigFilenameFilter(Locale locale) {
            this.locale = locale;
        }

        public boolean accept(File file, String string) {
            File file2;
            File file3 = new File(String.valueOf(String.valueOf(file)) + "/" + string);
            return file3.isDirectory() && (file2 = new File(String.valueOf(String.valueOf(file)) + "/" + ConfigManagement.getFilename(string, this.locale))).exists();
        }
    }
}

