/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.tsol.client.ClearanceBuilderDialog;
import com.sun.admin.tsol.client.LabelBuilderDialog;
import com.sun.admin.tsol.client.PrivilegeDialog;
import com.sun.admin.tsol.common.BadLabelException;
import com.sun.admin.tsol.common.BadPrivilegeException;
import com.sun.admin.tsol.common.UserSecurityInfo;
import com.sun.admin.tsol.server.TrustedSolarisServiceInterface;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.RightActProps;
import com.sun.admin.usermgr.client.rbac.RightCmdProps;
import com.sun.admin.usermgr.common.ExecAttrObj;
import com.sun.management.viper.Service;
import com.sun.management.viper.ToolInfrastructure;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class RightCmdAttrDlg
extends AdminDialog {
    private AdminDialog rightCmdAttrDlg;
    private GenInfoPanel infoPanel;
    private JTextField cmdOrDirField;
    private JRadioButton userEffectiveTypeBtn;
    private JRadioButton userRealTypeBtn;
    private JRadioButton groupEffectiveTypeBtn;
    private JRadioButton groupRealTypeBtn;
    private ButtonGroup userTypeBtnGroup;
    private ButtonGroup groupTypeBtnGroup;
    private JComboBox userComboBox;
    private JComboBox groupComboBox;
    private JButton applyBtn;
    private JButton resetBtn;
    private JButton closeBtn;
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private boolean userSpecifyEffective = true;
    private boolean groupSpecifyEffective = true;
    private boolean lastUserSpecifyEffective = true;
    private boolean lastGroupSpecifyEffective = true;
    private String currSelectedUid = "";
    private String currSelectedGid = "";
    private String lastSelectedUid;
    private String lastSelectedGid;
    private String[][] uidList = new String[][]{{"root", "0"}, {"daemon", "1"}, {"bin", "2"}, {"sys", "3"}, {"adm", "4"}, {"lp", "71"}, {"uucp", "5"}};
    private String[][] gidList = new String[][]{{"root", "0"}, {"other", "1"}, {"bin", "2"}, {"sys", "3"}, {"adm", "4"}, {"uucp", "5"}, {"lp", "8"}, {"mail", "6"}, {"sysadmin", "14"}, {"tty", "7"}};
    private ExecAttrObj targetExecAttr;
    private ActionString actionString;
    private JTextArea minLabelField;
    private JTextArea clearanceField;
    private JTextArea privField;
    private JButton minLabelBtn;
    private JButton clearanceBtn;
    private JButton privBtn;
    private JScrollPane newScrollPane;
    private String policy = null;
    private String userName = null;
    private JFrame topFrame = null;
    private ToolInfrastructure tInf = null;
    private UMgrPropsPanel propsDlg;
    private static final String TSOL_LABEL = "label";
    private static final String TSOL_CLEARANCE = "clearance";
    private static final String TSOL_PRIVS = "privs";
    private TrustedSolarisServiceInterface labelService = null;
    private LabelBuilderDialog labelBuilderDlg = null;
    private ClearanceBuilderDialog clearanceBuilderDlg = null;
    private PrivilegeDialog privilegeDlg = null;
    private static final String TSOL_ALL_PRIVS = "all";
    private static final String TSOL_INVALID_VALUE = "*****";
    private String lastSelectedLabel;
    private String lastSelectedClearance;
    private String lastSelectedPrivilege;
    private String currSelectedLabel = "";
    private String currSelectedClearance = "";
    private String currSelectedPrivilege = "";

    public RightCmdAttrDlg(VUserMgr vUserMgr, Dialog dialog, UMgrPropsPanel uMgrPropsPanel) {
        super(dialog, "Set Security Attributes");
        this.rightCmdAttrDlg = this;
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.infoPanel = this.getInfoPanel();
        this.policy = vUserMgr.getApplicationContext().getExecPolicy();
        if (this.policy.equals("tsol")) {
            this.userName = vUserMgr.getAuthenticatedUser();
            this.topFrame = vUserMgr.getFrame();
            this.tInf = vUserMgr.getToolInfrastructure();
            try {
                this.labelService = (TrustedSolarisServiceInterface)this.tInf.getServiceByName("com.sun.admin.tsol.server.TrustedSolarisService");
            }
            catch (Exception exception) {
                vUserMgr.reportErrorException(exception);
                return;
            }
        }
        this.propsDlg = uMgrPropsPanel;
        this.createGui();
        Vector vector = new Vector(40);
        this.cmdOrDirField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_attrdialog_dir")));
        vUserMgr.addHelpListener(this.userComboBox, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_attrdialog_user"));
        vUserMgr.addHelpListener(this.groupComboBox, new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_attrdialog_group"));
        UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_attrdialog_uradio");
        this.userEffectiveTypeBtn.addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.userRealTypeBtn.addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        uMgrContextHelpListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_attrdialog_gradio");
        this.groupEffectiveTypeBtn.addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.groupRealTypeBtn.addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        if (this.policy.equals("tsol")) {
            this.setBtnListeners();
        }
        this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "rtprop_attrdialog")), true);
    }

    private void clearanceBuilder() {
        String string = this.clearanceField.getText();
        try {
            if (this.clearanceBuilderDlg == null) {
                this.clearanceBuilderDlg = new ClearanceBuilderDialog(this.theApp.getFrame(), this.tInf);
            }
            if (this.clearanceBuilderDlg != null && !string.equals(TSOL_INVALID_VALUE) && !string.equals("") && string != null) {
                this.clearanceBuilderDlg.setClearance(string);
            }
            this.clearanceBuilderDlg.setVisible(true);
            if (this.clearanceBuilderDlg.isChangeCommitted()) {
                string = this.clearanceBuilderDlg.getClearance();
                this.clearanceField.setText(string);
            }
        }
        catch (BadLabelException badLabelException) {
            this.theApp.reportErrorException((Exception)((Object)badLabelException));
            this.clearanceField.setText(TSOL_INVALID_VALUE);
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
            this.clearanceField.setText(TSOL_INVALID_VALUE);
        }
        this.currSelectedClearance = this.clearanceField.getText();
    }

    private void createGui() {
        JPanel jPanel = this.getRightPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.rightCmdAttrDlg.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_set_security_attr_title"));
        this.applyBtn = this.getOKBtn();
        this.applyBtn.addActionListener(new ApplyButtonListener());
        this.resetBtn = this.getApplyBtn();
        this.setUpButton(this.resetBtn, "right_reset_attr_btn");
        this.resetBtn.addActionListener(new ResetButtonListener());
        this.closeBtn = this.getCancelBtn();
        this.closeBtn.addActionListener(new CloseButtonListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        if (this.propsDlg instanceof RightCmdProps) {
            this.setUpLabel(jLabel, "right_cmd_or_dir");
        } else {
            this.setUpLabel(jLabel, "right_action_field");
        }
        this.cmdOrDirField = new JTextField(20);
        this.cmdOrDirField.setMinimumSize(this.cmdOrDirField.getPreferredSize());
        this.cmdOrDirField.setEnabled(false);
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel2, (Component)this.cmdOrDirField, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_ownership"));
        jPanel3.setBorder(titledBorder);
        JLabel jLabel2 = new JLabel();
        this.setUpLabel(jLabel2, "right_user");
        this.userComboBox = new JComboBox();
        this.userComboBox.setEditable(true);
        int n = 0;
        while (n < this.uidList.length) {
            this.userComboBox.addItem(this.uidList[n][0]);
            ++n;
        }
        jLabel2.setLabelFor(this.userComboBox);
        UserComboBoxListener userComboBoxListener = new UserComboBoxListener();
        this.userComboBox.addActionListener(userComboBoxListener);
        this.userEffectiveTypeBtn = new JRadioButton();
        this.setUpButton(this.userEffectiveTypeBtn, "right_user_effective");
        this.userEffectiveTypeBtn.setActionCommand("effective");
        this.userRealTypeBtn = new JRadioButton();
        this.setUpButton(this.userRealTypeBtn, "right_user_real");
        this.userRealTypeBtn.setActionCommand("real");
        this.userTypeBtnGroup = new ButtonGroup();
        this.userTypeBtnGroup.add(this.userEffectiveTypeBtn);
        this.userTypeBtnGroup.add(this.userRealTypeBtn);
        this.userEffectiveTypeBtn.setSelected(true);
        this.userRealTypeBtn.setSelected(false);
        Constraints.constrain((Container)jPanel3, (Component)jLabel2, (int)0, (int)0, (int)1, (int)2, (int)0, (int)13, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel3, (Component)this.userComboBox, (int)1, (int)0, (int)1, (int)2, (int)2, (int)10, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel3, (Component)this.userEffectiveTypeBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)16, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel3, (Component)this.userRealTypeBtn, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)12, (int)12, (int)0);
        JLabel jLabel3 = new JLabel();
        this.setUpLabel(jLabel3, "right_group");
        this.groupComboBox = new JComboBox();
        this.groupComboBox.setEditable(true);
        int n2 = 0;
        while (n2 < this.gidList.length) {
            this.groupComboBox.addItem(this.gidList[n2][0]);
            ++n2;
        }
        jLabel3.setLabelFor(this.groupComboBox);
        GroupComboBoxListener groupComboBoxListener = new GroupComboBoxListener();
        this.groupComboBox.addActionListener(groupComboBoxListener);
        this.groupEffectiveTypeBtn = new JRadioButton();
        this.setUpButton(this.groupEffectiveTypeBtn, "right_group_effective");
        this.groupEffectiveTypeBtn.setActionCommand("effective");
        this.groupRealTypeBtn = new JRadioButton();
        this.setUpButton(this.groupRealTypeBtn, "right_group_real");
        this.groupRealTypeBtn.setActionCommand("real");
        this.groupTypeBtnGroup = new ButtonGroup();
        this.groupTypeBtnGroup.add(this.groupEffectiveTypeBtn);
        this.groupTypeBtnGroup.add(this.groupRealTypeBtn);
        this.groupEffectiveTypeBtn.setSelected(true);
        this.groupRealTypeBtn.setSelected(false);
        Constraints.constrain((Container)jPanel3, (Component)jLabel3, (int)0, (int)2, (int)1, (int)2, (int)0, (int)13, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel3, (Component)this.groupComboBox, (int)1, (int)2, (int)1, (int)2, (int)2, (int)10, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel3, (Component)this.groupEffectiveTypeBtn, (int)2, (int)2, (int)1, (int)1, (int)0, (int)16, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel3, (Component)this.groupRealTypeBtn, (int)2, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)12, (int)12, (int)0);
        JPanel jPanel4 = new JPanel();
        if (this.policy.equals("tsol")) {
            jPanel4.setLayout(gridBagLayout);
            TitledBorder titledBorder2 = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_extended_attrs"));
            jPanel4.setBorder(titledBorder2);
            JLabel jLabel4 = new JLabel();
            this.setUpLabel(jLabel4, "right_minlabel");
            this.minLabelField = new JTextArea("");
            this.minLabelField.setEditable(false);
            this.newScrollPane = new JScrollPane(this.minLabelField);
            jLabel4.setLabelFor(this.minLabelField);
            this.minLabelBtn = new JButton();
            this.setUpButton(this.minLabelBtn, "right_minlabel_btn");
            this.minLabelBtn.setEnabled(true);
            Constraints.constrain((Container)jPanel4, (Component)jLabel4, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
            Constraints.constrain((Container)jPanel4, (Component)this.minLabelField, (int)1, (int)0, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (int)12, (int)0, (int)0, (int)0);
            Constraints.constrain((Container)jPanel4, (Component)this.minLabelBtn, (int)2, (int)0, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
            JLabel jLabel5 = new JLabel();
            this.setUpLabel(jLabel5, "right_clearance");
            this.clearanceField = new JTextArea("");
            this.clearanceField.setEditable(false);
            this.newScrollPane = new JScrollPane(this.clearanceField);
            jLabel5.setLabelFor(this.clearanceField);
            this.clearanceBtn = new JButton();
            this.setUpButton(this.clearanceBtn, "right_clearance_btn");
            this.clearanceBtn.setEnabled(true);
            Constraints.constrain((Container)jPanel4, (Component)jLabel5, (int)0, (int)1, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
            Constraints.constrain((Container)jPanel4, (Component)this.clearanceField, (int)1, (int)1, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (int)12, (int)0, (int)0, (int)0);
            Constraints.constrain((Container)jPanel4, (Component)this.clearanceBtn, (int)2, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
            JLabel jLabel6 = new JLabel();
            this.setUpLabel(jLabel6, "right_privilege");
            this.privField = new JTextArea("", 3, 30);
            this.privField.setLineWrap(true);
            this.privField.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(){

                public float getAlignmentX() {
                    return 0.0f;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(3, 30);
                }
            };
            jScrollPane.getViewport().add(this.privField);
            this.privField.setFont(new Font("Dialog", 0, 12));
            this.privField.setEditable(false);
            jLabel6.setLabelFor(this.privField);
            this.privBtn = new JButton();
            this.setUpButton(this.privBtn, "right_privilege_btn");
            this.privBtn.setEnabled(true);
            Constraints.constrain((Container)jPanel4, (Component)jLabel6, (int)0, (int)2, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
            Constraints.constrain((Container)jPanel4, (Component)this.privField, (int)1, (int)2, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (int)12, (int)0, (int)0, (int)0);
            Constraints.constrain((Container)jPanel4, (Component)this.privBtn, (int)2, (int)2, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        }
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)jPanel3, (int)0, (int)1, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)1.0, (int)12, (int)12, (int)0, (int)0);
        if (this.policy.equals("tsol")) {
            Constraints.constrain((Container)jPanel, (Component)jPanel4, (int)0, (int)2, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)1.0, (int)12, (int)12, (int)0, (int)0);
        }
        ((Window)((Object)this)).pack();
    }

    public void disposeDlg() {
        this.rightCmdAttrDlg.dispose();
    }

    protected void finalize() throws Throwable {
        if (this.labelService != null) {
            this.tInf.releaseService((Service)this.labelService);
        }
    }

    private String gidToName(String string) {
        int n = 0;
        while (n < this.gidList.length) {
            if (string.equals(this.gidList[n][1])) {
                string = this.gidList[n][0];
                break;
            }
            ++n;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.groupComboBox.getModel();
        boolean bl = false;
        int n2 = 0;
        while (n2 < defaultComboBoxModel.getSize()) {
            Object e = defaultComboBoxModel.getElementAt(n2);
            if (string.equals(e.toString())) {
                this.groupComboBox.setSelectedItem(e);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.groupComboBox.addItem(string);
            this.groupComboBox.setSelectedItem(string);
        }
        return string;
    }

    private void labelBuilder() {
        String string = this.minLabelField.getText();
        try {
            if (this.labelBuilderDlg == null) {
                this.labelBuilderDlg = new LabelBuilderDialog(this.theApp.getFrame(), this.tInf);
            }
            if (this.labelBuilderDlg != null && !string.equals(TSOL_INVALID_VALUE) && !string.equals("") && string != null) {
                this.labelBuilderDlg.setLabel(string);
            }
            this.labelBuilderDlg.setVisible(true);
            if (this.labelBuilderDlg.isChangeCommitted()) {
                string = this.labelBuilderDlg.getLabel();
                this.minLabelField.setText(string);
            }
        }
        catch (BadLabelException badLabelException) {
            this.theApp.reportErrorException((Exception)((Object)badLabelException));
            this.minLabelField.setText(TSOL_INVALID_VALUE);
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
            this.minLabelField.setText(TSOL_INVALID_VALUE);
        }
        this.currSelectedLabel = this.minLabelField.getText();
    }

    private String nameToGid(String string) {
        int n = 0;
        while (n < this.gidList.length) {
            if (string.equals(this.gidList[n][0])) {
                return this.gidList[n][1];
            }
            ++n;
        }
        return string;
    }

    private String nameToUid(String string) {
        int n = 0;
        while (n < this.uidList.length) {
            if (string.equals(this.uidList[n][0])) {
                return this.uidList[n][1];
            }
            ++n;
        }
        return string;
    }

    private void privilegeChooser() {
        String string = this.privField.getText();
        try {
            if (this.privilegeDlg == null) {
                this.privilegeDlg = new PrivilegeDialog(this.theApp.getFrame(), this.tInf);
            }
            if (!string.equals(TSOL_INVALID_VALUE)) {
                this.privilegeDlg.setPrivilegeAsNames(string);
            }
            this.privilegeDlg.setVisible(true);
            if (this.privilegeDlg.isChangeCommitted()) {
                string = this.privilegeDlg.getPrivilegeAsNames();
                this.privField.setText(string);
            }
        }
        catch (BadPrivilegeException badPrivilegeException) {
            this.theApp.reportErrorException((Exception)((Object)badPrivilegeException));
            this.privField.setText(TSOL_INVALID_VALUE);
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
            this.privField.setText(TSOL_INVALID_VALUE);
        }
        this.currSelectedPrivilege = this.privField.getText();
    }

    private void setBtnListeners() {
        this.minLabelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdAttrDlg.this.minLabelBtn.setEnabled(false);
                RightCmdAttrDlg.this.labelBuilder();
                RightCmdAttrDlg.this.minLabelBtn.setEnabled(true);
            }
        });
        this.clearanceBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdAttrDlg.this.clearanceBtn.setEnabled(false);
                RightCmdAttrDlg.this.clearanceBuilder();
                RightCmdAttrDlg.this.clearanceBtn.setEnabled(true);
            }
        });
        this.privBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightCmdAttrDlg.this.privBtn.setEnabled(false);
                RightCmdAttrDlg.this.privilegeChooser();
                RightCmdAttrDlg.this.privBtn.setEnabled(true);
            }
        });
    }

    private void setUpButton(AbstractButton abstractButton, String string) {
        this.actionString = new ActionString(this.bundle, string);
        abstractButton.setText(this.actionString.getString());
        abstractButton.setMnemonic(this.actionString.getMnemonic());
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    private String uidToName(String string) {
        int n = 0;
        while (n < this.uidList.length) {
            if (string.equals(this.uidList[n][1])) {
                string = this.uidList[n][0];
                break;
            }
            ++n;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.userComboBox.getModel();
        boolean bl = false;
        int n2 = 0;
        while (n2 < defaultComboBoxModel.getSize()) {
            Object e = defaultComboBoxModel.getElementAt(n2);
            if (string.equals(e.toString())) {
                this.userComboBox.setSelectedItem(e);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.userComboBox.addItem(string);
            this.userComboBox.setSelectedItem(string);
        }
        return string;
    }

    public void updateDlg(boolean bl, String string, ExecAttrObj execAttrObj) {
        ComboBoxEditor comboBoxEditor = this.userComboBox.getEditor();
        ComboBoxEditor comboBoxEditor2 = this.groupComboBox.getEditor();
        this.cmdOrDirField.setEnabled(true);
        this.cmdOrDirField.setText(string);
        this.cmdOrDirField.setEnabled(false);
        this.targetExecAttr = execAttrObj;
        String string2 = execAttrObj.getEuid();
        if (string2 != null) {
            string2 = this.uidToName(string2);
            this.userEffectiveTypeBtn.setSelected(true);
            this.userRealTypeBtn.setSelected(false);
            this.lastUserSpecifyEffective = true;
            this.lastSelectedUid = string2;
            this.currSelectedUid = string2;
        } else {
            String string3 = execAttrObj.getUid();
            if (string3 != null) {
                string3 = this.uidToName(string3);
                this.userEffectiveTypeBtn.setSelected(false);
                this.userRealTypeBtn.setSelected(true);
                this.lastUserSpecifyEffective = false;
                this.lastSelectedUid = string3;
                this.currSelectedUid = string3;
            } else {
                this.userComboBox.addItem("");
                this.userComboBox.setSelectedItem("");
                this.userEffectiveTypeBtn.setSelected(true);
                this.userRealTypeBtn.setSelected(false);
                this.lastUserSpecifyEffective = true;
                this.lastSelectedUid = "";
                this.currSelectedUid = "";
            }
        }
        String string4 = execAttrObj.getEgid();
        if (string4 != null) {
            string4 = this.gidToName(string4);
            this.groupEffectiveTypeBtn.setSelected(true);
            this.groupRealTypeBtn.setSelected(false);
            this.lastGroupSpecifyEffective = true;
            this.lastSelectedGid = string4;
            this.currSelectedGid = string4;
        } else {
            String string5 = execAttrObj.getGid();
            if (string5 != null) {
                string5 = this.gidToName(string5);
                this.groupEffectiveTypeBtn.setSelected(false);
                this.groupRealTypeBtn.setSelected(true);
                this.lastGroupSpecifyEffective = false;
                this.lastSelectedGid = string5;
                this.currSelectedGid = string5;
            } else {
                this.groupComboBox.addItem("");
                this.groupComboBox.setSelectedItem("");
                this.groupEffectiveTypeBtn.setSelected(true);
                this.groupRealTypeBtn.setSelected(false);
                this.lastGroupSpecifyEffective = true;
                this.lastSelectedGid = "";
                this.currSelectedGid = "";
            }
        }
        if (this.policy.equals("tsol")) {
            Vector vector = execAttrObj.getAttribute(TSOL_LABEL);
            String string6 = null;
            if (vector != null) {
                try {
                    string6 = this.labelService.hexLabelToString((String)vector.elementAt(0), this.userName);
                    this.minLabelField.setText(string6);
                }
                catch (BadLabelException badLabelException) {
                    this.theApp.reportErrorException(new Exception(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_execattr_invalid_label")));
                    string6 = TSOL_INVALID_VALUE;
                    this.minLabelField.setText(string6);
                }
                catch (Exception exception) {
                    this.theApp.reportErrorException(exception);
                    string6 = TSOL_INVALID_VALUE;
                    this.minLabelField.setText(string6);
                }
            } else {
                this.minLabelField.setText("");
            }
            this.lastSelectedLabel = this.minLabelField.getText();
            this.currSelectedLabel = this.minLabelField.getText();
            Vector vector2 = execAttrObj.getAttribute(TSOL_CLEARANCE);
            String string7 = null;
            if (vector2 != null) {
                try {
                    string7 = this.labelService.hexClearanceToString((String)vector2.elementAt(0), this.userName);
                    this.clearanceField.setText(string7);
                }
                catch (BadLabelException badLabelException) {
                    this.theApp.reportErrorException(new Exception(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_execattr_invalid_clear")));
                    string7 = TSOL_INVALID_VALUE;
                    this.clearanceField.setText(string7);
                }
                catch (Exception exception) {
                    this.theApp.reportErrorException(exception);
                    string7 = TSOL_INVALID_VALUE;
                    this.clearanceField.setText(string7);
                }
            } else {
                this.clearanceField.setText("");
            }
            this.lastSelectedClearance = this.clearanceField.getText();
            this.currSelectedClearance = this.clearanceField.getText();
            Vector vector3 = execAttrObj.getAttribute(TSOL_PRIVS);
            String string8 = "";
            boolean bl2 = false;
            if (vector3 != null) {
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    String string9 = (String)enumeration.nextElement();
                    if (string9.equals(TSOL_ALL_PRIVS)) {
                        bl2 = true;
                        break;
                    }
                    string8 = string8.concat(string9);
                    string8 = string8.concat(",");
                }
                if (bl2) {
                    this.privField.setText(TSOL_ALL_PRIVS);
                } else {
                    int n = string8.length();
                    string8 = string8.substring(0, n - 1);
                    try {
                        string8 = this.labelService.privNumListToPrivStringList(string8);
                        this.privField.setText(string8);
                    }
                    catch (BadPrivilegeException badPrivilegeException) {
                        this.theApp.reportErrorException(new Exception(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tsol_execattr_invalid_priv")));
                        this.privField.setText(TSOL_INVALID_VALUE);
                    }
                    catch (Exception exception) {
                        this.theApp.reportErrorException(exception);
                        this.privField.setText(TSOL_INVALID_VALUE);
                    }
                }
            } else {
                this.privField.setText("");
            }
            this.lastSelectedPrivilege = this.privField.getText();
            this.currSelectedPrivilege = this.privField.getText();
        }
    }

    private class UserComboBoxListener
    implements ActionListener {
        UserComboBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = RightCmdAttrDlg.this.userComboBox.getSelectedIndex();
            if (n > -1) {
                RightCmdAttrDlg.this.currSelectedUid = (String)RightCmdAttrDlg.this.userComboBox.getSelectedItem();
            } else {
                ComboBoxEditor comboBoxEditor = RightCmdAttrDlg.this.userComboBox.getEditor();
                RightCmdAttrDlg.this.currSelectedUid = comboBoxEditor.getItem().toString();
            }
        }
    }

    private class GroupComboBoxListener
    implements ActionListener {
        GroupComboBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = RightCmdAttrDlg.this.groupComboBox.getSelectedIndex();
            if (n > -1) {
                RightCmdAttrDlg.this.currSelectedGid = (String)RightCmdAttrDlg.this.groupComboBox.getSelectedItem();
            } else {
                ComboBoxEditor comboBoxEditor = RightCmdAttrDlg.this.groupComboBox.getEditor();
                RightCmdAttrDlg.this.currSelectedGid = comboBoxEditor.getItem().toString();
            }
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        ApplyButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            String string2 = null;
            RightCmdAttrDlg.this.lastSelectedUid = RightCmdAttrDlg.this.currSelectedUid;
            RightCmdAttrDlg.this.lastSelectedGid = RightCmdAttrDlg.this.currSelectedGid;
            if (RightCmdAttrDlg.this.userEffectiveTypeBtn.isSelected()) {
                RightCmdAttrDlg.this.userSpecifyEffective = true;
                RightCmdAttrDlg.this.lastUserSpecifyEffective = true;
            } else {
                RightCmdAttrDlg.this.userSpecifyEffective = false;
                RightCmdAttrDlg.this.lastUserSpecifyEffective = false;
            }
            if (RightCmdAttrDlg.this.groupEffectiveTypeBtn.isSelected()) {
                RightCmdAttrDlg.this.groupSpecifyEffective = true;
                RightCmdAttrDlg.this.lastGroupSpecifyEffective = true;
            } else {
                RightCmdAttrDlg.this.groupSpecifyEffective = false;
                RightCmdAttrDlg.this.lastGroupSpecifyEffective = false;
            }
            ExecAttrObj execAttrObj = (ExecAttrObj)RightCmdAttrDlg.this.targetExecAttr.clone();
            execAttrObj.clearAttributes();
            RightCmdAttrDlg.this.currSelectedUid = RightCmdAttrDlg.this.nameToUid(RightCmdAttrDlg.this.currSelectedUid);
            RightCmdAttrDlg.this.currSelectedGid = RightCmdAttrDlg.this.nameToGid(RightCmdAttrDlg.this.currSelectedGid);
            if (RightCmdAttrDlg.this.userSpecifyEffective) {
                if (RightCmdAttrDlg.this.currSelectedUid != "") {
                    execAttrObj.setEuid(RightCmdAttrDlg.this.currSelectedUid);
                }
            } else if (RightCmdAttrDlg.this.currSelectedUid != "") {
                execAttrObj.setUid(RightCmdAttrDlg.this.currSelectedUid);
            }
            if (RightCmdAttrDlg.this.groupSpecifyEffective) {
                if (RightCmdAttrDlg.this.currSelectedGid != "") {
                    execAttrObj.setEgid(RightCmdAttrDlg.this.currSelectedGid);
                }
            } else if (RightCmdAttrDlg.this.currSelectedGid != "") {
                execAttrObj.setGid(RightCmdAttrDlg.this.currSelectedGid);
            }
            if (RightCmdAttrDlg.this.policy.equals("tsol")) {
                RightCmdAttrDlg.this.lastSelectedLabel = RightCmdAttrDlg.this.currSelectedLabel;
                RightCmdAttrDlg.this.lastSelectedClearance = RightCmdAttrDlg.this.currSelectedClearance;
                RightCmdAttrDlg.this.lastSelectedPrivilege = RightCmdAttrDlg.this.currSelectedPrivilege;
                if (!RightCmdAttrDlg.this.currSelectedLabel.equals(RightCmdAttrDlg.TSOL_INVALID_VALUE) && !RightCmdAttrDlg.this.currSelectedLabel.equals("") && RightCmdAttrDlg.this.currSelectedLabel != null) {
                    try {
                        string = RightCmdAttrDlg.this.labelService.stringLabelToHex(RightCmdAttrDlg.this.currSelectedLabel, RightCmdAttrDlg.this.userName);
                    }
                    catch (BadLabelException badLabelException) {
                        RightCmdAttrDlg.this.theApp.reportErrorException((Exception)((Object)badLabelException));
                        return;
                    }
                    catch (Exception exception) {
                        RightCmdAttrDlg.this.theApp.reportErrorException(exception);
                        return;
                    }
                }
                if (!RightCmdAttrDlg.this.currSelectedClearance.equals(RightCmdAttrDlg.TSOL_INVALID_VALUE) && !RightCmdAttrDlg.this.currSelectedClearance.equals("") && RightCmdAttrDlg.this.currSelectedClearance != null) {
                    try {
                        string2 = RightCmdAttrDlg.this.labelService.stringClearanceToHex(RightCmdAttrDlg.this.currSelectedClearance, RightCmdAttrDlg.this.userName);
                    }
                    catch (BadLabelException badLabelException) {
                        RightCmdAttrDlg.this.theApp.reportErrorException((Exception)((Object)badLabelException));
                        return;
                    }
                    catch (Exception exception) {
                        RightCmdAttrDlg.this.theApp.reportErrorException(exception);
                        return;
                    }
                }
                if (string != null || string2 != null) {
                    if (string != null && string2 == null) {
                        string2 = string;
                    } else {
                        try {
                            if (string2 != null && string == null) {
                                UserSecurityInfo userSecurityInfo = RightCmdAttrDlg.this.labelService.getUserSecurityInfo(RightCmdAttrDlg.this.userName);
                                if (userSecurityInfo != null) {
                                    string = userSecurityInfo.getMinLabel();
                                } else {
                                    RightCmdAttrDlg.this.theApp.reportErrorException(new Exception(ResourceStrings.getString((ResourceBundle)RightCmdAttrDlg.this.bundle, (String)"tsol_getuserinfo_err")));
                                    return;
                                }
                            }
                            boolean bl = true;
                            bl = RightCmdAttrDlg.this.labelService.checkClearanceDominance(string, string2, RightCmdAttrDlg.this.userName);
                            if (!bl) {
                                ErrorDialog errorDialog = new ErrorDialog(RightCmdAttrDlg.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)RightCmdAttrDlg.this.bundle, (String)"tsol_execattr_dominance_error"));
                                return;
                            }
                        }
                        catch (Exception exception) {
                            RightCmdAttrDlg.this.theApp.reportErrorException(exception);
                            return;
                        }
                    }
                }
                if (string2 != null) {
                    execAttrObj.setAttribute(RightCmdAttrDlg.TSOL_CLEARANCE, string2);
                }
                if (string != null) {
                    execAttrObj.setAttribute(RightCmdAttrDlg.TSOL_LABEL, string);
                }
                if (!RightCmdAttrDlg.this.currSelectedPrivilege.equals(RightCmdAttrDlg.TSOL_INVALID_VALUE) && !RightCmdAttrDlg.this.currSelectedPrivilege.equals("") && RightCmdAttrDlg.this.currSelectedPrivilege != null) {
                    Vector<String> vector = new Vector<String>();
                    if (RightCmdAttrDlg.this.currSelectedPrivilege.equals(RightCmdAttrDlg.TSOL_ALL_PRIVS)) {
                        vector.addElement(RightCmdAttrDlg.TSOL_ALL_PRIVS);
                        execAttrObj.setAttribute(RightCmdAttrDlg.TSOL_PRIVS, vector);
                    } else {
                        try {
                            String string3 = RightCmdAttrDlg.this.labelService.privNameListToPrivNumList(RightCmdAttrDlg.this.currSelectedPrivilege);
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                            String string4 = "";
                            while (stringTokenizer.hasMoreTokens()) {
                                string4 = stringTokenizer.nextToken();
                                vector.addElement(string4);
                            }
                            execAttrObj.setAttribute(RightCmdAttrDlg.TSOL_PRIVS, vector);
                        }
                        catch (BadPrivilegeException badPrivilegeException) {
                            RightCmdAttrDlg.this.theApp.reportErrorException((Exception)((Object)badPrivilegeException));
                            return;
                        }
                        catch (Exception exception) {
                            RightCmdAttrDlg.this.theApp.reportErrorException(exception);
                            return;
                        }
                    }
                }
            }
            if (RightCmdAttrDlg.this.propsDlg instanceof RightCmdProps) {
                RightCmdProps rightCmdProps = (RightCmdProps)RightCmdAttrDlg.this.propsDlg;
                rightCmdProps.updateCmdExecAttr(execAttrObj);
            } else {
                RightActProps rightActProps = (RightActProps)RightCmdAttrDlg.this.propsDlg;
                rightActProps.updateActExecAttr(execAttrObj);
            }
        }
    }

    class ResetButtonListener
    implements ActionListener {
        ResetButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RightCmdAttrDlg.this.lastUserSpecifyEffective) {
                RightCmdAttrDlg.this.userEffectiveTypeBtn.setSelected(true);
                RightCmdAttrDlg.this.userRealTypeBtn.setSelected(false);
            } else {
                RightCmdAttrDlg.this.userEffectiveTypeBtn.setSelected(false);
                RightCmdAttrDlg.this.userRealTypeBtn.setSelected(true);
            }
            if (RightCmdAttrDlg.this.lastGroupSpecifyEffective) {
                RightCmdAttrDlg.this.groupEffectiveTypeBtn.setSelected(true);
                RightCmdAttrDlg.this.groupRealTypeBtn.setSelected(false);
            } else {
                RightCmdAttrDlg.this.groupEffectiveTypeBtn.setSelected(false);
                RightCmdAttrDlg.this.groupRealTypeBtn.setSelected(true);
            }
            RightCmdAttrDlg.this.userComboBox.setSelectedItem(RightCmdAttrDlg.this.lastSelectedUid);
            RightCmdAttrDlg.this.groupComboBox.setSelectedItem(RightCmdAttrDlg.this.lastSelectedGid);
            if (RightCmdAttrDlg.this.policy.equals("tsol")) {
                RightCmdAttrDlg.this.minLabelField.setText(RightCmdAttrDlg.this.lastSelectedLabel);
                RightCmdAttrDlg.this.clearanceField.setText(RightCmdAttrDlg.this.lastSelectedClearance);
                RightCmdAttrDlg.this.privField.setText(RightCmdAttrDlg.this.lastSelectedPrivilege);
            }
        }
    }

    class CloseButtonListener
    implements ActionListener {
        CloseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RightCmdAttrDlg.this.rightCmdAttrDlg.dispose();
            if (RightCmdAttrDlg.this.propsDlg instanceof RightCmdProps) {
                RightCmdProps rightCmdProps = (RightCmdProps)RightCmdAttrDlg.this.propsDlg;
                rightCmdProps.setCmdAttrNull();
            } else {
                RightActProps rightActProps = (RightActProps)RightCmdAttrDlg.this.propsDlg;
                rightActProps.setActAttrNull();
            }
        }
    }
}

