/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SolMailProps
extends UMgrPropsPanel {
    private GenInfoPanel infoPanel;
    private boolean isLocalScope;
    private JTextField nsTextField;
    private JLabel server;
    private VUserMgr theApp;
    private ResourceBundle bundle;

    public SolMailProps(VUserMgr vUserMgr, UserObj userObj, GenInfoPanel genInfoPanel) {
        this.infoPanel = genInfoPanel;
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.setUpScopeContext();
        this.createGui(userObj);
        Vector vector = new Vector(2);
        this.focusListener = new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_mail");
        Thread thread = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((UMgrContextHelpListener)((Object)SolMailProps.this.getFocusListener())));
                }
                catch (Exception exception) {}
            }
        };
        thread.start();
        if (!this.isLocalScope) {
            this.nsTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "uprop_mail_server")));
        }
    }

    private void createGui(UserObj userObj) {
        SolServicesAttr solServicesAttr;
        String string = "";
        if (userObj.getSolServicesAttr() != null && (solServicesAttr = userObj.getSolServicesAttr()).getMailServer() != null) {
            string = solServicesAttr.getMailServer();
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_mail_props_info"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(gridBagLayout);
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)0.4, (int)20, (int)16, (int)220, (int)16);
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"au_wiz_mail_lbl2"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)10, (int)24, (int)0, (int)0);
        if (!this.isLocalScope) {
            this.nsTextField = new JTextField(string, 15);
            this.nsTextField.setMinimumSize(this.nsTextField.getPreferredSize());
            Constraints.constrain((Container)jPanel, (Component)this.nsTextField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)9.0, (double)0.0, (int)10, (int)16, (int)0, (int)0);
        } else {
            this.server = new JLabel(string);
            this.server.setForeground(Constants.PROPS_LABEL_COLOR);
            Constraints.constrain((Container)jPanel, (Component)this.server, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)9.0, (double)0.0, (int)10, (int)16, (int)0, (int)0);
        }
        JLabel jLabel2 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"sol_mail_box"));
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel2.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)10, (int)24, (int)0, (int)0);
        String string2 = new String(SolServicesAttr.DEFAULT_MAILBOX_DIRECTORY);
        string2 = string2.concat(userObj.getUserName());
        JLabel jLabel3 = new JLabel(string2);
        jLabel3.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain((Container)jPanel, (Component)jLabel3, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)9.0, (double)1.0, (int)10, (int)16, (int)0, (int)0);
    }

    public boolean isMailSyntaxOK() {
        if (!this.isLocalScope) {
            if (CheckSyntax.isHomeDirServerOK((String)this.nsTextField.getText())) {
                return true;
            }
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), CheckSyntax.getErrorString());
            return false;
        }
        return true;
    }

    private void setUpScopeContext() {
        this.isLocalScope = this.theApp.getApplicationContext().isLocalScope();
    }

    public UserObj updateSolMailProps(UserObj userObj) {
        SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
        if (solServicesAttr == null) {
            solServicesAttr = new SolServicesAttr();
        }
        if (!this.isLocalScope) {
            String string = this.nsTextField.getText();
            solServicesAttr.setMailServer(string);
            userObj.setSolServicesAttr(solServicesAttr);
        }
        return userObj;
    }
}

